/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.system.InstallToken;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.base.UserInfo;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.csadmin.SecurityDomainProcessor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ArgBlock;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.dogtagpki.server.authentication.AuthToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCookie
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(GetCookie.class);
    private static final long serialVersionUID = 2466968231929541707L;
    private String mErrorFormPath = null;
    private String mFormPath = null;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        logger.debug("GetCookie init");
        this.mTemplates.remove(CMSRequest.SUCCESS);
        this.mErrorFormPath = sc.getInitParameter("errorTemplatePath");
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    @Override
    protected void process(CMSRequest cmsReq) throws EBaseException {
        try {
            this.processImpl(cmsReq);
        }
        catch (Throwable t) {
            logger.error("GetCookie: " + t.getMessage(), t);
            throw t;
        }
    }

    protected void processImpl(CMSRequest cmsReq) throws EBaseException {
        block20: {
            int index1;
            HttpServletRequest httpReq = cmsReq.getHttpReq();
            HttpServletResponse httpResp = cmsReq.getHttpResp();
            logger.debug("GetCookie start");
            AuthToken authToken = null;
            CMSEngine engine = this.getCMSEngine();
            EngineConfig cs = engine.getConfig();
            ArgBlock header = new ArgBlock();
            ArgBlock ctx = new ArgBlock();
            CMSTemplateParams argSet = new CMSTemplateParams(header, ctx);
            CMSTemplate form = null;
            Locale[] locale = new Locale[1];
            String url = httpReq.getParameter("url");
            logger.debug("GetCookie before auth, url = " + url);
            if (url == null) {
                throw new ECMSGWException("GetCookie missing parameter: url");
            }
            String url_e = "";
            URL u = null;
            try {
                url_e = URLDecoder.decode(url, "UTF-8");
                u = new URL(url_e);
            }
            catch (Exception eee) {
                throw new ECMSGWException("Unable to parse URL: " + StringEscapeUtils.escapeHtml4((String)url));
            }
            int index2 = url_e.indexOf("subsystem=");
            String subsystem = "";
            if (index2 > 0 && (index1 = (subsystem = url.substring(index2 + 10)).indexOf("&")) > 0) {
                subsystem = subsystem.substring(0, index1);
            }
            try {
                authToken = this.authenticate(cmsReq);
            }
            catch (Exception e) {
                logger.error("GetCookie authentication failed: " + e.getMessage(), (Throwable)e);
                logger.error(CMS.getLogMessage("CMSGW_ERR_BAD_SERV_OUT_STREAM", "", e.toString()));
                header.addStringValue("sd_uid", "");
                header.addStringValue("sd_pwd", "");
                header.addStringValue("host", u.getHost());
                header.addStringValue("sdhost", cs.getHostname());
                header.addStringValue("subsystem", subsystem);
                header.addStringValue("url", StringEscapeUtils.escapeHtml4((String)url_e));
                header.addStringValue("errorString", "Failed Authentication");
                String sdname = cs.getString("securitydomain.name", "");
                header.addStringValue("sdname", sdname);
                logger.debug("mErrorFormPath=" + this.mErrorFormPath);
                try {
                    form = this.getTemplate(this.mErrorFormPath, httpReq, locale);
                }
                catch (IOException eee) {
                    logger.error("GetCookie process: cant locate the form: " + eee.getMessage(), (Throwable)eee);
                }
                if (form == null) {
                    logger.error("GetCookie::process() - form is null!");
                    throw new EBaseException("form is null");
                }
                try {
                    ServletOutputStream out = httpResp.getOutputStream();
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                    httpResp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                }
                catch (IOException ee) {
                    logger.error(CMS.getLogMessage("CMSGW_ERR_OUT_STREAM_TEMPLATE", ee.toString()), (Throwable)ee);
                    throw new ECMSGWException(CMS.getUserMessage("CMS_GW_DISPLAY_TEMPLATE_ERROR", new String[0]), ee);
                }
                return;
            }
            if (authToken != null) {
                String uid = authToken.getInString("uid");
                logger.debug("UID: " + uid);
                String addr = "";
                try {
                    addr = u.getHost();
                }
                catch (Exception e) {
                    logger.error("GetCookie: " + e.getMessage(), (Throwable)e);
                }
                try {
                    SecurityDomainProcessor processor = new SecurityDomainProcessor(this.getLocale(httpReq));
                    processor.setCMSEngine(engine);
                    processor.init();
                    InstallToken installToken = processor.getInstallToken(uid, addr, subsystem);
                    String cookie = installToken.getToken();
                    logger.debug("Cookie: " + cookie);
                    if (url.startsWith("$")) break block20;
                    try {
                        form = this.getTemplate(this.mFormPath, httpReq, locale);
                    }
                    catch (IOException e) {
                        logger.error("GetCookie process: cant locate the form: " + e.getMessage(), (Throwable)e);
                    }
                    header.addStringValue("url", StringEscapeUtils.escapeHtml4((String)url));
                    header.addStringValue("session_id", cookie);
                    try {
                        ServletOutputStream out = httpResp.getOutputStream();
                        cmsReq.setStatus(CMSRequest.SUCCESS);
                        httpResp.setContentType("text/html");
                        form.renderOutput((OutputStream)out, argSet);
                    }
                    catch (IOException e) {
                        logger.error(CMS.getLogMessage("CMSGW_ERR_OUT_STREAM_TEMPLATE", e.toString()), (Throwable)e);
                        throw new ECMSGWException(CMS.getUserMessage("CMS_GW_DISPLAY_TEMPLATE_ERROR", new String[0]), e);
                    }
                }
                catch (Exception e) {
                    logger.warn("GetCookie: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected Locale getLocale(HttpServletRequest req) {
        Locale locale = null;
        String lang = req.getHeader("accept-language");
        locale = lang == null ? Locale.getDefault() : new Locale(UserInfo.getUserLanguage(lang), UserInfo.getUserCountry(lang));
        return locale;
    }
}

