/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.base;

import com.netscape.cms.servlet.base.PKIService;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.logging.Auditor;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.ResourceBundle;
import javax.ws.rs.core.HttpHeaders;

public class SubsystemService
extends PKIService {
    public String getSubsystemName() {
        String path = this.servletContext.getContextPath();
        return path.startsWith("/") ? path.substring(1) : path;
    }

    public String getSubsystemConfDir() {
        return CMS.getInstanceDir() + File.separator + this.getSubsystemName() + File.separator + "conf";
    }

    public String getSharedSubsystemConfDir() {
        return File.separator + "usr" + File.separator + "share" + File.separator + "pki" + File.separator + this.getSubsystemName() + File.separator + "conf";
    }

    public ResourceBundle getResourceBundle(String name) throws Exception {
        URL[] urls = new URL[]{new File(this.getSubsystemConfDir()).toURI().toURL(), new File(this.getSharedSubsystemConfDir()).toURI().toURL()};
        URLClassLoader loader = new URLClassLoader(urls);
        return ResourceBundle.getBundle(name, this.servletRequest.getLocale(), loader);
    }

    public String getUserMessage(String messageId, HttpHeaders headers, String ... params) {
        return CMS.getUserMessage(this.getLocale(headers), messageId, params);
    }

    public void audit(String message, String scope, String type, String id, Map<String, String> params, String status) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = CMS.getLogMessage(message, auditor.getSubjectID(), status, auditor.getParamString(scope, type, id, params));
        auditor.log(auditMessage);
    }

    public void auditConfigTokenGeneral(String status, String service, Map<String, String> params, String info) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String msg = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_TOKEN_GENERAL_5", this.servletRequest.getUserPrincipal().getName(), status, service, auditor.getParamString(params), info);
        auditor.log(msg);
    }
}

