/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.ocsp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class ResponseBytes
implements ASN1Value {
    public static final OBJECT_IDENTIFIER OCSP = new OBJECT_IDENTIFIER("1.3.6.1.5.5.7.48.1");
    public static final OBJECT_IDENTIFIER OCSP_BASIC = new OBJECT_IDENTIFIER("1.3.6.1.5.5.7.48.1.1");
    private OBJECT_IDENTIFIER responseType = null;
    private OCTET_STRING response = null;
    private SEQUENCE sequence = new SEQUENCE();
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public OBJECT_IDENTIFIER getObjectIdentifier() {
        return this.responseType;
    }

    public OCTET_STRING getResponse() {
        return this.response;
    }

    public ResponseBytes(OBJECT_IDENTIFIER responseType, OCTET_STRING response) {
        this.responseType = responseType;
        this.sequence.addElement((ASN1Value)responseType);
        this.response = response;
        this.sequence.addElement((ASN1Value)response);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement((ASN1Template)OCTET_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new ResponseBytes((OBJECT_IDENTIFIER)seq.elementAt(0), (OCTET_STRING)seq.elementAt(1));
        }
    }
}

