/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.net.Socket;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSSLSocket;
import netscape.ldap.LDAPSSLSocketFactoryExt;

public class LDAPSSLSocketWrapFactory
implements LDAPSSLSocketFactoryExt,
Serializable {
    static final long serialVersionUID = -4171548771815037740L;
    private boolean clientAuth = false;
    private String packageName = null;
    private transient Object cipherSuites = null;

    public LDAPSSLSocketWrapFactory(String className) {
        this.packageName = className;
    }

    public LDAPSSLSocketWrapFactory(String className, Object cipherSuites) {
        this.packageName = className;
        this.cipherSuites = cipherSuites;
    }

    @Override
    public Socket makeSocket(String host, int port) throws LDAPException {
        LDAPSSLSocket s = null;
        try {
            s = this.cipherSuites == null ? new LDAPSSLSocket(host, port, this.packageName) : new LDAPSSLSocket(host, port, this.packageName, this.cipherSuites);
            return s;
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.toString());
            throw new LDAPException("Failed to create SSL socket", 91);
        }
    }

    @Override
    public boolean isClientAuth() {
        return this.clientAuth;
    }

    public void enableClientAuth() throws LDAPException {
        throw new LDAPException("Client Authentication is not implemented yet.");
    }

    public String getSSLSocketImpl() {
        return this.packageName;
    }

    @Override
    public Object getCipherSuites() {
        return this.cipherSuites;
    }
}

