/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.SignatureSpi;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.KeyType;
import org.mozilla.jss.pkcs11.PK11Key;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.pkcs11.SigContextProxy;
import org.mozilla.jss.pkcs11.TokenProxy;

public final class PK11Signature
extends SignatureSpi
implements AutoCloseable {
    public static final String NO_TOKEN = "No token provided";
    public static final String NO_TOKEN_PROXY = "No tokenProxy provided";
    public static final String NO_ALGORTIHM = "No algorithm provided";
    public static final String NO_KEY = "No key provided";
    public static final String NO_CONTEXT = "Signature has no context";
    public static final String SIG_NOT_INITIALIZED = "Signature is not initialized";
    public static final String NO_INPUT_STREAM = "Raw signature has no input stream";
    protected PK11Token token;
    protected TokenProxy tokenProxy;
    protected Algorithm algorithm;
    protected Algorithm digestAlgorithm;
    protected PK11Key key;
    protected int state;
    protected SigContextProxy sigContext;
    protected boolean raw = false;
    protected ByteArrayOutputStream rawInput;
    public static final int UNINITIALIZED = 0;
    public static final int SIGN = 1;
    public static final int VERIFY = 2;

    public PK11Signature(PK11Token token, SignatureAlgorithm algorithm) throws NoSuchAlgorithmException, TokenException {
        if (token == null) {
            throw new TokenException(NO_TOKEN);
        }
        if (algorithm == null) {
            throw new NoSuchAlgorithmException(NO_ALGORTIHM);
        }
        if (!token.doesAlgorithm(algorithm) && !token.doesAlgorithm(algorithm.getSigningAlg())) {
            throw new NoSuchAlgorithmException();
        }
        this.tokenProxy = token.getProxy();
        if (this.tokenProxy == null) {
            throw new TokenException(NO_TOKEN_PROXY);
        }
        this.token = token;
        this.algorithm = algorithm;
        this.digestAlgorithm = null;
        if (!this.isRSAPSSAlgorithm(algorithm) && algorithm.getRawAlg() == algorithm) {
            this.raw = true;
            this.rawInput = new ByteArrayOutputStream();
        }
        this.state = 0;
        if (this.isRSAPSSAlgorithm(algorithm)) {
            try {
                this.digestAlgorithm = algorithm.getDigestAlg();
            }
            catch (NoSuchAlgorithmException e) {
                this.digestAlgorithm = null;
            }
        }
    }

    @Override
    public void engineInitSign(PrivateKey privateKey) throws InvalidKeyException, TokenException {
        if (privateKey == null) {
            throw new InvalidKeyException("private key is null");
        }
        if (!(privateKey instanceof PK11PrivKey)) {
            throw new InvalidKeyException("privateKey is not a PKCS #11 private key");
        }
        PK11PrivKey privKey = (PK11PrivKey)privateKey;
        try {
            privKey.verifyKeyIsOnToken(this.token);
        }
        catch (NoSuchItemOnTokenException e) {
            throw new InvalidKeyException(e.toString());
        }
        try {
            if (KeyType.getKeyTypeFromAlgorithm(this.algorithm) != privKey.getKeyType()) {
                throw new InvalidKeyException("Key type is inconsistent with algorithm");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException("Unknown algorithm: " + this.algorithm, e);
        }
        this.key = privKey;
        if (!this.raw) {
            this.sigContext = null;
            this.initSigContext();
        }
        this.state = 1;
    }

    @Override
    public void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException, TokenException {
        throw new RuntimeException("PK11Signature.engineInitSign() is not supported");
    }

    protected native void initSigContext() throws TokenException;

    @Override
    public void engineInitVerify(PublicKey publicKey) throws InvalidKeyException, TokenException {
        if (!(publicKey instanceof PK11PubKey)) {
            throw new InvalidKeyException("publicKey is not a PKCS #11 public key");
        }
        PK11PubKey pubKey = (PK11PubKey)publicKey;
        try {
            if (KeyType.getKeyTypeFromAlgorithm(this.algorithm) != pubKey.getKeyType()) {
                throw new InvalidKeyException("Key type is inconsistent with algorithm");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException("Unknown algorithm: " + this.algorithm, e);
        }
        this.key = pubKey;
        if (!this.raw) {
            this.sigContext = null;
            this.initVfyContext();
        }
        this.state = 2;
    }

    protected native void initVfyContext() throws TokenException;

    @Override
    public void engineUpdate(byte b) throws SignatureException, TokenException {
        this.engineUpdate(new byte[]{b}, 0, 1);
    }

    @Override
    public void engineUpdate(byte[] b, int off, int len) throws SignatureException, TokenException {
        if (b == null) {
            throw new SignatureException("No byte provided");
        }
        this.validateUpdate();
        if (this.raw) {
            this.rawInput.write(b, off, len);
        } else {
            this.engineUpdateNative(b, off, len);
        }
    }

    private void validateUpdate() throws SignatureException {
        if (this.state == 1 || this.state == 2) {
            if (!this.raw && this.sigContext == null) {
                throw new SignatureException(NO_CONTEXT);
            }
            if (this.raw && this.rawInput == null) {
                throw new SignatureException(NO_INPUT_STREAM);
            }
        } else if (this.state == 0) {
            throw new SignatureException(SIG_NOT_INITIALIZED);
        }
        if (this.key == null) {
            throw new SignatureException(NO_KEY);
        }
    }

    protected native void engineUpdateNative(byte[] var1, int var2, int var3) throws TokenException;

    @Override
    public byte[] engineSign() throws SignatureException, TokenException {
        byte[] result;
        if (this.state != 1) {
            throw new SignatureException(SIG_NOT_INITIALIZED);
        }
        if (!this.raw && this.sigContext == null) {
            throw new SignatureException(NO_CONTEXT);
        }
        if (this.raw && this.rawInput == null) {
            throw new SignatureException(NO_INPUT_STREAM);
        }
        if (this.key == null) {
            throw new SignatureException(NO_KEY);
        }
        if (this.raw) {
            result = PK11Signature.engineRawSignNative(this.token, (PK11PrivKey)this.key, this.rawInput.toByteArray());
            this.rawInput.reset();
        } else {
            result = this.engineSignNative();
        }
        this.state = 0;
        this.sigContext = null;
        return result;
    }

    @Override
    public int engineSign(byte[] outbuf, int offset, int len) throws SignatureException, TokenException {
        byte[] sig;
        if (outbuf == null) {
            throw new SignatureException("No output buffer provided");
        }
        if (this.raw) {
            sig = PK11Signature.engineRawSignNative(this.token, (PK11PrivKey)this.key, this.rawInput.toByteArray());
            this.rawInput.reset();
        } else {
            sig = this.engineSign();
        }
        if (outbuf.length <= offset || len < sig.length || offset + len > outbuf.length) {
            throw new SignatureException("outbuf is not sufficient to hold signature");
        }
        System.arraycopy(sig, 0, outbuf, offset, sig.length);
        return sig.length;
    }

    private static native byte[] engineRawSignNative(PK11Token var0, PrivateKey var1, byte[] var2) throws SignatureException, TokenException;

    private native byte[] engineSignNative() throws SignatureException, TokenException;

    @Override
    public boolean engineVerify(byte[] sigBytes) throws SignatureException, TokenException {
        boolean result;
        if (sigBytes == null) {
            throw new SignatureException("No signature bytes provided");
        }
        if (this.state != 2) {
            throw new SignatureException("Signature is not initialized properly");
        }
        if (!this.raw && this.sigContext == null) {
            throw new SignatureException(NO_CONTEXT);
        }
        if (this.raw && this.rawInput == null) {
            throw new SignatureException(NO_INPUT_STREAM);
        }
        if (this.key == null) {
            throw new SignatureException(NO_KEY);
        }
        if (this.raw) {
            result = PK11Signature.engineRawVerifyNative(this.token, (PK11PubKey)this.key, this.rawInput.toByteArray(), sigBytes);
            this.rawInput.reset();
        } else {
            result = this.engineVerifyNative(sigBytes);
        }
        this.state = 0;
        this.sigContext = null;
        return result;
    }

    protected static native boolean engineRawVerifyNative(PK11Token var0, PublicKey var1, byte[] var2, byte[] var3) throws SignatureException, TokenException;

    protected native boolean engineVerifyNative(byte[] var1) throws SignatureException, TokenException;

    @Override
    public void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException, TokenException {
        if (!this.isRSAPSSAlgorithm((SignatureAlgorithm)this.algorithm)) {
            Object msg = "Passing algorithm parameters for this algorithm (";
            msg = (String)msg + this.algorithm + ") is not supported: " + params.toString();
            throw new InvalidAlgorithmParameterException((String)msg);
        }
        if (!(params instanceof PSSParameterSpec)) {
            Object msg = "Unsupported algorithm parameter spec class for ";
            msg = (String)msg + "RSA/PSS: " + params.getClass().getName() + " -- ";
            msg = (String)msg + params.toString();
            throw new InvalidAlgorithmParameterException((String)msg);
        }
        this.digestAlgorithm = this.getRSAPSSDigestAlgFromSpec((PSSParameterSpec)params);
    }

    private Algorithm getRSAPSSDigestAlgFromSpec(PSSParameterSpec params) throws InvalidAlgorithmParameterException {
        String hashAlgName = params.getDigestAlgorithm();
        DigestAlgorithm hashAlg = null;
        if (hashAlgName.equals("SHA-256")) {
            hashAlg = DigestAlgorithm.SHA256;
        } else if (hashAlgName.equals("SHA-384")) {
            hashAlg = DigestAlgorithm.SHA384;
        } else if (hashAlgName.equals("SHA-512")) {
            hashAlg = DigestAlgorithm.SHA512;
        } else {
            String msg = "This digest algorithm (" + hashAlgName + ") isn't ";
            msg = msg + "supported for this algorithm (" + this.algorithm + "): ";
            msg = msg + params.toString();
            throw new InvalidAlgorithmParameterException(msg);
        }
        return hashAlg;
    }

    private boolean isRSAPSSAlgorithm(SignatureAlgorithm algorithm) {
        if (algorithm == null) {
            return false;
        }
        return algorithm == SignatureAlgorithm.RSAPSSSignatureWithSHA256Digest || algorithm == SignatureAlgorithm.RSAPSSSignatureWithSHA384Digest || algorithm == SignatureAlgorithm.RSAPSSSignatureWithSHA512Digest || algorithm == SignatureAlgorithm.RSAPSSSignature;
    }

    public void finalize() throws Throwable {
        this.close();
    }

    @Override
    public void close() throws Exception {
        if (this.sigContext != null) {
            try {
                this.sigContext.close();
            }
            finally {
                this.sigContext = null;
            }
        }
    }
}

