/*
 * Decompiled with CFR 0.152.
 */
package java.dyn;

import java.dyn.CoroutineBase;
import java.dyn.CoroutineSupport;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;

public class Coroutine
extends CoroutineBase {
    private final Runnable target;

    public Coroutine() {
        this.target = null;
        this.threadSupport.addCoroutine(this, -1L);
    }

    public Coroutine(Runnable runnable) {
        this.target = runnable;
        this.threadSupport.addCoroutine(this, -1L);
    }

    public Coroutine(long l) {
        this.target = null;
        this.threadSupport.addCoroutine(this, l);
    }

    public Coroutine(Runnable runnable, long l) {
        this.target = runnable;
        this.threadSupport.addCoroutine(this, l);
    }

    Coroutine(CoroutineSupport coroutineSupport, long l) {
        super(coroutineSupport, l);
        this.target = null;
    }

    public static void yieldTo(Coroutine coroutine) {
        JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
        javaLangAccess.getCoroutineSupport(javaLangAccess.currentThread0()).symmetricYieldTo(coroutine);
    }

    public static void unsafeYieldTo(Coroutine coroutine) {
        JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
        javaLangAccess.getCoroutineSupport(javaLangAccess.currentThread0()).unsafeSymmetricYieldTo(coroutine);
    }

    public StealResult steal(boolean bl) {
        return this.threadSupport.steal(this, bl);
    }

    public void stop() {
        JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
        javaLangAccess.getCoroutineSupport(javaLangAccess.currentThread0()).symmetricStopCoroutine(this);
    }

    public void setWispTask(int n, Object object, Object object2) {
        Coroutine.setWispTask(this.nativeCoroutine, n, object, object2);
    }

    @Override
    protected void run() {
        assert (Thread.currentThread() == this.threadSupport.getThread());
        if (this.target != null) {
            this.target.run();
        }
    }

    private static native void registerNatives();

    private static native void setWispTask(long var0, int var2, Object var3, Object var4);

    public StackTraceElement[] getCoroutineStack() {
        return CoroutineSupport.getCoroutineStack(this.nativeCoroutine);
    }

    static {
        Coroutine.registerNatives();
    }

    public static enum StealResult {
        SUCCESS,
        FAIL_BY_CONTENTION,
        FAIL_BY_STATUS,
        FAIL_BY_NATIVE_FRAME;

    }
}

