/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.wisp.engine;

import com.alibaba.wisp.engine.WispConfiguration;
import com.alibaba.wisp.engine.WispTask;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public class TimeOut {
    private final Action action;
    final WispTask task;
    long deadlineNano;
    boolean canceled = false;
    private int queueIdx;
    private TimerManager manager;

    public TimeOut(WispTask wispTask, long l, Action action) {
        this.task = wispTask;
        this.deadlineNano = l;
        this.action = action;
    }

    public boolean expired() {
        return !this.canceled && System.nanoTime() >= this.deadlineNano;
    }

    void doAction() {
        switch (this.action) {
            case RESUME: {
                this.task.carrier.wakeupTask(this.task);
                break;
            }
            case JDK_UNPARK: {
                this.task.jdkUnpark();
                break;
            }
            case JVM_UNPARK: {
                this.task.unpark();
            }
        }
    }

    private static long overflowFree(long l, TimeOut timeOut) {
        if (l < -4611686018427387904L) {
            l = Long.MAX_VALUE;
        }
        if (timeOut != null && timeOut.deadlineNano < 0L && l > 0L && l - timeOut.deadlineNano < 0L) {
            l = Long.MAX_VALUE + timeOut.deadlineNano;
        }
        return l;
    }

    static long nanos2Millis(long l) {
        long l2 = TimeUnit.NANOSECONDS.toMillis(l + TimeUnit.MILLISECONDS.toNanos(1L) / 2L);
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (WispConfiguration.PARK_ONE_MS_AT_LEAST && l2 == 0L) {
            l2 = 1L;
        }
        return l2;
    }

    static class TimerManager {
        Queue queue = new Queue();
        ConcurrentLinkedQueue<TimeOut> rmQ = new ConcurrentLinkedQueue();

        TimerManager() {
        }

        void copyTimer(Queue queue) {
            queue.size = 0;
            for (TimeOut timeOut : queue.queue) {
                if (timeOut == null) continue;
                this.addTimer(timeOut);
            }
        }

        void addTimer(TimeOut timeOut) {
            timeOut.deadlineNano = TimeOut.overflowFree(timeOut.deadlineNano, this.queue.peek());
            timeOut.manager = this;
            this.queue.offer(timeOut);
        }

        void cancelTimer(TimeOut timeOut) {
            if (timeOut.queueIdx != -1) {
                if (timeOut.manager == this) {
                    this.queue.remove(timeOut);
                } else {
                    ((TimeOut)timeOut).manager.rmQ.add(timeOut);
                }
            }
        }

        long processTimeoutEventsAndGetWaitDeadline(long l) {
            TimeOut timeOut;
            while ((timeOut = this.rmQ.poll()) != null) {
                assert (timeOut.manager == this);
                this.queue.remove(timeOut);
            }
            long l2 = -1L;
            if (this.queue.size != 0) {
                while ((timeOut = this.queue.peek()) != null) {
                    if (timeOut.canceled) {
                        this.queue.poll();
                        continue;
                    }
                    if (timeOut.deadlineNano <= l) {
                        this.queue.poll();
                        timeOut.doAction();
                        continue;
                    }
                    l2 = timeOut.deadlineNano;
                    break;
                }
            }
            return l2;
        }

        static class Queue {
            private static final int INITIAL_CAPACITY = 16;
            private TimeOut[] queue = new TimeOut[16];
            private int size = 0;

            Queue() {
            }

            private void siftUp(int n, TimeOut timeOut) {
                while (n > 0) {
                    int n2 = n - 1 >>> 1;
                    TimeOut timeOut2 = this.queue[n2];
                    if (timeOut.deadlineNano >= timeOut2.deadlineNano) break;
                    this.queue[n] = timeOut2;
                    timeOut2.queueIdx = n;
                    n = n2;
                }
                this.queue[n] = timeOut;
                timeOut.queueIdx = n;
            }

            private void siftDown(int n, TimeOut timeOut) {
                int n2 = this.size >>> 1;
                while (n < n2) {
                    int n3 = (n << 1) + 1;
                    TimeOut timeOut2 = this.queue[n3];
                    int n4 = n3 + 1;
                    if (n4 < this.size && timeOut2.deadlineNano > this.queue[n4].deadlineNano) {
                        n3 = n4;
                        timeOut2 = this.queue[n3];
                    }
                    if (timeOut.deadlineNano <= timeOut2.deadlineNano) break;
                    this.queue[n] = timeOut2;
                    timeOut2.queueIdx = n;
                    n = n3;
                }
                this.queue[n] = timeOut;
                timeOut.queueIdx = n;
            }

            public boolean remove(TimeOut timeOut) {
                int n = timeOut.queueIdx;
                if (n == -1) {
                    return false;
                }
                this.queue[n].queueIdx = -1;
                int n2 = --this.size;
                TimeOut timeOut2 = this.queue[n2];
                this.queue[n2] = null;
                if (n2 != n) {
                    this.siftDown(n, timeOut2);
                    if (this.queue[n] == timeOut2) {
                        this.siftUp(n, timeOut2);
                    }
                }
                return true;
            }

            public int size() {
                return this.size;
            }

            public boolean offer(TimeOut timeOut) {
                int n;
                if ((n = this.size++) >= this.queue.length) {
                    this.queue = Arrays.copyOf(this.queue, this.queue.length * 2);
                }
                if (n == 0) {
                    this.queue[0] = timeOut;
                    timeOut.queueIdx = 0;
                } else {
                    this.siftUp(n, timeOut);
                }
                return true;
            }

            public TimeOut poll() {
                if (this.size == 0) {
                    return null;
                }
                TimeOut timeOut = this.queue[0];
                int n = --this.size;
                TimeOut timeOut2 = this.queue[n];
                this.queue[n] = null;
                if (n != 0) {
                    this.siftDown(0, timeOut2);
                }
                timeOut.queueIdx = -1;
                return timeOut;
            }

            public TimeOut peek() {
                return this.queue[0];
            }
        }
    }

    static enum Action {
        JVM_UNPARK,
        JDK_UNPARK,
        RESUME;

    }
}

