import { ResourceAgentDescribeAgent } from "dev/types";

export const ocfHeartbeatDummy: ResourceAgentDescribeAgent = {
  name: "ocf:heartbeat:Dummy",
  shortdesc: "Example stateless resource agent",
  longdesc:
    "This is a Dummy Resource Agent. It does absolutely nothing except \nkeep track of whether its running or not.\nIts purpose in life is for testing and to serve as a template for RA writers.\n\nNB: Please pay attention to the timeouts specified in the actions\nsection below. They should be meaningful for the kind of resource\nthe agent manages. They should be the minimum advised timeouts,\nbut they shouldn't/cannot cover _all_ possible resource\ninstances. So, try to be neither overly generous nor too stingy,\nbut moderate. The minimum timeouts should never be below 10 seconds.",
  parameters: [
    {
      name: "state",
      longdesc: "Location to store the resource state in.",
      shortdesc: "State file",
      type: "string",
      default: "/run/resource-agents/Dummy-Dummy.state",
      required: false,
      advanced: false,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
      unique: true,
    },
    {
      name: "fake",
      longdesc: "Fake attribute that can be changed to cause a reload",
      shortdesc: "Fake attribute that can be changed to cause a reload",
      type: "string",
      default: "dummy",
      required: false,
      advanced: false,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
      unique: false,
    },
    {
      name: "trace_ra",
      longdesc:
        "Set to 1 to turn on resource agent tracing (expect large output) The trace output will be saved to trace_file, if set, or by default to $HA_VARRUN/ra_trace/<type>/<id>.<action>.<timestamp> e.g. $HA_VARRUN/ra_trace/oracle/db.start.2012-11-27.08:37:08",
      shortdesc:
        "Set to 1 to turn on resource agent tracing (expect large output)",
      type: "integer",
      default: 0,
      required: false,
      advanced: true,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
      unique: false,
    },
    {
      name: "trace_file",
      longdesc: "Path to a file to store resource agent tracing log",
      shortdesc: "Path to a file to store resource agent tracing log",
      type: "string",
      default: "",
      required: false,
      advanced: true,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
      unique: false,
    },
  ],
  actions: [
    { name: "start", timeout: "20s" },
    { name: "stop", timeout: "20s" },
    { name: "monitor", timeout: "20s", interval: "10s" },
    { name: "reload", timeout: "20s" },
    { name: "migrate_to", timeout: "20s" },
    { name: "migrate_from", timeout: "20s" },
    { name: "meta-data", timeout: "5s" },
    { name: "validate-all", timeout: "20s" },
  ],
  default_actions: [
    { name: "start", timeout: "20s", interval: "0s" },
    { name: "stop", timeout: "20s", interval: "0s" },
    { name: "monitor", timeout: "20s", interval: "10s" },
    { name: "reload", timeout: "20s", interval: "0s" },
    { name: "migrate_to", timeout: "20s", interval: "0s" },
    { name: "migrate_from", timeout: "20s", interval: "0s" },
  ],
};
