/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#ifndef OB_MOCK_STMT_H_
#define OB_MOCK_STMT_H_

#include "sql/resolver/cmd/ob_cmd_stmt.h"

namespace oceanbase
{
namespace sql
{
class ObMockStmt : public ObCMDStmt
{
public:
  ObMockStmt() : ObCMDStmt(stmt::T_NONE)
  {
  }
  virtual ~ObMockStmt() {}

  int add_stmt(stmt::StmtType stmt_type) {
    return stmt_types_.push_back(stmt_type);
  }

  const ObIArray<stmt::StmtType> &get_stmt_type_list() const {
    return stmt_types_;
  }

private:
  DISALLOW_COPY_AND_ASSIGN(ObMockStmt);
  ObSEArray<stmt::StmtType, 16> stmt_types_;
};
}
}

#endif
