/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#define USING_LOG_PREFIX SHARE_SCHEMA
#include "ob_inner_table_schema.h"

#include "share/schema/ob_schema_macro_define.h"
#include "share/schema/ob_schema_service_sql_impl.h"
#include "share/schema/ob_table_schema.h"
#include "share/scn.h"

namespace oceanbase
{
using namespace share::schema;
using namespace common;
namespace share
{

int ObInnerTableSchema::dba_synonyms_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_DBA_SYNONYMS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_DBA_SYNONYMS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       A.DATABASE_NAME AS OWNER,       A.SYNONYM_NAME AS SYNONYM_NAME,       CAST(CASE WHEN INSTR(A.OBJECT_NAME, '@') = 0            THEN B.DATABASE_NAME            ELSE SUBSTR(A.OBJECT_NAME, 1, INSTR(A.OBJECT_NAME, '.') -1)            END            AS VARCHAR2(128)) AS TABLE_OWNER,       CAST(CASE WHEN INSTR(A.OBJECT_NAME, '@') = 0            THEN A.OBJECT_NAME            ELSE SUBSTR(A.OBJECT_NAME, INSTR(A.OBJECT_NAME, '.') + 1, INSTR(A.OBJECT_NAME, '@') - INSTR(A.OBJECT_NAME, '.') -1)            END            AS VARCHAR2(128)) AS TABLE_NAME,       CAST(CASE WHEN INSTR(A.OBJECT_NAME, '@') = 0                 THEN NULL                 ELSE SUBSTR(A.OBJECT_NAME, INSTR(A.OBJECT_NAME, '@')+1)                 END                 AS VARCHAR2(128)) AS DB_LINK     FROM       (SELECT BB.DATABASE_NAME, AA.SYNONYM_NAME,       AA.OBJECT_NAME, AA.SYNONYM_ID       FROM       SYS.ALL_VIRTUAL_SYNONYM_REAL_AGENT AA,       SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT BB       WHERE AA.DATABASE_ID = BB.DATABASE_ID         AND AA.TENANT_ID = EFFECTIVE_TENANT_ID()         AND BB.TENANT_ID = EFFECTIVE_TENANT_ID()) A,       (SELECT BB.DATABASE_NAME, AA.SYNONYM_ID       FROM       SYS.ALL_VIRTUAL_SYNONYM_REAL_AGENT AA,       SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT BB       WHERE AA.OBJECT_DATABASE_ID = BB.DATABASE_ID         AND AA.TENANT_ID = EFFECTIVE_TENANT_ID()         AND BB.TENANT_ID = EFFECTIVE_TENANT_ID()) B     WHERE       A.SYNONYM_ID = B.SYNONYM_ID )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::dba_objects_ora_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_DBA_OBJECTS_ORA_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_DBA_OBJECTS_ORA_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       CAST(B.DATABASE_NAME AS VARCHAR(128)) AS OWNER,       CAST(A.OBJECT_NAME AS VARCHAR(128)) AS OBJECT_NAME,       CAST(A.SUBOBJECT_NAME AS VARCHAR2(128)) AS SUBOBJECT_NAME,       CAST(A.OBJECT_ID AS NUMBER) AS OBJECT_ID,       CAST(A.DATA_OBJECT_ID AS NUMBER) AS DATA_OBJECT_ID,       CAST(A.OBJECT_TYPE AS VARCHAR2(23)) AS OBJECT_TYPE,       CAST(A.GMT_CREATE AS DATE) AS CREATED,       CAST(A.GMT_MODIFIED AS DATE) AS LAST_DDL_TIME,       CAST(TO_CHAR(A.GMT_CREATE) AS VARCHAR2(19)) AS TIMESTAMP,       CAST(A.STATUS AS VARCHAR2(7)) AS STATUS,       CAST(A.TEMPORARY AS VARCHAR2(1)) AS TEMPORARY,       CAST(A."GENERATED" AS VARCHAR2(1)) AS "GENERATED",       CAST(A.SECONDARY AS VARCHAR2(1)) AS SECONDARY,       CAST(A.NAMESPACE AS NUMBER) AS NAMESPACE,       CAST(A.EDITION_NAME AS VARCHAR2(128)) AS EDITION_NAME,       CAST(NULL AS VARCHAR2(18)) AS SHARING,       CAST(NULL AS VARCHAR2(1)) AS EDITIONABLE,       CAST(NULL AS VARCHAR2(1)) AS ORACLE_MAINTAINED,       CAST(NULL AS VARCHAR2(1)) AS APPLICATION,       CAST(NULL AS VARCHAR2(1)) AS DEFAULT_COLLATION,       CAST(NULL AS VARCHAR2(1)) AS DUPLICATED,       CAST(NULL AS VARCHAR2(1)) AS SHARDED,       CAST(NULL AS VARCHAR2(1)) AS IMPORTED_OBJECT,       CAST(NULL AS NUMBER) AS CREATED_APPID,       CAST(NULL AS NUMBER) AS CREATED_VSNID,       CAST(NULL AS NUMBER) AS MODIFIED_APPID,       CAST(NULL AS NUMBER) AS MODIFIED_VSNID     FROM (       SELECT              A.TENANT_ID,              (TO_DATE('19700101','YYYYMMDD')               + B.SCHEMA_VERSION / 86400 / 1000000               + TO_NUMBER(SUBSTR(TZ_OFFSET(SESSIONTIMEZONE),1,3))/24) AS GMT_CREATE,              (TO_DATE('19700101','YYYYMMDD')               + A.SCHEMA_VERSION / 86400 / 1000000               + TO_NUMBER(SUBSTR(TZ_OFFSET(SESSIONTIMEZONE),1,3))/24) AS GMT_MODIFIED,              A.DATABASE_ID,              A.TABLE_NAME AS OBJECT_NAME,              NULL AS SUBOBJECT_NAME,              CAST(A.TABLE_ID AS NUMBER) AS OBJECT_ID,              A.TABLE_ID AS DATA_OBJECT_ID,              'TABLE' AS OBJECT_TYPE,              'VALID' AS STATUS,              'N' AS TEMPORARY,              'N' AS "GENERATED",              'N' AS SECONDARY,              0 AS NAMESPACE,              NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_CORE_ALL_TABLE A       JOIN SYS.ALL_VIRTUAL_CORE_ALL_TABLE B         ON A.TENANT_ID = B.TENANT_ID       WHERE B.TABLE_NAME = '__all_core_table'             AND A.TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT       TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,DATABASE_ID       ,CAST((CASE              WHEN DATABASE_ID = 201004 THEN TABLE_NAME              WHEN TABLE_TYPE = 5 THEN SUBSTR(TABLE_NAME, 7 + INSTR(SUBSTR(TABLE_NAME, 7), '_'))              ELSE TABLE_NAME END) AS VARCHAR2(128)) AS OBJECT_NAME       ,NULL SUBOBJECT_NAME       ,TABLE_ID OBJECT_ID       ,(CASE WHEN TABLET_ID != 0 THEN TABLET_ID ELSE NULL END) DATA_OBJECT_ID       ,CASE WHEN TABLE_TYPE IN (0,3,6,8,9,14) THEN 'TABLE'             WHEN TABLE_TYPE IN (2) THEN 'VIRTUAL TABLE'             WHEN TABLE_TYPE IN (1,4) THEN 'VIEW'             WHEN TABLE_TYPE IN (5) THEN 'INDEX'             WHEN TABLE_TYPE IN (7) THEN 'MATERIALIZED VIEW'             WHEN TABLE_TYPE IN (15) THEN 'MATERIALIZED VIEW LOG'             ELSE NULL END AS OBJECT_TYPE       ,CAST(CASE WHEN TABLE_TYPE IN (5) THEN CASE WHEN INDEX_STATUS = 2 THEN 'VALID'               WHEN INDEX_STATUS = 3 THEN 'CHECKING'               WHEN INDEX_STATUS = 4 THEN 'INELEGIBLE'               WHEN INDEX_STATUS = 5 THEN 'ERROR'               ELSE 'UNUSABLE' END             ELSE  CASE WHEN OBJECT_STATUS = 1 THEN 'VALID' ELSE 'INVALID' END END AS VARCHAR2(10)) AS STATUS       ,CASE WHEN TABLE_TYPE IN (6,8,9) THEN 'Y'           ELSE 'N' END AS TEMPORARY       ,CASE WHEN TABLE_TYPE IN (0,1) THEN 'Y'           ELSE 'N' END AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM       SYS.ALL_VIRTUAL_TABLE_REAL_AGENT       WHERE TENANT_ID = EFFECTIVE_TENANT_ID() AND TABLE_TYPE != 12 AND TABLE_TYPE != 13          AND BITAND((TABLE_MODE / 4096), 15) IN (0,1)          AND BITAND(INDEX_ATTRIBUTES_SET, 16) = 0        UNION ALL        SELECT           CST.TENANT_ID          ,CST.GMT_CREATE          ,CST.GMT_MODIFIED          ,DB.DATABASE_ID          ,CST.CONSTRAINT_NAME AS OBJECT_NAME          ,NULL AS SUBOBJECT_NAME          ,TBL.TABLE_ID AS OBJECT_ID          ,NULL AS DATA_OBJECT_ID          ,'INDEX' AS OBJECT_TYPE          ,'VALID' AS STATUS          ,'N' AS TEMPORARY          ,'N' AS "GENERATED"          ,'N' AS SECONDARY          ,0 AS NAMESPACE          ,NULL AS EDITION_NAME          FROM SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT CST, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT TBL, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT DB          WHERE CST.TENANT_ID = EFFECTIVE_TENANT_ID() AND DB.DATABASE_ID = TBL.DATABASE_ID AND TBL.TABLE_ID = CST.TABLE_ID and CST.CONSTRAINT_TYPE = 1 AND TBL.TABLE_TYPE != 12 AND TBL.TABLE_TYPE != 13             AND BITAND((TBL.TABLE_MODE / 4096), 15) IN (0,1)              AND BITAND(TBL.INDEX_ATTRIBUTES_SET, 16) = 0        UNION ALL        SELECT       P.TENANT_ID       ,P.GMT_CREATE       ,P.GMT_MODIFIED       ,T.DATABASE_ID       ,CAST((CASE              WHEN T.DATABASE_ID = 201004 THEN T.TABLE_NAME              WHEN T.TABLE_TYPE = 5 THEN SUBSTR(T.TABLE_NAME, 7 + INSTR(SUBSTR(T.TABLE_NAME, 7), '_'))              ELSE T.TABLE_NAME END) AS VARCHAR2(128)) AS OBJECT_NAME       ,P.PART_NAME SUBOBJECT_NAME       ,P.PART_ID OBJECT_ID       ,CASE WHEN P.TABLET_ID != 0 THEN P.TABLET_ID ELSE NULL END AS DATA_OBJECT_ID       ,DECODE (T.TABLE_TYPE, 5, 'INDEX PARTITION', 'TABLE PARTITION') AS OBJECT_TYPE       ,'VALID' AS STATUS       ,'N' AS TEMPORARY       , NULL AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT T JOIN SYS.ALL_VIRTUAL_PART_REAL_AGENT P ON T.TABLE_ID = P.TABLE_ID       WHERE T.TENANT_ID = EFFECTIVE_TENANT_ID() AND P.TENANT_ID = EFFECTIVE_TENANT_ID() AND T.TABLE_TYPE != 12 AND T.TABLE_TYPE != 13       AND P.PARTITION_TYPE = 0       AND bitand((T.TABLE_MODE / 4096), 15) IN (0,1)       /*do not show deleting index*/       AND BITAND(T.INDEX_ATTRIBUTES_SET, 16) = 0       UNION ALL        SELECT       SUBP.TENANT_ID       ,SUBP.GMT_CREATE       ,SUBP.GMT_MODIFIED       ,T.DATABASE_ID       ,CAST((CASE              WHEN T.DATABASE_ID = 201004 THEN T.TABLE_NAME              WHEN T.TABLE_TYPE = 5 THEN SUBSTR(T.TABLE_NAME, 7 + INSTR(SUBSTR(T.TABLE_NAME, 7), '_'))              ELSE T.TABLE_NAME END) AS VARCHAR2(128)) AS OBJECT_NAME       ,SUBP.SUB_PART_NAME SUBOBJECT_NAME       ,SUBP.SUB_PART_ID OBJECT_ID       ,SUBP.TABLET_ID AS DATA_OBJECT_ID       ,DECODE (T.TABLE_TYPE, 5, 'INDEX SUBPARTITION', 'TABLE SUBPARTITION') AS OBJECT_TYPE       ,'VALID' AS STATUS       ,'N' AS TEMPORARY       ,'Y' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT T, SYS.ALL_VIRTUAL_PART_REAL_AGENT P,SYS.ALL_VIRTUAL_SUB_PART_REAL_AGENT SUBP       WHERE T.TABLE_ID =P.TABLE_ID AND P.TABLE_ID=SUBP.TABLE_ID AND P.PART_ID =SUBP.PART_ID       AND T.TENANT_ID = EFFECTIVE_TENANT_ID() AND P.TENANT_ID = EFFECTIVE_TENANT_ID() AND SUBP.TENANT_ID = EFFECTIVE_TENANT_ID()       AND T.TABLE_TYPE != 12 AND T.TABLE_TYPE != 13 AND bitand((T.TABLE_MODE / 4096), 15) IN (0,1)       AND SUBP.PARTITION_TYPE = 0 AND P.PARTITION_TYPE = 0       /*do not show deleting index*/       AND BITAND(T.INDEX_ATTRIBUTES_SET, 16) = 0        UNION ALL        SELECT         EFFECTIVE_TENANT_ID() AS TENANT_ID         ,GMT_CREATE         ,GMT_MODIFIED         ,CAST(201006 AS NUMBER) AS DATABASE_ID         ,PACKAGE_NAME AS OBJECT_NAME         ,NULL AS SUBOBJECT_NAME         ,PACKAGE_ID OBJECT_ID         ,NULL AS DATA_OBJECT_ID         ,CASE WHEN TYPE = 1 THEN 'PACKAGE'               WHEN TYPE = 2 THEN 'PACKAGE BODY'               ELSE NULL END AS OBJECT_TYPE         ,'VALID' AS STATUS         ,'N' AS TEMPORARY         ,'N' AS "GENERATED"         ,'N' AS SECONDARY         ,0 AS NAMESPACE         ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_PACKAGE_SYS_AGENT        UNION ALL        SELECT       P.TENANT_ID       ,P.GMT_CREATE       ,P.GMT_MODIFIED       ,P.DATABASE_ID       ,P.PACKAGE_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,P.PACKAGE_ID OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,CASE WHEN TYPE = 1 THEN 'PACKAGE'             WHEN TYPE = 2 THEN 'PACKAGE BODY'             ELSE NULL END AS OBJECT_TYPE       ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE P.TENANT_ID = E.TENANT_ID AND P.PACKAGE_ID = E.OBJ_ID AND (E.OBJ_TYPE = 3 OR E.OBJ_TYPE = 5))                  THEN 'INVALID'             WHEN TYPE = 2 AND EXISTS                    (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT Eb                     WHERE OBJ_ID IN                              (SELECT PACKAGE_ID FROM SYS.ALL_VIRTUAL_PACKAGE_REAL_AGENT Pb                               WHERE Pb.PACKAGE_NAME = P.PACKAGE_NAME AND Pb.DATABASE_ID = P.DATABASE_ID AND Pb.TENANT_ID = P.TENANT_ID AND TYPE = 1)                           AND Eb.OBJ_TYPE = 3)               THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_PACKAGE_REAL_AGENT P       WHERE P.TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT       R.TENANT_ID       ,R.GMT_CREATE       ,R.GMT_MODIFIED       ,R.DATABASE_ID       ,R.ROUTINE_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,R.ROUTINE_ID OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,CASE WHEN ROUTINE_TYPE = 1 THEN 'PROCEDURE'             WHEN ROUTINE_TYPE = 2 THEN 'FUNCTION'             ELSE NULL END AS OBJECT_TYPE       ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE R.TENANT_ID = E.TENANT_ID AND R.ROUTINE_ID = E.OBJ_ID AND (E.OBJ_TYPE = 9 OR E.OBJ_TYPE = 12))                  THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_ROUTINE_REAL_AGENT R       WHERE (ROUTINE_TYPE = 1 OR ROUTINE_TYPE = 2) AND R.TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT         EFFECTIVE_TENANT_ID() AS TENANT_ID         ,GMT_CREATE         ,GMT_MODIFIED         ,CAST(201006 AS NUMBER) AS DATABASE_ID         ,TS.TYPE_NAME AS OBJECT_NAME         ,NULL AS SUBOBJECT_NAME         ,TS.TYPE_ID AS OBJECT_ID         ,NULL AS DATA_OBJECT_ID         ,'TYPE' AS OBJECT_TYPE         ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE TS.TENANT_ID = E.TENANT_ID AND TS.TYPE_ID = E.OBJ_ID AND E.OBJ_TYPE = 4)                   THEN 'INVALID'               ELSE 'VALID' END AS STATUS         ,'N' AS TEMPORARY         ,'N' AS "GENERATED"         ,'N' AS SECONDARY         ,0 AS NAMESPACE         ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TYPE_SYS_AGENT TS        UNION ALL        SELECT       TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,DATABASE_ID       ,TYPE_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,TYPE_ID OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'TYPE' AS OBJECT_TYPE       ,CASE WHEN EXISTS                 (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                   WHERE TY.TENANT_ID = E.TENANT_ID AND TY.TYPE_ID = E.OBJ_ID AND E.OBJ_TYPE = 4)                 THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TYPE_REAL_AGENT TY       WHERE TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT       EFFECTIVE_TENANT_ID() AS TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,CAST(201006 AS NUMBER) AS DATABASE_ID       ,OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,OBJECT_TYPE_ID OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'TYPE BODY' AS OBJECT_TYPE       ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE EFFECTIVE_TENANT_ID() = E.TENANT_ID AND TS.OBJECT_TYPE_ID = E.OBJ_ID AND E.OBJ_TYPE = 6)                   THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TENANT_OBJECT_TYPE_SYS_AGENT TS       WHERE TYPE = 2        UNION ALL        SELECT       TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,DATABASE_ID       ,OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,OBJECT_TYPE_ID OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'TYPE BODY' AS OBJECT_TYPE       ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE TY.TENANT_ID = E.TENANT_ID AND TY.OBJECT_TYPE_ID = E.OBJ_ID AND E.OBJ_TYPE = 6)                   THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TENANT_OBJECT_TYPE_REAL_AGENT TY       WHERE TENANT_ID = EFFECTIVE_TENANT_ID() and TYPE = 2        UNION ALL        SELECT       T.TENANT_ID       ,T.GMT_CREATE       ,T.GMT_MODIFIED       ,T.DATABASE_ID       ,T.TRIGGER_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,T.TRIGGER_ID OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'TRIGGER' OBJECT_TYPE       ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE T.TENANT_ID = E.TENANT_ID AND T.TRIGGER_ID = E.OBJ_ID AND (E.OBJ_TYPE = 7))                  THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TENANT_TRIGGER_REAL_AGENT T       WHERE T.TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT       TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,DATABASE_ID       ,SEQUENCE_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,SEQUENCE_ID OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'SEQUENCE' AS OBJECT_TYPE       ,'VALID' AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_SEQUENCE_OBJECT_REAL_AGENT       WHERE TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT       TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,DATABASE_ID       ,SYNONYM_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,SYNONYM_ID OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'SYNONYM' AS OBJECT_TYPE       ,'VALID' AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_SYNONYM_REAL_AGENT       WHERE TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT         TENANT_ID         ,GMT_CREATE         ,GMT_MODIFIED         ,CAST(201006 AS NUMBER) AS DATABASE_ID         ,NAMESPACE AS OBJECT_NAME         ,NULL AS SUBOBJECT_NAME         ,CONTEXT_ID OBJECT_ID         ,NULL AS DATA_OBJECT_ID         ,'CONTEXT' AS OBJECT_TYPE         ,'VALID' AS STATUS         ,'N' AS TEMPORARY         ,'N' AS "GENERATED"         ,'N' AS SECONDARY         ,21 AS NAMESPACE         ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_CONTEXT_REAL_AGENT       WHERE TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT         TENANT_ID,         GMT_CREATE,         GMT_MODIFIED,         DATABASE_ID,         DATABASE_NAME AS OBJECT_NAME,         NULL AS SUBOBJECT_NAME,         DATABASE_ID AS OBJECT_ID,         NULL AS DATA_OBJECT_ID,         'DATABASE' AS OBJECT_TYPE,         'VALID' AS STATUS,         'N' AS TEMPORARY,         'N' AS "GENERATED",         'N' AS SECONDARY,         0 AS NAMESPACE,         NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT       WHERE TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT         TENANT_ID,         GMT_CREATE,         GMT_MODIFIED,         CAST(201001 AS NUMBER) AS DATABASE_ID,         TABLEGROUP_NAME AS OBJECT_NAME,         NULL AS SUBOBJECT_NAME,         TABLEGROUP_ID AS OBJECT_ID,         NULL AS DATA_OBJECT_ID,         'TABLEGROUP' AS OBJECT_TYPE,         'VALID' AS STATUS,         'N' AS TEMPORARY,         'N' AS "GENERATED",         'N' AS SECONDARY,         0 AS NAMESPACE,         NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TABLEGROUP_REAL_AGENT       WHERE TENANT_ID = EFFECTIVE_TENANT_ID()     ) A     JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT B     ON A.TENANT_ID = B.TENANT_ID        AND A.DATABASE_ID = B.DATABASE_ID        AND B.TENANT_ID = EFFECTIVE_TENANT_ID() )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::all_objects_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_ALL_OBJECTS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_ALL_OBJECTS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       CAST(B.DATABASE_NAME AS VARCHAR(128)) AS OWNER,       CAST(A.OBJECT_NAME AS VARCHAR(128)) AS OBJECT_NAME,       CAST(A.SUBOBJECT_NAME AS VARCHAR2(128)) AS SUBOBJECT_NAME,       CAST(A.OBJECT_ID AS NUMBER) AS OBJECT_ID,       CAST(A.DATA_OBJECT_ID AS NUMBER) AS DATA_OBJECT_ID,       CAST(A.OBJECT_TYPE AS VARCHAR2(23)) AS OBJECT_TYPE,       CAST(A.GMT_CREATE AS DATE) AS CREATED,       CAST(A.GMT_MODIFIED AS DATE) AS LAST_DDL_TIME,       CAST(TO_CHAR(A.GMT_CREATE) AS VARCHAR2(19)) AS TIMESTAMP,       CAST(A.STATUS AS VARCHAR2(7)) AS STATUS,       CAST(A.TEMPORARY AS VARCHAR2(1)) AS TEMPORARY,       CAST(A."GENERATED" AS VARCHAR2(1)) AS "GENERATED",       CAST(A.SECONDARY AS VARCHAR2(1)) AS SECONDARY,       CAST(A.NAMESPACE AS NUMBER) AS NAMESPACE,       CAST(A.EDITION_NAME AS VARCHAR2(128)) AS EDITION_NAME,       CAST(NULL AS VARCHAR2(18)) AS SHARING,       CAST(NULL AS VARCHAR2(1)) AS EDITIONABLE,       CAST(NULL AS VARCHAR2(1)) AS ORACLE_MAINTAINED,       CAST(NULL AS VARCHAR2(1)) AS APPLICATION,       CAST(NULL AS VARCHAR2(1)) AS DEFAULT_COLLATION,       CAST(NULL AS VARCHAR2(1)) AS DUPLICATED,       CAST(NULL AS VARCHAR2(1)) AS SHARDED,       CAST(NULL AS VARCHAR2(1)) AS IMPORTED_OBJECT,       CAST(NULL AS NUMBER) AS CREATED_APPID,       CAST(NULL AS NUMBER) AS CREATED_VSNID,       CAST(NULL AS NUMBER) AS MODIFIED_APPID,       CAST(NULL AS NUMBER) AS MODIFIED_VSNID     FROM (       SELECT              A.TENANT_ID,              (TO_DATE('19700101','YYYYMMDD')               + B.SCHEMA_VERSION / 86400 / 1000000               + TO_NUMBER(SUBSTR(TZ_OFFSET(SESSIONTIMEZONE),1,3))/24) AS GMT_CREATE,              (TO_DATE('19700101','YYYYMMDD')               + A.SCHEMA_VERSION / 86400 / 1000000               + TO_NUMBER(SUBSTR(TZ_OFFSET(SESSIONTIMEZONE),1,3))/24) AS GMT_MODIFIED,              A.DATABASE_ID,              A.TABLE_NAME AS OBJECT_NAME,              NULL AS SUBOBJECT_NAME,              CAST(A.TABLE_ID AS NUMBER) AS OBJECT_ID,              CAST(A.TABLE_ID AS NUMBER) AS PRIV_OBJECT_ID,              A.TABLE_ID AS DATA_OBJECT_ID,              'TABLE' AS OBJECT_TYPE,              'VALID' AS STATUS,              'N' AS TEMPORARY,              'N' AS "GENERATED",              'N' AS SECONDARY,              0 AS NAMESPACE,              NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_CORE_ALL_TABLE A       JOIN SYS.ALL_VIRTUAL_CORE_ALL_TABLE B         ON A.TENANT_ID = B.TENANT_ID       WHERE B.TABLE_NAME = '__all_core_table'             AND A.TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT       TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,DATABASE_ID       ,CAST((CASE              WHEN DATABASE_ID = 201004 THEN TABLE_NAME              WHEN TABLE_TYPE = 5 THEN SUBSTR(TABLE_NAME, 7 + INSTR(SUBSTR(TABLE_NAME, 7), '_'))              ELSE TABLE_NAME END) AS VARCHAR2(128)) AS OBJECT_NAME       ,NULL SUBOBJECT_NAME       ,TABLE_ID OBJECT_ID       ,TABLE_ID PRIV_OBJECT_ID       ,(CASE WHEN TABLET_ID != 0 THEN TABLET_ID ELSE NULL END) DATA_OBJECT_ID       ,CASE WHEN TABLE_TYPE IN (0,3,6,8,9,14) THEN 'TABLE'             WHEN TABLE_TYPE IN (2) THEN 'VIRTUAL TABLE'             WHEN TABLE_TYPE IN (1,4) THEN 'VIEW'             WHEN TABLE_TYPE IN (5) THEN 'INDEX'             WHEN TABLE_TYPE IN (7) THEN 'MATERIALIZED VIEW'             WHEN TABLE_TYPE IN (15) THEN 'MATERIALIZED VIEW LOG'             ELSE NULL END AS OBJECT_TYPE       ,CAST(CASE WHEN TABLE_TYPE IN (5,15) THEN CASE WHEN INDEX_STATUS = 2 THEN 'VALID'               WHEN INDEX_STATUS = 3 THEN 'CHECKING'               WHEN INDEX_STATUS = 4 THEN 'INELEGIBLE'               WHEN INDEX_STATUS = 5 THEN 'ERROR'               ELSE 'UNUSABLE' END             ELSE  CASE WHEN OBJECT_STATUS = 1 THEN 'VALID' ELSE 'INVALID' END END AS VARCHAR2(10)) AS STATUS       ,CASE WHEN TABLE_TYPE IN (6,8,9) THEN 'Y'           ELSE 'N' END AS TEMPORARY       ,CASE WHEN TABLE_TYPE IN (0,1) THEN 'Y'           ELSE 'N' END AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM       SYS.ALL_VIRTUAL_TABLE_REAL_AGENT       WHERE TENANT_ID = EFFECTIVE_TENANT_ID() AND TABLE_TYPE != 12 AND TABLE_TYPE != 13          AND BITAND((TABLE_MODE / 4096), 15) IN (0,1)         AND BITAND(INDEX_ATTRIBUTES_SET, 16) = 0        UNION ALL        SELECT           CST.TENANT_ID          ,CST.GMT_CREATE          ,CST.GMT_MODIFIED          ,DB.DATABASE_ID          ,CST.CONSTRAINT_NAME AS OBJECT_NAME          ,NULL AS SUBOBJECT_NAME          ,TBL.TABLE_ID AS OBJECT_ID          ,TBL.TABLE_ID AS PRIV_OBJECT_ID          ,NULL AS DATA_OBJECT_ID          ,'INDEX' AS OBJECT_TYPE          ,'VALID' AS STATUS          ,'N' AS TEMPORARY          ,'N' AS "GENERATED"          ,'N' AS SECONDARY          ,0 AS NAMESPACE          ,NULL AS EDITION_NAME          FROM SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT CST, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT TBL, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT DB          WHERE CST.TENANT_ID = EFFECTIVE_TENANT_ID() AND DB.DATABASE_ID = TBL.DATABASE_ID AND TBL.TABLE_ID = CST.TABLE_ID and CST.CONSTRAINT_TYPE = 1 AND TBL.TABLE_TYPE != 12 AND TBL.TABLE_TYPE != 13              AND BITAND((TBL.TABLE_MODE / 4096), 15) IN (0,1) AND BITAND(TBL.INDEX_ATTRIBUTES_SET, 16) = 0        UNION ALL        SELECT       P.TENANT_ID       ,P.GMT_CREATE       ,P.GMT_MODIFIED       ,T.DATABASE_ID       ,CAST((CASE              WHEN T.DATABASE_ID = 201004 THEN T.TABLE_NAME              WHEN T.TABLE_TYPE = 5 THEN SUBSTR(T.TABLE_NAME, 7 + INSTR(SUBSTR(T.TABLE_NAME, 7), '_'))              ELSE T.TABLE_NAME END) AS VARCHAR2(128)) AS OBJECT_NAME       ,P.PART_NAME SUBOBJECT_NAME       ,P.PART_ID OBJECT_ID       ,P.TABLE_ID PRIV_OBJECT_ID       ,CASE WHEN P.TABLET_ID != 0 THEN P.TABLET_ID ELSE NULL END AS DATA_OBJECT_ID       ,DECODE (T.TABLE_TYPE, 5, 'INDEX PARTITION', 'TABLE PARTITION') AS OBJECT_TYPE       ,'VALID' AS STATUS       ,'N' AS TEMPORARY       , NULL AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT T JOIN SYS.ALL_VIRTUAL_PART_REAL_AGENT P ON T.TABLE_ID = P.TABLE_ID       WHERE T.TENANT_ID = EFFECTIVE_TENANT_ID() AND P.TENANT_ID = EFFECTIVE_TENANT_ID() AND T.TABLE_TYPE != 12 AND T.TABLE_TYPE != 13 AND bitand((T.TABLE_MODE / 4096), 15) IN (0,1)       AND P.PARTITION_TYPE = 0       /*do not show deleting index*/       AND BITAND(T.INDEX_ATTRIBUTES_SET, 16) = 0        UNION ALL        SELECT       SUBP.TENANT_ID       ,SUBP.GMT_CREATE       ,SUBP.GMT_MODIFIED       ,T.DATABASE_ID       ,CAST((CASE              WHEN T.DATABASE_ID = 201004 THEN T.TABLE_NAME              WHEN T.TABLE_TYPE = 5 THEN SUBSTR(T.TABLE_NAME, 7 + INSTR(SUBSTR(T.TABLE_NAME, 7), '_'))              ELSE T.TABLE_NAME END) AS VARCHAR2(128)) AS OBJECT_NAME       ,SUBP.SUB_PART_NAME SUBOBJECT_NAME       ,SUBP.SUB_PART_ID OBJECT_ID       ,SUBP.TABLE_ID PRIV_OBJECT_ID       ,SUBP.TABLET_ID AS DATA_OBJECT_ID       ,DECODE (T.TABLE_TYPE, 5, 'INDEX SUBPARTITION', 'TABLE SUBPARTITION') AS OBJECT_TYPE       ,'VALID' AS STATUS       ,'N' AS TEMPORARY       ,'Y' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT T, SYS.ALL_VIRTUAL_PART_REAL_AGENT P,SYS.ALL_VIRTUAL_SUB_PART_REAL_AGENT SUBP       WHERE T.TABLE_ID =P.TABLE_ID AND P.TABLE_ID=SUBP.TABLE_ID AND P.PART_ID =SUBP.PART_ID       AND T.TENANT_ID = EFFECTIVE_TENANT_ID() AND P.TENANT_ID = EFFECTIVE_TENANT_ID() AND SUBP.TENANT_ID = EFFECTIVE_TENANT_ID()       AND T.TABLE_TYPE != 12 AND T.TABLE_TYPE != 13 AND bitand((T.TABLE_MODE / 4096), 15) IN (0,1)       AND SUBP.PARTITION_TYPE = 0 AND P.PARTITION_TYPE = 0       /*do not show deleting index*/       AND BITAND(T.INDEX_ATTRIBUTES_SET, 16) = 0        UNION ALL        SELECT         EFFECTIVE_TENANT_ID() AS TENANT_ID         ,GMT_CREATE         ,GMT_MODIFIED         ,CAST(201006 AS NUMBER) AS DATABASE_ID         ,PACKAGE_NAME AS OBJECT_NAME         ,NULL AS SUBOBJECT_NAME         ,PACKAGE_ID OBJECT_ID         ,PACKAGE_ID PRIV_OBJECT_ID         ,NULL AS DATA_OBJECT_ID         ,CASE WHEN TYPE = 1 THEN 'PACKAGE'               WHEN TYPE = 2 THEN 'PACKAGE BODY'               ELSE NULL END AS OBJECT_TYPE         ,'VALID' AS STATUS         ,'N' AS TEMPORARY         ,'N' AS "GENERATED"         ,'N' AS SECONDARY         ,0 AS NAMESPACE         ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_PACKAGE_SYS_AGENT        UNION ALL        SELECT       P.TENANT_ID       ,P.GMT_CREATE       ,P.GMT_MODIFIED       ,P.DATABASE_ID       ,P.PACKAGE_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,P.PACKAGE_ID OBJECT_ID       ,P.PACKAGE_ID PRIV_OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,CASE WHEN TYPE = 1 THEN 'PACKAGE'             WHEN TYPE = 2 THEN 'PACKAGE BODY'             ELSE NULL END AS OBJECT_TYPE       ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE P.TENANT_ID = E.TENANT_ID AND P.PACKAGE_ID = E.OBJ_ID AND (E.OBJ_TYPE = 3 OR E.OBJ_TYPE = 5))                  THEN 'INVALID'             WHEN TYPE = 2 AND EXISTS                    (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT Eb                     WHERE OBJ_ID IN                              (SELECT PACKAGE_ID FROM SYS.ALL_VIRTUAL_PACKAGE_REAL_AGENT Pb                               WHERE Pb.PACKAGE_NAME = P.PACKAGE_NAME AND Pb.DATABASE_ID = P.DATABASE_ID AND Pb.TENANT_ID = P.TENANT_ID AND TYPE = 1)                           AND Eb.OBJ_TYPE = 3)               THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_PACKAGE_REAL_AGENT P       WHERE P.TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT       R.TENANT_ID       ,R.GMT_CREATE       ,R.GMT_MODIFIED       ,R.DATABASE_ID       ,R.ROUTINE_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,R.ROUTINE_ID OBJECT_ID       ,R.ROUTINE_ID PRIV_OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,CASE WHEN ROUTINE_TYPE = 1 THEN 'PROCEDURE'             WHEN ROUTINE_TYPE = 2 THEN 'FUNCTION'             ELSE NULL END AS OBJECT_TYPE       ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE R.TENANT_ID = E.TENANT_ID AND R.ROUTINE_ID = E.OBJ_ID AND (E.OBJ_TYPE = 9 OR E.OBJ_TYPE = 12))                  THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_ROUTINE_REAL_AGENT R       WHERE (ROUTINE_TYPE = 1 OR ROUTINE_TYPE = 2) AND R.TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT         EFFECTIVE_TENANT_ID() AS TENANT_ID         ,GMT_CREATE         ,GMT_MODIFIED         ,CAST(201006 AS NUMBER) AS DATABASE_ID         ,TS.TYPE_NAME AS OBJECT_NAME         ,NULL AS SUBOBJECT_NAME         ,TS.TYPE_ID AS OBJECT_ID         ,TS.TYPE_ID AS PRIV_OBJECT_ID         ,NULL AS DATA_OBJECT_ID         ,'TYPE' AS OBJECT_TYPE         ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE TS.TENANT_ID = E.TENANT_ID AND TS.TYPE_ID = E.OBJ_ID AND E.OBJ_TYPE = 4)                   THEN 'INVALID'               ELSE 'VALID' END AS STATUS         ,'N' AS TEMPORARY         ,'N' AS "GENERATED"         ,'N' AS SECONDARY         ,0 AS NAMESPACE         ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TYPE_SYS_AGENT TS        UNION ALL        SELECT       TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,DATABASE_ID       ,TYPE_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,TYPE_ID OBJECT_ID       ,TYPE_ID PRIV_OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'TYPE' AS OBJECT_TYPE       ,CASE WHEN EXISTS                 (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                   WHERE TY.TENANT_ID = E.TENANT_ID AND TY.TYPE_ID = E.OBJ_ID AND E.OBJ_TYPE = 4)                 THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TYPE_REAL_AGENT TY       WHERE TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT       EFFECTIVE_TENANT_ID() AS TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,CAST(201006 AS NUMBER) AS DATABASE_ID       ,OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,OBJECT_TYPE_ID OBJECT_ID       ,OBJECT_TYPE_ID PRIV_OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'TYPE BODY' AS OBJECT_TYPE       ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE EFFECTIVE_TENANT_ID() = E.TENANT_ID AND TS.OBJECT_TYPE_ID = E.OBJ_ID AND E.OBJ_TYPE = 6)                   THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TENANT_OBJECT_TYPE_SYS_AGENT TS       WHERE TYPE = 2        UNION ALL        SELECT       TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,DATABASE_ID       ,OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,OBJECT_TYPE_ID OBJECT_ID       ,OBJECT_TYPE_ID PRIV_OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'TYPE BODY' AS OBJECT_TYPE       ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE TY.TENANT_ID = E.TENANT_ID AND TY.OBJECT_TYPE_ID = E.OBJ_ID AND E.OBJ_TYPE = 6)                   THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TENANT_OBJECT_TYPE_REAL_AGENT TY       WHERE TENANT_ID = EFFECTIVE_TENANT_ID() and TYPE = 2        UNION ALL        SELECT       T.TENANT_ID       ,T.GMT_CREATE       ,T.GMT_MODIFIED       ,T.DATABASE_ID       ,T.TRIGGER_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,T.TRIGGER_ID OBJECT_ID       ,T.TRIGGER_ID PRIV_OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'TRIGGER' OBJECT_TYPE       ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE T.TENANT_ID = E.TENANT_ID AND T.TRIGGER_ID = E.OBJ_ID AND (E.OBJ_TYPE = 7))                  THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TENANT_TRIGGER_REAL_AGENT T       WHERE T.TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT       TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,DATABASE_ID       ,SEQUENCE_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,SEQUENCE_ID OBJECT_ID       ,SEQUENCE_ID PRIV_OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'SEQUENCE' AS OBJECT_TYPE       ,'VALID' AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_SEQUENCE_OBJECT_REAL_AGENT       WHERE TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT       TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,DATABASE_ID       ,SYNONYM_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,SYNONYM_ID OBJECT_ID       ,SYNONYM_ID PRIV_OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'SYNONYM' AS OBJECT_TYPE       ,'VALID' AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_SYNONYM_REAL_AGENT       WHERE TENANT_ID = EFFECTIVE_TENANT_ID()        /*UNION ALL        SELECT         TENANT_ID         ,GMT_CREATE         ,GMT_MODIFIED         ,CAST(201006 AS NUMBER) AS DATABASE_ID         ,NAMESPACE AS OBJECT_NAME         ,NULL AS SUBOBJECT_NAME         ,CONTEXT_ID OBJECT_ID         ,CONTEXT_ID PRIV_OBJECT_ID         ,NULL AS DATA_OBJECT_ID         ,'CONTEXT' AS OBJECT_TYPE         ,'VALID' AS STATUS         ,'N' AS TEMPORARY         ,'N' AS "GENERATED"         ,'N' AS SECONDARY         ,21 AS NAMESPACE         ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_CONTEXT_REAL_AGENT       WHERE TENANT_ID = EFFECTIVE_TENANT_ID()*/        UNION ALL        SELECT         TENANT_ID,         GMT_CREATE,         GMT_MODIFIED,         DATABASE_ID,         DATABASE_NAME AS OBJECT_NAME,         NULL AS SUBOBJECT_NAME,         DATABASE_ID AS OBJECT_ID,         CAST(-1 AS NUMBER) AS PRIV_OBJECT_ID,         NULL AS DATA_OBJECT_ID,         'DATABASE' AS OBJECT_TYPE,         'VALID' AS STATUS,         'N' AS TEMPORARY,         'N' AS "GENERATED",         'N' AS SECONDARY,         0 AS NAMESPACE,         NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT       WHERE TENANT_ID = EFFECTIVE_TENANT_ID()     ) A     JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT B     ON A.TENANT_ID = B.TENANT_ID        AND A.DATABASE_ID = B.DATABASE_ID        AND B.TENANT_ID = EFFECTIVE_TENANT_ID()        AND (A.DATABASE_ID = USERENV('SCHEMAID')             OR (A.PRIV_OBJECT_ID != -1                 AND USER_CAN_ACCESS_OBJ(DECODE(OBJECT_TYPE,                                           'TABLE', 1,                                           'VIEW', 1,                                           'INDEX', 1,                                           'MATERIALIZED VIEW', 1,                                           'MATERIALIZED VIEW LOG', 1,                                           'TABLE PARTITION', 1,                                           'TABLE SUBPARTITION', 1,                                           'INDEX PARTITION', 1,                                           'INDEX SUBPARTITION', 1,                                           'SEQUENCE', 2,                                           'PACKAGE', 3,                                           'PACKAGE BODY', 3,                                           'TYPE', 4,                                           'TYPE BODY', 4,                                           'TRIGGER', 7,                                           'FUNCTION', 9,                                           'PROCEDURE', 12,                                           'SYNONYM', 13,                                           1), A.PRIV_OBJECT_ID, A.DATABASE_ID) = 1)) )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::user_objects_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_USER_OBJECTS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_USER_OBJECTS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       CAST(A.OBJECT_NAME AS VARCHAR(128)) AS OBJECT_NAME,       CAST(A.SUBOBJECT_NAME AS VARCHAR2(128)) AS SUBOBJECT_NAME,       CAST(A.OBJECT_ID AS NUMBER) AS OBJECT_ID,       CAST(A.DATA_OBJECT_ID AS NUMBER) AS DATA_OBJECT_ID,       CAST(A.OBJECT_TYPE AS VARCHAR2(23)) AS OBJECT_TYPE,       CAST(A.GMT_CREATE AS DATE) AS CREATED,       CAST(A.GMT_MODIFIED AS DATE) AS LAST_DDL_TIME,       CAST(TO_CHAR(A.GMT_CREATE) AS VARCHAR2(19)) AS TIMESTAMP,       CAST(A.STATUS AS VARCHAR2(7)) AS STATUS,       CAST(A.TEMPORARY AS VARCHAR2(1)) AS TEMPORARY,       CAST(A."GENERATED" AS VARCHAR2(1)) AS "GENERATED",       CAST(A.SECONDARY AS VARCHAR2(1)) AS SECONDARY,       CAST(A.NAMESPACE AS NUMBER) AS NAMESPACE,       CAST(A.EDITION_NAME AS VARCHAR2(128)) AS EDITION_NAME,       CAST(NULL AS VARCHAR2(18)) AS SHARING,       CAST(NULL AS VARCHAR2(1)) AS EDITIONABLE,       CAST(NULL AS VARCHAR2(1)) AS ORACLE_MAINTAINED,       CAST(NULL AS VARCHAR2(1)) AS APPLICATION,       CAST(NULL AS VARCHAR2(1)) AS DEFAULT_COLLATION,       CAST(NULL AS VARCHAR2(1)) AS DUPLICATED,       CAST(NULL AS VARCHAR2(1)) AS SHARDED,       CAST(NULL AS VARCHAR2(1)) AS IMPORTED_OBJECT,       CAST(NULL AS NUMBER) AS CREATED_APPID,       CAST(NULL AS NUMBER) AS CREATED_VSNID,       CAST(NULL AS NUMBER) AS MODIFIED_APPID,       CAST(NULL AS NUMBER) AS MODIFIED_VSNID     FROM (       SELECT              A.TENANT_ID,              (TO_DATE('19700101','YYYYMMDD')               + B.SCHEMA_VERSION / 86400 / 1000000               + TO_NUMBER(SUBSTR(TZ_OFFSET(SESSIONTIMEZONE),1,3))/24) AS GMT_CREATE,              (TO_DATE('19700101','YYYYMMDD')               + A.SCHEMA_VERSION / 86400 / 1000000               + TO_NUMBER(SUBSTR(TZ_OFFSET(SESSIONTIMEZONE),1,3))/24) AS GMT_MODIFIED,              A.DATABASE_ID,              A.TABLE_NAME AS OBJECT_NAME,              NULL AS SUBOBJECT_NAME,              CAST(A.TABLE_ID AS NUMBER) AS OBJECT_ID,              A.TABLE_ID AS DATA_OBJECT_ID,              'TABLE' AS OBJECT_TYPE,              'VALID' AS STATUS,              'N' AS TEMPORARY,              'N' AS "GENERATED",              'N' AS SECONDARY,              0 AS NAMESPACE,              NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_CORE_ALL_TABLE A       JOIN SYS.ALL_VIRTUAL_CORE_ALL_TABLE B         ON A.TENANT_ID = B.TENANT_ID       WHERE B.TABLE_NAME = '__all_core_table'             AND A.TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT       TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,DATABASE_ID       ,CAST((CASE              WHEN DATABASE_ID = 201004 THEN TABLE_NAME              WHEN TABLE_TYPE = 5 THEN SUBSTR(TABLE_NAME, 7 + INSTR(SUBSTR(TABLE_NAME, 7), '_'))              ELSE TABLE_NAME END) AS VARCHAR2(128)) AS OBJECT_NAME       ,NULL SUBOBJECT_NAME       ,TABLE_ID OBJECT_ID       ,(CASE WHEN TABLET_ID != 0 THEN TABLET_ID ELSE NULL END) DATA_OBJECT_ID       ,CASE WHEN TABLE_TYPE IN (0,3,6,8,9,14) THEN 'TABLE'             WHEN TABLE_TYPE IN (2) THEN 'VIRTUAL TABLE'             WHEN TABLE_TYPE IN (1,4) THEN 'VIEW'             WHEN TABLE_TYPE IN (5) THEN 'INDEX'             WHEN TABLE_TYPE IN (7) THEN 'MATERIALIZED VIEW'             WHEN TABLE_TYPE IN (15) THEN 'MATERIALIZED VIEW LOG'             ELSE NULL END AS OBJECT_TYPE       ,CAST(CASE WHEN TABLE_TYPE IN (5,15) THEN CASE WHEN INDEX_STATUS = 2 THEN 'VALID'               WHEN INDEX_STATUS = 3 THEN 'CHECKING'               WHEN INDEX_STATUS = 4 THEN 'INELEGIBLE'               WHEN INDEX_STATUS = 5 THEN 'ERROR'               ELSE 'UNUSABLE' END             ELSE  CASE WHEN OBJECT_STATUS = 1 THEN 'VALID' ELSE 'INVALID' END END AS VARCHAR2(10)) AS STATUS       ,CASE WHEN TABLE_TYPE IN (6,8,9) THEN 'Y'           ELSE 'N' END AS TEMPORARY       ,CASE WHEN TABLE_TYPE IN (0,1) THEN 'Y'           ELSE 'N' END AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM       SYS.ALL_VIRTUAL_TABLE_REAL_AGENT       WHERE TENANT_ID = EFFECTIVE_TENANT_ID() AND TABLE_TYPE != 12 AND TABLE_TYPE != 13          AND BITAND((TABLE_MODE / 4096), 15) IN (0,1)          AND BITAND(INDEX_ATTRIBUTES_SET, 16) = 0        UNION ALL        SELECT           CST.TENANT_ID          ,CST.GMT_CREATE          ,CST.GMT_MODIFIED          ,DB.DATABASE_ID          ,CST.CONSTRAINT_NAME AS OBJECT_NAME          ,NULL AS SUBOBJECT_NAME          ,TBL.TABLE_ID AS OBJECT_ID          ,NULL AS DATA_OBJECT_ID          ,'INDEX' AS OBJECT_TYPE          ,'VALID' AS STATUS          ,'N' AS TEMPORARY          ,'N' AS "GENERATED"          ,'N' AS SECONDARY          ,0 AS NAMESPACE          ,NULL AS EDITION_NAME          FROM SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT CST, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT TBL, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT DB          WHERE CST.TENANT_ID = EFFECTIVE_TENANT_ID() AND DB.DATABASE_ID = TBL.DATABASE_ID AND TBL.TABLE_ID = CST.TABLE_ID and CST.CONSTRAINT_TYPE = 1 AND TBL.TABLE_TYPE != 12 AND TBL.TABLE_TYPE != 13          AND BITAND((TBL.TABLE_MODE / 4096), 15) IN (0,1) AND BITAND(TBL.INDEX_ATTRIBUTES_SET, 16) = 0        UNION ALL        SELECT       P.TENANT_ID       ,P.GMT_CREATE       ,P.GMT_MODIFIED       ,T.DATABASE_ID       ,CAST((CASE              WHEN T.DATABASE_ID = 201004 THEN T.TABLE_NAME              WHEN T.TABLE_TYPE = 5 THEN SUBSTR(T.TABLE_NAME, 7 + INSTR(SUBSTR(T.TABLE_NAME, 7), '_'))              ELSE T.TABLE_NAME END) AS VARCHAR2(128)) AS OBJECT_NAME       ,P.PART_NAME SUBOBJECT_NAME       ,P.PART_ID OBJECT_ID       ,CASE WHEN P.TABLET_ID != 0 THEN P.TABLET_ID ELSE NULL END AS DATA_OBJECT_ID       ,DECODE (T.TABLE_TYPE, 5, 'INDEX PARTITION', 'TABLE PARTITION') AS OBJECT_TYPE       ,'VALID' AS STATUS       ,'N' AS TEMPORARY       , NULL AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT T JOIN SYS.ALL_VIRTUAL_PART_REAL_AGENT P ON T.TABLE_ID = P.TABLE_ID       WHERE T.TENANT_ID = EFFECTIVE_TENANT_ID() AND P.TENANT_ID = EFFECTIVE_TENANT_ID() AND T.TABLE_TYPE != 12 AND T.TABLE_TYPE != 13 AND bitand((T.TABLE_MODE / 4096), 15) IN (0,1)       AND P.PARTITION_TYPE = 0       /*do not show deleting index*/       AND BITAND(T.INDEX_ATTRIBUTES_SET, 16) = 0        UNION ALL        SELECT       SUBP.TENANT_ID       ,SUBP.GMT_CREATE       ,SUBP.GMT_MODIFIED       ,T.DATABASE_ID       ,CAST((CASE              WHEN T.DATABASE_ID = 201004 THEN T.TABLE_NAME              WHEN T.TABLE_TYPE = 5 THEN SUBSTR(T.TABLE_NAME, 7 + INSTR(SUBSTR(T.TABLE_NAME, 7), '_'))              ELSE T.TABLE_NAME END) AS VARCHAR2(128)) AS OBJECT_NAME       ,SUBP.SUB_PART_NAME SUBOBJECT_NAME       ,SUBP.SUB_PART_ID OBJECT_ID       ,SUBP.TABLET_ID AS DATA_OBJECT_ID       ,DECODE (T.TABLE_TYPE, 5, 'INDEX SUBPARTITION', 'TABLE SUBPARTITION') AS OBJECT_TYPE       ,'VALID' AS STATUS       ,'N' AS TEMPORARY       ,'Y' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT T, SYS.ALL_VIRTUAL_PART_REAL_AGENT P,SYS.ALL_VIRTUAL_SUB_PART_REAL_AGENT SUBP       WHERE T.TABLE_ID =P.TABLE_ID AND P.TABLE_ID=SUBP.TABLE_ID AND P.PART_ID =SUBP.PART_ID       AND T.TENANT_ID = EFFECTIVE_TENANT_ID() AND P.TENANT_ID = EFFECTIVE_TENANT_ID() AND SUBP.TENANT_ID = EFFECTIVE_TENANT_ID()       AND T.TABLE_TYPE != 12 AND T.TABLE_TYPE != 13 AND bitand((T.TABLE_MODE / 4096), 15) IN (0,1)       AND SUBP.PARTITION_TYPE = 0 AND P.PARTITION_TYPE = 0       /*do not show deleting index*/       AND BITAND(T.INDEX_ATTRIBUTES_SET, 16) = 0        UNION ALL        SELECT         EFFECTIVE_TENANT_ID() AS TENANT_ID         ,GMT_CREATE         ,GMT_MODIFIED         ,CAST(201006 AS NUMBER) AS DATABASE_ID         ,PACKAGE_NAME AS OBJECT_NAME         ,NULL AS SUBOBJECT_NAME         ,PACKAGE_ID OBJECT_ID         ,NULL AS DATA_OBJECT_ID         ,CASE WHEN TYPE = 1 THEN 'PACKAGE'               WHEN TYPE = 2 THEN 'PACKAGE BODY'               ELSE NULL END AS OBJECT_TYPE         ,'VALID' AS STATUS         ,'N' AS TEMPORARY         ,'N' AS "GENERATED"         ,'N' AS SECONDARY         ,0 AS NAMESPACE         ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_PACKAGE_SYS_AGENT        UNION ALL        SELECT       P.TENANT_ID       ,P.GMT_CREATE       ,P.GMT_MODIFIED       ,P.DATABASE_ID       ,P.PACKAGE_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,P.PACKAGE_ID OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,CASE WHEN TYPE = 1 THEN 'PACKAGE'             WHEN TYPE = 2 THEN 'PACKAGE BODY'             ELSE NULL END AS OBJECT_TYPE       ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE P.TENANT_ID = E.TENANT_ID AND P.PACKAGE_ID = E.OBJ_ID AND (E.OBJ_TYPE = 3 OR E.OBJ_TYPE = 5))                   THEN 'INVALID'             WHEN TYPE = 2 AND EXISTS                    (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT Eb                     WHERE OBJ_ID IN                              (SELECT PACKAGE_ID FROM SYS.ALL_VIRTUAL_PACKAGE_REAL_AGENT Pb                               WHERE Pb.PACKAGE_NAME = P.PACKAGE_NAME AND Pb.DATABASE_ID = P.DATABASE_ID AND Pb.TENANT_ID = P.TENANT_ID AND TYPE = 1)                           AND Eb.OBJ_TYPE = 3)                   THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_PACKAGE_REAL_AGENT P       WHERE P.TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT       R.TENANT_ID       ,R.GMT_CREATE       ,R.GMT_MODIFIED       ,R.DATABASE_ID       ,R.ROUTINE_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,R.ROUTINE_ID OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,CASE WHEN ROUTINE_TYPE = 1 THEN 'PROCEDURE'             WHEN ROUTINE_TYPE = 2 THEN 'FUNCTION'             ELSE NULL END AS OBJECT_TYPE       ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE R.TENANT_ID = E.TENANT_ID AND R.ROUTINE_ID = E.OBJ_ID AND (E.OBJ_TYPE = 9 OR E.OBJ_TYPE = 12))                  THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_ROUTINE_REAL_AGENT R       WHERE (ROUTINE_TYPE = 1 OR ROUTINE_TYPE = 2) AND R.TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT         EFFECTIVE_TENANT_ID() AS TENANT_ID         ,GMT_CREATE         ,GMT_MODIFIED         ,CAST(201006 AS NUMBER) AS DATABASE_ID         ,TS.TYPE_NAME AS OBJECT_NAME         ,NULL AS SUBOBJECT_NAME         ,TS.TYPE_ID AS OBJECT_ID         ,NULL AS DATA_OBJECT_ID         ,'TYPE' AS OBJECT_TYPE         ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE TS.TENANT_ID = E.TENANT_ID AND TS.TYPE_ID = E.OBJ_ID AND E.OBJ_TYPE = 4)                   THEN 'INVALID'               ELSE 'VALID' END AS STATUS         ,'N' AS TEMPORARY         ,'N' AS "GENERATED"         ,'N' AS SECONDARY         ,0 AS NAMESPACE         ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TYPE_SYS_AGENT TS        UNION ALL        SELECT       TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,DATABASE_ID       ,TYPE_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,TYPE_ID OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'TYPE' AS OBJECT_TYPE       ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE TY.TENANT_ID = E.TENANT_ID AND TY.TYPE_ID = E.OBJ_ID AND E.OBJ_TYPE = 4)                   THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TYPE_REAL_AGENT TY       WHERE TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT       EFFECTIVE_TENANT_ID() AS TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,CAST(201006 AS NUMBER) AS DATABASE_ID       ,OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,OBJECT_TYPE_ID OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'TYPE BODY' AS OBJECT_TYPE       ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE EFFECTIVE_TENANT_ID() = E.TENANT_ID AND TS.OBJECT_TYPE_ID = E.OBJ_ID AND E.OBJ_TYPE = 6)                   THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TENANT_OBJECT_TYPE_SYS_AGENT TS       WHERE TYPE = 2        UNION ALL        SELECT       TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,DATABASE_ID       ,OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,OBJECT_TYPE_ID OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'TYPE BODY' AS OBJECT_TYPE       ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE TY.TENANT_ID = E.TENANT_ID AND TY.OBJECT_TYPE_ID = E.OBJ_ID AND E.OBJ_TYPE = 6)                   THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TENANT_OBJECT_TYPE_REAL_AGENT TY       WHERE TENANT_ID = EFFECTIVE_TENANT_ID() and TYPE = 2        UNION ALL        SELECT       T.TENANT_ID       ,T.GMT_CREATE       ,T.GMT_MODIFIED       ,T.DATABASE_ID       ,T.TRIGGER_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,T.TRIGGER_ID OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'TRIGGER' OBJECT_TYPE       ,CASE WHEN EXISTS                   (SELECT OBJ_ID FROM SYS.ALL_VIRTUAL_TENANT_ERROR_REAL_AGENT E                     WHERE T.TENANT_ID = E.TENANT_ID AND T.TRIGGER_ID = E.OBJ_ID AND (E.OBJ_TYPE = 7))                  THEN 'INVALID'             ELSE 'VALID' END AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_TENANT_TRIGGER_REAL_AGENT T       WHERE T.TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT       TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,DATABASE_ID       ,SEQUENCE_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,SEQUENCE_ID OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'SEQUENCE' AS OBJECT_TYPE       ,'VALID' AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_SEQUENCE_OBJECT_REAL_AGENT       WHERE TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT       TENANT_ID       ,GMT_CREATE       ,GMT_MODIFIED       ,DATABASE_ID       ,SYNONYM_NAME AS OBJECT_NAME       ,NULL AS SUBOBJECT_NAME       ,SYNONYM_ID OBJECT_ID       ,NULL AS DATA_OBJECT_ID       ,'SYNONYM' AS OBJECT_TYPE       ,'VALID' AS STATUS       ,'N' AS TEMPORARY       ,'N' AS "GENERATED"       ,'N' AS SECONDARY       , 0 AS NAMESPACE       ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_SYNONYM_REAL_AGENT       WHERE TENANT_ID = EFFECTIVE_TENANT_ID()        /*UNION ALL        SELECT         TENANT_ID         ,GMT_CREATE         ,GMT_MODIFIED         ,CAST(201006 AS NUMBER) AS DATABASE_ID         ,NAMESPACE AS OBJECT_NAME         ,NULL AS SUBOBJECT_NAME         ,CONTEXT_ID OBJECT_ID         ,NULL AS DATA_OBJECT_ID         ,'CONTEXT' AS OBJECT_TYPE         ,'VALID' AS STATUS         ,'N' AS TEMPORARY         ,'N' AS "GENERATED"         ,'N' AS SECONDARY         ,21 AS NAMESPACE         ,NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_CONTEXT_REAL_AGENT       WHERE TENANT_ID = EFFECTIVE_TENANT_ID()*/        UNION ALL        SELECT         TENANT_ID,         GMT_CREATE,         GMT_MODIFIED,         DATABASE_ID,         DATABASE_NAME AS OBJECT_NAME,         NULL AS SUBOBJECT_NAME,         DATABASE_ID AS OBJECT_ID,         NULL AS DATA_OBJECT_ID,         'DATABASE' AS OBJECT_TYPE,         'VALID' AS STATUS,         'N' AS TEMPORARY,         'N' AS "GENERATED",         'N' AS SECONDARY,         0 AS NAMESPACE,         NULL AS EDITION_NAME       FROM SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT       WHERE TENANT_ID = EFFECTIVE_TENANT_ID()     ) A     JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT B     ON A.TENANT_ID = B.TENANT_ID        AND A.DATABASE_ID = B.DATABASE_ID        AND B.TENANT_ID = EFFECTIVE_TENANT_ID()        AND A.DATABASE_ID = USERENV('SCHEMAID') )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::dba_sequences_ora_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_DBA_SEQUENCES_ORA_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_DBA_SEQUENCES_ORA_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT        C.DATABASE_NAME AS SEQUENCE_OWNER       ,A.SEQUENCE_NAME AS SEQUENCE_NAME       ,A.MIN_VALUE AS MIN_VALUE       ,A.MAX_VALUE AS MAX_VALUE       ,A.INCREMENT_BY AS INCREMENT_BY       ,CASE A.CYCLE_FLAG WHEN 1 THEN 'Y'                          WHEN 0 THEN  'N'                          ELSE NULL END AS CYCLE_FLAG       ,CASE A.ORDER_FLAG WHEN 1 THEN 'Y'                          WHEN 0 THEN  'N'                          ELSE NULL END AS ORDER_FLAG       ,A.CACHE_SIZE AS CACHE_SIZE       ,CAST(COALESCE(B.NEXT_VALUE,A.START_WITH) AS NUMBER(38,0)) AS LAST_NUMBER     FROM        SYS.ALL_VIRTUAL_SEQUENCE_OBJECT_REAL_AGENT A     INNER JOIN        SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C     ON A.DATABASE_ID = C.DATABASE_ID AND A.TENANT_ID = C.TENANT_ID       AND A.TENANT_ID = EFFECTIVE_TENANT_ID()       AND C.TENANT_ID = EFFECTIVE_TENANT_ID()     LEFT JOIN       SYS.ALL_VIRTUAL_SEQUENCE_VALUE_REAL_AGENT B     ON B.SEQUENCE_ID = A.SEQUENCE_ID )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::all_sequences_ora_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_ALL_SEQUENCES_ORA_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_ALL_SEQUENCES_ORA_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT        C.DATABASE_NAME AS SEQUENCE_OWNER       ,A.SEQUENCE_NAME AS SEQUENCE_NAME       ,A.MIN_VALUE AS MIN_VALUE       ,A.MAX_VALUE AS MAX_VALUE       ,A.INCREMENT_BY AS INCREMENT_BY       ,CASE A.CYCLE_FLAG WHEN 1 THEN 'Y'                          WHEN 0 THEN  'N'                          ELSE NULL END AS CYCLE_FLAG       ,CASE A.ORDER_FLAG WHEN 1 THEN 'Y'                          WHEN 0 THEN  'N'                          ELSE NULL END AS ORDER_FLAG       ,A.CACHE_SIZE AS CACHE_SIZE       ,CAST(COALESCE(B.NEXT_VALUE,A.START_WITH) AS NUMBER(38,0)) AS LAST_NUMBER     FROM        SYS.ALL_VIRTUAL_SEQUENCE_OBJECT_REAL_AGENT A     INNER JOIN        SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C     ON A.DATABASE_ID = C.DATABASE_ID AND A.TENANT_ID = C.TENANT_ID       AND A.TENANT_ID = EFFECTIVE_TENANT_ID()       AND C.TENANT_ID = EFFECTIVE_TENANT_ID()     AND (A.DATABASE_ID = USERENV('SCHEMAID')          OR USER_CAN_ACCESS_OBJ(2, A.SEQUENCE_ID, A.DATABASE_ID) = 1)     LEFT JOIN       SYS.ALL_VIRTUAL_SEQUENCE_VALUE_REAL_AGENT B     ON B.SEQUENCE_ID = A.SEQUENCE_ID )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::user_sequences_ora_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_USER_SEQUENCES_ORA_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_USER_SEQUENCES_ORA_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT        A.SEQUENCE_NAME AS SEQUENCE_NAME       ,A.MIN_VALUE AS MIN_VALUE       ,A.MAX_VALUE AS MAX_VALUE       ,A.INCREMENT_BY AS INCREMENT_BY       ,CASE A.CYCLE_FLAG WHEN 1 THEN 'Y'                          WHEN 0 THEN  'N'                          ELSE NULL END AS CYCLE_FLAG       ,CASE A.ORDER_FLAG WHEN 1 THEN 'Y'                          WHEN 0 THEN  'N'                          ELSE NULL END AS ORDER_FLAG       ,A.CACHE_SIZE AS CACHE_SIZE       ,CAST(COALESCE(B.NEXT_VALUE,A.START_WITH) AS NUMBER(38,0)) AS LAST_NUMBER     FROM        SYS.ALL_VIRTUAL_SEQUENCE_OBJECT_REAL_AGENT A     LEFT JOIN       SYS.ALL_VIRTUAL_SEQUENCE_VALUE_REAL_AGENT B     ON B.SEQUENCE_ID = A.SEQUENCE_ID     WHERE       A.DATABASE_ID = USERENV('SCHEMAID') )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::dba_users_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_DBA_USERS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_DBA_USERS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       B.USER_NAME AS USERNAME,       B.USER_ID AS USERID,       B.PASSWD AS PASSWORD,       CAST(CASE WHEN B.IS_LOCKED = 1 THEN 'LOCKED' ELSE 'OPEN' END as VARCHAR2(32)) AS ACCOUNT_STATUS,       CAST(NULL as DATE) AS LOCK_DATE,       CAST(NULL as DATE) AS EXPIRY_DATE,       CAST(NULL as VARCHAR2(30)) AS DEFAULT_TABLESPACE,       CAST(NULL as VARCHAR2(30)) AS TEMPORARY_TABLESPACE,       CAST(NULL as VARCHAR2(30)) AS LOCAL_TEMP_TABLESPACE,       CAST(B.GMT_CREATE AS DATE) AS CREATED,       CAST(NVL(P.PROFILE_NAME, 'DEFAULT') AS VARCHAR2(128)) AS PROFILE,       CAST(NULL as VARCHAR2(30)) AS INITIAL_RSRC_CONSUMER_GROUP,       CAST(NULL as VARCHAR2(4000)) AS EXTERNAL_NAME,       CAST(NULL as VARCHAR2(12)) AS PASSWORD_VERSIONS,       CAST('N' as VARCHAR2(1)) AS EDITIONS_ENABLED,       CAST('PASSWORD' as VARCHAR2(8)) AS AUTHENTICATION_TYPE,       CAST('N' as VARCHAR2(1)) AS PROXY_ONLY_CONNECT,       CAST('NO' as VARCHAR2(3)) AS COMMON,       CAST(NULL as TIMESTAMP(9) WITH TIME ZONE) AS LAST_LOGIN,       CAST('N' as VARCHAR2(1)) AS ORACLE_MAINTAINED,       CAST('NO' as VARCHAR2(3)) AS INHERITED,       CAST('USING_NLS_COMP' as VARCHAR2(100)) AS DEFAULT_COLLATION,       CAST('NO' as VARCHAR2(3)) AS IMPLICIT,       CAST('NO' as VARCHAR2(3)) AS ALL_SHARD,       CAST(B.PASSWORD_LAST_CHANGED AS DATE) AS PASSWORD_CHANGE_DATE     FROM       SYS.ALL_VIRTUAL_USER_REAL_AGENT B       LEFT JOIN SYS.ALL_VIRTUAL_TENANT_PROFILE_REAL_AGENT P       ON B.TENANT_ID = P.TENANT_ID AND B.PROFILE_ID = P.PROFILE_ID     WHERE       B.TYPE = 0       AND B.TENANT_ID = EFFECTIVE_TENANT_ID() )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::all_users_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_ALL_USERS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_ALL_USERS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       B.USER_NAME AS USERNAME,       B.USER_ID AS USERID,       CAST(B.GMT_CREATE AS DATE) AS CREATED,       CAST('NO' as VARCHAR2(3)) AS COMMON,       CAST('N' as VARCHAR2(1)) AS ORACLE_MAINTAINED,       CAST('NO' as VARCHAR2(3)) AS INHERITED,       CAST('USING_NLS_COMP' as VARCHAR2(100)) AS DEFAULT_COLLATION,       CAST('NO' as VARCHAR2(3)) AS IMPLICIT,       CAST('NO' as VARCHAR2(3)) AS ALL_SHARD     FROM       SYS.ALL_VIRTUAL_USER_REAL_AGENT B     WHERE       B.TYPE = 0       AND B.TENANT_ID = EFFECTIVE_TENANT_ID()  )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::all_synonyms_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_ALL_SYNONYMS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_ALL_SYNONYMS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       A.DATABASE_NAME AS OWNER,       A.SYNONYM_NAME AS SYNONYM_NAME,       CAST(CASE WHEN INSTR(A.OBJECT_NAME, '@') = 0            THEN B.DATABASE_NAME            ELSE SUBSTR(A.OBJECT_NAME, 1, INSTR(A.OBJECT_NAME, '.') -1)            END            AS VARCHAR2(128)) AS TABLE_OWNER,       CAST(CASE WHEN INSTR(A.OBJECT_NAME, '@') = 0            THEN A.OBJECT_NAME            ELSE SUBSTR(A.OBJECT_NAME, INSTR(A.OBJECT_NAME, '.') + 1, INSTR(A.OBJECT_NAME, '@') - INSTR(A.OBJECT_NAME, '.') -1)            END            AS VARCHAR2(128)) AS TABLE_NAME,       CAST(CASE WHEN INSTR(A.OBJECT_NAME, '@') = 0                 THEN NULL                 ELSE SUBSTR(A.OBJECT_NAME, INSTR(A.OBJECT_NAME, '@')+1)                 END                 AS VARCHAR2(128)) AS DB_LINK     FROM       (SELECT BB.DATABASE_NAME, AA.SYNONYM_NAME,       AA.OBJECT_NAME, AA.SYNONYM_ID       FROM       SYS.ALL_VIRTUAL_SYNONYM_REAL_AGENT AA,       SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT BB       WHERE AA.DATABASE_ID = BB.DATABASE_ID             AND AA.TENANT_ID = BB.TENANT_ID AND AA.TENANT_ID = EFFECTIVE_TENANT_ID()             AND (AA.DATABASE_ID = USERENV('SCHEMAID')                 OR USER_CAN_ACCESS_OBJ(13, AA.SYNONYM_ID, AA.DATABASE_ID) = 1)) A,       (SELECT BB.DATABASE_NAME, AA.SYNONYM_ID       FROM       SYS.ALL_VIRTUAL_SYNONYM_REAL_AGENT AA,       SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT BB       WHERE AA.OBJECT_DATABASE_ID = BB.DATABASE_ID             AND AA.TENANT_ID = BB.TENANT_ID AND AA.TENANT_ID = EFFECTIVE_TENANT_ID()             AND (AA.DATABASE_ID = USERENV('SCHEMAID')                 OR USER_CAN_ACCESS_OBJ(13, AA.SYNONYM_ID, AA.DATABASE_ID) = 1)) B     WHERE       A.SYNONYM_ID = B.SYNONYM_ID )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::user_synonyms_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_USER_SYNONYMS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_USER_SYNONYMS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       A.SYNONYM_NAME AS SYNONYM_NAME,       CAST(CASE WHEN INSTR(A.OBJECT_NAME, '@') = 0            THEN B.DATABASE_NAME            ELSE SUBSTR(A.OBJECT_NAME, 1, INSTR(A.OBJECT_NAME, '.') -1)            END            AS VARCHAR2(128)) AS TABLE_OWNER,       CAST(CASE WHEN INSTR(A.OBJECT_NAME, '@') = 0            THEN A.OBJECT_NAME            ELSE SUBSTR(A.OBJECT_NAME, INSTR(A.OBJECT_NAME, '.') + 1, INSTR(A.OBJECT_NAME, '@') - INSTR(A.OBJECT_NAME, '.') -1)            END            AS VARCHAR2(128)) AS TABLE_NAME,       CAST(CASE WHEN INSTR(A.OBJECT_NAME, '@') = 0                 THEN NULL                 ELSE SUBSTR(A.OBJECT_NAME, INSTR(A.OBJECT_NAME, '@')+1)                 END                 AS VARCHAR2(128)) AS DB_LINK,       CAST (0 AS number) AS ORIGIN_CON_ID     FROM       (SELECT BB.DATABASE_NAME, AA.SYNONYM_NAME,       AA.OBJECT_NAME, AA.SYNONYM_ID       FROM       SYS.ALL_VIRTUAL_SYNONYM_REAL_AGENT AA,       SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT BB       WHERE AA.DATABASE_ID = BB.DATABASE_ID             AND (AA.DATABASE_ID = USERENV('SCHEMAID')                 OR USER_CAN_ACCESS_OBJ(13, AA.SYNONYM_ID, AA.DATABASE_ID) = 1)) A,       (SELECT BB.DATABASE_NAME, AA.SYNONYM_ID       FROM       SYS.ALL_VIRTUAL_SYNONYM_REAL_AGENT AA,       SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT BB       WHERE AA.OBJECT_DATABASE_ID = BB.DATABASE_ID            AND (AA.DATABASE_ID = USERENV('SCHEMAID')                 OR USER_CAN_ACCESS_OBJ(13, AA.SYNONYM_ID, AA.DATABASE_ID) = 1)) B     WHERE       A.SYNONYM_ID = B.SYNONYM_ID     AND       A.DATABASE_NAME = SYS_CONTEXT('USERENV','CURRENT_USER') )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::dba_ind_columns_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_DBA_IND_COLUMNS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_DBA_IND_COLUMNS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       CAST(INDEX_OWNER AS VARCHAR2(128)) AS INDEX_OWNER,       CAST(INDEX_NAME AS VARCHAR2(128)) AS INDEX_NAME,       CAST(TABLE_OWNER AS VARCHAR2(128)) AS TABLE_OWNER,       CAST(NEW_TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST(COLUMN_NAME AS VARCHAR2(4000)) AS COLUMN_NAME,       CAST(ROWKEY_POSITION AS NUMBER) AS COLUMN_POSITION,        CASE WHEN DATA_TYPE >= 1 AND DATA_TYPE <= 16 OR DATA_TYPE = 50 THEN CAST(22 AS NUMBER)            WHEN DATA_TYPE = 17 THEN CAST(7 AS NUMBER)            WHEN DATA_TYPE IN (22, 23) AND F.DATA_PRECISION = 2 THEN CAST(DATA_LENGTH AS NUMBER)            WHEN DATA_TYPE IN (22, 23) AND F.DATA_PRECISION = 1 AND F.COLLATION_TYPE IN (45, 46, 224, 54, 55, 101) THEN CAST(DATA_LENGTH * 4 AS NUMBER)            WHEN DATA_TYPE IN (22, 23) AND F.DATA_PRECISION = 1 AND F.COLLATION_TYPE IN (28, 87) THEN CAST(DATA_LENGTH * 2 AS NUMBER)            WHEN DATA_TYPE = 36 THEN CAST(12 AS NUMBER)            WHEN DATA_TYPE IN (37, 38) THEN CAST(11 AS NUMBER)            WHEN DATA_TYPE = 39 THEN CAST(DATA_LENGTH AS NUMBER)            WHEN DATA_TYPE = 40 THEN CAST(5 AS NUMBER)            WHEN DATA_TYPE = 41 THEN CAST(11 AS NUMBER)            ELSE CAST(0 AS NUMBER) END AS COLUMN_LENGTH,        CASE WHEN DATA_TYPE IN (22, 23) THEN CAST(DATA_LENGTH AS NUMBER)            ELSE CAST(0 AS NUMBER) END AS CHAR_LENGTH,        CAST('ASC' AS VARCHAR2(4)) AS DESCEND,       CAST(NULL AS NUMBER) AS COLLATED_COLUMN_ID        FROM         (SELECT             A.TENANT_ID,             DATABASE_NAME AS INDEX_OWNER,             CASE WHEN (TABLE_TYPE = 5 AND B.DATABASE_NAME !=  '__recyclebin')                  THEN SUBSTR(TABLE_NAME, 7 + INSTR(SUBSTR(TABLE_NAME, 7), '_'))                  WHEN (TABLE_TYPE = 5 AND B.DATABASE_NAME =  '__recyclebin')                  THEN TABLE_NAME                  ELSE (CONS_TAB.CONSTRAINT_NAME) END AS INDEX_NAME,             DATABASE_NAME AS TABLE_OWNER,             CASE WHEN (TABLE_TYPE = 3) THEN A.TABLE_ID                  ELSE A.DATA_TABLE_ID END AS TABLE_ID,             A.TABLE_ID AS INDEX_ID,             TABLE_TYPE AS IDX_TYPE           FROM             SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A             JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT B             ON A.DATABASE_ID = B.DATABASE_ID                AND TABLE_TYPE IN (5, 3)                AND A.TENANT_ID = B.TENANT_ID AND A.TENANT_ID = EFFECTIVE_TENANT_ID()                AND BITAND((A.TABLE_MODE / 4096), 15) IN (0,1)                 AND BITAND(A.INDEX_ATTRIBUTES_SET, 16) = 0              LEFT JOIN SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT CONS_TAB             ON CONS_TAB.TABLE_ID = A.TABLE_ID                AND A.TENANT_ID = CONS_TAB.TENANT_ID                AND CONS_TAB.TENANT_ID = EFFECTIVE_TENANT_ID()            WHERE             NOT(TABLE_TYPE = 3 AND CONSTRAINT_NAME IS NULL)             AND (CONS_TAB.CONSTRAINT_TYPE IS NULL OR CONS_TAB.CONSTRAINT_TYPE = 1)         ) E         JOIN          ((             SELECT                 mv_table.table_name AS new_table_name,                 container_table.*             FROM                 SYS.ALL_VIRTUAL_TABLE_REAL_AGENT mv_table,                 (                     SELECT                         *                     FROM                         SYS.ALL_VIRTUAL_TABLE_REAL_AGENT                     WHERE                       bitand(table_mode, POWER(2, 24)) = POWER(2, 24)                 ) container_table             WHERE                 mv_table.data_table_id = container_table.table_id  			  				and mv_table.table_type = 7         )                  UNION ALL                  (             SELECT                 table_name as new_table_name,                 SYS.ALL_VIRTUAL_TABLE_REAL_AGENT.*             FROM                 SYS.ALL_VIRTUAL_TABLE_REAL_AGENT             WHERE                 bitand(table_mode, POWER(2, 24)) = 0         )) D           ON E.TENANT_ID = D.TENANT_ID              AND E.TABLE_ID = D.TABLE_ID              AND D.TABLE_TYPE != 12 AND D.TABLE_TYPE != 13              AND BITAND((D.TABLE_MODE / 4096), 15) IN (0,1)               AND BITAND(D.INDEX_ATTRIBUTES_SET, 16) = 0         JOIN SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT F ON E.INDEX_ID = F.TABLE_ID               AND F.TENANT_ID = EFFECTIVE_TENANT_ID()       WHERE         F.ROWKEY_POSITION != 0 AND (CASE WHEN IDX_TYPE = 5 THEN INDEX_POSITION ELSE 1 END) != 0 )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::all_ind_columns_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_ALL_IND_COLUMNS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_ALL_IND_COLUMNS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       CAST(INDEX_OWNER AS VARCHAR2(128)) AS INDEX_OWNER,       CAST(INDEX_NAME AS VARCHAR2(128)) AS INDEX_NAME,       CAST(TABLE_OWNER AS VARCHAR2(128)) AS TABLE_OWNER,       CAST(NEW_TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST(COLUMN_NAME AS VARCHAR2(4000)) AS COLUMN_NAME,       CAST(ROWKEY_POSITION AS NUMBER) AS COLUMN_POSITION,        CASE WHEN DATA_TYPE >= 1 AND DATA_TYPE <= 16 OR DATA_TYPE = 50 THEN CAST(22 AS NUMBER)            WHEN DATA_TYPE = 17 THEN CAST(7 AS NUMBER)            WHEN DATA_TYPE IN (22, 23) AND F.DATA_PRECISION = 2 THEN CAST(DATA_LENGTH AS NUMBER)            WHEN DATA_TYPE IN (22, 23) AND F.DATA_PRECISION = 1 AND F.COLLATION_TYPE IN (45, 46, 224, 54, 55, 101) THEN CAST(DATA_LENGTH * 4 AS NUMBER)            WHEN DATA_TYPE IN (22, 23) AND F.DATA_PRECISION = 1 AND F.COLLATION_TYPE IN (28, 87) THEN CAST(DATA_LENGTH * 2 AS NUMBER)            WHEN DATA_TYPE = 36 THEN CAST(12 AS NUMBER)            WHEN DATA_TYPE IN (37, 38) THEN CAST(11 AS NUMBER)            WHEN DATA_TYPE = 39 THEN CAST(DATA_LENGTH AS NUMBER)            WHEN DATA_TYPE = 40 THEN CAST(5 AS NUMBER)            WHEN DATA_TYPE = 41 THEN CAST(11 AS NUMBER)            ELSE CAST(0 AS NUMBER) END AS COLUMN_LENGTH,        CASE WHEN DATA_TYPE IN (22, 23) THEN CAST(DATA_LENGTH AS NUMBER)            ELSE CAST(0 AS NUMBER) END AS CHAR_LENGTH,        CAST('ASC' AS VARCHAR2(4)) AS DESCEND,       CAST(NULL AS NUMBER) AS COLLATED_COLUMN_ID        FROM         (SELECT             A.TENANT_ID,             DATABASE_NAME AS INDEX_OWNER,             CASE WHEN (TABLE_TYPE = 5 AND B.DATABASE_NAME !=  '__recyclebin')                  THEN SUBSTR(TABLE_NAME, 7 + INSTR(SUBSTR(TABLE_NAME, 7), '_'))                  WHEN (TABLE_TYPE = 5 AND B.DATABASE_NAME =  '__recyclebin')                  THEN TABLE_NAME                  ELSE (CONS_TAB.CONSTRAINT_NAME) END AS INDEX_NAME,             DATABASE_NAME AS TABLE_OWNER,             CASE WHEN (TABLE_TYPE = 3) THEN A.TABLE_ID                  ELSE A.DATA_TABLE_ID END AS TABLE_ID,             A.TABLE_ID AS INDEX_ID,             TABLE_TYPE AS IDX_TYPE           FROM             SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A             JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT B             ON A.DATABASE_ID = B.DATABASE_ID                AND TABLE_TYPE IN (5, 3)                AND A.TENANT_ID = B.TENANT_ID AND A.TENANT_ID = EFFECTIVE_TENANT_ID()                AND BITAND((A.TABLE_MODE / 4096), 15) IN (0,1)                 AND BITAND(A.INDEX_ATTRIBUTES_SET, 16) = 0                AND (A.DATABASE_ID = USERENV('SCHEMAID')                     OR USER_CAN_ACCESS_OBJ(1, DECODE(TABLE_TYPE,                                                      3, TABLE_ID,                                                      5, DATA_TABLE_ID), A.DATABASE_ID) = 1)              LEFT JOIN SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT CONS_TAB             ON CONS_TAB.TABLE_ID = A.TABLE_ID                AND A.TENANT_ID = CONS_TAB.TENANT_ID                AND CONS_TAB.TENANT_ID = EFFECTIVE_TENANT_ID()            WHERE             NOT(TABLE_TYPE = 3 AND CONSTRAINT_NAME IS NULL)             AND (CONS_TAB.CONSTRAINT_TYPE IS NULL OR CONS_TAB.CONSTRAINT_TYPE = 1)         ) E         JOIN          ((             SELECT                 mv_table.table_name AS new_table_name,                 container_table.*             FROM                 SYS.ALL_VIRTUAL_TABLE_REAL_AGENT mv_table,                 (                     SELECT                         *                     FROM                         SYS.ALL_VIRTUAL_TABLE_REAL_AGENT                     WHERE                       bitand(table_mode, POWER(2, 24)) = POWER(2, 24)                 ) container_table             WHERE                 mv_table.data_table_id = container_table.table_id  			  				and mv_table.table_type = 7         )                  UNION ALL                  (             SELECT                 table_name as new_table_name,                 SYS.ALL_VIRTUAL_TABLE_REAL_AGENT.*             FROM                 SYS.ALL_VIRTUAL_TABLE_REAL_AGENT             WHERE                 bitand(table_mode, POWER(2, 24)) = 0         )) D           ON E.TENANT_ID = D.TENANT_ID              AND E.TABLE_ID = D.TABLE_ID              AND D.TABLE_TYPE != 12 AND D.TABLE_TYPE != 13              AND BITAND((D.TABLE_MODE / 4096), 15) IN (0,1)               AND BITAND(D.INDEX_ATTRIBUTES_SET, 16) = 0         JOIN SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT F ON E.INDEX_ID = F.TABLE_ID               AND F.TENANT_ID = EFFECTIVE_TENANT_ID()       WHERE         F.ROWKEY_POSITION != 0 AND (CASE WHEN IDX_TYPE = 5 THEN INDEX_POSITION ELSE 1 END) != 0 )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::user_ind_columns_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_USER_IND_COLUMNS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_USER_IND_COLUMNS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       CAST(INDEX_NAME AS VARCHAR2(128)) AS INDEX_NAME,       CAST(NEW_TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST(COLUMN_NAME AS VARCHAR2(4000)) AS COLUMN_NAME,       CAST(ROWKEY_POSITION AS NUMBER) AS COLUMN_POSITION,        CASE WHEN DATA_TYPE >= 1 AND DATA_TYPE <= 16 OR DATA_TYPE = 50 THEN CAST(22 AS NUMBER)            WHEN DATA_TYPE = 17 THEN CAST(7 AS NUMBER)            WHEN DATA_TYPE IN (22, 23) AND F.DATA_PRECISION = 2 THEN CAST(DATA_LENGTH AS NUMBER)            WHEN DATA_TYPE IN (22, 23) AND F.DATA_PRECISION = 1 AND F.COLLATION_TYPE IN (45, 46, 224, 54, 55, 101) THEN CAST(DATA_LENGTH * 4 AS NUMBER)            WHEN DATA_TYPE IN (22, 23) AND F.DATA_PRECISION = 1 AND F.COLLATION_TYPE IN (28, 87) THEN CAST(DATA_LENGTH * 2 AS NUMBER)            WHEN DATA_TYPE = 36 THEN CAST(12 AS NUMBER)            WHEN DATA_TYPE IN (37, 38) THEN CAST(11 AS NUMBER)            WHEN DATA_TYPE = 39 THEN CAST(DATA_LENGTH AS NUMBER)            WHEN DATA_TYPE = 40 THEN CAST(5 AS NUMBER)            WHEN DATA_TYPE = 41 THEN CAST(11 AS NUMBER)            ELSE CAST(0 AS NUMBER) END AS COLUMN_LENGTH,        CASE WHEN DATA_TYPE IN (22, 23) THEN CAST(DATA_LENGTH AS NUMBER)            ELSE CAST(0 AS NUMBER) END AS CHAR_LENGTH,        CAST('ASC' AS VARCHAR2(4)) AS DESCEND,       CAST(NULL AS NUMBER) AS COLLATED_COLUMN_ID        FROM         (SELECT             A.TENANT_ID,             DATABASE_NAME AS INDEX_OWNER,             CASE WHEN (TABLE_TYPE = 5 AND B.DATABASE_NAME !=  '__recyclebin')                  THEN SUBSTR(TABLE_NAME, 7 + INSTR(SUBSTR(TABLE_NAME, 7), '_'))                  WHEN (TABLE_TYPE = 5 AND B.DATABASE_NAME =  '__recyclebin')                  THEN TABLE_NAME                  ELSE (CONS_TAB.CONSTRAINT_NAME) END AS INDEX_NAME,             DATABASE_NAME AS TABLE_OWNER,             CASE WHEN (TABLE_TYPE = 3) THEN A.TABLE_ID                  ELSE A.DATA_TABLE_ID END AS TABLE_ID,             A.TABLE_ID AS INDEX_ID,             TABLE_TYPE AS IDX_TYPE           FROM             SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A             JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT B             ON A.DATABASE_ID = B.DATABASE_ID                AND TABLE_TYPE IN (5, 3)                AND A.TENANT_ID = B.TENANT_ID AND A.TENANT_ID = EFFECTIVE_TENANT_ID()                AND A.DATABASE_ID = USERENV('SCHEMAID')                AND BITAND((A.TABLE_MODE / 4096), 15) IN (0,1)                 AND BITAND(A.INDEX_ATTRIBUTES_SET, 16) = 0              LEFT JOIN SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT CONS_TAB             ON CONS_TAB.TABLE_ID = A.TABLE_ID                AND A.TENANT_ID = CONS_TAB.TENANT_ID                AND CONS_TAB.TENANT_ID = EFFECTIVE_TENANT_ID()            WHERE             NOT(TABLE_TYPE = 3 AND CONSTRAINT_NAME IS NULL)             AND (CONS_TAB.CONSTRAINT_TYPE IS NULL OR CONS_TAB.CONSTRAINT_TYPE = 1)         ) E         JOIN          ((             SELECT                 mv_table.table_name AS new_table_name,                 container_table.*             FROM                 SYS.ALL_VIRTUAL_TABLE_REAL_AGENT mv_table,                 (                     SELECT                         *                     FROM                         SYS.ALL_VIRTUAL_TABLE_REAL_AGENT                     WHERE                       bitand(table_mode, POWER(2, 24)) = POWER(2, 24)                 ) container_table             WHERE                 mv_table.data_table_id = container_table.table_id  			  				and mv_table.table_type = 7         )                  UNION ALL                  (             SELECT                 table_name as new_table_name,                 SYS.ALL_VIRTUAL_TABLE_REAL_AGENT.*             FROM                 SYS.ALL_VIRTUAL_TABLE_REAL_AGENT             WHERE                 bitand(table_mode, POWER(2, 24)) = 0         )) D           ON E.TENANT_ID = D.TENANT_ID              AND E.TABLE_ID = D.TABLE_ID              AND D.TABLE_TYPE != 12 AND D.TABLE_TYPE != 13              AND BITAND((D.TABLE_MODE / 4096), 15) IN (0,1)               AND BITAND(D.INDEX_ATTRIBUTES_SET, 16) = 0         JOIN SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT F ON E.INDEX_ID = F.TABLE_ID               AND F.TENANT_ID = EFFECTIVE_TENANT_ID()       WHERE         F.ROWKEY_POSITION != 0 AND (CASE WHEN IDX_TYPE = 5 THEN INDEX_POSITION ELSE 1 END) != 0 )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::dba_constraints_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_DBA_CONSTRAINTS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_DBA_CONSTRAINTS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,     CAST(SUBSTR(A.TABLE_NAME, 7 + INSTR(SUBSTR(A.TABLE_NAME, 7), '_')) AS VARCHAR2(128)) AS CONSTRAINT_NAME,     CAST('U' AS VARCHAR2(1)) AS CONSTRAINT_TYPE,     CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,     CAST(NULL AS VARCHAR2(4000)) AS SEARCH_CONDITION,     CAST(NULL AS VARCHAR2(128)) AS R_OWNER,     CAST(NULL AS VARCHAR2(128)) AS R_CONSTRAINT_NAME,     CAST(NULL AS VARCHAR2(9)) AS DELETE_RULE,     CAST('ENABLED' AS VARCHAR2(8)) AS STATUS,     CAST('NOT DEFERRABLE' AS VARCHAR2(14)) AS DEFERRABLE,     CAST('IMMEDIATE' AS VARCHAR2(9)) AS DEFERRED,     CAST('VALIDATED' AS VARCHAR2(13)) AS VALIDATED,     CASE WHEN A.NAME_GENERATED_TYPE = 2 THEN CAST('GENERATED NAME' AS VARCHAR2(14))         WHEN A.NAME_GENERATED_TYPE = 1 THEN CAST('USER NAME' AS VARCHAR2(14))         ELSE CAST('NULL' AS VARCHAR2(14)) END AS "GENERATED",     CAST(NULL AS VARCHAR2(3)) AS BAD,     CAST(NULL AS VARCHAR2(4)) AS RELY,     CAST(NULL AS DATE) AS LAST_CHANGE,     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS INDEX_OWNER,     CAST(SUBSTR(A.TABLE_NAME, 7 + INSTR(SUBSTR(A.TABLE_NAME, 7), '_')) AS VARCHAR2(128)) AS INDEX_NAME,     CAST(NULL AS VARCHAR2(7)) AS INVALID,     CAST(NULL AS VARCHAR2(14)) AS VIEW_RELATED     FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C WHERE A.DATA_TABLE_ID = B.TABLE_ID AND A.DATABASE_ID = C.DATABASE_ID       AND A.INDEX_TYPE IN (2, 4, 8, 41) AND C.DATABASE_NAME != '__recyclebin'       AND A.TENANT_ID = EFFECTIVE_TENANT_ID()       AND bitand((A.TABLE_MODE / 4096), 15) IN (0,1)       AND bitand(A.INDEX_ATTRIBUTES_SET, 16) = 0       AND B.TENANT_ID = EFFECTIVE_TENANT_ID()       AND C.TENANT_ID = EFFECTIVE_TENANT_ID()       AND A.TABLE_TYPE != 12 AND A.TABLE_TYPE != 13       AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13     UNION ALL     SELECT     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,     CAST(A.FOREIGN_KEY_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,     CAST('R' AS VARCHAR2(1)) AS CONSTRAINT_TYPE,     CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,     CAST(NULL AS VARCHAR2(4000)) AS SEARCH_CONDITION,     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS R_OWNER,     CAST(NULL AS VARCHAR2(128)) AS R_CONSTRAINT_NAME,     CAST(CASE WHEN DELETE_ACTION = 1 THEN 'NO ACTION'          WHEN DELETE_ACTION = 2 THEN 'CASCADE'       ELSE 'SET NULL' END AS VARCHAR2(9)) AS DELETE_RULE,     CASE WHEN A.ENABLE_FLAG = 1 THEN CAST('ENABLED' AS VARCHAR2(8))          ELSE CAST('DISABLED' AS VARCHAR2(8)) END AS STATUS,     CAST('NOT DEFERRABLE' AS VARCHAR2(14)) AS DEFERRABLE,     CAST('IMMEDIATE' AS VARCHAR2(9)) AS DEFERRED,     CASE WHEN A.VALIDATE_FLAG = 1 THEN CAST('VALIDATED' AS VARCHAR2(13))          ELSE CAST('NOT VALIDATED' AS VARCHAR2(13)) END AS VALIDATED,     CASE WHEN A.NAME_GENERATED_TYPE = 2 THEN CAST('GENERATED NAME' AS VARCHAR2(14))         WHEN A.NAME_GENERATED_TYPE = 1 THEN CAST('USER NAME' AS VARCHAR2(14))         ELSE CAST('NULL' AS VARCHAR2(14)) END AS "GENERATED",     CAST(NULL AS VARCHAR2(3)) AS BAD,     CASE WHEN A.RELY_FLAG = 1 THEN CAST('RELY' AS VARCHAR2(4))          ELSE CAST(NULL AS VARCHAR2(4)) END AS RELY,     CAST(NULL AS DATE) AS LAST_CHANGE,     CAST(NULL AS VARCHAR2(128)) AS INDEX_OWNER,     CAST(NULL AS VARCHAR2(128)) AS INDEX_NAME,     CAST(NULL AS VARCHAR2(7)) AS INVALID,     CAST(NULL AS VARCHAR2(14)) AS VIEW_RELATED     FROM SYS.ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C     WHERE A.CHILD_TABLE_ID = B.TABLE_ID AND B.DATABASE_ID = C.DATABASE_ID AND A.REF_CST_TYPE = 0 AND A.REF_CST_ID = -1       AND A.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TENANT_ID = EFFECTIVE_TENANT_ID()       AND C.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13       AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)        AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0     UNION ALL     SELECT     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,     CAST(A.FOREIGN_KEY_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,     CAST('R' AS VARCHAR2(1)) AS CONSTRAINT_TYPE,     CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,     CAST(NULL AS VARCHAR2(4000)) AS SEARCH_CONDITION,     CAST(E.DATABASE_NAME AS VARCHAR2(128)) AS R_OWNER,     CAST(CASE WHEN A.REF_CST_TYPE = 2 THEN SUBSTR(F.TABLE_NAME, 7 + INSTR(SUBSTR(F.TABLE_NAME, 7), '_'))          ELSE NULL END AS VARCHAR2(128)) AS R_CONSTRAINT_NAME,     CAST(CASE WHEN DELETE_ACTION = 1 THEN 'NO ACTION'          WHEN DELETE_ACTION = 2 THEN 'CASCADE'          ELSE 'SET NULL' END AS VARCHAR2(9)) AS DELETE_RULE,     CASE WHEN A.ENABLE_FLAG = 1 THEN CAST('ENABLED' AS VARCHAR2(8))          ELSE CAST('DISABLED' AS VARCHAR2(8)) END AS STATUS,     CAST('NOT DEFERRABLE' AS VARCHAR2(14)) AS DEFERRABLE,     CAST('IMMEDIATE' AS VARCHAR2(9)) AS DEFERRED,     CASE WHEN A.VALIDATE_FLAG = 1 THEN CAST('VALIDATED' AS VARCHAR2(13))          ELSE CAST('NOT VALIDATED' AS VARCHAR2(13)) END AS VALIDATED,     CASE WHEN A.NAME_GENERATED_TYPE = 2 THEN CAST('GENERATED NAME' AS VARCHAR2(14))         WHEN A.NAME_GENERATED_TYPE = 1 THEN CAST('USER NAME' AS VARCHAR2(14))         ELSE CAST('NULL' AS VARCHAR2(14)) END AS "GENERATED",     CAST(NULL AS VARCHAR2(3)) AS BAD,     CASE WHEN A.RELY_FLAG = 1 THEN CAST('RELY' AS VARCHAR2(4))          ELSE CAST(NULL AS VARCHAR2(4)) END AS RELY,     CAST(NULL AS DATE) AS LAST_CHANGE,     CAST(NULL AS VARCHAR2(128)) AS INDEX_OWNER,     CAST(NULL AS VARCHAR2(128)) AS INDEX_NAME,     CAST(NULL AS VARCHAR2(7)) AS INVALID,     CAST(NULL AS VARCHAR2(14)) AS VIEW_RELATED     FROM SYS.ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT D, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT E, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT F       WHERE A.CHILD_TABLE_ID = B.TABLE_ID AND B.DATABASE_ID = C.DATABASE_ID AND A.PARENT_TABLE_ID = D.TABLE_ID AND D.DATABASE_ID = E.DATABASE_ID AND (A.REF_CST_ID = F.TABLE_ID AND A.REF_CST_TYPE = 2)       AND A.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TENANT_ID = EFFECTIVE_TENANT_ID()       AND C.TENANT_ID = EFFECTIVE_TENANT_ID()       AND D.TENANT_ID = EFFECTIVE_TENANT_ID()       AND E.TENANT_ID = EFFECTIVE_TENANT_ID()       AND F.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13       AND D.TABLE_TYPE != 12 AND D.TABLE_TYPE != 13       AND F.TABLE_TYPE != 12 AND F.TABLE_TYPE != 13       AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)        AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0     UNION ALL     SELECT     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,     CAST(A.FOREIGN_KEY_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,     CAST('R' AS VARCHAR2(1)) AS CONSTRAINT_TYPE,     CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,     CAST(NULL AS VARCHAR2(4000)) AS SEARCH_CONDITION,     CAST(E.DATABASE_NAME AS VARCHAR2(128)) AS R_OWNER,     CAST(CASE WHEN A.REF_CST_TYPE = 1 THEN F.CONSTRAINT_NAME         ELSE NULL END AS VARCHAR2(128)) AS R_CONSTRAINT_NAME,     CAST(CASE WHEN DELETE_ACTION = 1 THEN 'NO ACTION'          WHEN DELETE_ACTION = 2 THEN 'CASCADE'          ELSE 'SET NULL' END AS VARCHAR2(9)) AS DELETE_RULE,     CASE WHEN A.ENABLE_FLAG = 1 THEN CAST('ENABLED' AS VARCHAR2(8))          ELSE CAST('DISABLED' AS VARCHAR2(8)) END AS STATUS,     CAST('NOT DEFERRABLE' AS VARCHAR2(14)) AS DEFERRABLE,     CAST('IMMEDIATE' AS VARCHAR2(9)) AS DEFERRED,     CASE WHEN A.VALIDATE_FLAG = 1 THEN CAST('VALIDATED' AS VARCHAR2(13))          ELSE CAST('NOT VALIDATED' AS VARCHAR2(13)) END AS VALIDATED,     CASE WHEN A.NAME_GENERATED_TYPE = 2 THEN CAST('GENERATED NAME' AS VARCHAR2(14))         WHEN A.NAME_GENERATED_TYPE = 1 THEN CAST('USER NAME' AS VARCHAR2(14))         ELSE CAST('NULL' AS VARCHAR2(14)) END AS "GENERATED",     CAST(NULL AS VARCHAR2(3)) AS BAD,     CASE WHEN A.RELY_FLAG = 1 THEN CAST('RELY' AS VARCHAR2(4))          ELSE CAST(NULL AS VARCHAR2(4)) END AS RELY,     CAST(NULL AS DATE) AS LAST_CHANGE,     CAST(NULL AS VARCHAR2(128)) AS INDEX_OWNER,     CAST(NULL AS VARCHAR2(128)) AS INDEX_NAME,     CAST(NULL AS VARCHAR2(7)) AS INVALID,     CAST(NULL AS VARCHAR2(14)) AS VIEW_RELATED     FROM SYS.ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT D, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT E, SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT F       WHERE A.CHILD_TABLE_ID = B.TABLE_ID AND B.DATABASE_ID = C.DATABASE_ID AND A.PARENT_TABLE_ID = D.TABLE_ID AND D.DATABASE_ID = E.DATABASE_ID AND (A.PARENT_TABLE_ID = F.TABLE_ID AND A.REF_CST_TYPE = 1 AND F.CONSTRAINT_TYPE = 1 AND A.REF_CST_ID = F.CONSTRAINT_ID)       AND A.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TENANT_ID = EFFECTIVE_TENANT_ID()       AND C.TENANT_ID = EFFECTIVE_TENANT_ID()       AND D.TENANT_ID = EFFECTIVE_TENANT_ID()       AND E.TENANT_ID = EFFECTIVE_TENANT_ID()       AND F.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13       AND D.TABLE_TYPE != 12 AND D.TABLE_TYPE != 13       AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)        AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0     UNION ALL     SELECT       CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,       CAST(CONSTRAINT_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,       CASE WHEN A.CONSTRAINT_TYPE = 1 THEN CAST('P' AS VARCHAR2(1))         ELSE CAST('C' AS VARCHAR2(1)) END AS CONSTRAINT_TYPE,       CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CASE WHEN A.CONSTRAINT_TYPE = 1 THEN CAST(NULL AS VARCHAR2(4000))         ELSE CAST(A.CHECK_EXPR AS VARCHAR2(4000)) END AS SEARCH_CONDITION,       CAST(NULL AS VARCHAR2(128)) AS R_OWNER,       CAST(NULL AS VARCHAR2(128)) AS R_CONSTRAINT_NAME,       CAST(NULL AS VARCHAR2(9)) AS DELETE_RULE,       CASE WHEN A.ENABLE_FLAG = 1 THEN CAST('ENABLED' AS VARCHAR2(8))         ELSE CAST('DISABLED' AS VARCHAR2(8)) END AS STATUS,       CAST('NOT DEFERRABLE' AS VARCHAR2(14)) AS DEFERRABLE,       CAST('IMMEDIATE' AS VARCHAR2(9)) AS DEFERRED,       CASE WHEN A.VALIDATE_FLAG = 1 THEN CAST('VALIDATED' AS VARCHAR2(13))         ELSE CAST('NOT VALIDATED' AS VARCHAR2(13)) END AS VALIDATED,       CASE WHEN A.NAME_GENERATED_TYPE = 2 THEN CAST('GENERATED NAME' AS VARCHAR2(14))         WHEN A.NAME_GENERATED_TYPE = 1 THEN CAST('USER NAME' AS VARCHAR2(14))         ELSE CAST('NULL' AS VARCHAR2(14)) END AS "GENERATED",       CAST(NULL AS VARCHAR2(3)) AS BAD,       CASE WHEN A.RELY_FLAG = 1 THEN CAST('RELY' AS VARCHAR2(4))         ELSE CAST(NULL AS VARCHAR2(4)) END AS RELY,       CAST(NULL AS DATE) AS LAST_CHANGE,       CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS INDEX_OWNER,       CASE WHEN A.CONSTRAINT_TYPE = 1 THEN CAST(A.CONSTRAINT_NAME AS VARCHAR2(128))         ELSE CAST(NULL AS VARCHAR2(128)) END AS INDEX_NAME,       CAST(NULL AS VARCHAR2(7)) AS INVALID,       CAST(NULL AS VARCHAR2(14)) AS VIEW_RELATED     FROM SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C     WHERE A.TABLE_ID = B.TABLE_ID AND B.DATABASE_ID = C.DATABASE_ID AND C.DATABASE_NAME != '__recyclebin'     AND A.TENANT_ID = EFFECTIVE_TENANT_ID()     AND B.TENANT_ID = EFFECTIVE_TENANT_ID()     AND C.TENANT_ID = EFFECTIVE_TENANT_ID()     AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13     AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)      AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0 )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::all_constraints_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_ALL_CONSTRAINTS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_ALL_CONSTRAINTS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,     CAST(SUBSTR(A.TABLE_NAME, 7 + INSTR(SUBSTR(A.TABLE_NAME, 7), '_')) AS VARCHAR2(128)) AS CONSTRAINT_NAME,     CAST('U' AS VARCHAR2(1)) AS CONSTRAINT_TYPE,     CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,     CAST(NULL AS VARCHAR2(4000)) AS SEARCH_CONDITION,     CAST(NULL AS VARCHAR2(128)) AS R_OWNER,     CAST(NULL AS VARCHAR2(128)) AS R_CONSTRAINT_NAME,     CAST(NULL AS VARCHAR2(9)) AS DELETE_RULE,     CAST('ENABLED' AS VARCHAR2(8)) AS STATUS,     CAST('NOT DEFERRABLE' AS VARCHAR2(14)) AS DEFERRABLE,     CAST('IMMEDIATE' AS VARCHAR2(9)) AS DEFERRED,     CAST('VALIDATED' AS VARCHAR2(13)) AS VALIDATED,     CASE WHEN A.NAME_GENERATED_TYPE = 2 THEN CAST('GENERATED NAME' AS VARCHAR2(14))         WHEN A.NAME_GENERATED_TYPE = 1 THEN CAST('USER NAME' AS VARCHAR2(14))         ELSE CAST('NULL' AS VARCHAR2(14)) END AS "GENERATED",     CAST(NULL AS VARCHAR2(3)) AS BAD,     CAST(NULL AS VARCHAR2(4)) AS RELY,     CAST(NULL AS DATE) AS LAST_CHANGE,     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS INDEX_OWNER,     CAST(SUBSTR(A.TABLE_NAME, 7 + INSTR(SUBSTR(A.TABLE_NAME, 7), '_')) AS VARCHAR2(128)) AS INDEX_NAME,     CAST(NULL AS VARCHAR2(7)) AS INVALID,     CAST(NULL AS VARCHAR2(14)) AS VIEW_RELATED     FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C     WHERE A.DATA_TABLE_ID = B.TABLE_ID       AND A.DATABASE_ID = C.DATABASE_ID       AND (A.DATABASE_ID = USERENV('SCHEMAID')           OR USER_CAN_ACCESS_OBJ(1, A.DATA_TABLE_ID, A.DATABASE_ID) = 1)       AND A.INDEX_TYPE IN (2, 4, 8, 41) AND C.DATABASE_NAME != '__recyclebin'       AND A.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TENANT_ID = EFFECTIVE_TENANT_ID()       AND C.TENANT_ID = EFFECTIVE_TENANT_ID()       AND A.TABLE_TYPE != 12 AND A.TABLE_TYPE != 13       AND bitand((A.TABLE_MODE / 4096), 15) IN (0,1)       AND bitand(A.INDEX_ATTRIBUTES_SET, 16) = 0       AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13     UNION ALL     SELECT     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,     CAST(A.FOREIGN_KEY_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,     CAST('R' AS VARCHAR2(1)) AS CONSTRAINT_TYPE,     CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,     CAST(NULL AS VARCHAR2(4000)) AS SEARCH_CONDITION,     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS R_OWNER,     CAST(NULL AS VARCHAR2(128)) AS R_CONSTRAINT_NAME,     CAST(CASE WHEN DELETE_ACTION = 1 THEN 'NO ACTION'          WHEN DELETE_ACTION = 2 THEN 'CASCADE'       ELSE 'SET NULL' END AS VARCHAR2(9)) AS DELETE_RULE,     CASE WHEN A.ENABLE_FLAG = 1 THEN CAST('ENABLED' AS VARCHAR2(8))          ELSE CAST('DISABLED' AS VARCHAR2(8)) END AS STATUS,     CAST('NOT DEFERRABLE' AS VARCHAR2(14)) AS DEFERRABLE,     CAST('IMMEDIATE' AS VARCHAR2(9)) AS DEFERRED,     CASE WHEN A.VALIDATE_FLAG = 1 THEN CAST('VALIDATED' AS VARCHAR2(13))          ELSE CAST('NOT VALIDATED' AS VARCHAR2(13)) END AS VALIDATED,     CASE WHEN A.NAME_GENERATED_TYPE = 2 THEN CAST('GENERATED NAME' AS VARCHAR2(14))         WHEN A.NAME_GENERATED_TYPE = 1 THEN CAST('USER NAME' AS VARCHAR2(14))         ELSE CAST('NULL' AS VARCHAR2(14)) END AS "GENERATED",     CAST(NULL AS VARCHAR2(3)) AS BAD,     CASE WHEN A.RELY_FLAG = 1 THEN CAST('RELY' AS VARCHAR2(4))          ELSE CAST(NULL AS VARCHAR2(4)) END AS RELY,     CAST(NULL AS DATE) AS LAST_CHANGE,     CAST(NULL AS VARCHAR2(128)) AS INDEX_OWNER,     CAST(NULL AS VARCHAR2(128)) AS INDEX_NAME,     CAST(NULL AS VARCHAR2(7)) AS INVALID,     CAST(NULL AS VARCHAR2(14)) AS VIEW_RELATED     FROM SYS.ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C     WHERE A.CHILD_TABLE_ID = B.TABLE_ID AND B.DATABASE_ID = C.DATABASE_ID AND A.REF_CST_TYPE = 0 AND A.REF_CST_ID = -1         AND A.TENANT_ID = EFFECTIVE_TENANT_ID()         AND B.TENANT_ID = EFFECTIVE_TENANT_ID()         AND C.TENANT_ID = EFFECTIVE_TENANT_ID()         AND (B.DATABASE_ID = USERENV('SCHEMAID')              OR USER_CAN_ACCESS_OBJ(1, B.TABLE_ID, B.DATABASE_ID) = 1)         AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13         AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)          AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0     UNION ALL     SELECT     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,     CAST(A.FOREIGN_KEY_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,     CAST('R' AS VARCHAR2(1)) AS CONSTRAINT_TYPE,     CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,     CAST(NULL AS VARCHAR2(4000)) AS SEARCH_CONDITION,     CAST(E.DATABASE_NAME AS VARCHAR2(128)) AS R_OWNER,     CAST(CASE WHEN A.REF_CST_TYPE = 2 THEN SUBSTR(F.TABLE_NAME, 7 + INSTR(SUBSTR(F.TABLE_NAME, 7), '_'))          ELSE NULL END AS VARCHAR2(128)) AS R_CONSTRAINT_NAME,     CAST(CASE WHEN DELETE_ACTION = 1 THEN 'NO ACTION'          WHEN DELETE_ACTION = 2 THEN 'CASCADE'          ELSE 'SET NULL' END AS VARCHAR2(9)) AS DELETE_RULE,     CASE WHEN A.ENABLE_FLAG = 1 THEN CAST('ENABLED' AS VARCHAR2(8))          ELSE CAST('DISABLED' AS VARCHAR2(8)) END AS STATUS,     CAST('NOT DEFERRABLE' AS VARCHAR2(14)) AS DEFERRABLE,     CAST('IMMEDIATE' AS VARCHAR2(9)) AS DEFERRED,     CASE WHEN A.VALIDATE_FLAG = 1 THEN CAST('VALIDATED' AS VARCHAR2(13))          ELSE CAST('NOT VALIDATED' AS VARCHAR2(13)) END AS VALIDATED,     CASE WHEN A.NAME_GENERATED_TYPE = 2 THEN CAST('GENERATED NAME' AS VARCHAR2(14))         WHEN A.NAME_GENERATED_TYPE = 1 THEN CAST('USER NAME' AS VARCHAR2(14))         ELSE CAST('NULL' AS VARCHAR2(14)) END AS "GENERATED",     CAST(NULL AS VARCHAR2(3)) AS BAD,     CASE WHEN A.RELY_FLAG = 1 THEN CAST('RELY' AS VARCHAR2(4))          ELSE CAST(NULL AS VARCHAR2(4)) END AS RELY,     CAST(NULL AS DATE) AS LAST_CHANGE,     CAST(NULL AS VARCHAR2(128)) AS INDEX_OWNER,     CAST(NULL AS VARCHAR2(128)) AS INDEX_NAME,     CAST(NULL AS VARCHAR2(7)) AS INVALID,     CAST(NULL AS VARCHAR2(14)) AS VIEW_RELATED     FROM SYS.ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT D, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT E, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT F       WHERE A.CHILD_TABLE_ID = B.TABLE_ID         AND B.DATABASE_ID = C.DATABASE_ID         AND A.PARENT_TABLE_ID = D.TABLE_ID         AND D.DATABASE_ID = E.DATABASE_ID         AND (D.DATABASE_ID = USERENV('SCHEMAID')              OR USER_CAN_ACCESS_OBJ(1, D.TABLE_ID, D.DATABASE_ID) = 1)         AND (A.REF_CST_ID = F.TABLE_ID AND A.REF_CST_TYPE = 2)         AND A.TENANT_ID = EFFECTIVE_TENANT_ID()         AND B.TENANT_ID = EFFECTIVE_TENANT_ID()         AND C.TENANT_ID = EFFECTIVE_TENANT_ID()         AND D.TENANT_ID = EFFECTIVE_TENANT_ID()         AND E.TENANT_ID = EFFECTIVE_TENANT_ID()         AND F.TENANT_ID = EFFECTIVE_TENANT_ID()         AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13         AND D.TABLE_TYPE != 12 AND D.TABLE_TYPE != 13         AND F.TABLE_TYPE != 12 AND F.TABLE_TYPE != 13         AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)          AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0     UNION ALL     SELECT     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,     CAST(A.FOREIGN_KEY_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,     CAST('R' AS VARCHAR2(1)) AS CONSTRAINT_TYPE,     CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,     CAST(NULL AS VARCHAR2(4000)) AS SEARCH_CONDITION,     CAST(E.DATABASE_NAME AS VARCHAR2(128)) AS R_OWNER,     CAST(CASE WHEN A.REF_CST_TYPE = 1 THEN F.CONSTRAINT_NAME         ELSE NULL END AS VARCHAR2(128)) AS R_CONSTRAINT_NAME,     CAST(CASE WHEN DELETE_ACTION = 1 THEN 'NO ACTION'          WHEN DELETE_ACTION = 2 THEN 'CASCADE'          ELSE 'SET NULL' END AS VARCHAR2(9)) AS DELETE_RULE,     CASE WHEN A.ENABLE_FLAG = 1 THEN CAST('ENABLED' AS VARCHAR2(8))          ELSE CAST('DISABLED' AS VARCHAR2(8)) END AS STATUS,     CAST('NOT DEFERRABLE' AS VARCHAR2(14)) AS DEFERRABLE,     CAST('IMMEDIATE' AS VARCHAR2(9)) AS DEFERRED,     CASE WHEN A.VALIDATE_FLAG = 1 THEN CAST('VALIDATED' AS VARCHAR2(13))          ELSE CAST('NOT VALIDATED' AS VARCHAR2(13)) END AS VALIDATED,     CASE WHEN A.NAME_GENERATED_TYPE = 2 THEN CAST('GENERATED NAME' AS VARCHAR2(14))         WHEN A.NAME_GENERATED_TYPE = 1 THEN CAST('USER NAME' AS VARCHAR2(14))         ELSE CAST('NULL' AS VARCHAR2(14)) END AS "GENERATED",     CAST(NULL AS VARCHAR2(3)) AS BAD,     CASE WHEN A.RELY_FLAG = 1 THEN CAST('RELY' AS VARCHAR2(4))          ELSE CAST(NULL AS VARCHAR2(4)) END AS RELY,     CAST(NULL AS DATE) AS LAST_CHANGE,     CAST(NULL AS VARCHAR2(128)) AS INDEX_OWNER,     CAST(NULL AS VARCHAR2(128)) AS INDEX_NAME,     CAST(NULL AS VARCHAR2(7)) AS INVALID,     CAST(NULL AS VARCHAR2(14)) AS VIEW_RELATED     FROM SYS.ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT D, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT E, SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT F       WHERE A.CHILD_TABLE_ID = B.TABLE_ID         AND B.DATABASE_ID = C.DATABASE_ID         AND A.PARENT_TABLE_ID = D.TABLE_ID         AND D.DATABASE_ID = E.DATABASE_ID         AND (D.DATABASE_ID = USERENV('SCHEMAID')              OR USER_CAN_ACCESS_OBJ(1, D.TABLE_ID, D.DATABASE_ID) = 1)         AND (A.PARENT_TABLE_ID = F.TABLE_ID              AND A.REF_CST_TYPE = 1              AND F.CONSTRAINT_TYPE = 1              AND A.REF_CST_ID = F.CONSTRAINT_ID)         AND A.TENANT_ID = EFFECTIVE_TENANT_ID()         AND B.TENANT_ID = EFFECTIVE_TENANT_ID()         AND C.TENANT_ID = EFFECTIVE_TENANT_ID()         AND D.TENANT_ID = EFFECTIVE_TENANT_ID()         AND E.TENANT_ID = EFFECTIVE_TENANT_ID()         AND F.TENANT_ID = EFFECTIVE_TENANT_ID()         AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13         AND D.TABLE_TYPE != 12 AND D.TABLE_TYPE != 13         AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)          AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0     UNION ALL     SELECT       CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,       CAST(CONSTRAINT_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,       CASE WHEN A.CONSTRAINT_TYPE = 1 THEN CAST('P' AS VARCHAR2(1))         ELSE CAST('C' AS VARCHAR2(1)) END AS CONSTRAINT_TYPE,       CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CASE WHEN A.CONSTRAINT_TYPE = 1 THEN CAST(NULL AS VARCHAR2(4000))         ELSE CAST(A.CHECK_EXPR AS VARCHAR2(4000)) END AS SEARCH_CONDITION,       CAST(NULL AS VARCHAR2(128)) AS R_OWNER,       CAST(NULL AS VARCHAR2(128)) AS R_CONSTRAINT_NAME,       CAST(NULL AS VARCHAR2(9)) AS DELETE_RULE,       CASE WHEN A.ENABLE_FLAG = 1 THEN CAST('ENABLED' AS VARCHAR2(8))         ELSE CAST('DISABLED' AS VARCHAR2(8)) END AS STATUS,       CAST('NOT DEFERRABLE' AS VARCHAR2(14)) AS DEFERRABLE,       CAST('IMMEDIATE' AS VARCHAR2(9)) AS DEFERRED,       CASE WHEN A.VALIDATE_FLAG = 1 THEN CAST('VALIDATED' AS VARCHAR2(13))         ELSE CAST('NOT VALIDATED' AS VARCHAR2(13)) END AS VALIDATED,       CASE WHEN A.NAME_GENERATED_TYPE = 2 THEN CAST('GENERATED NAME' AS VARCHAR2(14))         WHEN A.NAME_GENERATED_TYPE = 1 THEN CAST('USER NAME' AS VARCHAR2(14))         ELSE CAST('NULL' AS VARCHAR2(14)) END AS "GENERATED",       CAST(NULL AS VARCHAR2(3)) AS BAD,       CASE WHEN A.RELY_FLAG = 1 THEN CAST('RELY' AS VARCHAR2(4))         ELSE CAST(NULL AS VARCHAR2(4)) END AS RELY,       CAST(NULL AS DATE) AS LAST_CHANGE,       CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS INDEX_OWNER,       CASE WHEN A.CONSTRAINT_TYPE = 1 THEN CAST(A.CONSTRAINT_NAME AS VARCHAR2(128))         ELSE CAST(NULL AS VARCHAR2(128)) END AS INDEX_NAME,       CAST(NULL AS VARCHAR2(7)) AS INVALID,       CAST(NULL AS VARCHAR2(14)) AS VIEW_RELATED     FROM SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C     WHERE A.TABLE_ID = B.TABLE_ID       AND B.DATABASE_ID = C.DATABASE_ID       AND (B.DATABASE_ID = USERENV('SCHEMAID')              OR USER_CAN_ACCESS_OBJ(1, B.TABLE_ID, B.DATABASE_ID) = 1)       AND C.DATABASE_NAME != '__recyclebin'       AND A.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TENANT_ID = EFFECTIVE_TENANT_ID()       AND C.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13       AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)        AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0 )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::user_constraints_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_USER_CONSTRAINTS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_USER_CONSTRAINTS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,     CAST(SUBSTR(A.TABLE_NAME, 7 + INSTR(SUBSTR(A.TABLE_NAME, 7), '_')) AS VARCHAR2(128)) AS CONSTRAINT_NAME,     CAST('U' AS VARCHAR2(1)) AS CONSTRAINT_TYPE,     CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,     CAST(NULL AS VARCHAR2(4000)) AS SEARCH_CONDITION,     CAST(NULL AS VARCHAR2(128)) AS R_OWNER,     CAST(NULL AS VARCHAR2(128)) AS R_CONSTRAINT_NAME,     CAST(NULL AS VARCHAR2(9)) AS DELETE_RULE,     CAST('ENABLED' AS VARCHAR2(8)) AS STATUS,     CAST('NOT DEFERRABLE' AS VARCHAR2(14)) AS DEFERRABLE,     CAST('IMMEDIATE' AS VARCHAR2(9)) AS DEFERRED,     CAST('VALIDATED' AS VARCHAR2(13)) AS VALIDATED,     CASE WHEN A.NAME_GENERATED_TYPE = 2 THEN CAST('GENERATED NAME' AS VARCHAR2(14))         WHEN A.NAME_GENERATED_TYPE = 1 THEN CAST('USER NAME' AS VARCHAR2(14))         ELSE CAST('NULL' AS VARCHAR2(14)) END AS "GENERATED",     CAST(NULL AS VARCHAR2(3)) AS BAD,     CAST(NULL AS VARCHAR2(4)) AS RELY,     CAST(NULL AS DATE) AS LAST_CHANGE,     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS INDEX_OWNER,     CAST(SUBSTR(A.TABLE_NAME, 7 + INSTR(SUBSTR(A.TABLE_NAME, 7), '_')) AS VARCHAR2(128)) AS INDEX_NAME,     CAST(NULL AS VARCHAR2(7)) AS INVALID,     CAST(NULL AS VARCHAR2(14)) AS VIEW_RELATED     FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C WHERE A.DATA_TABLE_ID = B.TABLE_ID AND A.DATABASE_ID = C.DATABASE_ID       AND A.DATABASE_ID = USERENV('SCHEMAID') AND A.INDEX_TYPE IN (2, 4, 8, 41)       AND A.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TENANT_ID = EFFECTIVE_TENANT_ID()       AND C.TENANT_ID = EFFECTIVE_TENANT_ID()       AND A.TABLE_TYPE != 12 AND A.TABLE_TYPE != 13       AND bitand((A.TABLE_MODE / 4096), 15) IN (0,1)       AND BITAND(A.INDEX_ATTRIBUTES_SET, 16) = 0       AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13     UNION ALL     SELECT     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,     CAST(A.FOREIGN_KEY_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,     CAST('R' AS VARCHAR2(1)) AS CONSTRAINT_TYPE,     CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,     CAST(NULL AS VARCHAR2(4000)) AS SEARCH_CONDITION,     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS R_OWNER,     CAST(NULL AS VARCHAR2(128)) AS R_CONSTRAINT_NAME,     CAST(CASE WHEN DELETE_ACTION = 1 THEN 'NO ACTION'          WHEN DELETE_ACTION = 2 THEN 'CASCADE'       ELSE 'SET NULL' END AS VARCHAR2(9)) AS DELETE_RULE,     CASE WHEN A.ENABLE_FLAG = 1 THEN CAST('ENABLED' AS VARCHAR2(8))          ELSE CAST('DISABLED' AS VARCHAR2(8)) END AS STATUS,     CAST('NOT DEFERRABLE' AS VARCHAR2(14)) AS DEFERRABLE,     CAST('IMMEDIATE' AS VARCHAR2(9)) AS DEFERRED,     CASE WHEN A.VALIDATE_FLAG = 1 THEN CAST('VALIDATED' AS VARCHAR2(13))          ELSE CAST('NOT VALIDATED' AS VARCHAR2(13)) END AS VALIDATED,     CASE WHEN A.NAME_GENERATED_TYPE = 2 THEN CAST('GENERATED NAME' AS VARCHAR2(14))         WHEN A.NAME_GENERATED_TYPE = 1 THEN CAST('USER NAME' AS VARCHAR2(14))         ELSE CAST('NULL' AS VARCHAR2(14)) END AS "GENERATED",     CAST(NULL AS VARCHAR2(3)) AS BAD,     CAST(NULL AS VARCHAR2(4)) AS RELY,     CAST(NULL AS DATE) AS LAST_CHANGE,     CAST(NULL AS VARCHAR2(128)) AS INDEX_OWNER,     CAST(NULL AS VARCHAR2(128)) AS INDEX_NAME,     CAST(NULL AS VARCHAR2(7)) AS INVALID,     CAST(NULL AS VARCHAR2(14)) AS VIEW_RELATED     FROM SYS.ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C       WHERE A.CHILD_TABLE_ID = B.TABLE_ID AND B.DATABASE_ID = C.DATABASE_ID AND A.REF_CST_TYPE = 0 AND A.REF_CST_ID = -1 AND B.DATABASE_ID = USERENV('SCHEMAID')         AND A.TENANT_ID = EFFECTIVE_TENANT_ID()         AND B.TENANT_ID = EFFECTIVE_TENANT_ID()         AND C.TENANT_ID = EFFECTIVE_TENANT_ID()         AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13         AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)          AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0     UNION ALL     SELECT     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,     CAST(A.FOREIGN_KEY_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,     CAST('R' AS VARCHAR2(1)) AS CONSTRAINT_TYPE,     CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,     CAST(NULL AS VARCHAR2(4000)) AS SEARCH_CONDITION,     CAST(E.DATABASE_NAME AS VARCHAR2(128)) AS R_OWNER,     CAST(CASE WHEN A.REF_CST_TYPE = 2 THEN SUBSTR(F.TABLE_NAME, 7 + INSTR(SUBSTR(F.TABLE_NAME, 7), '_'))          ELSE NULL END AS VARCHAR2(128)) AS R_CONSTRAINT_NAME,     CAST(CASE WHEN DELETE_ACTION = 1 THEN 'NO ACTION'          WHEN DELETE_ACTION = 2 THEN 'CASCADE'          ELSE 'SET NULL' END AS VARCHAR2(9)) AS DELETE_RULE,     CASE WHEN A.ENABLE_FLAG = 1 THEN CAST('ENABLED' AS VARCHAR2(8))          ELSE CAST('DISABLED' AS VARCHAR2(8)) END AS STATUS,     CAST('NOT DEFERRABLE' AS VARCHAR2(14)) AS DEFERRABLE,     CAST('IMMEDIATE' AS VARCHAR2(9)) AS DEFERRED,     CASE WHEN A.VALIDATE_FLAG = 1 THEN CAST('VALIDATED' AS VARCHAR2(13))          ELSE CAST('NOT VALIDATED' AS VARCHAR2(13)) END AS VALIDATED,     CASE WHEN A.NAME_GENERATED_TYPE = 2 THEN CAST('GENERATED NAME' AS VARCHAR2(14))         WHEN A.NAME_GENERATED_TYPE = 1 THEN CAST('USER NAME' AS VARCHAR2(14))         ELSE CAST('NULL' AS VARCHAR2(14)) END AS "GENERATED",     CAST(NULL AS VARCHAR2(3)) AS BAD,     CASE WHEN A.RELY_FLAG = 1 THEN CAST('RELY' AS VARCHAR2(4))          ELSE CAST(NULL AS VARCHAR2(4)) END AS RELY,     CAST(NULL AS DATE) AS LAST_CHANGE,     CAST(NULL AS VARCHAR2(128)) AS INDEX_OWNER,     CAST(NULL AS VARCHAR2(128)) AS INDEX_NAME,     CAST(NULL AS VARCHAR2(7)) AS INVALID,     CAST(NULL AS VARCHAR2(14)) AS VIEW_RELATED     FROM SYS.ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT D, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT E, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT F       WHERE A.CHILD_TABLE_ID = B.TABLE_ID AND B.DATABASE_ID = C.DATABASE_ID AND A.PARENT_TABLE_ID = D.TABLE_ID AND D.DATABASE_ID = E.DATABASE_ID AND (A.REF_CST_ID = F.TABLE_ID AND A.REF_CST_TYPE = 2) AND B.DATABASE_ID = USERENV('SCHEMAID')       AND A.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TENANT_ID = EFFECTIVE_TENANT_ID()       AND C.TENANT_ID = EFFECTIVE_TENANT_ID()       AND D.TENANT_ID = EFFECTIVE_TENANT_ID()       AND E.TENANT_ID = EFFECTIVE_TENANT_ID()       AND F.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13       AND D.TABLE_TYPE != 12 AND D.TABLE_TYPE != 13       AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)        AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0     UNION ALL     SELECT     CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,     CAST(A.FOREIGN_KEY_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,     CAST('R' AS VARCHAR2(1)) AS CONSTRAINT_TYPE,     CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,     CAST(NULL AS VARCHAR2(4000)) AS SEARCH_CONDITION,     CAST(E.DATABASE_NAME AS VARCHAR2(128)) AS R_OWNER,     CAST(CASE WHEN A.REF_CST_TYPE = 1 THEN F.CONSTRAINT_NAME         ELSE NULL END AS VARCHAR2(128)) AS R_CONSTRAINT_NAME,     CAST(CASE WHEN DELETE_ACTION = 1 THEN 'NO ACTION'          WHEN DELETE_ACTION = 2 THEN 'CASCADE'          ELSE 'SET NULL' END AS VARCHAR2(9)) AS DELETE_RULE,     CASE WHEN A.ENABLE_FLAG = 1 THEN CAST('ENABLED' AS VARCHAR2(8))          ELSE CAST('DISABLED' AS VARCHAR2(8)) END AS STATUS,     CAST('NOT DEFERRABLE' AS VARCHAR2(14)) AS DEFERRABLE,     CAST('IMMEDIATE' AS VARCHAR2(9)) AS DEFERRED,     CASE WHEN A.VALIDATE_FLAG = 1 THEN CAST('VALIDATED' AS VARCHAR2(13))          ELSE CAST('NOT VALIDATED' AS VARCHAR2(13)) END AS VALIDATED,     CASE WHEN A.NAME_GENERATED_TYPE = 2 THEN CAST('GENERATED NAME' AS VARCHAR2(14))         WHEN A.NAME_GENERATED_TYPE = 1 THEN CAST('USER NAME' AS VARCHAR2(14))         ELSE CAST('NULL' AS VARCHAR2(14)) END AS "GENERATED",     CAST(NULL AS VARCHAR2(3)) AS BAD,     CASE WHEN A.RELY_FLAG = 1 THEN CAST('RELY' AS VARCHAR2(4))          ELSE CAST(NULL AS VARCHAR2(4)) END AS RELY,     CAST(NULL AS DATE) AS LAST_CHANGE,     CAST(NULL AS VARCHAR2(128)) AS INDEX_OWNER,     CAST(NULL AS VARCHAR2(128)) AS INDEX_NAME,     CAST(NULL AS VARCHAR2(7)) AS INVALID,     CAST(NULL AS VARCHAR2(14)) AS VIEW_RELATED     FROM SYS.ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT D, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT E, SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT F       WHERE A.CHILD_TABLE_ID = B.TABLE_ID AND B.DATABASE_ID = C.DATABASE_ID AND A.PARENT_TABLE_ID = D.TABLE_ID AND D.DATABASE_ID = E.DATABASE_ID AND (A.PARENT_TABLE_ID = F.TABLE_ID AND A.REF_CST_TYPE = 1 AND F.CONSTRAINT_TYPE = 1 AND A.REF_CST_ID = F.CONSTRAINT_ID) AND B.DATABASE_ID = USERENV('SCHEMAID')       AND A.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TENANT_ID = EFFECTIVE_TENANT_ID()       AND C.TENANT_ID = EFFECTIVE_TENANT_ID()       AND D.TENANT_ID = EFFECTIVE_TENANT_ID()       AND E.TENANT_ID = EFFECTIVE_TENANT_ID()       AND F.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13       AND D.TABLE_TYPE != 12 AND D.TABLE_TYPE != 13       AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)       AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0     UNION ALL     SELECT       CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,       CAST(CONSTRAINT_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,       CASE WHEN A.CONSTRAINT_TYPE = 1 THEN CAST('P' AS VARCHAR2(1))         ELSE CAST('C' AS VARCHAR2(1)) END AS CONSTRAINT_TYPE,       CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CASE WHEN A.CONSTRAINT_TYPE = 1 THEN CAST(NULL AS VARCHAR2(4000))         ELSE CAST(A.CHECK_EXPR AS VARCHAR2(4000)) END AS SEARCH_CONDITION,       CAST(NULL AS VARCHAR2(128)) AS R_OWNER,       CAST(NULL AS VARCHAR2(128)) AS R_CONSTRAINT_NAME,       CAST(NULL AS VARCHAR2(9)) AS DELETE_RULE,       CASE WHEN A.ENABLE_FLAG = 1 THEN CAST('ENABLED' AS VARCHAR2(8))         ELSE CAST('DISABLED' AS VARCHAR2(8)) END AS STATUS,       CAST('NOT DEFERRABLE' AS VARCHAR2(14)) AS DEFERRABLE,       CAST('IMMEDIATE' AS VARCHAR2(9)) AS DEFERRED,       CASE WHEN A.VALIDATE_FLAG = 1 THEN CAST('VALIDATED' AS VARCHAR2(13))         ELSE CAST('NOT VALIDATED' AS VARCHAR2(13)) END AS VALIDATED,       CASE WHEN A.NAME_GENERATED_TYPE = 2 THEN CAST('GENERATED NAME' AS VARCHAR2(14))         WHEN A.NAME_GENERATED_TYPE = 1 THEN CAST('USER NAME' AS VARCHAR2(14))         ELSE CAST('NULL' AS VARCHAR2(14)) END AS "GENERATED",       CAST(NULL AS VARCHAR2(3)) AS BAD,       CASE WHEN A.RELY_FLAG = 1 THEN CAST('RELY' AS VARCHAR2(4))         ELSE CAST(NULL AS VARCHAR2(4)) END AS RELY,       CAST(NULL AS DATE) AS LAST_CHANGE,       CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS INDEX_OWNER,       CASE WHEN A.CONSTRAINT_TYPE = 1 THEN CAST(A.CONSTRAINT_NAME AS VARCHAR2(128))         ELSE CAST(NULL AS VARCHAR2(128)) END AS INDEX_NAME,       CAST(NULL AS VARCHAR2(7)) AS INVALID,       CAST(NULL AS VARCHAR2(14)) AS VIEW_RELATED     FROM SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C     WHERE C.DATABASE_ID = USERENV('SCHEMAID') AND A.TABLE_ID = B.TABLE_ID AND B.DATABASE_ID = C.DATABASE_ID AND C.DATABASE_NAME != '__recyclebin'     AND A.TENANT_ID = EFFECTIVE_TENANT_ID()     AND B.TENANT_ID = EFFECTIVE_TENANT_ID()     AND C.TENANT_ID = EFFECTIVE_TENANT_ID()     AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13     AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)      AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0 )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::all_tab_cols_v_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_ALL_TAB_COLS_V_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_ALL_TAB_COLS_V_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__( SELECT   CAST(DB.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,   CAST(TC.TABLE_NAME AS VARCHAR2(128)) AS  TABLE_NAME,   CAST(TC.COLUMN_NAME AS VARCHAR2(128)) AS  COLUMN_NAME,   CAST(DECODE(TC.DATA_TYPE,         0, 'VARCHAR2',          1, 'NUMBER',         2, 'NUMBER',         3, 'NUMBER',         4, 'NUMBER',         5, 'NUMBER',          6, 'NUMBER',         7, 'NUMBER',         8, 'NUMBER',         9, 'NUMBER',         10, 'NUMBER',          11, 'BINARY_FLOAT',         12, 'BINARY_DOUBLE',          13, 'NUMBER',         14, 'NUMBER',          15, 'NUMBER',         16, 'NUMBER',          17, 'DATE',         18, 'TIMESTAMP',         19, 'DATE',         20, 'TIME',         21, 'YEAR',          22, 'VARCHAR2',         23, 'CHAR',         24, 'HEX_STRING',          25, 'UNDEFINED',         26, 'UNKNOWN',          27, 'TINYTEXT',         28, 'TEXT',         29, 'MEDIUMTEXT',         30, DECODE(TC.COLLATION_TYPE, 63, 'BLOB', 'CLOB'),         31, 'BIT',         32, 'ENUM',         33, 'SET',         34, 'ENUM_INNER',         35, 'SET_INNER',         36, CONCAT('TIMESTAMP(', CONCAT(TC.DATA_SCALE, ') WITH TIME ZONE')),         37, CONCAT('TIMESTAMP(', CONCAT(TC.DATA_SCALE, ') WITH LOCAL TIME ZONE')),         38, CONCAT('TIMESTAMP(', CONCAT(TC.DATA_SCALE, ')')),         39, 'RAW',         40, CONCAT('INTERVAL YEAR(', CONCAT(TC.DATA_SCALE, ') TO MONTH')),         41, CONCAT('INTERVAL DAY(', CONCAT(TRUNC(TC.DATA_SCALE/10), CONCAT(') TO SECOND(', CONCAT(MOD(TC.DATA_SCALE, 10), ')')))),         42, 'FLOAT',         43, 'NVARCHAR2',         44, 'NCHAR',         45, 'UROWID',         46, 'LOB',         47, 'JSON',         48, 'SDO_GEOMETRY',         49, DECODE(TC.SUB_DATA_TYPE, 300001, 'XMLTYPE', 'UDT'),         50, 'NUMBER',         52, 'MYSQL_DATE',         53, 'MYSQL_DATETIME',         'UNDEFINED') AS VARCHAR2(128)) AS  DATA_TYPE,   CAST(NULL AS VARCHAR2(3)) AS  DATA_TYPE_MOD,   CAST(NULL AS VARCHAR2(128)) AS  DATA_TYPE_OWNER,   CAST(CASE WHEN TC.DATA_TYPE in (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13, 14, 15, 16, 42, 50) THEN 22             WHEN TC.DATA_TYPE = 11 THEN 4             WHEN TC.DATA_TYPE = 12 THEN 8             WHEN TC.DATA_TYPE in (17, 19) THEN 7             WHEN TC.DATA_TYPE in (18, 37, 38) THEN CASE WHEN TC.DATA_SCALE = 0 THEN 7 ELSE 11 END             WHEN TC.DATA_TYPE = 41 THEN 11             WHEN TC.DATA_TYPE = 40 THEN 5             WHEN TC.DATA_TYPE = 30 THEN 4000             WHEN TC.DATA_TYPE = 36 THEN 13             WHEN TC.DATA_TYPE IN (0,22,43,46) AND TC.DATA_PRECISION = 1 THEN LEAST(32767, TC.DATA_LENGTH * DECODE(TC.COLLATION_TYPE, 63, 1, 249, 4, 248, 4, 87, 2,28, 2, 55, 2, 54, 4, 101, 2, 46, 4, 45, 4, 224, 4, 1))             WHEN TC.DATA_TYPE IN (23,44) AND TC.DATA_PRECISION = 1 THEN LEAST(2000, TC.DATA_LENGTH * DECODE(TC.COLLATION_TYPE, 63, 1, 249, 4, 248, 4, 87, 2,28, 2, 55, 2, 54, 4, 101, 2, 46, 4, 45, 4, 224, 4, 1))             WHEN TC.DATA_TYPE = 48 THEN 1             ELSE TC.DATA_LENGTH END AS NUMBER) AS DATA_LENGTH,   CAST(CASE WHEN TC.DATA_TYPE IN (0,11,12,17,18,19,22,23,27,28,29,30,36,37,38,43,44)             THEN NULL             ELSE CASE WHEN TC.DATA_PRECISION < 0 THEN NULL ELSE TC.DATA_PRECISION END        END AS NUMBER) AS  DATA_PRECISION,   CAST(CASE WHEN TC.DATA_TYPE IN (0,11,12,17,19,22,23,27,28,29,30,42,43,44)             THEN NULL             ELSE CASE WHEN TC.DATA_SCALE < -84 THEN NULL ELSE TC.DATA_SCALE END        END AS NUMBER) AS  DATA_SCALE,   CAST(DECODE(TC.NULLABLE, 0, 'N', DECODE(BITAND(TC.COLUMN_FLAGS, 5 * POWER(2, 13)), 5 * POWER(2, 13), 'N', 'Y')) AS VARCHAR2(1)) AS  NULLABLE,   CAST(DECODE(BITAND(TC.COLUMN_FLAGS, 64), 0, TC.COLUMN_ID, NULL) AS NUMBER) AS  COLUMN_ID,   CAST(LENGTHB(TC.CUR_DEFAULT_VALUE_V2) AS NUMBER) AS  DEFAULT_LENGTH,   CAST(TC.CUR_DEFAULT_VALUE_V2 AS /* TODO: LONG() */ VARCHAR(32767)) AS  DATA_DEFAULT,   CAST(STAT.DISTINCT_CNT AS NUMBER) AS  NUM_DISTINCT,   CAST(STAT.MIN_VALUE AS /* TODO: RAW */ VARCHAR(128)) AS  LOW_VALUE,   CAST(STAT.MAX_VALUE AS /* TODO: RAW */ VARCHAR(128)) AS  HIGH_VALUE,   CAST(STAT.DENSITY AS NUMBER) AS  DENSITY,   CAST(STAT.NULL_CNT AS NUMBER) AS  NUM_NULLS,   CAST(STAT.BUCKET_CNT AS NUMBER) AS  NUM_BUCKETS,   CAST(STAT.LAST_ANALYZED AS DATE) AS  LAST_ANALYZED,   CAST(STAT.SAMPLE_SIZE AS NUMBER) AS  SAMPLE_SIZE,   CAST(DECODE(TC.DATA_TYPE,          22, 'CHAR_CS',          23, 'CHAR_CS',          30, DECODE(TC.COLLATION_TYPE, 63, 'NULL', 'CHAR_CS'),          43, 'NCHAR_CS',          44, 'NCHAR_CS',          '') AS VARCHAR2(44)) AS  CHARACTER_SET_NAME,   CAST(NULL AS NUMBER) AS  CHAR_COL_DECL_LENGTH,   CAST(DECODE(STAT.GLOBAL_STATS, 0, 'NO', 1, 'YES', NULL) AS    VARCHAR2(3)) AS GLOBAL_STATS,   CAST(DECODE(STAT.USER_STATS, 0, 'NO', 1, 'YES', NULL) AS    VARCHAR2(3)) AS USER_STATS,   CAST(NULL AS VARCHAR2(80)) AS  NOTES,   CAST(STAT.AVG_LEN AS NUMBER) AS  AVG_COL_LEN,   CAST(CASE WHEN TC.DATA_TYPE IN (22,23,43,44) THEN TC.DATA_LENGTH ELSE 0 END AS NUMBER) AS  CHAR_LENGTH,   CAST(DECODE(TC.DATA_TYPE,          22, DECODE(TC.DATA_PRECISION, 1, 'C', 'B'),          23, DECODE(TC.DATA_PRECISION, 1, 'C', 'B'),          43, DECODE(TC.DATA_PRECISION, 1, 'C', 'B'),          44, DECODE(TC.DATA_PRECISION, 1, 'C', 'B'),          NULL) AS VARCHAR2(1)) AS  CHAR_USED,   CAST(NULL AS VARCHAR2(3)) AS  V80_FMT_IMAGE,   CAST(NULL AS VARCHAR2(3)) AS  DATA_UPGRADED,   CAST(DECODE(BITAND(TC.COLUMN_FLAGS, 2097216), 0, 'NO', 'YES') AS   /* regard invisible and unused columns as hidden ones to be compatible with oracle, other hidden columns will filtered out in the where condition and not displayed. */   VARCHAR2(3)) AS HIDDEN_COLUMN,   CAST(DECODE(BITAND(TC.COLUMN_FLAGS, 1), 1, 'YES', 'NO') AS VARCHAR2(3)) AS  VIRTUAL_COLUMN,   CAST(NULL AS NUMBER) AS  SEGMENT_COLUMN_ID,   CAST(NULL AS NUMBER) AS  INTERNAL_COLUMN_ID,   CAST((CASE WHEN STAT.HISTOGRAM_TYPE = 1 THEN 'FREQUENCY'         WHEN STAT.HISTOGRAM_TYPE = 3 THEN 'TOP-FREQUENCY'         WHEN STAT.HISTOGRAM_TYPE = 4 THEN 'HYBRID'         ELSE NULL END) AS VARCHAR2(15)) AS HISTOGRAM,   CAST(TC.COLUMN_NAME AS VARCHAR2(4000)) AS  QUALIFIED_COL_NAME,   CAST(DECODE(BITAND(TC.COLUMN_FLAGS, 2097152), 0, 'YES', 'NO') AS VARCHAR2(3)) AS USER_GENERATED,   CAST(NULL AS VARCHAR2(3)) AS  DEFAULT_ON_NULL,   CAST(NULL AS VARCHAR2(3)) AS  IDENTITY_COLUMN,   CAST(NULL AS VARCHAR2(128)) AS  EVALUATION_EDITION,   CAST(NULL AS VARCHAR2(128)) AS  UNUSABLE_BEFORE,   CAST(NULL AS VARCHAR2(128)) AS  UNUSABLE_BEGINNING,   CAST(NULL AS VARCHAR2(100)) AS  COLLATION,   CAST(NULL AS NUMBER) AS  COLLATED_COLUMN_ID FROM     (SELECT T.TENANT_ID,             T.TABLE_ID,             T.DATABASE_ID,             T.TABLE_NAME,             T.TABLE_TYPE,             C.COLUMN_ID,             C.COLUMN_NAME,             C.DATA_TYPE,             C.SUB_DATA_TYPE,             C.COLLATION_TYPE,             C.DATA_SCALE,             C.DATA_LENGTH,             C.DATA_PRECISION,             C.NULLABLE,             C.COLUMN_FLAGS,             C.CUR_DEFAULT_VALUE_V2      FROM SYS.ALL_VIRTUAL_CORE_ALL_TABLE T,           SYS.ALL_VIRTUAL_CORE_COLUMN_TABLE C      WHERE C.TENANT_ID = T.TENANT_ID        AND C.TABLE_ID = T.TABLE_ID        AND (C.IS_HIDDEN = 0 OR BITAND(C.COLUMN_FLAGS, 2097152) > 0)      UNION ALL      SELECT T.TENANT_ID,             T.TABLE_ID,             T.DATABASE_ID,             T.TABLE_NAME,             T.TABLE_TYPE,             C.COLUMN_ID,             C.COLUMN_NAME,             C.DATA_TYPE,             C.SUB_DATA_TYPE,             C.COLLATION_TYPE,             C.DATA_SCALE,             C.DATA_LENGTH,             C.DATA_PRECISION,             C.NULLABLE,             C.COLUMN_FLAGS,             C.CUR_DEFAULT_VALUE_V2      FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT T,           SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT C      WHERE T.TENANT_ID = EFFECTIVE_TENANT_ID()      AND C.TENANT_ID = EFFECTIVE_TENANT_ID()      AND T.TABLE_TYPE IN (0,1,3,4,7,8,9,14,15)      AND bitand((T.TABLE_MODE / 4096), 15) IN (0,1)      /*do not show deleting index*/      AND bitand(T.INDEX_ATTRIBUTES_SET, 16) = 0      AND C.TENANT_ID = T.TENANT_ID      AND C.TABLE_ID = T.TABLE_ID      AND (C.IS_HIDDEN = 0 OR bitand(C.COLUMN_FLAGS, 2097152) > 0)) TC   JOIN     SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT DB     ON DB.TENANT_ID = TC.TENANT_ID     AND DB.DATABASE_ID = TC.DATABASE_ID     AND DB.TENANT_ID = EFFECTIVE_TENANT_ID()     AND (TC.DATABASE_ID = USERENV('SCHEMAID')          OR USER_CAN_ACCESS_OBJ(1, TC.TABLE_ID, TC.DATABASE_ID) = 1)   LEFT JOIN     SYS.ALL_VIRTUAL_COLUMN_STAT_REAL_AGENT STAT     ON TC.TENANT_ID = STAT.TENANT_ID     AND TC.TABLE_ID = STAT.TABLE_ID     AND TC.COLUMN_ID = STAT.COLUMN_ID     AND STAT.OBJECT_TYPE = 1     AND STAT.TENANT_ID = EFFECTIVE_TENANT_ID() )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::dba_tab_cols_v_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_DBA_TAB_COLS_V_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_DBA_TAB_COLS_V_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__( SELECT   CAST(DB.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,   CAST(TC.TABLE_NAME AS VARCHAR2(128)) AS  TABLE_NAME,   CAST(TC.COLUMN_NAME AS VARCHAR2(128)) AS  COLUMN_NAME,   CAST(DECODE(TC.DATA_TYPE,         0, 'VARCHAR2',          1, 'NUMBER',         2, 'NUMBER',         3, 'NUMBER',         4, 'NUMBER',         5, 'NUMBER',          6, 'NUMBER',         7, 'NUMBER',         8, 'NUMBER',         9, 'NUMBER',         10, 'NUMBER',          11, 'BINARY_FLOAT',         12, 'BINARY_DOUBLE',          13, 'NUMBER',         14, 'NUMBER',          15, 'NUMBER',         16, 'NUMBER',          17, 'DATE',         18, 'TIMESTAMP',         19, 'DATE',         20, 'TIME',         21, 'YEAR',          22, 'VARCHAR2',         23, 'CHAR',         24, 'HEX_STRING',          25, 'UNDEFINED',         26, 'UNKNOWN',          27, 'TINYTEXT',         28, 'TEXT',         29, 'MEDIUMTEXT',         30, DECODE(TC.COLLATION_TYPE, 63, 'BLOB', 'CLOB'),         31, 'BIT',         32, 'ENUM',         33, 'SET',         34, 'ENUM_INNER',         35, 'SET_INNER',         36, CONCAT('TIMESTAMP(', CONCAT(TC.DATA_SCALE, ') WITH TIME ZONE')),         37, CONCAT('TIMESTAMP(', CONCAT(TC.DATA_SCALE, ') WITH LOCAL TIME ZONE')),         38, CONCAT('TIMESTAMP(', CONCAT(TC.DATA_SCALE, ')')),         39, 'RAW',         40, CONCAT('INTERVAL YEAR(', CONCAT(TC.DATA_SCALE, ') TO MONTH')),         41, CONCAT('INTERVAL DAY(', CONCAT(TRUNC(TC.DATA_SCALE/10), CONCAT(') TO SECOND(', CONCAT(MOD(TC.DATA_SCALE, 10), ')')))),         42, 'FLOAT',         43, 'NVARCHAR2',         44, 'NCHAR',         45, 'UROWID',         46, 'LOB',         47, 'JSON',         48, 'SDO_GEOMETRY',         49, DECODE(TC.SUB_DATA_TYPE, 300001, 'XMLTYPE', 'UDT'),         50, 'NUMBER',         52, 'MYSQL_DATE',         53, 'MYSQL_DATETIME',         'UNDEFINED') AS VARCHAR2(128)) AS  DATA_TYPE,   CAST(NULL AS VARCHAR2(3)) AS  DATA_TYPE_MOD,   CAST(NULL AS VARCHAR2(128)) AS  DATA_TYPE_OWNER,   CAST(CASE WHEN TC.DATA_TYPE in (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13, 14, 15, 16, 42, 50) THEN 22             WHEN TC.DATA_TYPE = 11 THEN 4             WHEN TC.DATA_TYPE = 12 THEN 8             WHEN TC.DATA_TYPE in (17, 19) THEN 7             WHEN TC.DATA_TYPE in (18, 37, 38) THEN CASE WHEN TC.DATA_SCALE = 0 THEN 7 ELSE 11 END             WHEN TC.DATA_TYPE = 41 THEN 11             WHEN TC.DATA_TYPE = 40 THEN 5             WHEN TC.DATA_TYPE = 30 THEN 4000             WHEN TC.DATA_TYPE = 36 THEN 13             WHEN TC.DATA_TYPE IN (0,22,43,46) AND TC.DATA_PRECISION = 1 THEN LEAST(32767, TC.DATA_LENGTH * DECODE(TC.COLLATION_TYPE, 63, 1, 249, 4, 248, 4, 87, 2,28, 2, 55, 2, 54, 4, 101, 2, 46, 4, 45, 4, 224, 4, 1))             WHEN TC.DATA_TYPE IN (23,44) AND TC.DATA_PRECISION = 1 THEN LEAST(2000, TC.DATA_LENGTH * DECODE(TC.COLLATION_TYPE, 63, 1, 249, 4, 248, 4, 87, 2,28, 2, 55, 2, 54, 4, 101, 2, 46, 4, 45, 4, 224, 4, 1))             WHEN TC.DATA_TYPE = 48 THEN 1             ELSE TC.DATA_LENGTH END AS NUMBER) AS DATA_LENGTH,   CAST(CASE WHEN TC.DATA_TYPE IN (0,11,12,17,18,19,22,23,27,28,29,30,36,37,38,43,44)             THEN NULL             ELSE CASE WHEN TC.DATA_PRECISION < 0 THEN NULL ELSE TC.DATA_PRECISION END        END AS NUMBER) AS  DATA_PRECISION,   CAST(CASE WHEN TC.DATA_TYPE IN (0,11,12,17,19,22,23,27,28,29,30,42,43,44)             THEN NULL             ELSE CASE WHEN TC.DATA_SCALE < -84 THEN NULL ELSE TC.DATA_SCALE END        END AS NUMBER) AS  DATA_SCALE,   CAST(DECODE(TC.NULLABLE, 0, 'N', DECODE(BITAND(TC.COLUMN_FLAGS, 5 * POWER(2, 13)), 5 * POWER(2, 13), 'N', 'Y')) AS VARCHAR2(1)) AS  NULLABLE,   CAST(DECODE(BITAND(TC.COLUMN_FLAGS, 64), 0, TC.COLUMN_ID, NULL) AS NUMBER) AS  COLUMN_ID,   CAST(LENGTHB(TC.CUR_DEFAULT_VALUE_V2) AS NUMBER) AS  DEFAULT_LENGTH,   CAST(TC.CUR_DEFAULT_VALUE_V2 AS /* TODO: LONG() */ VARCHAR(32767)) AS  DATA_DEFAULT,   CAST(STAT.DISTINCT_CNT AS NUMBER) AS  NUM_DISTINCT,   CAST(STAT.MIN_VALUE AS /* TODO: RAW */ VARCHAR(128)) AS  LOW_VALUE,   CAST(STAT.MAX_VALUE AS /* TODO: RAW */ VARCHAR(128)) AS  HIGH_VALUE,   CAST(STAT.DENSITY AS NUMBER) AS  DENSITY,   CAST(STAT.NULL_CNT AS NUMBER) AS  NUM_NULLS,   CAST(STAT.BUCKET_CNT AS NUMBER) AS  NUM_BUCKETS,   CAST(STAT.LAST_ANALYZED AS DATE) AS  LAST_ANALYZED,   CAST(STAT.SAMPLE_SIZE AS NUMBER) AS  SAMPLE_SIZE,   CAST(DECODE(TC.DATA_TYPE,          22, 'CHAR_CS',          23, 'CHAR_CS',          30, DECODE(TC.COLLATION_TYPE, 63, 'NULL', 'CHAR_CS'),          43, 'NCHAR_CS',          44, 'NCHAR_CS',          '') AS VARCHAR2(44)) AS  CHARACTER_SET_NAME,   CAST(NULL AS NUMBER) AS  CHAR_COL_DECL_LENGTH,   CAST(DECODE(STAT.GLOBAL_STATS, 0, 'NO', 1, 'YES', NULL) AS    VARCHAR2(3)) AS GLOBAL_STATS,   CAST(DECODE(STAT.USER_STATS, 0, 'NO', 1, 'YES', NULL) AS    VARCHAR2(3)) AS USER_STATS,   CAST(NULL AS VARCHAR2(80)) AS  NOTES,   CAST(STAT.AVG_LEN AS NUMBER) AS  AVG_COL_LEN,   CAST(CASE WHEN TC.DATA_TYPE IN (22,23,43,44) THEN TC.DATA_LENGTH ELSE 0 END AS NUMBER) AS  CHAR_LENGTH,   CAST(DECODE(TC.DATA_TYPE,          22, DECODE(TC.DATA_PRECISION, 1, 'C', 'B'),          23, DECODE(TC.DATA_PRECISION, 1, 'C', 'B'),          43, DECODE(TC.DATA_PRECISION, 1, 'C', 'B'),          44, DECODE(TC.DATA_PRECISION, 1, 'C', 'B'),          NULL) AS VARCHAR2(1)) AS  CHAR_USED,   CAST(NULL AS VARCHAR2(3)) AS  V80_FMT_IMAGE,   CAST(NULL AS VARCHAR2(3)) AS  DATA_UPGRADED,   CAST(DECODE(BITAND(TC.COLUMN_FLAGS, 64), 0, 'NO', 'YES') AS VARCHAR2(3)) AS HIDDEN_COLUMN,   CAST(DECODE(BITAND(TC.COLUMN_FLAGS, 1), 1, 'YES', 'NO') AS VARCHAR2(3)) AS  VIRTUAL_COLUMN,   CAST(NULL AS NUMBER) AS  SEGMENT_COLUMN_ID,   CAST(NULL AS NUMBER) AS  INTERNAL_COLUMN_ID,   CAST((CASE WHEN STAT.HISTOGRAM_TYPE = 1 THEN 'FREQUENCY'         WHEN STAT.HISTOGRAM_TYPE = 3 THEN 'TOP-FREQUENCY'         WHEN STAT.HISTOGRAM_TYPE = 4 THEN 'HYBRID'         ELSE NULL END) AS VARCHAR2(15)) AS HISTOGRAM,   CAST(TC.COLUMN_NAME AS VARCHAR2(4000)) AS  QUALIFIED_COL_NAME,   CAST(DECODE(BITAND(TC.COLUMN_FLAGS, 2097152), 0, 'YES', 'NO') AS VARCHAR2(3)) AS USER_GENERATED,   CAST(NULL AS VARCHAR2(3)) AS  DEFAULT_ON_NULL,   CAST(NULL AS VARCHAR2(3)) AS  IDENTITY_COLUMN,   CAST(NULL AS VARCHAR2(128)) AS  EVALUATION_EDITION,   CAST(NULL AS VARCHAR2(128)) AS  UNUSABLE_BEFORE,   CAST(NULL AS VARCHAR2(128)) AS  UNUSABLE_BEGINNING,   CAST(NULL AS VARCHAR2(100)) AS  COLLATION,   CAST(NULL AS NUMBER) AS  COLLATED_COLUMN_ID FROM     (SELECT T.TENANT_ID,             T.TABLE_ID,             T.DATABASE_ID,             T.TABLE_NAME,             T.TABLE_TYPE,             C.COLUMN_ID,             C.COLUMN_NAME,             C.DATA_TYPE,             C.SUB_DATA_TYPE,             C.COLLATION_TYPE,             C.DATA_SCALE,             C.DATA_LENGTH,             C.DATA_PRECISION,             C.NULLABLE,             C.COLUMN_FLAGS,             C.CUR_DEFAULT_VALUE_V2      FROM SYS.ALL_VIRTUAL_CORE_ALL_TABLE T,           SYS.ALL_VIRTUAL_CORE_COLUMN_TABLE C      WHERE C.TENANT_ID = T.TENANT_ID        AND C.TABLE_ID = T.TABLE_ID        AND (C.IS_HIDDEN = 0 OR BITAND(C.COLUMN_FLAGS, 2097152) > 0)      UNION ALL      SELECT T.TENANT_ID,             T.TABLE_ID,             T.DATABASE_ID,             T.TABLE_NAME,             T.TABLE_TYPE,             C.COLUMN_ID,             C.COLUMN_NAME,             C.DATA_TYPE,             C.SUB_DATA_TYPE,             C.COLLATION_TYPE,             C.DATA_SCALE,             C.DATA_LENGTH,             C.DATA_PRECISION,             C.NULLABLE,             C.COLUMN_FLAGS,             C.CUR_DEFAULT_VALUE_V2      FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT T,           SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT C      WHERE T.TENANT_ID = EFFECTIVE_TENANT_ID()      AND C.TENANT_ID = EFFECTIVE_TENANT_ID()      AND T.TABLE_TYPE IN (0,1,3,4,7,8,9,14,15)      AND bitand((T.TABLE_MODE / 4096), 15) IN (0,1)      /*do not show deleting index*/      AND bitand(T.INDEX_ATTRIBUTES_SET, 16) = 0      AND C.TENANT_ID = T.TENANT_ID      AND C.TABLE_ID = T.TABLE_ID      AND (C.IS_HIDDEN = 0 OR BITAND(C.COLUMN_FLAGS, 2097152) > 0)) TC   JOIN     SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT DB     ON DB.TENANT_ID = TC.TENANT_ID     AND DB.DATABASE_ID = TC.DATABASE_ID     AND DB.TENANT_ID = EFFECTIVE_TENANT_ID()   LEFT JOIN     SYS.ALL_VIRTUAL_COLUMN_STAT_REAL_AGENT STAT     ON TC.TENANT_ID = STAT.TENANT_ID     AND TC.TABLE_ID = STAT.TABLE_ID     AND TC.COLUMN_ID = STAT.COLUMN_ID     AND STAT.OBJECT_TYPE = 1     AND STAT.TENANT_ID = EFFECTIVE_TENANT_ID() )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::user_tab_cols_v_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_USER_TAB_COLS_V_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_USER_TAB_COLS_V_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__( SELECT   CAST(TC.TABLE_NAME AS VARCHAR2(128)) AS  TABLE_NAME,   CAST(TC.COLUMN_NAME AS VARCHAR2(128)) AS  COLUMN_NAME,   CAST(DECODE(TC.DATA_TYPE,         0, 'VARCHAR2',          1, 'NUMBER',         2, 'NUMBER',         3, 'NUMBER',         4, 'NUMBER',         5, 'NUMBER',          6, 'NUMBER',         7, 'NUMBER',         8, 'NUMBER',         9, 'NUMBER',         10, 'NUMBER',          11, 'BINARY_FLOAT',         12, 'BINARY_DOUBLE',          13, 'NUMBER',         14, 'NUMBER',          15, 'NUMBER',         16, 'NUMBER',          17, 'DATE',         18, 'TIMESTAMP',         19, 'DATE',         20, 'TIME',         21, 'YEAR',          22, 'VARCHAR2',         23, 'CHAR',         24, 'HEX_STRING',          25, 'UNDEFINED',         26, 'UNKNOWN',          27, 'TINYTEXT',         28, 'TEXT',         29, 'MEDIUMTEXT',         30, DECODE(TC.COLLATION_TYPE, 63, 'BLOB', 'CLOB'),         31, 'BIT',         32, 'ENUM',         33, 'SET',         34, 'ENUM_INNER',         35, 'SET_INNER',         36, CONCAT('TIMESTAMP(', CONCAT(TC.DATA_SCALE, ') WITH TIME ZONE')),         37, CONCAT('TIMESTAMP(', CONCAT(TC.DATA_SCALE, ') WITH LOCAL TIME ZONE')),         38, CONCAT('TIMESTAMP(', CONCAT(TC.DATA_SCALE, ')')),         39, 'RAW',         40, CONCAT('INTERVAL YEAR(', CONCAT(TC.DATA_SCALE, ') TO MONTH')),         41, CONCAT('INTERVAL DAY(', CONCAT(TRUNC(TC.DATA_SCALE/10), CONCAT(') TO SECOND(', CONCAT(MOD(TC.DATA_SCALE, 10), ')')))),         42, 'FLOAT',         43, 'NVARCHAR2',         44, 'NCHAR',         45, 'UROWID',         46, 'LOB',         47, 'JSON',         48, 'SDO_GEOMETRY',         49, DECODE(TC.SUB_DATA_TYPE, 300001, 'XMLTYPE', 'UDT'),         50, 'NUMBER',         52, 'MYSQL_DATE',         53, 'MYSQL_DATETIME',         'UNDEFINED') AS VARCHAR2(128)) AS  DATA_TYPE,   CAST(NULL AS VARCHAR2(3)) AS  DATA_TYPE_MOD,   CAST(NULL AS VARCHAR2(128)) AS  DATA_TYPE_OWNER,   CAST(CASE WHEN TC.DATA_TYPE in (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13, 14, 15, 16, 42, 50) THEN 22             WHEN TC.DATA_TYPE = 11 THEN 4             WHEN TC.DATA_TYPE = 12 THEN 8             WHEN TC.DATA_TYPE in (17, 19) THEN 7             WHEN TC.DATA_TYPE in (18, 37, 38) THEN CASE WHEN TC.DATA_SCALE = 0 THEN 7 ELSE 11 END             WHEN TC.DATA_TYPE = 41 THEN 11             WHEN TC.DATA_TYPE = 40 THEN 5             WHEN TC.DATA_TYPE = 30 THEN 4000             WHEN TC.DATA_TYPE = 36 THEN 13             WHEN TC.DATA_TYPE IN (0,22,43,46) AND TC.DATA_PRECISION = 1 THEN LEAST(32767, TC.DATA_LENGTH * DECODE(TC.COLLATION_TYPE, 63, 1, 249, 4, 248, 4, 87, 2,28, 2, 55, 2, 54, 4, 101, 2, 46, 4, 45, 4, 224, 4, 1))             WHEN TC.DATA_TYPE IN (23,44) AND TC.DATA_PRECISION = 1 THEN LEAST(2000, TC.DATA_LENGTH * DECODE(TC.COLLATION_TYPE, 63, 1, 249, 4, 248, 4, 87, 2,28, 2, 55, 2, 54, 4, 101, 2, 46, 4, 45, 4, 224, 4, 1))             WHEN TC.DATA_TYPE = 48 THEN 1             ELSE TC.DATA_LENGTH END AS NUMBER) AS DATA_LENGTH,   CAST(CASE WHEN TC.DATA_TYPE IN (0,11,12,17,18,19,22,23,27,28,29,30,36,37,38,43,44)             THEN NULL             ELSE CASE WHEN TC.DATA_PRECISION < 0 THEN NULL ELSE TC.DATA_PRECISION END        END AS NUMBER) AS  DATA_PRECISION,   CAST(CASE WHEN TC.DATA_TYPE IN (0,11,12,17,19,22,23,27,28,29,30,42,43,44)             THEN NULL             ELSE CASE WHEN TC.DATA_SCALE < -84 THEN NULL ELSE TC.DATA_SCALE END        END AS NUMBER) AS  DATA_SCALE,   CAST(DECODE(TC.NULLABLE, 0, 'N', DECODE(BITAND(TC.COLUMN_FLAGS, 5 * POWER(2, 13)), 5 * POWER(2, 13), 'N', 'Y')) AS VARCHAR2(1)) AS  NULLABLE,   CAST(DECODE(BITAND(TC.COLUMN_FLAGS, 64), 0, TC.COLUMN_ID, NULL) AS NUMBER) AS  COLUMN_ID,   CAST(LENGTHB(TC.CUR_DEFAULT_VALUE_V2) AS NUMBER) AS  DEFAULT_LENGTH,   CAST(TC.CUR_DEFAULT_VALUE_V2 AS /* TODO: LONG() */ VARCHAR(32767)) AS  DATA_DEFAULT,   CAST(STAT.DISTINCT_CNT AS NUMBER) AS  NUM_DISTINCT,   CAST(STAT.MIN_VALUE AS /* TODO: RAW */ VARCHAR(128)) AS  LOW_VALUE,   CAST(STAT.MAX_VALUE AS /* TODO: RAW */ VARCHAR(128)) AS  HIGH_VALUE,   CAST(STAT.DENSITY AS NUMBER) AS  DENSITY,   CAST(STAT.NULL_CNT AS NUMBER) AS  NUM_NULLS,   CAST(STAT.BUCKET_CNT AS NUMBER) AS  NUM_BUCKETS,   CAST(STAT.LAST_ANALYZED AS DATE) AS  LAST_ANALYZED,   CAST(STAT.SAMPLE_SIZE AS NUMBER) AS  SAMPLE_SIZE,   CAST(DECODE(TC.DATA_TYPE,          22, 'CHAR_CS',          23, 'CHAR_CS',          30, DECODE(TC.COLLATION_TYPE, 63, 'NULL', 'CHAR_CS'),          43, 'NCHAR_CS',          44, 'NCHAR_CS',          '') AS VARCHAR2(44)) AS  CHARACTER_SET_NAME,   CAST(NULL AS NUMBER) AS  CHAR_COL_DECL_LENGTH,   CAST(DECODE(STAT.GLOBAL_STATS, 0, 'NO', 1, 'YES', NULL) AS    VARCHAR2(3)) AS GLOBAL_STATS,   CAST(DECODE(STAT.USER_STATS, 0, 'NO', 1, 'YES', NULL) AS    VARCHAR2(3)) AS USER_STATS,   CAST(NULL AS VARCHAR2(80)) AS  NOTES,   CAST(STAT.AVG_LEN AS NUMBER) AS  AVG_COL_LEN,   CAST(CASE WHEN TC.DATA_TYPE IN (22,23,43,44) THEN TC.DATA_LENGTH ELSE 0 END AS NUMBER) AS  CHAR_LENGTH,   CAST(DECODE(TC.DATA_TYPE,          22, DECODE(TC.DATA_PRECISION, 1, 'C', 'B'),          23, DECODE(TC.DATA_PRECISION, 1, 'C', 'B'),          43, DECODE(TC.DATA_PRECISION, 1, 'C', 'B'),          44, DECODE(TC.DATA_PRECISION, 1, 'C', 'B'),          NULL) AS VARCHAR2(1)) AS  CHAR_USED,   CAST(NULL AS VARCHAR2(3)) AS  V80_FMT_IMAGE,   CAST(NULL AS VARCHAR2(3)) AS  DATA_UPGRADED,   CAST(DECODE(BITAND(TC.COLUMN_FLAGS, 64), 0, 'NO', 'YES') AS VARCHAR2(3)) AS HIDDEN_COLUMN,   CAST(DECODE(BITAND(TC.COLUMN_FLAGS, 1), 1, 'YES', 'NO') AS VARCHAR2(3)) AS  VIRTUAL_COLUMN,   CAST(NULL AS NUMBER) AS  SEGMENT_COLUMN_ID,   CAST(NULL AS NUMBER) AS  INTERNAL_COLUMN_ID,   CAST((CASE WHEN STAT.HISTOGRAM_TYPE = 1 THEN 'FREQUENCY'         WHEN STAT.HISTOGRAM_TYPE = 3 THEN 'TOP-FREQUENCY'         WHEN STAT.HISTOGRAM_TYPE = 4 THEN 'HYBRID'         ELSE NULL END) AS VARCHAR2(15)) AS HISTOGRAM,   CAST(TC.COLUMN_NAME AS VARCHAR2(4000)) AS  QUALIFIED_COL_NAME,   CAST(DECODE(BITAND(TC.COLUMN_FLAGS, 2097152), 0, 'YES', 'NO') AS VARCHAR2(3)) AS USER_GENERATED,   CAST(NULL AS VARCHAR2(3)) AS  DEFAULT_ON_NULL,   CAST(NULL AS VARCHAR2(3)) AS  IDENTITY_COLUMN,   CAST(NULL AS VARCHAR2(128)) AS  EVALUATION_EDITION,   CAST(NULL AS VARCHAR2(128)) AS  UNUSABLE_BEFORE,   CAST(NULL AS VARCHAR2(128)) AS  UNUSABLE_BEGINNING,   CAST(NULL AS VARCHAR2(100)) AS  COLLATION,   CAST(NULL AS NUMBER) AS  COLLATED_COLUMN_ID FROM     (SELECT T.TENANT_ID,             T.TABLE_ID,             T.DATABASE_ID,             T.TABLE_NAME,             T.TABLE_TYPE,             C.COLUMN_ID,             C.COLUMN_NAME,             C.DATA_TYPE,             C.SUB_DATA_TYPE,             C.COLLATION_TYPE,             C.DATA_SCALE,             C.DATA_LENGTH,             C.DATA_PRECISION,             C.NULLABLE,             C.COLUMN_FLAGS,             C.CUR_DEFAULT_VALUE_V2      FROM SYS.ALL_VIRTUAL_CORE_ALL_TABLE T,           SYS.ALL_VIRTUAL_CORE_COLUMN_TABLE C      WHERE C.TENANT_ID = T.TENANT_ID        AND C.TABLE_ID = T.TABLE_ID        AND (C.IS_HIDDEN = 0 OR BITAND(C.COLUMN_FLAGS, 2097152) > 0)      UNION ALL      SELECT T.TENANT_ID,             T.TABLE_ID,             T.DATABASE_ID,             T.TABLE_NAME,             T.TABLE_TYPE,             C.COLUMN_ID,             C.COLUMN_NAME,             C.DATA_TYPE,             C.SUB_DATA_TYPE,             C.COLLATION_TYPE,             C.DATA_SCALE,             C.DATA_LENGTH,             C.DATA_PRECISION,             C.NULLABLE,             C.COLUMN_FLAGS,             C.CUR_DEFAULT_VALUE_V2      FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT T,           SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT C      WHERE T.TENANT_ID = EFFECTIVE_TENANT_ID()      AND C.TENANT_ID = EFFECTIVE_TENANT_ID()      AND T.TABLE_TYPE IN (0,1,3,4,7,8,9,14,15)      AND bitand((T.TABLE_MODE / 4096), 15) IN (0,1)      AND bitand(INDEX_ATTRIBUTES_SET, 16) = 0      AND C.TENANT_ID = T.TENANT_ID      AND C.TABLE_ID = T.TABLE_ID      AND (C.IS_HIDDEN = 0 OR bitand(C.COLUMN_FLAGS, 2097152) > 0)) TC   JOIN     SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT DB     ON DB.TENANT_ID = TC.TENANT_ID     AND DB.DATABASE_ID = TC.DATABASE_ID     AND DB.TENANT_ID = EFFECTIVE_TENANT_ID()     AND TC.DATABASE_ID = USERENV('SCHEMAID')   LEFT JOIN     SYS.ALL_VIRTUAL_COLUMN_STAT_REAL_AGENT STAT     ON TC.TENANT_ID = STAT.TENANT_ID     AND TC.TABLE_ID = STAT.TABLE_ID     AND TC.COLUMN_ID = STAT.COLUMN_ID     AND STAT.OBJECT_TYPE = 1     AND STAT.TENANT_ID = EFFECTIVE_TENANT_ID() )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::all_tab_cols_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_ALL_TAB_COLS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_ALL_TAB_COLS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__( SELECT   OWNER,   TABLE_NAME,   COLUMN_NAME,   DATA_TYPE,   DATA_TYPE_MOD,   DATA_TYPE_OWNER,   DATA_LENGTH,   DATA_PRECISION,   DATA_SCALE,   NULLABLE,   COLUMN_ID,   DEFAULT_LENGTH,   DATA_DEFAULT,   NUM_DISTINCT,   LOW_VALUE,   HIGH_VALUE,   DENSITY,   NUM_NULLS,   NUM_BUCKETS,   LAST_ANALYZED,   SAMPLE_SIZE,   CHARACTER_SET_NAME,   CHAR_COL_DECL_LENGTH,   GLOBAL_STATS,   USER_STATS,   AVG_COL_LEN,   CHAR_LENGTH,   CHAR_USED,   V80_FMT_IMAGE,   DATA_UPGRADED,   HIDDEN_COLUMN,   VIRTUAL_COLUMN,   SEGMENT_COLUMN_ID,   INTERNAL_COLUMN_ID,   HISTOGRAM,   QUALIFIED_COL_NAME,   USER_GENERATED,   DEFAULT_ON_NULL,   IDENTITY_COLUMN,   EVALUATION_EDITION,   UNUSABLE_BEFORE,   UNUSABLE_BEGINNING,   COLLATION,   COLLATED_COLUMN_ID FROM SYS.ALL_TAB_COLS_V$ )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::dba_tab_cols_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_DBA_TAB_COLS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_DBA_TAB_COLS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__( SELECT   OWNER,   TABLE_NAME,   COLUMN_NAME,   DATA_TYPE,   DATA_TYPE_MOD,   DATA_TYPE_OWNER,   DATA_LENGTH,   DATA_PRECISION,   DATA_SCALE,   NULLABLE,   COLUMN_ID,   DEFAULT_LENGTH,   DATA_DEFAULT,   NUM_DISTINCT,   LOW_VALUE,   HIGH_VALUE,   DENSITY,   NUM_NULLS,   NUM_BUCKETS,   LAST_ANALYZED,   SAMPLE_SIZE,   CHARACTER_SET_NAME,   CHAR_COL_DECL_LENGTH,   GLOBAL_STATS,   USER_STATS,   AVG_COL_LEN,   CHAR_LENGTH,   CHAR_USED,   V80_FMT_IMAGE,   DATA_UPGRADED,   HIDDEN_COLUMN,   VIRTUAL_COLUMN,   SEGMENT_COLUMN_ID,   INTERNAL_COLUMN_ID,   HISTOGRAM,   QUALIFIED_COL_NAME,   USER_GENERATED,   DEFAULT_ON_NULL,   IDENTITY_COLUMN,   EVALUATION_EDITION,   UNUSABLE_BEFORE,   UNUSABLE_BEGINNING,   COLLATION,   COLLATED_COLUMN_ID FROM SYS.DBA_TAB_COLS_V$ )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::user_tab_cols_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_USER_TAB_COLS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_USER_TAB_COLS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__( SELECT   TABLE_NAME,   COLUMN_NAME,   DATA_TYPE,   DATA_TYPE_MOD,   DATA_TYPE_OWNER,   DATA_LENGTH,   DATA_PRECISION,   DATA_SCALE,   NULLABLE,   COLUMN_ID,   DEFAULT_LENGTH,   DATA_DEFAULT,   NUM_DISTINCT,   LOW_VALUE,   HIGH_VALUE,   DENSITY,   NUM_NULLS,   NUM_BUCKETS,   LAST_ANALYZED,   SAMPLE_SIZE,   CHARACTER_SET_NAME,   CHAR_COL_DECL_LENGTH,   GLOBAL_STATS,   USER_STATS,   AVG_COL_LEN,   CHAR_LENGTH,   CHAR_USED,   V80_FMT_IMAGE,   DATA_UPGRADED,   HIDDEN_COLUMN,   VIRTUAL_COLUMN,   SEGMENT_COLUMN_ID,   INTERNAL_COLUMN_ID,   HISTOGRAM,   QUALIFIED_COL_NAME,   USER_GENERATED,   DEFAULT_ON_NULL,   IDENTITY_COLUMN,   EVALUATION_EDITION,   UNUSABLE_BEFORE,   UNUSABLE_BEGINNING,   COLLATION,   COLLATED_COLUMN_ID FROM SYS.USER_TAB_COLS_V$ )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::all_tab_columns_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_ALL_TAB_COLUMNS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_ALL_TAB_COLUMNS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__( SELECT   OWNER,   TABLE_NAME,   COLUMN_NAME,   DATA_TYPE,   DATA_TYPE_MOD,   DATA_TYPE_OWNER,   DATA_LENGTH,   DATA_PRECISION,   DATA_SCALE,   NULLABLE,   COLUMN_ID,   DEFAULT_LENGTH,   DATA_DEFAULT,   NUM_DISTINCT,   LOW_VALUE,   HIGH_VALUE,   DENSITY,   NUM_NULLS,   NUM_BUCKETS,   LAST_ANALYZED,   SAMPLE_SIZE,   CHARACTER_SET_NAME,   CHAR_COL_DECL_LENGTH,   GLOBAL_STATS,   USER_STATS,   AVG_COL_LEN,   CHAR_LENGTH,   CHAR_USED,   V80_FMT_IMAGE,   DATA_UPGRADED,   HISTOGRAM,   DEFAULT_ON_NULL,   IDENTITY_COLUMN,   EVALUATION_EDITION,   UNUSABLE_BEFORE,   UNUSABLE_BEGINNING,   COLLATION FROM SYS.ALL_TAB_COLS WHERE USER_GENERATED = 'YES' )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::dba_tab_columns_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_DBA_TAB_COLUMNS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_DBA_TAB_COLUMNS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__( SELECT   OWNER,   TABLE_NAME,   COLUMN_NAME,   DATA_TYPE,   DATA_TYPE_MOD,   DATA_TYPE_OWNER,   DATA_LENGTH,   DATA_PRECISION,   DATA_SCALE,   NULLABLE,   COLUMN_ID,   DEFAULT_LENGTH,   DATA_DEFAULT,   NUM_DISTINCT,   LOW_VALUE,   HIGH_VALUE,   DENSITY,   NUM_NULLS,   NUM_BUCKETS,   LAST_ANALYZED,   SAMPLE_SIZE,   CHARACTER_SET_NAME,   CHAR_COL_DECL_LENGTH,   GLOBAL_STATS,   USER_STATS,   AVG_COL_LEN,   CHAR_LENGTH,   CHAR_USED,   V80_FMT_IMAGE,   DATA_UPGRADED,   HISTOGRAM,   DEFAULT_ON_NULL,   IDENTITY_COLUMN,   EVALUATION_EDITION,   UNUSABLE_BEFORE,   UNUSABLE_BEGINNING,   COLLATION FROM SYS.DBA_TAB_COLS WHERE USER_GENERATED = 'YES' )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::user_tab_columns_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_USER_TAB_COLUMNS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_USER_TAB_COLUMNS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__( SELECT   TABLE_NAME,   COLUMN_NAME,   DATA_TYPE,   DATA_TYPE_MOD,   DATA_TYPE_OWNER,   DATA_LENGTH,   DATA_PRECISION,   DATA_SCALE,   NULLABLE,   COLUMN_ID,   DEFAULT_LENGTH,   DATA_DEFAULT,   NUM_DISTINCT,   LOW_VALUE,   HIGH_VALUE,   DENSITY,   NUM_NULLS,   NUM_BUCKETS,   LAST_ANALYZED,   SAMPLE_SIZE,   CHARACTER_SET_NAME,   CHAR_COL_DECL_LENGTH,   GLOBAL_STATS,   USER_STATS,   AVG_COL_LEN,   CHAR_LENGTH,   CHAR_USED,   V80_FMT_IMAGE,   DATA_UPGRADED,   HISTOGRAM,   DEFAULT_ON_NULL,   IDENTITY_COLUMN,   EVALUATION_EDITION,   UNUSABLE_BEFORE,   UNUSABLE_BEGINNING,   COLLATION FROM SYS.USER_TAB_COLS WHERE USER_GENERATED = 'YES' )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::all_tables_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_ALL_TABLES_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_ALL_TABLES_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__( SELECT   CAST(DB.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,   CAST(T.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,   CAST(TP.TABLESPACE_NAME AS VARCHAR2(30)) AS TABLESPACE_NAME,   CAST(NULL AS VARCHAR2(128)) AS CLUSTER_NAME,   CAST(NULL AS VARCHAR2(128)) AS IOT_NAME,   CAST('VALID' AS VARCHAR2(8)) AS STATUS,   CAST(T."PCTFREE" AS NUMBER) AS PCT_FREE,   CAST(NULL AS NUMBER) AS PCT_USED,   CAST(NULL AS NUMBER) AS INI_TRANS,   CAST(NULL AS NUMBER) AS MAX_TRANS,   CAST(NULL AS NUMBER) AS INITIAL_EXTENT,   CAST(NULL AS NUMBER) AS NEXT_EXTENT,   CAST(NULL AS NUMBER) AS MIN_EXTENTS,   CAST(NULL AS NUMBER) AS MAX_EXTENTS,   CAST(NULL AS NUMBER) AS PCT_INCREASE,   CAST(NULL AS NUMBER) AS FREELISTS,   CAST(NULL AS NUMBER) AS FREELIST_GROUPS,   CAST(NULL AS VARCHAR2(3)) AS LOGGING,   CAST(NULL AS VARCHAR2(1)) AS BACKED_UP,   CAST(INFO.ROW_COUNT AS NUMBER) AS NUM_ROWS,   CAST(NULL AS NUMBER) AS BLOCKS,   CAST(NULL AS NUMBER) AS EMPTY_BLOCKS,   CAST(NULL AS NUMBER) AS AVG_SPACE,   CAST(NULL AS NUMBER) AS CHAIN_CNT,   CAST(NULL AS NUMBER) AS AVG_ROW_LEN,   CAST(NULL AS NUMBER) AS AVG_SPACE_FREELIST_BLOCKS,   CAST(NULL AS NUMBER) AS NUM_FREELIST_BLOCKS,   CAST(NULL AS VARCHAR2(10)) AS DEGREE,   CAST(NULL AS VARCHAR2(10)) AS INSTANCES,   CAST(NULL AS VARCHAR2(5)) AS CACHE,   CAST(NULL AS VARCHAR2(8)) AS TABLE_LOCK,   CAST(NULL AS NUMBER) AS SAMPLE_SIZE,   CAST(NULL AS DATE) AS LAST_ANALYZED,   CAST(   CASE     WHEN       T.PART_LEVEL = 0     THEN       'NO'     ELSE       'YES'   END   AS VARCHAR2(3)) AS PARTITIONED,   CAST(NULL AS VARCHAR2(12)) AS IOT_TYPE,   CAST(DECODE (T.TABLE_TYPE, 8, 'Y', 9, 'Y', 'N') AS VARCHAR2(1)) AS TEMPORARY,   CAST(NULL AS VARCHAR2(1)) AS SECONDARY,   CAST('NO' AS VARCHAR2(3)) AS NESTED,   CAST(NULL AS VARCHAR2(7)) AS BUFFER_POOL,   CAST(NULL AS VARCHAR2(7)) AS FLASH_CACHE,   CAST(NULL AS VARCHAR2(7)) AS CELL_FLASH_CACHE,   CAST(NULL AS VARCHAR2(8)) AS ROW_MOVEMENT,   CAST(NULL AS VARCHAR2(3)) AS GLOBAL_STATS,   CAST(NULL AS VARCHAR2(3)) AS USER_STATS,   CAST(DECODE (T.TABLE_TYPE, 8, 'SYS$SESSION',                              9, 'SYS$TRANSACTION',                              NULL) AS VARCHAR2(15)) AS DURATION,   CAST(NULL AS VARCHAR2(8)) AS SKIP_CORRUPT,   CAST(NULL AS VARCHAR2(3)) AS MONITORING,   CAST(NULL AS VARCHAR2(128)) AS CLUSTER_OWNER,   CAST(NULL AS VARCHAR2(8)) AS DEPENDENCIES,   CAST(NULL AS VARCHAR2(8)) AS COMPRESSION,   CAST(NULL AS VARCHAR2(30)) AS COMPRESS_FOR,   CAST(CASE WHEN DB.IN_RECYCLEBIN = 1 THEN 'YES' ELSE 'NO' END AS VARCHAR2(3)) AS DROPPED,   CAST(NULL AS VARCHAR2(3)) AS READ_ONLY,   CAST(NULL AS VARCHAR2(3)) AS SEGMENT_CREATED,   CAST(NULL AS VARCHAR2(7)) AS RESULT_CACHE,   CAST(NULL AS VARCHAR2(3)) AS CLUSTERING,   CAST(NULL AS VARCHAR2(23)) AS ACTIVITY_TRACKING,   CAST(NULL AS VARCHAR2(25)) AS DML_TIMESTAMP,   CAST(NULL AS VARCHAR2(3)) AS HAS_IDENTITY,   CAST(NULL AS VARCHAR2(3)) AS CONTAINER_DATA,   CAST(NULL AS VARCHAR2(8)) AS INMEMORY,   CAST(NULL AS VARCHAR2(8)) AS INMEMORY_PRIORITY,   CAST(NULL AS VARCHAR2(15)) AS INMEMORY_DISTRIBUTE,   CAST(NULL AS VARCHAR2(17)) AS INMEMORY_COMPRESSION,   CAST(NULL AS VARCHAR2(13)) AS INMEMORY_DUPLICATE,   CAST(NULL AS VARCHAR2(100)) AS DEFAULT_COLLATION,   CAST(NULL AS VARCHAR2(1)) AS DUPLICATED,   CAST(NULL AS VARCHAR2(1)) AS SHARDED,   CAST(NULL AS VARCHAR2(1)) AS EXTERNALLY_SHARDED,   CAST(NULL AS VARCHAR2(1)) AS EXTERNALLY_DUPLICATED,   CAST(DECODE (T.TABLE_TYPE, 14, 'YES', 'NO') AS VARCHAR2(3)) AS EXTERNAL,   CAST(NULL AS VARCHAR2(3)) AS HYBRID,   CAST(NULL AS VARCHAR2(24)) AS CELLMEMORY,   CAST(NULL AS VARCHAR2(3)) AS CONTAINERS_DEFAULT,   CAST(NULL AS VARCHAR2(3)) AS CONTAINER_MAP,   CAST(NULL AS VARCHAR2(3)) AS EXTENDED_DATA_LINK,   CAST(NULL AS VARCHAR2(3)) AS EXTENDED_DATA_LINK_MAP,   CAST(NULL AS VARCHAR2(12)) AS INMEMORY_SERVICE,   CAST(NULL AS VARCHAR2(1000)) AS INMEMORY_SERVICE_NAME,   CAST(NULL AS VARCHAR2(3)) AS CONTAINER_MAP_OBJECT,   CAST(NULL AS VARCHAR2(8)) AS MEMOPTIMIZE_READ,   CAST(NULL AS VARCHAR2(8)) AS MEMOPTIMIZE_WRITE,   CAST(NULL AS VARCHAR2(3)) AS HAS_SENSITIVE_COLUMN,   CAST(NULL AS VARCHAR2(3)) AS ADMIT_NULL,   CAST(NULL AS VARCHAR2(3)) AS DATA_LINK_DML_ENABLED,   CAST(NULL AS VARCHAR2(8)) AS LOGICAL_REPLICATION,   CAST(CASE WHEN T.AUTO_PART = 1 THEN 'TRUE' ELSE 'FALSE' END AS VARCHAR2(16)) AS AUTO_SPLIT,   CAST(CASE WHEN T.AUTO_PART = 1 THEN T.AUTO_PART_SIZE ELSE 0 END AS VARCHAR2(128)) AS AUTO_SPLIT_TABLET_SIZE FROM   (SELECT      TENANT_ID,      TABLE_ID,      ROW_CNT AS ROW_COUNT    FROM      SYS.ALL_VIRTUAL_TABLE_STAT_REAL_AGENT TS    WHERE      TS.TENANT_ID = EFFECTIVE_TENANT_ID()      AND (PARTITION_ID = -1 OR PARTITION_ID = TABLE_ID)   ) INFO    RIGHT JOIN   (SELECT      TENANT_ID,      TABLE_ID,      TABLE_NAME,      DATABASE_ID,      "PCTFREE",      PART_LEVEL,      TABLE_TYPE,      TABLESPACE_ID,      AUTO_PART,      AUTO_PART_SIZE    FROM      SYS.ALL_VIRTUAL_CORE_ALL_TABLE     UNION ALL     SELECT      TENANT_ID,      TABLE_ID,      TABLE_NAME,      DATABASE_ID,      "PCTFREE",      PART_LEVEL,      TABLE_TYPE,      TABLESPACE_ID,      AUTO_PART,      AUTO_PART_SIZE    FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT    WHERE TENANT_ID = EFFECTIVE_TENANT_ID()    AND BITAND((TABLE_MODE / 4096), 15) IN (0,1)     AND BITAND(INDEX_ATTRIBUTES_SET, 16) = 0   ) T   ON     T.TENANT_ID = INFO.TENANT_ID     AND T.TABLE_ID = INFO.TABLE_ID     AND INFO.TENANT_ID = EFFECTIVE_TENANT_ID()    JOIN     SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT DB   ON     DB.TENANT_ID = T.TENANT_ID     AND DB.DATABASE_ID = T.DATABASE_ID     AND T.TABLE_TYPE IN (0, 3, 8, 9, 14, 15)     AND DB.TENANT_ID = EFFECTIVE_TENANT_ID()     AND DB.DATABASE_NAME !=  '__recyclebin'     AND (T.DATABASE_ID = USERENV('SCHEMAID')          OR USER_CAN_ACCESS_OBJ(1, T.TABLE_ID, T.DATABASE_ID) =1)    LEFT JOIN     SYS.ALL_VIRTUAL_TENANT_TABLESPACE_REAL_AGENT TP   ON     TP.TABLESPACE_ID = T.TABLESPACE_ID     AND T.TENANT_ID = TP.TENANT_ID     AND TP.TENANT_ID = EFFECTIVE_TENANT_ID() )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::dba_tables_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_DBA_TABLES_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_DBA_TABLES_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__( SELECT   CAST(DB.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,   CAST(T.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,   CAST(TP.TABLESPACE_NAME AS VARCHAR2(30)) AS TABLESPACE_NAME,   CAST(NULL AS VARCHAR2(128)) AS CLUSTER_NAME,   CAST(NULL AS VARCHAR2(128)) AS IOT_NAME,   CAST('VALID' AS VARCHAR2(8)) AS STATUS,   CAST(T."PCTFREE" AS NUMBER) AS PCT_FREE,   CAST(NULL AS NUMBER) AS PCT_USED,   CAST(NULL AS NUMBER) AS INI_TRANS,   CAST(NULL AS NUMBER) AS MAX_TRANS,   CAST(NULL AS NUMBER) AS INITIAL_EXTENT,   CAST(NULL AS NUMBER) AS NEXT_EXTENT,   CAST(NULL AS NUMBER) AS MIN_EXTENTS,   CAST(NULL AS NUMBER) AS MAX_EXTENTS,   CAST(NULL AS NUMBER) AS PCT_INCREASE,   CAST(NULL AS NUMBER) AS FREELISTS,   CAST(NULL AS NUMBER) AS FREELIST_GROUPS,   CAST(NULL AS VARCHAR2(3)) AS LOGGING,   CAST(NULL AS VARCHAR2(1)) AS BACKED_UP,   CAST(INFO.ROW_COUNT AS NUMBER) AS NUM_ROWS,   CAST(NULL AS NUMBER) AS BLOCKS,   CAST(NULL AS NUMBER) AS EMPTY_BLOCKS,   CAST(NULL AS NUMBER) AS AVG_SPACE,   CAST(NULL AS NUMBER) AS CHAIN_CNT,   CAST(NULL AS NUMBER) AS AVG_ROW_LEN,   CAST(NULL AS NUMBER) AS AVG_SPACE_FREELIST_BLOCKS,   CAST(NULL AS NUMBER) AS NUM_FREELIST_BLOCKS,   CAST(NULL AS VARCHAR2(10)) AS DEGREE,   CAST(NULL AS VARCHAR2(10)) AS INSTANCES,   CAST(NULL AS VARCHAR2(5)) AS CACHE,   CAST(NULL AS VARCHAR2(8)) AS TABLE_LOCK,   CAST(NULL AS NUMBER) AS SAMPLE_SIZE,   CAST(NULL AS DATE) AS LAST_ANALYZED,   CAST(   CASE     WHEN       T.PART_LEVEL = 0     THEN       'NO'     ELSE       'YES'   END   AS VARCHAR2(3)) AS PARTITIONED,   CAST(NULL AS VARCHAR2(12)) AS IOT_TYPE,   CAST(DECODE (T.TABLE_TYPE, 8, 'Y', 9, 'Y', 'N') AS VARCHAR2(1)) AS TEMPORARY,   CAST(NULL AS VARCHAR2(1)) AS SECONDARY,   CAST('NO' AS VARCHAR2(3)) AS NESTED,   CAST(NULL AS VARCHAR2(7)) AS BUFFER_POOL,   CAST(NULL AS VARCHAR2(7)) AS FLASH_CACHE,   CAST(NULL AS VARCHAR2(7)) AS CELL_FLASH_CACHE,   CAST(NULL AS VARCHAR2(8)) AS ROW_MOVEMENT,   CAST(NULL AS VARCHAR2(3)) AS GLOBAL_STATS,   CAST(NULL AS VARCHAR2(3)) AS USER_STATS,   CAST(DECODE (T.TABLE_TYPE, 8, 'SYS$SESSION',                              9, 'SYS$TRANSACTION',                              NULL) AS VARCHAR2(15)) AS DURATION,   CAST(NULL AS VARCHAR2(8)) AS SKIP_CORRUPT,   CAST(NULL AS VARCHAR2(3)) AS MONITORING,   CAST(NULL AS VARCHAR2(128)) AS CLUSTER_OWNER,   CAST(NULL AS VARCHAR2(8)) AS DEPENDENCIES,   CAST(NULL AS VARCHAR2(8)) AS COMPRESSION,   CAST(NULL AS VARCHAR2(30)) AS COMPRESS_FOR,   CAST(CASE WHEN DB.IN_RECYCLEBIN = 1 THEN 'YES' ELSE 'NO' END AS VARCHAR2(3)) AS DROPPED,   CAST(NULL AS VARCHAR2(3)) AS READ_ONLY,   CAST(NULL AS VARCHAR2(3)) AS SEGMENT_CREATED,   CAST(NULL AS VARCHAR2(7)) AS RESULT_CACHE,   CAST(NULL AS VARCHAR2(3)) AS CLUSTERING,   CAST(NULL AS VARCHAR2(23)) AS ACTIVITY_TRACKING,   CAST(NULL AS VARCHAR2(25)) AS DML_TIMESTAMP,   CAST(NULL AS VARCHAR2(3)) AS HAS_IDENTITY,   CAST(NULL AS VARCHAR2(3)) AS CONTAINER_DATA,   CAST(NULL AS VARCHAR2(8)) AS INMEMORY,   CAST(NULL AS VARCHAR2(8)) AS INMEMORY_PRIORITY,   CAST(NULL AS VARCHAR2(15)) AS INMEMORY_DISTRIBUTE,   CAST(NULL AS VARCHAR2(17)) AS INMEMORY_COMPRESSION,   CAST(NULL AS VARCHAR2(13)) AS INMEMORY_DUPLICATE,   CAST(NULL AS VARCHAR2(100)) AS DEFAULT_COLLATION,   CAST(NULL AS VARCHAR2(1)) AS DUPLICATED,   CAST(NULL AS VARCHAR2(1)) AS SHARDED,   CAST(NULL AS VARCHAR2(1)) AS EXTERNALLY_SHARDED,   CAST(NULL AS VARCHAR2(1)) AS EXTERNALLY_DUPLICATED,   CAST(DECODE (T.TABLE_TYPE, 14, 'YES', 'NO') AS VARCHAR2(3)) AS EXTERNAL,   CAST(NULL AS VARCHAR2(3)) AS HYBRID,   CAST(NULL AS VARCHAR2(24)) AS CELLMEMORY,   CAST(NULL AS VARCHAR2(3)) AS CONTAINERS_DEFAULT,   CAST(NULL AS VARCHAR2(3)) AS CONTAINER_MAP,   CAST(NULL AS VARCHAR2(3)) AS EXTENDED_DATA_LINK,   CAST(NULL AS VARCHAR2(3)) AS EXTENDED_DATA_LINK_MAP,   CAST(NULL AS VARCHAR2(12)) AS INMEMORY_SERVICE,   CAST(NULL AS VARCHAR2(1000)) AS INMEMORY_SERVICE_NAME,   CAST(NULL AS VARCHAR2(3)) AS CONTAINER_MAP_OBJECT,   CAST(NULL AS VARCHAR2(8)) AS MEMOPTIMIZE_READ,   CAST(NULL AS VARCHAR2(8)) AS MEMOPTIMIZE_WRITE,   CAST(NULL AS VARCHAR2(3)) AS HAS_SENSITIVE_COLUMN,   CAST(NULL AS VARCHAR2(3)) AS ADMIT_NULL,   CAST(NULL AS VARCHAR2(3)) AS DATA_LINK_DML_ENABLED,   CAST(NULL AS VARCHAR2(8)) AS LOGICAL_REPLICATION,   CAST(CASE WHEN T.AUTO_PART = 1 THEN 'TRUE' ELSE 'FALSE' END AS VARCHAR2(16)) AS AUTO_SPLIT,   CAST(CASE WHEN T.AUTO_PART = 1 THEN T.AUTO_PART_SIZE ELSE 0 END AS VARCHAR2(128)) AS AUTO_SPLIT_TABLET_SIZE FROM   (SELECT      TENANT_ID,      TABLE_ID,      ROW_CNT AS ROW_COUNT    FROM      SYS.ALL_VIRTUAL_TABLE_STAT_REAL_AGENT TS    WHERE      TS.TENANT_ID = EFFECTIVE_TENANT_ID()      AND (PARTITION_ID = -1 OR PARTITION_ID = TABLE_ID)   ) INFO    RIGHT JOIN   (SELECT      TENANT_ID,      TABLE_ID,      TABLE_NAME,      DATABASE_ID,      "PCTFREE",      PART_LEVEL,      TABLE_TYPE,      TABLESPACE_ID,      AUTO_PART,      AUTO_PART_SIZE    FROM      SYS.ALL_VIRTUAL_CORE_ALL_TABLE     UNION ALL     SELECT      TENANT_ID,      TABLE_ID,      TABLE_NAME,      DATABASE_ID,      "PCTFREE",      PART_LEVEL,      TABLE_TYPE,      TABLESPACE_ID,      AUTO_PART,      AUTO_PART_SIZE    FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT    WHERE TENANT_ID = EFFECTIVE_TENANT_ID() AND TABLE_TYPE != 12 AND TABLE_TYPE != 13    AND BITAND((TABLE_MODE / 4096), 15) IN (0,1)     AND BITAND(INDEX_ATTRIBUTES_SET, 16) = 0   ) T   ON     T.TENANT_ID = INFO.TENANT_ID     AND T.TABLE_ID = INFO.TABLE_ID     AND INFO.TENANT_ID = EFFECTIVE_TENANT_ID()    JOIN     SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT DB   ON     DB.TENANT_ID = T.TENANT_ID     AND DB.DATABASE_ID = T.DATABASE_ID     AND T.TABLE_TYPE IN (0, 3, 8, 9, 14, 15)     AND DB.TENANT_ID = EFFECTIVE_TENANT_ID()     AND DB.DATABASE_NAME !=  '__recyclebin'    LEFT JOIN     SYS.ALL_VIRTUAL_TENANT_TABLESPACE_REAL_AGENT TP   ON     TP.TABLESPACE_ID = T.TABLESPACE_ID     AND T.TENANT_ID = TP.TENANT_ID     AND TP.TENANT_ID = EFFECTIVE_TENANT_ID() )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::user_tables_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_USER_TABLES_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_USER_TABLES_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__( SELECT   CAST(T.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,   CAST(TP.TABLESPACE_NAME AS VARCHAR2(30)) AS TABLESPACE_NAME,   CAST(NULL AS VARCHAR2(128)) AS CLUSTER_NAME,   CAST(NULL AS VARCHAR2(128)) AS IOT_NAME,   CAST('VALID' AS VARCHAR2(8)) AS STATUS,   CAST(T."PCTFREE" AS NUMBER) AS PCT_FREE,   CAST(NULL AS NUMBER) AS PCT_USED,   CAST(NULL AS NUMBER) AS INI_TRANS,   CAST(NULL AS NUMBER) AS MAX_TRANS,   CAST(NULL AS NUMBER) AS INITIAL_EXTENT,   CAST(NULL AS NUMBER) AS NEXT_EXTENT,   CAST(NULL AS NUMBER) AS MIN_EXTENTS,   CAST(NULL AS NUMBER) AS MAX_EXTENTS,   CAST(NULL AS NUMBER) AS PCT_INCREASE,   CAST(NULL AS NUMBER) AS FREELISTS,   CAST(NULL AS NUMBER) AS FREELIST_GROUPS,   CAST(NULL AS VARCHAR2(3)) AS LOGGING,   CAST(NULL AS VARCHAR2(1)) AS BACKED_UP,   CAST(INFO.ROW_COUNT AS NUMBER) AS NUM_ROWS,   CAST(NULL AS NUMBER) AS BLOCKS,   CAST(NULL AS NUMBER) AS EMPTY_BLOCKS,   CAST(NULL AS NUMBER) AS AVG_SPACE,   CAST(NULL AS NUMBER) AS CHAIN_CNT,   CAST(NULL AS NUMBER) AS AVG_ROW_LEN,   CAST(NULL AS NUMBER) AS AVG_SPACE_FREELIST_BLOCKS,   CAST(NULL AS NUMBER) AS NUM_FREELIST_BLOCKS,   CAST(NULL AS VARCHAR2(10)) AS DEGREE,   CAST(NULL AS VARCHAR2(10)) AS INSTANCES,   CAST(NULL AS VARCHAR2(5)) AS CACHE,   CAST(NULL AS VARCHAR2(8)) AS TABLE_LOCK,   CAST(NULL AS NUMBER) AS SAMPLE_SIZE,   CAST(NULL AS DATE) AS LAST_ANALYZED,   CAST(   CASE     WHEN       T.PART_LEVEL = 0     THEN       'NO'     ELSE       'YES'   END   AS VARCHAR2(3)) AS PARTITIONED,   CAST(NULL AS VARCHAR2(12)) AS IOT_TYPE,   CAST(DECODE (T.TABLE_TYPE, 8, 'Y', 9, 'Y', 'N') AS VARCHAR2(1)) AS TEMPORARY,   CAST(NULL AS VARCHAR2(1)) AS SECONDARY,   CAST('NO' AS VARCHAR2(3)) AS NESTED,   CAST(NULL AS VARCHAR2(7)) AS BUFFER_POOL,   CAST(NULL AS VARCHAR2(7)) AS FLASH_CACHE,   CAST(NULL AS VARCHAR2(7)) AS CELL_FLASH_CACHE,   CAST(NULL AS VARCHAR2(8)) AS ROW_MOVEMENT,   CAST(NULL AS VARCHAR2(3)) AS GLOBAL_STATS,   CAST(NULL AS VARCHAR2(3)) AS USER_STATS,   CAST(DECODE (T.TABLE_TYPE, 8, 'SYS$SESSION',                              9, 'SYS$TRANSACTION',                              NULL) AS VARCHAR2(15)) AS DURATION,   CAST(NULL AS VARCHAR2(8)) AS SKIP_CORRUPT,   CAST(NULL AS VARCHAR2(3)) AS MONITORING,   CAST(NULL AS VARCHAR2(128)) AS CLUSTER_OWNER,   CAST(NULL AS VARCHAR2(8)) AS DEPENDENCIES,   CAST(NULL AS VARCHAR2(8)) AS COMPRESSION,   CAST(NULL AS VARCHAR2(30)) AS COMPRESS_FOR,   CAST(CASE WHEN DB.IN_RECYCLEBIN = 1 THEN 'YES' ELSE 'NO' END AS VARCHAR2(3)) AS DROPPED,   CAST(NULL AS VARCHAR2(3)) AS READ_ONLY,   CAST(NULL AS VARCHAR2(3)) AS SEGMENT_CREATED,   CAST(NULL AS VARCHAR2(7)) AS RESULT_CACHE,   CAST(NULL AS VARCHAR2(3)) AS CLUSTERING,   CAST(NULL AS VARCHAR2(23)) AS ACTIVITY_TRACKING,   CAST(NULL AS VARCHAR2(25)) AS DML_TIMESTAMP,   CAST(NULL AS VARCHAR2(3)) AS HAS_IDENTITY,   CAST(NULL AS VARCHAR2(3)) AS CONTAINER_DATA,   CAST(NULL AS VARCHAR2(8)) AS INMEMORY,   CAST(NULL AS VARCHAR2(8)) AS INMEMORY_PRIORITY,   CAST(NULL AS VARCHAR2(15)) AS INMEMORY_DISTRIBUTE,   CAST(NULL AS VARCHAR2(17)) AS INMEMORY_COMPRESSION,   CAST(NULL AS VARCHAR2(13)) AS INMEMORY_DUPLICATE,   CAST(NULL AS VARCHAR2(100)) AS DEFAULT_COLLATION,   CAST(NULL AS VARCHAR2(1)) AS DUPLICATED,   CAST(NULL AS VARCHAR2(1)) AS SHARDED,   CAST(NULL AS VARCHAR2(1)) AS EXTERNALLY_SHARDED,   CAST(NULL AS VARCHAR2(1)) AS EXTERNALLY_DUPLICATED,   CAST(DECODE (T.TABLE_TYPE, 14, 'YES', 'NO') AS VARCHAR2(3)) AS EXTERNAL,   CAST(NULL AS VARCHAR2(3)) AS HYBRID,   CAST(NULL AS VARCHAR2(24)) AS CELLMEMORY,   CAST(NULL AS VARCHAR2(3)) AS CONTAINERS_DEFAULT,   CAST(NULL AS VARCHAR2(3)) AS CONTAINER_MAP,   CAST(NULL AS VARCHAR2(3)) AS EXTENDED_DATA_LINK,   CAST(NULL AS VARCHAR2(3)) AS EXTENDED_DATA_LINK_MAP,   CAST(NULL AS VARCHAR2(12)) AS INMEMORY_SERVICE,   CAST(NULL AS VARCHAR2(1000)) AS INMEMORY_SERVICE_NAME,   CAST(NULL AS VARCHAR2(3)) AS CONTAINER_MAP_OBJECT,   CAST(NULL AS VARCHAR2(8)) AS MEMOPTIMIZE_READ,   CAST(NULL AS VARCHAR2(8)) AS MEMOPTIMIZE_WRITE,   CAST(NULL AS VARCHAR2(3)) AS HAS_SENSITIVE_COLUMN,   CAST(NULL AS VARCHAR2(3)) AS ADMIT_NULL,   CAST(NULL AS VARCHAR2(3)) AS DATA_LINK_DML_ENABLED,   CAST(NULL AS VARCHAR2(8)) AS LOGICAL_REPLICATION,   CAST(CASE WHEN T.AUTO_PART = 1 THEN 'TRUE' ELSE 'FALSE' END AS VARCHAR2(16)) AS AUTO_SPLIT,   CAST(CASE WHEN T.AUTO_PART = 1 THEN T.AUTO_PART_SIZE ELSE 0 END AS VARCHAR2(128)) AS AUTO_SPLIT_TABLET_SIZE FROM   (SELECT      TENANT_ID,      TABLE_ID,      ROW_CNT AS ROW_COUNT    FROM      SYS.ALL_VIRTUAL_TABLE_STAT_REAL_AGENT TS    WHERE      TS.TENANT_ID = EFFECTIVE_TENANT_ID()      AND (PARTITION_ID = -1 OR PARTITION_ID = TABLE_ID)   ) INFO    RIGHT JOIN   (SELECT      TENANT_ID,      TABLE_ID,      TABLE_NAME,      DATABASE_ID,      "PCTFREE",      PART_LEVEL,      TABLE_TYPE,      TABLESPACE_ID,      AUTO_PART,      AUTO_PART_SIZE    FROM      SYS.ALL_VIRTUAL_CORE_ALL_TABLE     UNION ALL     SELECT      TENANT_ID,      TABLE_ID,      TABLE_NAME,      DATABASE_ID,      "PCTFREE",      PART_LEVEL,      TABLE_TYPE,      TABLESPACE_ID,      AUTO_PART,      AUTO_PART_SIZE    FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT    WHERE TENANT_ID = EFFECTIVE_TENANT_ID() AND TABLE_TYPE != 12 AND TABLE_TYPE != 13    AND BITAND((TABLE_MODE / 4096), 15) IN (0,1)     AND BITAND(INDEX_ATTRIBUTES_SET, 16) = 0   ) T   ON     T.TENANT_ID = INFO.TENANT_ID     AND T.TABLE_ID = INFO.TABLE_ID     AND INFO.TENANT_ID = EFFECTIVE_TENANT_ID()    JOIN     SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT DB   ON     DB.TENANT_ID = T.TENANT_ID     AND DB.DATABASE_ID = T.DATABASE_ID     AND T.TABLE_TYPE IN (0, 3, 8, 9, 14, 15)     AND T.DATABASE_ID = USERENV('SCHEMAID')     AND DB.TENANT_ID = EFFECTIVE_TENANT_ID()     AND DB.DATABASE_NAME !=  '__recyclebin'    LEFT JOIN     SYS.ALL_VIRTUAL_TENANT_TABLESPACE_REAL_AGENT TP   ON     TP.TABLESPACE_ID = T.TABLESPACE_ID     AND T.TENANT_ID = TP.TENANT_ID     AND TP.TENANT_ID = EFFECTIVE_TENANT_ID() )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::dba_tab_comments_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_DBA_TAB_COMMENTS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_DBA_TAB_COMMENTS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       A.DATABASE_NAME AS OWNER,       CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST(CASE WHEN TABLE_TYPE = 0 OR TABLE_TYPE = 2 OR TABLE_TYPE = 3 OR TABLE_TYPE = 8 OR TABLE_TYPE = 9 THEN 'TABLE'                 WHEN TABLE_TYPE = 1 OR TABLE_TYPE = 4 OR TABLE_TYPE = 7 THEN 'VIEW'                 WHEN TABLE_TYPE = 14 THEN 'EXTERNAL_TABLE'                 WHEN TABLE_TYPE = 15 THEN 'MATERIALIZED VIEW LOG'                 ELSE NULL END AS VARCHAR2(11)) AS TABLE_TYPE,       CAST(B."COMMENT" AS VARCHAR(4000)) AS COMMENTS     FROM       SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT A       JOIN SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B     ON A.DATABASE_ID = B.DATABASE_ID     AND A.TENANT_ID = EFFECTIVE_TENANT_ID()     AND B.TENANT_ID = EFFECTIVE_TENANT_ID()     AND B.TABLE_TYPE != 5     AND B.TABLE_TYPE != 12     AND B.TABLE_TYPE != 13     AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)      AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0 )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::all_tab_comments_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_ALL_TAB_COMMENTS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_ALL_TAB_COMMENTS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       A.DATABASE_NAME AS OWNER,       CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST(CASE WHEN TABLE_TYPE = 0 OR TABLE_TYPE = 2 OR TABLE_TYPE = 3 OR TABLE_TYPE = 8 OR TABLE_TYPE = 9 THEN 'TABLE'                 WHEN TABLE_TYPE = 1 OR TABLE_TYPE = 4 OR TABLE_TYPE = 7 THEN 'VIEW'                 WHEN TABLE_TYPE = 14 THEN 'EXTERNAL_TABLE'                 WHEN TABLE_TYPE = 15 THEN 'MATERIALIZED VIEW LOG'                 ELSE NULL END AS VARCHAR2(11)) AS TABLE_TYPE,       CAST(B."COMMENT" AS VARCHAR(4000)) AS COMMENTS     FROM       SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT A       JOIN SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B     ON A.DATABASE_ID = B.DATABASE_ID     AND A.TENANT_ID = EFFECTIVE_TENANT_ID()     AND B.TENANT_ID = EFFECTIVE_TENANT_ID()     AND B.TABLE_TYPE != 5     AND B.TABLE_TYPE != 12     AND B.TABLE_TYPE != 13     AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)      AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0     AND (A.DATABASE_ID = USERENV('SCHEMAID')         OR USER_CAN_ACCESS_OBJ(1, TABLE_ID, A.DATABASE_ID) = 1) )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::user_tab_comments_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_USER_TAB_COMMENTS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_USER_TAB_COMMENTS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST(CASE WHEN TABLE_TYPE = 0 OR TABLE_TYPE = 2 OR TABLE_TYPE = 3 OR TABLE_TYPE = 8 OR TABLE_TYPE = 9 THEN 'TABLE'                 WHEN TABLE_TYPE = 1 OR TABLE_TYPE = 4 OR TABLE_TYPE = 7 THEN 'VIEW'                 WHEN TABLE_TYPE = 14 THEN 'EXTERNAL_TABLE'                 WHEN TABLE_TYPE = 15 THEN 'MATERIALIZED VIEW LOG'                 ELSE NULL END AS VARCHAR2(11)) AS TABLE_TYPE,       CAST(B."COMMENT" AS VARCHAR(4000)) AS COMMENTS     FROM       SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT A       JOIN SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B     ON A.DATABASE_ID = B.DATABASE_ID     AND A.TENANT_ID = EFFECTIVE_TENANT_ID()     AND B.TENANT_ID = EFFECTIVE_TENANT_ID()     AND B.TABLE_TYPE != 5     AND B.TABLE_TYPE != 12     AND B.TABLE_TYPE != 13     AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)      AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0     AND A.DATABASE_NAME = SYS_CONTEXT('USERENV','CURRENT_USER') )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::dba_col_comments_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_DBA_COL_COMMENTS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_DBA_COL_COMMENTS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       A.DATABASE_NAME AS OWNER,       CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       C.COLUMN_NAME AS COLUMN_NAME,       CAST(C."COMMENT" AS VARCHAR(4000)) AS COMMENTS     FROM       SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT A,       SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B,       SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT C     WHERE       A.DATABASE_ID = B.DATABASE_ID       AND B.TABLE_ID = C.TABLE_ID       AND A.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TENANT_ID = EFFECTIVE_TENANT_ID()       AND C.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13       AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)        AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0 )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::all_col_comments_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_ALL_COL_COMMENTS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_ALL_COL_COMMENTS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       A.DATABASE_NAME AS OWNER,       CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       C.COLUMN_NAME AS COLUMN_NAME,       CAST(C."COMMENT" AS VARCHAR(4000)) AS COMMENTS     FROM     SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT A,       SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B,       SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT C     WHERE       A.DATABASE_ID = B.DATABASE_ID       AND B.TABLE_ID = C.TABLE_ID       AND A.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TENANT_ID = EFFECTIVE_TENANT_ID()       AND C.TENANT_ID = EFFECTIVE_TENANT_ID()       AND (A.DATABASE_ID = USERENV('SCHEMAID')            OR USER_CAN_ACCESS_OBJ(1, B.TABLE_ID, B.DATABASE_ID) = 1)       AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13       AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)        AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0       AND BITAND(C.COLUMN_FLAGS, 2097152) = 0 )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::user_col_comments_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_USER_COL_COMMENTS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_USER_COL_COMMENTS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       C.COLUMN_NAME AS COLUMN_NAME,       CAST(C."COMMENT" AS VARCHAR(4000)) AS COMMENTS     FROM       SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT A,       SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B,       SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT C     WHERE       A.DATABASE_ID = B.DATABASE_ID       AND B.TABLE_ID = C.TABLE_ID       AND A.TENANT_ID = EFFECTIVE_TENANT_ID()       AND B.TENANT_ID = EFFECTIVE_TENANT_ID()       AND C.TENANT_ID = EFFECTIVE_TENANT_ID()       AND A.DATABASE_NAME = SYS_CONTEXT('USERENV','CURRENT_USER')       AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13       AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)        AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0 )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::dba_indexes_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_DBA_INDEXES_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_DBA_INDEXES_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       CAST(INDEX_OWNER AS VARCHAR2(128)) AS OWNER,       CAST(INDEX_NAME AS VARCHAR2(128)) AS INDEX_NAME,       CAST(INDEX_TYPE_NAME AS VARCHAR2(27)) AS INDEX_TYPE,       CAST(TABLE_OWNER AS VARCHAR2(128)) AS TABLE_OWNER,       CAST(NEW_TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST('TABLE' AS CHAR(5)) AS TABLE_TYPE,       CAST(UNIQUENESS AS VARCHAR2(9)) AS UNIQUENESS,       CAST(COMPRESSION AS VARCHAR2(13)) AS COMPRESSION,       CAST(NULL AS NUMBER) AS PREFIX_LENGTH,       CAST(TABLESPACE_NAME AS VARCHAR2(30)) AS TABLESPACE_NAME,       CAST(NULL AS NUMBER) AS INI_TRANS,       CAST(NULL AS NUMBER) AS MAX_TRANS,       CAST(NULL AS NUMBER) AS INITIAL_EXTENT,       CAST(NULL AS NUMBER) AS NEXT_EXTENT,       CAST(NULL AS NUMBER) AS MIN_EXTENTS,       CAST(NULL AS NUMBER) AS MAX_EXTENTS,       CAST(NULL AS NUMBER) AS PCT_INCREASE,       CAST(NULL AS NUMBER) AS PCT_THRESHOLD,       CAST(NULL AS NUMBER) AS INCLUDE_COLUMN,       CAST(NULL AS NUMBER) AS FREELISTS,       CAST(NULL AS NUMBER) AS FREELIST_GROUPS,       CAST(NULL AS NUMBER) AS PCT_FREE,       CAST(NULL AS VARCHAR2(3)) AS LOGGING,       CAST(NULL AS NUMBER) AS BLEVEL,       CAST(NULL AS NUMBER) AS LEAF_BLOCKS,       CAST(NULL AS NUMBER) AS DISTINCT_KEYS,       CAST(NULL AS NUMBER) AS AVG_LEAF_BLOCKS_PER_KEY,       CAST(NULL AS NUMBER) AS AVG_DATA_BLOCKS_PER_KEY,       CAST(NULL AS NUMBER) AS CLUSTERING_FACTOR,       CAST(STATUS AS VARCHAR2(8)) AS STATUS,       CAST(NULL AS NUMBER) AS NUM_ROWS,       CAST(NULL AS NUMBER) AS SAMPLE_SIZE,       CAST(NULL AS DATE) AS LAST_ANALYZED,       CAST(DOP_DEGREE AS VARCHAR2(40)) AS DEGREE,       CAST(NULL AS VARCHAR2(40)) AS INSTANCES,       CAST(CASE WHEN A_PART_LEVEL = 0 THEN 'NO' ELSE 'YES' END AS VARCHAR2(3)) AS PARTITIONED,       CAST(NULL AS VARCHAR2(1)) AS TEMPORARY,       CAST(NULL AS VARCHAR2(1)) AS "GENERATED",       CAST(NULL AS VARCHAR2(1)) AS SECONDARY,       CAST(NULL AS VARCHAR2(7)) AS BUFFER_POOL,       CAST(NULL AS VARCHAR2(7)) AS FLASH_CACHE,       CAST(NULL AS VARCHAR2(7)) AS CELL_FLASH_CACHE,       CAST(NULL AS VARCHAR2(3)) AS USER_STATS,       CAST(NULL AS VARCHAR2(15)) AS DURATION,       CAST(NULL AS NUMBER) AS PCT_DIRECT_ACCESS,       CAST(NULL AS VARCHAR2(128)) AS ITYP_OWNER,       CAST(INDEX_ITYP_NAME AS VARCHAR2(128)) AS ITYP_NAME,       CAST(NULL AS VARCHAR2(1000)) AS PARAMETERS,       CAST(NULL AS VARCHAR2(3)) AS GLOBAL_STATS,       CAST(NULL AS VARCHAR2(12)) AS DOMIDX_STATUS,       CAST(NULL AS VARCHAR2(6)) AS DOMIDX_OPSTATUS,       CAST(FUNCIDX_STATUS AS VARCHAR2(8)) AS FUNCIDX_STATUS,       CAST('NO' AS VARCHAR2(3)) AS JOIN_INDEX,       CAST(NULL AS VARCHAR2(3)) AS IOT_REDUNDANT_PKEY_ELIM,       CAST(DROPPED AS VARCHAR2(3)) AS DROPPED,       CAST(VISIBILITY AS VARCHAR2(9)) AS VISIBILITY,       CAST(NULL AS VARCHAR2(14)) AS DOMIDX_MANAGEMENT,       CAST(NULL AS VARCHAR2(3)) AS SEGMENT_CREATED,       CAST(NULL AS VARCHAR2(3)) AS ORPHANED_ENTRIES,       CAST(NULL AS VARCHAR2(7)) AS INDEXING,       CAST(NULL AS VARCHAR2(3)) AS AUTO       FROM         (SELECT         A.TENANT_ID,         DATABASE_NAME AS INDEX_OWNER,          CASE WHEN (TABLE_TYPE = 5 AND B.DATABASE_NAME !=  '__recyclebin')              THEN SUBSTR(TABLE_NAME, 7 + INSTR(SUBSTR(TABLE_NAME, 7), '_'))              WHEN (TABLE_TYPE = 5 AND B.DATABASE_NAME =  '__recyclebin')              THEN TABLE_NAME              ELSE (CONS_TAB.CONSTRAINT_NAME) END AS INDEX_NAME,          CASE           WHEN A.TABLE_TYPE = 5 AND A.INDEX_TYPE IN (10, 11, 12, 15, 18, 21) THEN 'DOMAIN'           WHEN A.TABLE_TYPE = 5 AND EXISTS (             SELECT 1             FROM SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT T_COL_INDEX,                  SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT T_COL_BASE             WHERE T_COL_BASE.TABLE_ID = A.DATA_TABLE_ID               AND T_COL_BASE.COLUMN_NAME = T_COL_INDEX.COLUMN_NAME               AND T_COL_INDEX.TABLE_ID = A.TABLE_ID               AND T_COL_BASE.TENANT_ID = A.TENANT_ID               AND T_COL_INDEX.TENANT_ID = A.TENANT_ID               AND BITAND(T_COL_BASE.COLUMN_FLAGS,3) > 0               AND T_COL_INDEX.INDEX_POSITION != 0           ) THEN 'FUNCTION-BASED NORMAL'           ELSE 'NORMAL'         END AS INDEX_TYPE_NAME,          CASE           WHEN  A.TABLE_TYPE = 5 AND A.INDEX_TYPE IN (10, 11, 12) THEN 'SPATIAL_INDEX'           ELSE 'NULL'         END AS INDEX_ITYP_NAME,          DATABASE_NAME AS TABLE_OWNER,          CASE WHEN (TABLE_TYPE IN (3, 15)) THEN A.TABLE_ID              ELSE A.DATA_TABLE_ID END AS TABLE_ID,          A.TABLE_ID AS INDEX_ID,          CASE WHEN TABLE_TYPE = 3 THEN 'UNIQUE'              WHEN A.INDEX_TYPE IN (2, 4, 8, 41) THEN 'UNIQUE'              ELSE 'NONUNIQUE' END AS UNIQUENESS,          CASE WHEN A.COMPRESS_FUNC_NAME = NULL THEN 'DISABLED'              ELSE 'ENABLED' END AS COMPRESSION,          CASE WHEN TABLE_TYPE IN (3, 15) THEN 'VALID'              WHEN A.INDEX_STATUS = 2 THEN 'VALID'              WHEN A.INDEX_STATUS = 3 THEN 'CHECKING'              WHEN A.INDEX_STATUS = 4 THEN 'INELEGIBLE'              WHEN A.INDEX_STATUS = 5 THEN 'ERROR'              ELSE 'UNUSABLE' END AS STATUS,          A.INDEX_TYPE AS A_INDEX_TYPE,         A.PART_LEVEL AS A_PART_LEVEL,         A.TABLE_TYPE AS A_TABLE_TYPE,          CASE WHEN 0 = (SELECT COUNT(1) FROM SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT                        WHERE TABLE_ID = A.TABLE_ID AND IS_HIDDEN = 0                        AND TENANT_ID = EFFECTIVE_TENANT_ID()) THEN 'ENABLED'              ELSE 'NULL' END AS FUNCIDX_STATUS,          CASE WHEN B.IN_RECYCLEBIN = 1 THEN 'YES' ELSE 'NO' END AS DROPPED,          CASE WHEN BITAND(A.INDEX_ATTRIBUTES_SET, 1) = 0 THEN 'VISIBLE'              ELSE 'INVISIBLE' END AS VISIBILITY,          A.TABLESPACE_ID,         A.DOP AS DOP_DEGREE          FROM           SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A           JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT B           ON A.DATABASE_ID = B.DATABASE_ID              AND TABLE_TYPE IN (5, 3, 15)              AND A.INDEX_TYPE NOT IN (13, 14, 16, 17, 19, 20, 22)              AND A.TENANT_ID = EFFECTIVE_TENANT_ID()              AND BITAND((A.TABLE_MODE / 4096), 15) IN (0,1)               AND BITAND(A.INDEX_ATTRIBUTES_SET, 16) = 0              AND B.TENANT_ID = EFFECTIVE_TENANT_ID()              AND B.DATABASE_NAME != '__recyclebin'            LEFT JOIN SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT CONS_TAB           ON (CONS_TAB.TABLE_ID = A.TABLE_ID)              AND CONS_TAB.TENANT_ID = EFFECTIVE_TENANT_ID()         WHERE           NOT(TABLE_TYPE = 3 AND CONSTRAINT_NAME IS NULL)           AND (CONS_TAB.CONSTRAINT_TYPE IS NULL OR CONS_TAB.CONSTRAINT_TYPE = 1)         ) C       JOIN        ((           SELECT               mv_table.table_name AS new_table_name,               container_table.*           FROM               SYS.ALL_VIRTUAL_TABLE_REAL_AGENT mv_table,               (                   SELECT                       *                   FROM                       SYS.ALL_VIRTUAL_TABLE_REAL_AGENT                   WHERE                     bitand(table_mode, POWER(2, 24)) = POWER(2, 24)               ) container_table           WHERE               mv_table.data_table_id = container_table.table_id  							and mv_table.table_type = 7       )              UNION ALL              (           SELECT               table_name as new_table_name,               SYS.ALL_VIRTUAL_TABLE_REAL_AGENT.*           FROM               SYS.ALL_VIRTUAL_TABLE_REAL_AGENT           WHERE               bitand(table_mode, POWER(2, 24)) = 0       )) D         ON C.TABLE_ID = D.TABLE_ID            AND C.TENANT_ID = D.TENANT_ID            AND D.TABLE_TYPE != 12 AND D.TABLE_TYPE != 13            AND BITAND((D.TABLE_MODE / 4096), 15) IN (0,1)             AND BITAND(D.INDEX_ATTRIBUTES_SET, 16) = 0       LEFT JOIN SYS.ALL_VIRTUAL_TENANT_TABLESPACE_REAL_AGENT TP       ON C.TABLESPACE_ID = TP.TABLESPACE_ID          AND TP.TENANT_ID = EFFECTIVE_TENANT_ID() )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::all_indexes_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_ALL_INDEXES_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_ALL_INDEXES_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       CAST(INDEX_OWNER AS VARCHAR2(128)) AS OWNER,       CAST(INDEX_NAME AS VARCHAR2(128)) AS INDEX_NAME,       CAST(INDEX_TYPE_NAME AS VARCHAR2(27)) AS INDEX_TYPE,       CAST(TABLE_OWNER AS VARCHAR2(128)) AS TABLE_OWNER,       CAST(NEW_TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST('TABLE' AS CHAR(5)) AS TABLE_TYPE,       CAST(UNIQUENESS AS VARCHAR2(9)) AS UNIQUENESS,       CAST(COMPRESSION AS VARCHAR2(13)) AS COMPRESSION,       CAST(NULL AS NUMBER) AS PREFIX_LENGTH,       CAST(TABLESPACE_NAME AS VARCHAR2(30)) AS TABLESPACE_NAME,       CAST(NULL AS NUMBER) AS INI_TRANS,       CAST(NULL AS NUMBER) AS MAX_TRANS,       CAST(NULL AS NUMBER) AS INITIAL_EXTENT,       CAST(NULL AS NUMBER) AS NEXT_EXTENT,       CAST(NULL AS NUMBER) AS MIN_EXTENTS,       CAST(NULL AS NUMBER) AS MAX_EXTENTS,       CAST(NULL AS NUMBER) AS PCT_INCREASE,       CAST(NULL AS NUMBER) AS PCT_THRESHOLD,       CAST(NULL AS NUMBER) AS INCLUDE_COLUMN,       CAST(NULL AS NUMBER) AS FREELISTS,       CAST(NULL AS NUMBER) AS FREELIST_GROUPS,       CAST(NULL AS NUMBER) AS PCT_FREE,       CAST(NULL AS VARCHAR2(3)) AS LOGGING,       CAST(NULL AS NUMBER) AS BLEVEL,       CAST(NULL AS NUMBER) AS LEAF_BLOCKS,       CAST(NULL AS NUMBER) AS DISTINCT_KEYS,       CAST(NULL AS NUMBER) AS AVG_LEAF_BLOCKS_PER_KEY,       CAST(NULL AS NUMBER) AS AVG_DATA_BLOCKS_PER_KEY,       CAST(NULL AS NUMBER) AS CLUSTERING_FACTOR,       CAST(STATUS AS VARCHAR2(8)) AS STATUS,       CAST(NULL AS NUMBER) AS NUM_ROWS,       CAST(NULL AS NUMBER) AS SAMPLE_SIZE,       CAST(NULL AS DATE) AS LAST_ANALYZED,       CAST(DOP_DEGREE AS VARCHAR2(40)) AS DEGREE,       CAST(NULL AS VARCHAR2(40)) AS INSTANCES,       CAST(CASE WHEN A_PART_LEVEL = 0 THEN 'NO' ELSE 'YES' END AS VARCHAR2(3)) AS PARTITIONED,       CAST(NULL AS VARCHAR2(1)) AS TEMPORARY,       CAST(NULL AS VARCHAR2(1)) AS "GENERATED",       CAST(NULL AS VARCHAR2(1)) AS SECONDARY,       CAST(NULL AS VARCHAR2(7)) AS BUFFER_POOL,       CAST(NULL AS VARCHAR2(7)) AS FLASH_CACHE,       CAST(NULL AS VARCHAR2(7)) AS CELL_FLASH_CACHE,       CAST(NULL AS VARCHAR2(3)) AS USER_STATS,       CAST(NULL AS VARCHAR2(15)) AS DURATION,       CAST(NULL AS NUMBER) AS PCT_DIRECT_ACCESS,       CAST(NULL AS VARCHAR2(128)) AS ITYP_OWNER,       CAST(INDEX_ITYP_NAME AS VARCHAR2(128)) AS ITYP_NAME,       CAST(NULL AS VARCHAR2(1000)) AS PARAMETERS,       CAST(NULL AS VARCHAR2(3)) AS GLOBAL_STATS,       CAST(NULL AS VARCHAR2(12)) AS DOMIDX_STATUS,       CAST(NULL AS VARCHAR2(6)) AS DOMIDX_OPSTATUS,       CAST(FUNCIDX_STATUS AS VARCHAR2(8)) AS FUNCIDX_STATUS,       CAST('NO' AS VARCHAR2(3)) AS JOIN_INDEX,       CAST(NULL AS VARCHAR2(3)) AS IOT_REDUNDANT_PKEY_ELIM,       CAST(DROPPED AS VARCHAR2(3)) AS DROPPED,       CAST(VISIBILITY AS VARCHAR2(9)) AS VISIBILITY,       CAST(NULL AS VARCHAR2(14)) AS DOMIDX_MANAGEMENT,       CAST(NULL AS VARCHAR2(3)) AS SEGMENT_CREATED,       CAST(NULL AS VARCHAR2(3)) AS ORPHANED_ENTRIES,       CAST(NULL AS VARCHAR2(7)) AS INDEXING,       CAST(NULL AS VARCHAR2(3)) AS AUTO       FROM         (SELECT         A.TENANT_ID,         DATABASE_NAME AS INDEX_OWNER,          CASE WHEN (TABLE_TYPE = 5 AND B.DATABASE_NAME !=  '__recyclebin')              THEN SUBSTR(TABLE_NAME, 7 + INSTR(SUBSTR(TABLE_NAME, 7), '_'))              WHEN (TABLE_TYPE = 5 AND B.DATABASE_NAME =  '__recyclebin')              THEN TABLE_NAME              ELSE (CONS_TAB.CONSTRAINT_NAME) END AS INDEX_NAME,          CASE           WHEN A.TABLE_TYPE = 5 AND A.INDEX_TYPE IN (10, 11, 12, 15, 18, 21) THEN 'DOMAIN'           WHEN A.TABLE_TYPE = 5 AND EXISTS (             SELECT 1             FROM SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT T_COL_INDEX,                  SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT T_COL_BASE             WHERE T_COL_BASE.TABLE_ID = A.DATA_TABLE_ID               AND T_COL_BASE.COLUMN_NAME = T_COL_INDEX.COLUMN_NAME               AND T_COL_INDEX.TABLE_ID = A.TABLE_ID               AND T_COL_BASE.TENANT_ID = A.TENANT_ID               AND T_COL_INDEX.TENANT_ID = A.TENANT_ID               AND BITAND(T_COL_BASE.COLUMN_FLAGS,3) > 0               AND T_COL_INDEX.INDEX_POSITION != 0           ) THEN 'FUNCTION-BASED NORMAL'           ELSE 'NORMAL'         END AS INDEX_TYPE_NAME,          CASE           WHEN  A.TABLE_TYPE = 5 AND A.INDEX_TYPE IN (10, 11, 12) THEN 'SPATIAL_INDEX'           ELSE 'NULL'         END AS INDEX_ITYP_NAME,          DATABASE_NAME AS TABLE_OWNER,          CASE WHEN (TABLE_TYPE IN (3, 15)) THEN A.TABLE_ID              ELSE A.DATA_TABLE_ID END AS TABLE_ID,          A.TABLE_ID AS INDEX_ID,          CASE WHEN TABLE_TYPE IN (3, 15) THEN 'UNIQUE'              WHEN A.INDEX_TYPE IN (2, 4, 8, 41) THEN 'UNIQUE'              ELSE 'NONUNIQUE' END AS UNIQUENESS,          CASE WHEN A.COMPRESS_FUNC_NAME = NULL THEN 'DISABLED'              ELSE 'ENABLED' END AS COMPRESSION,          CASE WHEN TABLE_TYPE IN (3, 15) THEN 'VALID'              WHEN A.INDEX_STATUS = 2 THEN 'VALID'              WHEN A.INDEX_STATUS = 3 THEN 'CHECKING'              WHEN A.INDEX_STATUS = 4 THEN 'INELEGIBLE'              WHEN A.INDEX_STATUS = 5 THEN 'ERROR'              ELSE 'UNUSABLE' END AS STATUS,          A.INDEX_TYPE AS A_INDEX_TYPE,         A.PART_LEVEL AS A_PART_LEVEL,         A.TABLE_TYPE AS A_TABLE_TYPE,          CASE WHEN 0 = (SELECT COUNT(1) FROM SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT                        WHERE TABLE_ID = A.TABLE_ID AND IS_HIDDEN = 0                        AND TENANT_ID = EFFECTIVE_TENANT_ID()) THEN 'ENABLED'              ELSE 'NULL' END AS FUNCIDX_STATUS,          CASE WHEN B.IN_RECYCLEBIN = 1 THEN 'YES' ELSE 'NO' END AS DROPPED,          CASE WHEN BITAND(A.INDEX_ATTRIBUTES_SET, 1) = 0 THEN 'VISIBLE'              ELSE 'INVISIBLE' END AS VISIBILITY,          A.TABLESPACE_ID,         A.DOP AS DOP_DEGREE          FROM           SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A           JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT B           ON A.DATABASE_ID = B.DATABASE_ID              AND TABLE_TYPE IN (5, 3, 15)              AND A.INDEX_TYPE NOT IN (13, 14, 16, 17, 19, 20, 22)              AND A.TENANT_ID = EFFECTIVE_TENANT_ID()              AND BITAND((A.TABLE_MODE / 4096), 15) IN (0,1)               AND BITAND(A.INDEX_ATTRIBUTES_SET, 16) = 0              AND B.TENANT_ID = EFFECTIVE_TENANT_ID()              AND B.DATABASE_NAME != '__recyclebin'              AND (A.DATABASE_ID = USERENV('SCHEMAID')                   OR USER_CAN_ACCESS_OBJ(1, DECODE(TABLE_TYPE,                                                    3, A.TABLE_ID,                                                    5, DATA_TABLE_ID), A.DATABASE_ID) = 1)            LEFT JOIN SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT CONS_TAB           ON (CONS_TAB.TABLE_ID = A.TABLE_ID)              AND CONS_TAB.TENANT_ID = EFFECTIVE_TENANT_ID()         WHERE           NOT(TABLE_TYPE = 3 AND CONSTRAINT_NAME IS NULL)           AND (CONS_TAB.CONSTRAINT_TYPE IS NULL OR CONS_TAB.CONSTRAINT_TYPE = 1)         ) C       JOIN        ((           SELECT               mv_table.table_name AS new_table_name,               container_table.*           FROM               SYS.ALL_VIRTUAL_TABLE_REAL_AGENT mv_table,               (                   SELECT                       *                   FROM                       SYS.ALL_VIRTUAL_TABLE_REAL_AGENT                   WHERE                     bitand(table_mode, POWER(2, 24)) = POWER(2, 24)               ) container_table           WHERE               mv_table.data_table_id = container_table.table_id  							and mv_table.table_type = 7       )              UNION ALL              (           SELECT               table_name as new_table_name,               SYS.ALL_VIRTUAL_TABLE_REAL_AGENT.*           FROM               SYS.ALL_VIRTUAL_TABLE_REAL_AGENT           WHERE               bitand(table_mode, POWER(2, 24)) = 0       )) D         ON C.TABLE_ID = D.TABLE_ID            AND C.TENANT_ID = D.TENANT_ID            AND D.TABLE_TYPE != 12 AND D.TABLE_TYPE != 13            AND BITAND((D.TABLE_MODE / 4096), 15) IN (0,1)             AND BITAND(D.INDEX_ATTRIBUTES_SET, 16) = 0       LEFT JOIN SYS.ALL_VIRTUAL_TENANT_TABLESPACE_REAL_AGENT TP       ON C.TABLESPACE_ID = TP.TABLESPACE_ID          AND TP.TENANT_ID = EFFECTIVE_TENANT_ID() )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::user_indexes_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_USER_INDEXES_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_USER_INDEXES_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       CAST(INDEX_NAME AS VARCHAR2(128)) AS INDEX_NAME,       CAST(INDEX_TYPE_NAME AS VARCHAR2(27)) AS INDEX_TYPE,       CAST(TABLE_OWNER AS VARCHAR2(128)) AS TABLE_OWNER,       CAST(NEW_TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST('TABLE' AS CHAR(5)) AS TABLE_TYPE,       CAST(UNIQUENESS AS VARCHAR2(9)) AS UNIQUENESS,       CAST(COMPRESSION AS VARCHAR2(13)) AS COMPRESSION,       CAST(NULL AS NUMBER) AS PREFIX_LENGTH,       CAST(TABLESPACE_NAME AS VARCHAR2(30)) AS TABLESPACE_NAME,       CAST(NULL AS NUMBER) AS INI_TRANS,       CAST(NULL AS NUMBER) AS MAX_TRANS,       CAST(NULL AS NUMBER) AS INITIAL_EXTENT,       CAST(NULL AS NUMBER) AS NEXT_EXTENT,       CAST(NULL AS NUMBER) AS MIN_EXTENTS,       CAST(NULL AS NUMBER) AS MAX_EXTENTS,       CAST(NULL AS NUMBER) AS PCT_INCREASE,       CAST(NULL AS NUMBER) AS PCT_THRESHOLD,       CAST(NULL AS NUMBER) AS INCLUDE_COLUMN,       CAST(NULL AS NUMBER) AS FREELISTS,       CAST(NULL AS NUMBER) AS FREELIST_GROUPS,       CAST(NULL AS NUMBER) AS PCT_FREE,       CAST(NULL AS VARCHAR2(3)) AS LOGGING,       CAST(NULL AS NUMBER) AS BLEVEL,       CAST(NULL AS NUMBER) AS LEAF_BLOCKS,       CAST(NULL AS NUMBER) AS DISTINCT_KEYS,       CAST(NULL AS NUMBER) AS AVG_LEAF_BLOCKS_PER_KEY,       CAST(NULL AS NUMBER) AS AVG_DATA_BLOCKS_PER_KEY,       CAST(NULL AS NUMBER) AS CLUSTERING_FACTOR,       CAST(STATUS AS VARCHAR2(8)) AS STATUS,       CAST(NULL AS NUMBER) AS NUM_ROWS,       CAST(NULL AS NUMBER) AS SAMPLE_SIZE,       CAST(NULL AS DATE) AS LAST_ANALYZED,       CAST(DOP_DEGREE AS VARCHAR2(40)) AS DEGREE,       CAST(NULL AS VARCHAR2(40)) AS INSTANCES,       CAST(CASE WHEN A_PART_LEVEL = 0 THEN 'NO' ELSE 'YES' END AS VARCHAR2(3)) AS PARTITIONED,       CAST(NULL AS VARCHAR2(1)) AS TEMPORARY,       CAST(NULL AS VARCHAR2(1)) AS "GENERATED",       CAST(NULL AS VARCHAR2(1)) AS SECONDARY,       CAST(NULL AS VARCHAR2(7)) AS BUFFER_POOL,       CAST(NULL AS VARCHAR2(7)) AS FLASH_CACHE,       CAST(NULL AS VARCHAR2(7)) AS CELL_FLASH_CACHE,       CAST(NULL AS VARCHAR2(3)) AS USER_STATS,       CAST(NULL AS VARCHAR2(15)) AS DURATION,       CAST(NULL AS NUMBER) AS PCT_DIRECT_ACCESS,       CAST(NULL AS VARCHAR2(128)) AS ITYP_OWNER,       CAST(INDEX_ITYP_NAME AS VARCHAR2(128)) AS ITYP_NAME,       CAST(NULL AS VARCHAR2(1000)) AS PARAMETERS,       CAST(NULL AS VARCHAR2(3)) AS GLOBAL_STATS,       CAST(NULL AS VARCHAR2(12)) AS DOMIDX_STATUS,       CAST(NULL AS VARCHAR2(6)) AS DOMIDX_OPSTATUS,       CAST(FUNCIDX_STATUS AS VARCHAR2(8)) AS FUNCIDX_STATUS,       CAST('NO' AS VARCHAR2(3)) AS JOIN_INDEX,       CAST(NULL AS VARCHAR2(3)) AS IOT_REDUNDANT_PKEY_ELIM,       CAST(DROPPED AS VARCHAR2(3)) AS DROPPED,       CAST(VISIBILITY AS VARCHAR2(9)) AS VISIBILITY,       CAST(NULL AS VARCHAR2(14)) AS DOMIDX_MANAGEMENT,       CAST(NULL AS VARCHAR2(3)) AS SEGMENT_CREATED,       CAST(NULL AS VARCHAR2(3)) AS ORPHANED_ENTRIES,       CAST(NULL AS VARCHAR2(7)) AS INDEXING,       CAST(NULL AS VARCHAR2(3)) AS AUTO       FROM         (SELECT         A.TENANT_ID,         DATABASE_NAME AS INDEX_OWNER,          CASE WHEN (TABLE_TYPE = 5 AND B.DATABASE_NAME !=  '__recyclebin')              THEN SUBSTR(TABLE_NAME, 7 + INSTR(SUBSTR(TABLE_NAME, 7), '_'))              WHEN (TABLE_TYPE = 5 AND B.DATABASE_NAME =  '__recyclebin')              THEN TABLE_NAME              ELSE (CONS_TAB.CONSTRAINT_NAME) END AS INDEX_NAME,          CASE           WHEN A.TABLE_TYPE = 5 AND A.INDEX_TYPE IN (10, 11, 12, 15, 18, 21) THEN 'DOMAIN'           WHEN A.TABLE_TYPE = 5 AND EXISTS (             SELECT 1             FROM SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT T_COL_INDEX,                  SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT T_COL_BASE             WHERE T_COL_BASE.TABLE_ID = A.DATA_TABLE_ID               AND T_COL_BASE.COLUMN_NAME = T_COL_INDEX.COLUMN_NAME               AND T_COL_INDEX.TABLE_ID = A.TABLE_ID               AND T_COL_BASE.TENANT_ID = A.TENANT_ID               AND T_COL_INDEX.TENANT_ID = A.TENANT_ID               AND BITAND(T_COL_BASE.COLUMN_FLAGS,3) > 0               AND T_COL_INDEX.INDEX_POSITION != 0           ) THEN 'FUNCTION-BASED NORMAL'           ELSE 'NORMAL'         END AS INDEX_TYPE_NAME,          CASE           WHEN  A.TABLE_TYPE = 5 AND A.INDEX_TYPE IN (10, 11, 12) THEN 'SPATIAL_INDEX'           ELSE 'NULL'         END AS INDEX_ITYP_NAME,                  DATABASE_NAME AS TABLE_OWNER,          CASE WHEN (TABLE_TYPE IN (3, 15)) THEN A.TABLE_ID              ELSE A.DATA_TABLE_ID END AS TABLE_ID,          A.TABLE_ID AS INDEX_ID,          CASE WHEN TABLE_TYPE IN (3, 15) THEN 'UNIQUE'              WHEN A.INDEX_TYPE IN (2, 4, 8, 41) THEN 'UNIQUE'              ELSE 'NONUNIQUE' END AS UNIQUENESS,          CASE WHEN A.COMPRESS_FUNC_NAME = NULL THEN 'DISABLED'              ELSE 'ENABLED' END AS COMPRESSION,          CASE WHEN TABLE_TYPE IN (3, 15) THEN 'VALID'              WHEN A.INDEX_STATUS = 2 THEN 'VALID'              WHEN A.INDEX_STATUS = 3 THEN 'CHECKING'              WHEN A.INDEX_STATUS = 4 THEN 'INELEGIBLE'              WHEN A.INDEX_STATUS = 5 THEN 'ERROR'              ELSE 'UNUSABLE' END AS STATUS,          A.INDEX_TYPE AS A_INDEX_TYPE,         A.PART_LEVEL AS A_PART_LEVEL,         A.TABLE_TYPE AS A_TABLE_TYPE,          CASE WHEN 0 = (SELECT COUNT(1) FROM SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT                        WHERE TABLE_ID = A.TABLE_ID AND IS_HIDDEN = 0                        AND TENANT_ID = EFFECTIVE_TENANT_ID()) THEN 'ENABLED'              ELSE 'NULL' END AS FUNCIDX_STATUS,          CASE WHEN B.IN_RECYCLEBIN = 1 THEN 'YES' ELSE 'NO' END AS DROPPED,          CASE WHEN BITAND(A.INDEX_ATTRIBUTES_SET, 1) = 0 THEN 'VISIBLE'              ELSE 'INVISIBLE' END AS VISIBILITY,          A.TABLESPACE_ID,         A.DOP AS DOP_DEGREE          FROM           SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A           JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT B           ON A.DATABASE_ID = B.DATABASE_ID              AND TABLE_TYPE IN (5, 3, 15)              AND A.INDEX_TYPE NOT IN (13, 14, 16, 17, 19, 20, 22)              AND A.TENANT_ID = EFFECTIVE_TENANT_ID()              AND BITAND((A.TABLE_MODE / 4096), 15) IN (0,1)               AND BITAND(A.INDEX_ATTRIBUTES_SET, 16) = 0              AND B.TENANT_ID = EFFECTIVE_TENANT_ID()              AND A.DATABASE_ID = USERENV('SCHEMAID')              AND B.DATABASE_NAME != '__recyclebin'            LEFT JOIN SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT CONS_TAB           ON (CONS_TAB.TABLE_ID = A.TABLE_ID)              AND CONS_TAB.TENANT_ID = EFFECTIVE_TENANT_ID()         WHERE           NOT(TABLE_TYPE = 3 AND CONSTRAINT_NAME IS NULL)           AND (CONS_TAB.CONSTRAINT_TYPE IS NULL OR CONS_TAB.CONSTRAINT_TYPE = 1)         ) C       JOIN        ((           SELECT               mv_table.table_name AS new_table_name,               container_table.*           FROM               SYS.ALL_VIRTUAL_TABLE_REAL_AGENT mv_table,               (                   SELECT                       *                   FROM                       SYS.ALL_VIRTUAL_TABLE_REAL_AGENT                   WHERE                     bitand(table_mode, POWER(2, 24)) = POWER(2, 24)               ) container_table           WHERE               mv_table.data_table_id = container_table.table_id  							and mv_table.table_type = 7       )              UNION ALL              (           SELECT               table_name as new_table_name,               SYS.ALL_VIRTUAL_TABLE_REAL_AGENT.*           FROM               SYS.ALL_VIRTUAL_TABLE_REAL_AGENT           WHERE               bitand(table_mode, POWER(2, 24)) = 0       )) D         ON C.TABLE_ID = D.TABLE_ID            AND C.TENANT_ID = D.TENANT_ID            AND D.TABLE_TYPE != 12 AND D.TABLE_TYPE != 13            AND BITAND((D.TABLE_MODE / 4096), 15) IN (0,1)             AND BITAND(D.INDEX_ATTRIBUTES_SET, 16) = 0       LEFT JOIN SYS.ALL_VIRTUAL_TENANT_TABLESPACE_REAL_AGENT TP       ON C.TABLESPACE_ID = TP.TABLESPACE_ID          AND TP.TENANT_ID = EFFECTIVE_TENANT_ID() )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::dba_cons_columns_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_DBA_CONS_COLUMNS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_DBA_CONS_COLUMNS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,       CAST(SUBSTR(A.TABLE_NAME, 7 + INSTR(SUBSTR(A.TABLE_NAME, 7), '_')) AS VARCHAR2(128)) AS CONSTRAINT_NAME,       CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST(D.COLUMN_NAME AS VARCHAR2(4000)) AS COLUMN_NAME,       CAST(D.INDEX_POSITION AS NUMBER) AS POSITION       FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT D       WHERE A.DATA_TABLE_ID = B.TABLE_ID AND A.DATABASE_ID = C.DATABASE_ID AND D.TABLE_ID = A.TABLE_ID AND A.INDEX_TYPE IN (2, 4, 8, 41) AND C.DATABASE_NAME != '__recyclebin' AND D.IS_HIDDEN = 0 AND D.INDEX_POSITION != 0         AND A.TENANT_ID = EFFECTIVE_TENANT_ID() AND A.TABLE_TYPE != 12 AND A.TABLE_TYPE != 13         AND bitand((A.TABLE_MODE / 4096), 15) IN (0,1)         AND bitand(A.INDEX_ATTRIBUTES_SET, 16) = 0         AND B.TENANT_ID = EFFECTIVE_TENANT_ID() AND A.TABLE_TYPE != 12 AND A.TABLE_TYPE != 13         AND C.TENANT_ID = EFFECTIVE_TENANT_ID()         AND D.TENANT_ID = EFFECTIVE_TENANT_ID()     UNION ALL     SELECT       CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,       CAST(A.FOREIGN_KEY_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,       CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST(E.COLUMN_NAME AS VARCHAR2(4000)) AS COLUMN_NAME,       CAST(D.POSITION AS NUMBER) AS POSITION       FROM SYS.ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_FOREIGN_KEY_COLUMN_REAL_AGENT D, SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT E       WHERE A.CHILD_TABLE_ID = B.TABLE_ID AND B.DATABASE_ID = C.DATABASE_ID AND A.FOREIGN_KEY_ID = D.FOREIGN_KEY_ID AND D.CHILD_COLUMN_ID = E.COLUMN_ID AND B.TABLE_ID = E.TABLE_ID         AND A.TENANT_ID = EFFECTIVE_TENANT_ID()         AND B.TENANT_ID = EFFECTIVE_TENANT_ID() AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13         AND C.TENANT_ID = EFFECTIVE_TENANT_ID()         AND D.TENANT_ID = EFFECTIVE_TENANT_ID()         AND E.TENANT_ID = EFFECTIVE_TENANT_ID()         AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)          AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0     UNION ALL     SELECT       CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,       CAST(D.CONSTRAINT_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,       CAST(A.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST(B.COLUMN_NAME AS VARCHAR2(4000)) AS COLUMN_NAME,       CAST(B.ROWKEY_POSITION AS NUMBER) AS POSITION       FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A, SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT D       WHERE A.TABLE_ID = D.TABLE_ID AND D.CONSTRAINT_TYPE = 1 AND A.TABLE_ID = B.TABLE_ID AND A.DATABASE_ID = C.DATABASE_ID AND B.ROWKEY_POSITION > 0 AND C.DATABASE_NAME != '__recyclebin' AND B.IS_HIDDEN = 0         AND A.TENANT_ID = EFFECTIVE_TENANT_ID() AND A.TABLE_TYPE != 12 AND A.TABLE_TYPE != 13         AND B.TENANT_ID = EFFECTIVE_TENANT_ID()         AND C.TENANT_ID = EFFECTIVE_TENANT_ID()         AND D.TENANT_ID = EFFECTIVE_TENANT_ID()         AND BITAND((A.TABLE_MODE / 4096), 15) IN (0,1)          AND BITAND(A.INDEX_ATTRIBUTES_SET, 16) = 0     UNION ALL     SELECT       CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,       CAST(D.CONSTRAINT_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,       CAST(A.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST(B.COLUMN_NAME AS VARCHAR2(4000)) AS COLUMN_NAME,       CAST(NULL AS NUMBER) AS POSITION       FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A, SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT D, SYS.ALL_VIRTUAL_TENANT_CONSTRAINT_COLUMN_REAL_AGENT E       WHERE A.TABLE_ID = E.TABLE_ID AND B.TABLE_ID = E.TABLE_ID AND B.COLUMN_ID = E.COLUMN_ID AND A.DATABASE_ID = C.DATABASE_ID AND D.TABLE_ID = E.TABLE_ID AND D.CONSTRAINT_ID = E.CONSTRAINT_ID AND C.DATABASE_NAME != '__recyclebin'         AND A.TENANT_ID = EFFECTIVE_TENANT_ID() AND A.TABLE_TYPE != 12 AND A.TABLE_TYPE != 13         AND B.TENANT_ID = EFFECTIVE_TENANT_ID()         AND C.TENANT_ID = EFFECTIVE_TENANT_ID()         AND D.TENANT_ID = EFFECTIVE_TENANT_ID()         AND E.TENANT_ID = EFFECTIVE_TENANT_ID()         AND BITAND((A.TABLE_MODE / 4096), 15) IN (0,1)          AND BITAND(A.INDEX_ATTRIBUTES_SET, 16) = 0 )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::all_cons_columns_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_ALL_CONS_COLUMNS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_ALL_CONS_COLUMNS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,       CAST(SUBSTR(A.TABLE_NAME, 7 + INSTR(SUBSTR(A.TABLE_NAME, 7), '_')) AS VARCHAR2(128)) AS CONSTRAINT_NAME,       CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST(D.COLUMN_NAME AS VARCHAR2(4000)) AS COLUMN_NAME,       CAST(D.INDEX_POSITION AS NUMBER) AS POSITION       FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT D       WHERE A.DATA_TABLE_ID = B.TABLE_ID         AND bitand((A.TABLE_MODE / 4096), 15) IN (0,1)         AND bitand(A.INDEX_ATTRIBUTES_SET, 16) = 0         AND A.DATABASE_ID = C.DATABASE_ID         AND (A.DATABASE_ID = USERENV('SCHEMAID')             OR USER_CAN_ACCESS_OBJ(1, A.DATA_TABLE_ID, A.DATABASE_ID) = 1)         AND D.TABLE_ID = A.TABLE_ID         AND A.INDEX_TYPE IN (2, 4, 8, 41)         AND C.DATABASE_NAME != '__recyclebin'         AND D.IS_HIDDEN = 0         AND D.INDEX_POSITION != 0         AND A.TABLE_TYPE != 12 AND A.TABLE_TYPE != 13 AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13     UNION ALL     SELECT       CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,       CAST(A.FOREIGN_KEY_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,       CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST(E.COLUMN_NAME AS VARCHAR2(4000)) AS COLUMN_NAME,       CAST(D.POSITION AS NUMBER) AS POSITION       FROM SYS.ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_FOREIGN_KEY_COLUMN_REAL_AGENT D, SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT E       WHERE A.CHILD_TABLE_ID = B.TABLE_ID         AND B.DATABASE_ID = C.DATABASE_ID         AND (B.DATABASE_ID = USERENV('SCHEMAID')             OR USER_CAN_ACCESS_OBJ(1, A.CHILD_TABLE_ID, B.DATABASE_ID) = 1)         AND A.FOREIGN_KEY_ID = D.FOREIGN_KEY_ID         AND D.CHILD_COLUMN_ID = E.COLUMN_ID         AND B.TABLE_ID = E.TABLE_ID         AND A.TENANT_ID = EFFECTIVE_TENANT_ID()         AND B.TENANT_ID = EFFECTIVE_TENANT_ID()         AND C.TENANT_ID = EFFECTIVE_TENANT_ID()         AND D.TENANT_ID = EFFECTIVE_TENANT_ID()         AND E.TENANT_ID = EFFECTIVE_TENANT_ID()         AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13         AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)          AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0     UNION ALL     SELECT       CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,       CAST(D.CONSTRAINT_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,       CAST(A.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST(B.COLUMN_NAME AS VARCHAR2(4000)) AS COLUMN_NAME,       CAST(B.ROWKEY_POSITION AS NUMBER) AS POSITION       FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A, SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT D       WHERE A.TABLE_ID = D.TABLE_ID         AND D.CONSTRAINT_TYPE = 1         AND A.TABLE_ID = B.TABLE_ID         AND A.DATABASE_ID = C.DATABASE_ID         AND (A.DATABASE_ID = USERENV('SCHEMAID')             OR USER_CAN_ACCESS_OBJ(1, A.TABLE_ID, A.DATABASE_ID) = 1)         AND B.ROWKEY_POSITION > 0         AND C.DATABASE_NAME != '__recyclebin' AND B.IS_HIDDEN = 0         AND A.TENANT_ID = EFFECTIVE_TENANT_ID()         AND B.TENANT_ID = EFFECTIVE_TENANT_ID()         AND C.TENANT_ID = EFFECTIVE_TENANT_ID()         AND D.TENANT_ID = EFFECTIVE_TENANT_ID()         AND A.TABLE_TYPE != 12 AND A.TABLE_TYPE != 13         AND BITAND((A.TABLE_MODE / 4096), 15) IN (0,1)          AND BITAND(A.INDEX_ATTRIBUTES_SET, 16) = 0     UNION ALL     SELECT       CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,       CAST(D.CONSTRAINT_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,       CAST(A.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST(B.COLUMN_NAME AS VARCHAR2(4000)) AS COLUMN_NAME,       CAST(NULL AS NUMBER) AS POSITION       FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A, SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT D, SYS.ALL_VIRTUAL_TENANT_CONSTRAINT_COLUMN_REAL_AGENT E       WHERE A.TABLE_ID = E.TABLE_ID AND B.TABLE_ID = E.TABLE_ID AND B.COLUMN_ID = E.COLUMN_ID AND A.DATABASE_ID = C.DATABASE_ID AND D.TABLE_ID = E.TABLE_ID AND D.CONSTRAINT_ID = E.CONSTRAINT_ID AND C.DATABASE_NAME != '__recyclebin'         AND (A.DATABASE_ID = USERENV('SCHEMAID')             OR USER_CAN_ACCESS_OBJ(1, A.TABLE_ID, A.DATABASE_ID) = 1)         AND A.TENANT_ID = EFFECTIVE_TENANT_ID() AND A.TABLE_TYPE != 12 AND A.TABLE_TYPE != 13         AND B.TENANT_ID = EFFECTIVE_TENANT_ID()         AND C.TENANT_ID = EFFECTIVE_TENANT_ID()         AND D.TENANT_ID = EFFECTIVE_TENANT_ID()         AND E.TENANT_ID = EFFECTIVE_TENANT_ID()         AND BITAND((A.TABLE_MODE / 4096), 15) IN (0,1)          AND BITAND(A.INDEX_ATTRIBUTES_SET, 16) = 0 )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::user_cons_columns_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_USER_CONS_COLUMNS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_USER_CONS_COLUMNS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,       CAST(SUBSTR(A.TABLE_NAME, 7 + INSTR(SUBSTR(A.TABLE_NAME, 7), '_')) AS VARCHAR2(128)) AS CONSTRAINT_NAME,       CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST(D.COLUMN_NAME AS VARCHAR2(4000)) AS COLUMN_NAME,       CAST(D.INDEX_POSITION AS NUMBER) AS POSITION       FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT D       WHERE A.DATA_TABLE_ID = B.TABLE_ID AND A.DATABASE_ID = C.DATABASE_ID AND D.TABLE_ID = A.TABLE_ID AND A.INDEX_TYPE IN (2, 4, 8, 41) AND C.DATABASE_NAME != '__recyclebin' AND D.IS_HIDDEN = 0 AND C.DATABASE_NAME = SYS_CONTEXT('USERENV','CURRENT_USER') AND D.INDEX_POSITION != 0         AND bitand((A.TABLE_MODE / 4096), 15) IN (0,1)         AND BITAND(A.INDEX_ATTRIBUTES_SET, 16) = 0         AND A.TENANT_ID = EFFECTIVE_TENANT_ID() AND A.TABLE_TYPE != 12 AND A.TABLE_TYPE != 13         AND B.TENANT_ID = EFFECTIVE_TENANT_ID() AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13         AND C.TENANT_ID = EFFECTIVE_TENANT_ID()         AND D.TENANT_ID = EFFECTIVE_TENANT_ID()     UNION ALL     SELECT       CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,       CAST(A.FOREIGN_KEY_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,       CAST(B.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST(E.COLUMN_NAME AS VARCHAR2(4000)) AS COLUMN_NAME,       CAST(D.POSITION AS NUMBER) AS POSITION       FROM SYS.ALL_VIRTUAL_FOREIGN_KEY_REAL_AGENT A, SYS.ALL_VIRTUAL_TABLE_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_FOREIGN_KEY_COLUMN_REAL_AGENT D, SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT E       WHERE A.CHILD_TABLE_ID = B.TABLE_ID AND B.DATABASE_ID = C.DATABASE_ID AND A.FOREIGN_KEY_ID = D.FOREIGN_KEY_ID AND D.CHILD_COLUMN_ID = E.COLUMN_ID AND B.TABLE_ID = E.TABLE_ID AND C.DATABASE_NAME = SYS_CONTEXT('USERENV','CURRENT_USER')         AND A.TENANT_ID = EFFECTIVE_TENANT_ID()         AND B.TENANT_ID = EFFECTIVE_TENANT_ID() AND B.TABLE_TYPE != 12 AND B.TABLE_TYPE != 13         AND C.TENANT_ID = EFFECTIVE_TENANT_ID()         AND D.TENANT_ID = EFFECTIVE_TENANT_ID()         AND E.TENANT_ID = EFFECTIVE_TENANT_ID()         AND BITAND((B.TABLE_MODE / 4096), 15) IN (0,1)          AND BITAND(B.INDEX_ATTRIBUTES_SET, 16) = 0     UNION ALL     SELECT       CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,       CAST(D.CONSTRAINT_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,       CAST(A.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,       CAST(B.COLUMN_NAME AS VARCHAR2(4000)) AS COLUMN_NAME,       CAST(B.ROWKEY_POSITION AS NUMBER) AS POSITION       FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A, SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT D       WHERE A.TABLE_ID = D.TABLE_ID AND D.CONSTRAINT_TYPE = 1 AND A.TABLE_ID = B.TABLE_ID AND A.DATABASE_ID = C.DATABASE_ID AND B.ROWKEY_POSITION > 0 AND C.DATABASE_NAME != '__recyclebin' AND B.IS_HIDDEN = 0 AND C.DATABASE_NAME = SYS_CONTEXT('USERENV','CURRENT_USER')         AND A.TENANT_ID = EFFECTIVE_TENANT_ID() AND A.TABLE_TYPE != 12 AND A.TABLE_TYPE != 13         AND B.TENANT_ID = EFFECTIVE_TENANT_ID()         AND C.TENANT_ID = EFFECTIVE_TENANT_ID()         AND D.TENANT_ID = EFFECTIVE_TENANT_ID()         AND BITAND((A.TABLE_MODE / 4096), 15) IN (0,1)          AND BITAND(A.INDEX_ATTRIBUTES_SET, 16) = 0       UNION ALL       SELECT         CAST(C.DATABASE_NAME AS VARCHAR2(128)) AS OWNER,         CAST(D.CONSTRAINT_NAME AS VARCHAR2(128)) AS CONSTRAINT_NAME,         CAST(A.TABLE_NAME AS VARCHAR2(128)) AS TABLE_NAME,         CAST(B.COLUMN_NAME AS VARCHAR2(4000)) AS COLUMN_NAME,         CAST(NULL AS NUMBER) AS POSITION         FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT A, SYS.ALL_VIRTUAL_COLUMN_REAL_AGENT B, SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT C, SYS.ALL_VIRTUAL_CONSTRAINT_REAL_AGENT D, SYS.ALL_VIRTUAL_TENANT_CONSTRAINT_COLUMN_REAL_AGENT E         WHERE A.TABLE_ID = E.TABLE_ID AND B.TABLE_ID = E.TABLE_ID AND B.COLUMN_ID = E.COLUMN_ID AND A.DATABASE_ID = C.DATABASE_ID AND D.TABLE_ID = E.TABLE_ID AND D.CONSTRAINT_ID = E.CONSTRAINT_ID AND C.DATABASE_NAME != '__recyclebin' AND C.DATABASE_NAME = SYS_CONTEXT('USERENV','CURRENT_USER')         AND A.TENANT_ID = EFFECTIVE_TENANT_ID() AND A.TABLE_TYPE != 12 AND A.TABLE_TYPE != 13         AND B.TENANT_ID = EFFECTIVE_TENANT_ID()         AND C.TENANT_ID = EFFECTIVE_TENANT_ID()         AND D.TENANT_ID = EFFECTIVE_TENANT_ID()         AND E.TENANT_ID = EFFECTIVE_TENANT_ID()         AND BITAND((A.TABLE_MODE / 4096), 15) IN (0,1)          AND BITAND(A.INDEX_ATTRIBUTES_SET, 16) = 0 )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::user_segments_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_USER_SEGMENTS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_USER_SEGMENTS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       CAST(CASE WHEN A.TABLE_TYPE = 5 AND A.DATABASE_ID != 201004                 THEN SUBSTR(A.SEGMENT_NAME, 7 + INSTR(SUBSTR(A.SEGMENT_NAME, 7), '_'))                 ELSE A.SEGMENT_NAME END AS VARCHAR2(128)) AS SEGMENT_NAME       ,CAST(A.PARTITION_NAME AS VARCHAR2(128)) AS PARTITION_NAME       ,CAST(A.SEGMENT_TYPE AS VARCHAR2(18)) AS SEGMENT_TYPE       ,CAST(NULL AS VARCHAR2(10)) AS SEGMENT_SUBTYPE       ,CAST(NULL AS VARCHAR2(30)) AS TABLESPACE_NAME       ,CAST(NULL AS NUMBER) AS HEADER_FILE       ,CAST(NULL AS NUMBER) AS HEADER_BLOCK       ,CAST(A.DATA_SIZE AS NUMBER) AS BYTES       ,CAST(A.BLOCK_SIZE AS NUMBER) AS BLOCKS       ,CAST(NULL AS NUMBER) AS EXTENTS       ,CAST(NULL AS NUMBER) AS INITIAL_EXTENT       ,CAST(NULL AS NUMBER) AS NEXT_EXTENT       ,CAST(NULL AS NUMBER) AS MIN_EXTENTS       ,CAST(NULL AS NUMBER) AS MAX_EXTENTS       ,CAST(NULL AS NUMBER) AS MAX_SIZE       ,CAST(NULL AS VARCHAR(7)) AS RETENTION       ,CAST(NULL AS NUMBER) AS MINRETENTION       ,CAST(NULL AS NUMBER) AS PCT_INCREASE       ,CAST(NULL AS NUMBER) AS FREELISTS       ,CAST(NULL AS NUMBER) AS FREELIST_GROUPS       ,CAST(NULL AS NUMBER) AS RELATIVE_FNO       ,CAST('DEFAULT' AS VARCHAR2(7)) AS BUFFER_POOL       ,CAST('DEFAULT' AS VARCHAR2(7)) AS FLASH_CACHE       ,CAST('DEFAULT' AS VARCHAR2(7)) AS CELL_FLASH_CACHE       ,CAST(NULL AS VARCHAR2(8)) AS INMEMORY       ,CAST(NULL AS VARCHAR2(8)) AS INMEMORY_PRIORITY       ,CAST(NULL AS VARCHAR2(15)) AS INMEMORY_DISTRIBUTE       ,CAST(NULL AS VARCHAR2(13)) AS INMEMORY_DUPLICATE       ,CAST(NULL AS VARCHAR2(17)) AS INMEMORY_COMPRESSION       ,CAST(NULL AS VARCHAR2(24)) AS CELLMEMORY       FROM (        SELECT       T.TABLE_ID       ,T.DATABASE_ID       ,T.TABLE_NAME SEGMENT_NAME       ,NULL PARTITION_NAME       ,CASE WHEN T.TABLE_TYPE IN (0, 3, 8, 9) THEN 'TABLE'             WHEN T.TABLE_TYPE IN (5) THEN 'INDEX'             ELSE NULL END AS SEGMENT_TYPE       ,T.BLOCK_SIZE       ,TS.DATA_SIZE       ,T.TABLE_TYPE       FROM       (SELECT TENANT_ID,               TABLE_ID,               DATABASE_ID,               TABLE_NAME,               TABLE_TYPE,               BLOCK_SIZE,               PART_LEVEL        FROM SYS.ALL_VIRTUAL_CORE_ALL_TABLE         UNION         SELECT TENANT_ID,               TABLE_ID,               DATABASE_ID,               TABLE_NAME,               TABLE_TYPE,               BLOCK_SIZE,               PART_LEVEL        FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT WHERE BITAND((TABLE_MODE / 4096), 15) IN (0,1) AND BITAND(INDEX_ATTRIBUTES_SET, 16) = 0) T       LEFT JOIN (         SELECT TENANT_ID,                TABLE_ID,                (MACRO_BLK_CNT * 2 * 1024 * 1024) AS DATA_SIZE         FROM SYS.ALL_VIRTUAL_TABLE_STAT_REAL_AGENT         WHERE PARTITION_ID = -1 OR PARTITION_ID = TABLE_ID) TS       ON T.TABLE_ID = TS.TABLE_ID       AND T.TENANT_ID = TS.TENANT_ID       WHERE T.PART_LEVEL = 0             AND T.TABLE_TYPE IN (0, 3, 5, 8, 9)             AND T.TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT           T.TABLE_ID           ,T.DATABASE_ID           ,T.TABLE_NAME SEGMENT_NAME           ,P.PART_NAME PARTITION_NAME           ,CASE WHEN T.TABLE_TYPE IN (0, 3, 8, 9) THEN 'TABLE PARTITION'                 WHEN T.TABLE_TYPE IN (5) THEN 'INDEX PARTITION'                 ELSE NULL END AS SEGMENT_TYPE           ,T.BLOCK_SIZE           ,TS.DATA_SIZE           ,T.TABLE_TYPE           FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT T           JOIN SYS.ALL_VIRTUAL_PART_REAL_AGENT P           ON T.TABLE_ID = P.TABLE_ID           AND P.TENANT_ID = T.TENANT_ID           AND BITAND((T.TABLE_MODE / 4096), 15) IN (0,1)           /*do not show deleting index*/           AND BITAND(T.INDEX_ATTRIBUTES_SET, 16) = 0           LEFT JOIN (             SELECT TENANT_ID,                    TABLE_ID,                    PARTITION_ID,                    (MACRO_BLK_CNT * 2 * 1024 * 1024) AS DATA_SIZE              FROM SYS.ALL_VIRTUAL_TABLE_STAT_REAL_AGENT) TS           ON P.TABLE_ID = TS.TABLE_ID           AND P.PART_ID = TS.PARTITION_ID           AND P.TENANT_ID = TS.TENANT_ID           WHERE T.PART_LEVEL = 1                 AND T.TABLE_TYPE IN (0, 3, 5, 8, 9)                 AND T.TENANT_ID = EFFECTIVE_TENANT_ID()                 AND P.PARTITION_TYPE = 0        UNION ALL        SELECT           T.TABLE_ID           ,T.DATABASE_ID           ,T.TABLE_NAME SEGMENT_NAME           ,SUBP.SUB_PART_NAME PARTITION_NAME           ,CASE WHEN T.TABLE_TYPE IN (0, 3, 8, 9) THEN 'TABLE SUBPARTITION'                 WHEN T.TABLE_TYPE IN (5) THEN 'INDEX SUBPARTITION'                 ELSE NULL END AS SEGMENT_TYPE           ,T.BLOCK_SIZE           ,TS.DATA_SIZE           ,T.TABLE_TYPE           FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT T           JOIN SYS.ALL_VIRTUAL_PART_REAL_AGENT P           ON T.TABLE_ID = P.TABLE_ID           AND T.TENANT_ID = P.TENANT_ID           AND BITAND((T.TABLE_MODE / 4096), 15) IN (0,1)           /*do not show deleting index*/           AND BITAND(T.INDEX_ATTRIBUTES_SET, 16) = 0           JOIN SYS.ALL_VIRTUAL_SUB_PART_REAL_AGENT SUBP           ON P.TABLE_ID = SUBP.TABLE_ID           AND P.PART_ID = SUBP.PART_ID           AND P.TENANT_ID = SUBP.TENANT_ID           LEFT JOIN (             SELECT TENANT_ID,                    TABLE_ID,                    PARTITION_ID,                    (MACRO_BLK_CNT * 2 * 1024 * 1024) AS DATA_SIZE             FROM SYS.ALL_VIRTUAL_TABLE_STAT_REAL_AGENT) TS           ON SUBP.TABLE_ID = TS.TABLE_ID           AND SUBP.SUB_PART_ID = TS.PARTITION_ID           AND SUBP.TENANT_ID = TS.TENANT_ID           WHERE T.PART_LEVEL = 2                 AND T.TABLE_TYPE IN (0, 3, 5, 8, 9)                 AND T.TENANT_ID = EFFECTIVE_TENANT_ID()                 AND SUBP.PARTITION_TYPE = 0 AND P.PARTITION_TYPE = 0     )A WHERE DATABASE_ID=USERENV('SCHEMAID') )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::dba_segments_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_DBA_SEGMENTS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_DBA_SEGMENTS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       CAST(B.DATABASE_NAME AS VARCHAR2(128)) AS OWNER       ,CAST(CASE WHEN A.TABLE_TYPE = 5 AND B.DATABASE_NAME != '__recyclebin'                  THEN SUBSTR(A.SEGMENT_NAME, 7 + INSTR(SUBSTR(A.SEGMENT_NAME, 7), '_'))                  ELSE A.SEGMENT_NAME END AS VARCHAR2(128)) AS SEGMENT_NAME       ,CAST(A.PARTITION_NAME AS VARCHAR2(128)) AS PARTITION_NAME       ,CAST(A.SEGMENT_TYPE AS VARCHAR2(18)) AS SEGMENT_TYPE       ,CAST(NULL AS VARCHAR2(10)) AS SEGMENT_SUBTYPE       ,CAST(NULL AS VARCHAR2(30)) AS TABLESPACE_NAME       ,CAST(NULL AS NUMBER) AS HEADER_FILE       ,CAST(NULL AS NUMBER) AS HEADER_BLOCK       ,CAST(A.DATA_SIZE AS NUMBER) AS BYTES       ,CAST(A.BLOCK_SIZE AS NUMBER) AS BLOCKS       ,CAST(NULL AS NUMBER) AS EXTENTS       ,CAST(NULL AS NUMBER) AS INITIAL_EXTENT       ,CAST(NULL AS NUMBER) AS NEXT_EXTENT       ,CAST(NULL AS NUMBER) AS MIN_EXTENTS       ,CAST(NULL AS NUMBER) AS MAX_EXTENTS       ,CAST(NULL AS NUMBER) AS MAX_SIZE       ,CAST(NULL AS VARCHAR(7)) AS RETENTION       ,CAST(NULL AS NUMBER) AS MINRETENTION       ,CAST(NULL AS NUMBER) AS PCT_INCREASE       ,CAST(NULL AS NUMBER) AS FREELISTS       ,CAST(NULL AS NUMBER) AS FREELIST_GROUPS       ,CAST(NULL AS NUMBER) AS RELATIVE_FNO       ,CAST('DEFAULT' AS VARCHAR2(7)) AS BUFFER_POOL       ,CAST('DEFAULT' AS VARCHAR2(7)) AS FLASH_CACHE       ,CAST('DEFAULT' AS VARCHAR2(7)) AS CELL_FLASH_CACHE       ,CAST(NULL AS VARCHAR2(8)) AS INMEMORY       ,CAST(NULL AS VARCHAR2(8)) AS INMEMORY_PRIORITY       ,CAST(NULL AS VARCHAR2(15)) AS INMEMORY_DISTRIBUTE       ,CAST(NULL AS VARCHAR2(13)) AS INMEMORY_DUPLICATE       ,CAST(NULL AS VARCHAR2(17)) AS INMEMORY_COMPRESSION       ,CAST(NULL AS VARCHAR2(24)) AS CELLMEMORY       FROM (        SELECT       T.TABLE_ID       ,T.DATABASE_ID       ,T.TABLE_NAME SEGMENT_NAME       ,NULL PARTITION_NAME       ,CASE WHEN T.TABLE_TYPE IN (0, 3, 8, 9) THEN 'TABLE'             WHEN T.TABLE_TYPE IN (5) THEN 'INDEX'             ELSE NULL END AS SEGMENT_TYPE       ,T.BLOCK_SIZE       ,TS.DATA_SIZE       ,T.TABLE_TYPE       FROM       (SELECT TENANT_ID,               TABLE_ID,               DATABASE_ID,               TABLE_NAME,               TABLE_TYPE,               BLOCK_SIZE,               PART_LEVEL        FROM SYS.ALL_VIRTUAL_CORE_ALL_TABLE         UNION         SELECT TENANT_ID,               TABLE_ID,               DATABASE_ID,               TABLE_NAME,               TABLE_TYPE,               BLOCK_SIZE,               PART_LEVEL        FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT WHERE BITAND((TABLE_MODE / 4096), 15) IN (0,1) AND BITAND(INDEX_ATTRIBUTES_SET, 16) = 0) T       LEFT JOIN (         SELECT TENANT_ID,                TABLE_ID,                (MACRO_BLK_CNT * 2 * 1024 * 1024) AS DATA_SIZE         FROM SYS.ALL_VIRTUAL_TABLE_STAT_REAL_AGENT         WHERE PARTITION_ID = -1 OR PARTITION_ID = TABLE_ID) TS       ON T.TABLE_ID = TS.TABLE_ID       AND T.TENANT_ID = TS.TENANT_ID       WHERE T.PART_LEVEL = 0             AND T.TABLE_TYPE IN (0, 3, 5, 8, 9)             AND T.TENANT_ID = EFFECTIVE_TENANT_ID()        UNION ALL        SELECT           T.TABLE_ID           ,T.DATABASE_ID           ,T.TABLE_NAME SEGMENT_NAME           ,P.PART_NAME PARTITION_NAME           ,CASE WHEN T.TABLE_TYPE IN (0, 3, 8, 9) THEN 'TABLE PARTITION'                 WHEN T.TABLE_TYPE IN (5) THEN 'INDEX PARTITION'                 ELSE NULL END AS SEGMENT_TYPE           ,T.BLOCK_SIZE           ,TS.DATA_SIZE           ,T.TABLE_TYPE           FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT T           JOIN SYS.ALL_VIRTUAL_PART_REAL_AGENT P           ON T.TABLE_ID = P.TABLE_ID           AND P.TENANT_ID = T.TENANT_ID           AND BITAND((T.TABLE_MODE / 4096), 15) IN (0,1)           /*do not show deleting index*/           AND BITAND(T.INDEX_ATTRIBUTES_SET, 16) = 0           LEFT JOIN (             SELECT TENANT_ID,                    TABLE_ID,                    PARTITION_ID,                    (MACRO_BLK_CNT * 2 * 1024 * 1024) AS DATA_SIZE              FROM SYS.ALL_VIRTUAL_TABLE_STAT_REAL_AGENT) TS           ON P.TABLE_ID = TS.TABLE_ID           AND P.PART_ID = TS.PARTITION_ID           AND P.TENANT_ID = TS.TENANT_ID           WHERE T.PART_LEVEL = 1                 AND T.TABLE_TYPE IN (0, 3, 5, 8, 9)                 AND T.TENANT_ID = EFFECTIVE_TENANT_ID()                 AND P.PARTITION_TYPE = 0        UNION ALL        SELECT           T.TABLE_ID           ,T.DATABASE_ID           ,T.TABLE_NAME SEGMENT_NAME           ,SUBP.SUB_PART_NAME PARTITION_NAME           ,CASE WHEN T.TABLE_TYPE IN (0, 3, 8, 9) THEN 'TABLE SUBPARTITION'                 WHEN T.TABLE_TYPE IN (5) THEN 'INDEX SUBPARTITION'                 ELSE NULL END AS SEGMENT_TYPE           ,T.BLOCK_SIZE           ,TS.DATA_SIZE           ,T.TABLE_TYPE           FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT T           JOIN SYS.ALL_VIRTUAL_PART_REAL_AGENT P           ON T.TABLE_ID = P.TABLE_ID           AND T.TENANT_ID = P.TENANT_ID           AND BITAND((T.TABLE_MODE / 4096), 15) IN (0,1)           /*do not show deleting index*/           AND BITAND(T.INDEX_ATTRIBUTES_SET, 16) = 0           JOIN SYS.ALL_VIRTUAL_SUB_PART_REAL_AGENT SUBP           ON P.TABLE_ID = SUBP.TABLE_ID           AND P.PART_ID = SUBP.PART_ID           AND P.TENANT_ID = SUBP.TENANT_ID           LEFT JOIN (             SELECT TENANT_ID,                    TABLE_ID,                    PARTITION_ID,                    (MACRO_BLK_CNT * 2 * 1024 * 1024) AS DATA_SIZE             FROM SYS.ALL_VIRTUAL_TABLE_STAT_REAL_AGENT) TS           ON SUBP.TABLE_ID = TS.TABLE_ID           AND SUBP.SUB_PART_ID = TS.PARTITION_ID           AND SUBP.TENANT_ID = TS.TENANT_ID           WHERE T.PART_LEVEL = 2                 AND T.TABLE_TYPE IN (0, 3, 5, 8, 9)                 AND T.TENANT_ID = EFFECTIVE_TENANT_ID()                 AND SUBP.PARTITION_TYPE =0 AND P.PARTITION_TYPE = 0     )A JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT B       ON A.DATABASE_ID = B.DATABASE_ID       AND B.TENANT_ID = EFFECTIVE_TENANT_ID() )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::dba_types_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_DBA_TYPES_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_DBA_TYPES_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       D.DATABASE_NAME AS OWNER,       T.TYPE_NAME AS TYPE_NAME,       T.TYPE_ID AS TYPE_OID,       CAST(         CASE T.TYPECODE         WHEN 1 THEN 'COLLECTION'         WHEN 2 THEN 'OBJECT' END AS VARCHAR2(10)) AS TYPECODE,       T.ATTRIBUTES AS ATTRIBUTES,       T.METHODS AS METHODS,       CAST('NO' AS CHAR(2)) AS PREDEFINED,       CAST('NO' AS CHAR(2)) AS INCOMPLETE,       CAST('YES' AS CHAR(3)) AS FINAL,       CAST('YES' AS CHAR(3)) AS INSTANTIABLE,       CAST(NULL AS VARCHAR2(30)) AS SUPERTYPE_OWNER,       CAST(NULL AS VARCHAR2(30)) AS SUPERTYPE_NAME,       CAST(NULL AS NUMBER(38)) AS LOCAL_ATTRIBUTES,       CAST(NULL AS NUMBER(38)) AS LOCAL_METHODS,       T.TYPE_ID AS TYPEID     FROM       SYS.ALL_VIRTUAL_TYPE_REAL_AGENT T JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT D         ON D.DATABASE_ID = T.DATABASE_ID         AND T.TENANT_ID = SYS_CONTEXT('USERENV', 'CON_ID')         AND T.TENANT_ID = EFFECTIVE_TENANT_ID()         AND D.TENANT_ID = EFFECTIVE_TENANT_ID()     UNION ALL     SELECT       CAST('SYS' AS VARCHAR2(30)) AS OWNER,       TS.TYPE_NAME AS TYPE_NAME,       TS.TYPE_ID AS TYPE_OID,       CAST(         CASE TS.TYPECODE         WHEN 1 THEN 'COLLECTION'         WHEN 2 THEN 'OBJECT' END AS VARCHAR2(10)) AS TYPECODE,       TS.ATTRIBUTES AS ATTRIBUTES,       TS.METHODS AS METHODS,       CAST('NO' AS CHAR(2)) AS PREDEFINED,       CAST('NO' AS CHAR(2)) AS INCOMPLETE,       CAST('YES' AS CHAR(3)) AS FINAL,       CAST('YES' AS CHAR(3)) AS INSTANTIABLE,       CAST(NULL AS VARCHAR2(30)) AS SUPERTYPE_OWNER,       CAST(NULL AS VARCHAR2(30)) AS SUPERTYPE_NAME,       CAST(NULL AS NUMBER(38)) AS LOCAL_ATTRIBUTES,       CAST(NULL AS NUMBER(38)) AS LOCAL_METHODS,       TS.TYPE_ID AS TYPEID     FROM       SYS.ALL_VIRTUAL_TYPE_SYS_AGENT TS )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::all_types_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_ALL_TYPES_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_ALL_TYPES_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       D.DATABASE_NAME AS OWNER,       T.TYPE_NAME AS TYPE_NAME,       T.TYPE_ID AS TYPE_OID,       CAST(         CASE T.TYPECODE         WHEN 1 THEN 'COLLECTION'         WHEN 2 THEN 'OBJECT' END AS VARCHAR2(10)) AS TYPECODE,       T.ATTRIBUTES AS ATTRIBUTES,       T.METHODS AS METHODS,       CAST('NO' AS CHAR(2)) AS PREDEFINED,       CAST('NO' AS CHAR(2)) AS INCOMPLETE,       CAST('YES' AS CHAR(3)) AS FINAL,       CAST('YES' AS CHAR(3)) AS INSTANTIABLE,       CAST(NULL AS VARCHAR2(30)) AS SUPERTYPE_OWNER,       CAST(NULL AS VARCHAR2(30)) AS SUPERTYPE_NAME,       CAST(NULL AS NUMBER(38)) AS LOCAL_ATTRIBUTES,       CAST(NULL AS NUMBER(38)) AS LOCAL_METHODS,       T.TYPE_ID AS TYPEID     FROM       SYS.ALL_VIRTUAL_TYPE_REAL_AGENT T JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT D         ON D.DATABASE_ID = T.DATABASE_ID         AND T.TENANT_ID = EFFECTIVE_TENANT_ID()         AND D.TENANT_ID = EFFECTIVE_TENANT_ID()         AND (T.DATABASE_ID = USERENV('SCHEMAID')              or USER_CAN_ACCESS_OBJ(4, T.TYPE_ID, T.DATABASE_ID) = 1)         AND T.TENANT_ID = SYS_CONTEXT('USERENV', 'CON_ID')     UNION ALL     SELECT       CAST('SYS' AS VARCHAR2(30)) AS OWNER,       TS.TYPE_NAME AS TYPE_NAME,       TS.TYPE_ID AS TYPE_OID,       CAST(         CASE TS.TYPECODE         WHEN 1 THEN 'COLLECTION'         WHEN 2 THEN 'OBJECT' END AS VARCHAR2(10)) AS TYPECODE,       TS.ATTRIBUTES AS ATTRIBUTES,       TS.METHODS AS METHODS,       CAST('NO' AS CHAR(2)) AS PREDEFINED,       CAST('NO' AS CHAR(2)) AS INCOMPLETE,       CAST('YES' AS CHAR(3)) AS FINAL,       CAST('YES' AS CHAR(3)) AS INSTANTIABLE,       CAST(NULL AS VARCHAR2(30)) AS SUPERTYPE_OWNER,       CAST(NULL AS VARCHAR2(30)) AS SUPERTYPE_NAME,       CAST(NULL AS NUMBER(38)) AS LOCAL_ATTRIBUTES,       CAST(NULL AS NUMBER(38)) AS LOCAL_METHODS,       TS.TYPE_ID AS TYPEID     FROM       SYS.ALL_VIRTUAL_TYPE_SYS_AGENT TS )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::user_types_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_USER_TYPES_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_USER_TYPES_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT       T.TYPE_NAME AS TYPE_NAME,       T.TYPE_ID AS TYPE_OID,       CAST(         CASE T.TYPECODE         WHEN 1 THEN 'COLLECTION'         WHEN 2 THEN 'OBJECT' END AS VARCHAR2(10)) AS TYPECODE,       T.ATTRIBUTES AS ATTRIBUTES,       T.METHODS AS METHODS,       CAST('NO' AS CHAR(2)) AS PREDEFINED,       CAST('NO' AS CHAR(2)) AS INCOMPLETE,       CAST('YES' AS CHAR(3)) AS FINAL,       CAST('YES' AS CHAR(3)) AS INSTANTIABLE,       CAST(NULL AS VARCHAR2(30)) AS SUPERTYPE_OWNER,       CAST(NULL AS VARCHAR2(30)) AS SUPERTYPE_NAME,       CAST(NULL AS NUMBER(38)) AS LOCAL_ATTRIBUTES,       CAST(NULL AS NUMBER(38)) AS LOCAL_METHODS,       T.TYPE_ID AS TYPEID     FROM       SYS.ALL_VIRTUAL_TYPE_REAL_AGENT T JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT D         ON D.DATABASE_ID = T.DATABASE_ID            AND T.TENANT_ID = SYS_CONTEXT('USERENV', 'CON_ID')            AND D.DATABASE_ID = USERENV('SCHEMAID')            AND T.TENANT_ID = EFFECTIVE_TENANT_ID()            AND D.TENANT_ID = EFFECTIVE_TENANT_ID() )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::dba_type_attrs_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_DBA_TYPE_ATTRS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_DBA_TYPE_ATTRS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT /*+ USE_MERGE(T, A, D, T1, D1) */       D.DATABASE_NAME AS OWNER,       T.TYPE_NAME AS TYPE_NAME,       A.NAME AS ATTR_NAME,       CAST(NULL AS VARCHAR2(7)) AS ATTR_TYPE_MOD,       CAST(         CASE BITAND(A.PROPERTIES, 15)         WHEN 3 THEN NULL         ELSE D1.DATABASE_NAME END AS VARCHAR2(128)) AS ATTR_TYPE_OWNER,       CAST(         CASE BITAND(A.PROPERTIES, 15)         WHEN 3           THEN DECODE (A.TYPE_ATTR_ID,             0,  'NULL',             1,  'NUMBER',             2,  'NUMBER',             3,  'NUMBER',             4,  'NUMBER',             5,  'NUMBER',             6,  'NUMBER',             7,  'NUMBER',             8,  'NUMBER',             9,  'NUMBER',             10, 'NUMBER',             11, 'BINARY_FLOAT',             12, 'BINARY_DOUBLE',             13, 'NUMBER',             14, 'NUMBER',             15, 'NUMBER',             16, 'NUMBER',             17, 'DATE',             18, 'TIMESTAMP',             19, 'DATE',             20, 'TIME',             21, 'YEAR',             22, 'VARCHAR2',             23, 'CHAR',             24, 'HEX_STRING',             25, 'EXT',             26, 'UNKNOWN',             27, 'TINYTEXT',             28, 'TEXT',             29, 'MEDIUMTEXT',             30,  DECODE(A.COLL_TYPE, 63, 'BLOB', 'CLOB'),             31, 'BIT',             32, 'ENUM',             33, 'SET',             34, 'ENUM_INNER',             35, 'SET_INNER',             36, CONCAT('TIMESTAMP(', CONCAT(A.SCALE, ') WITH TIME ZONE')),             37, CONCAT('TIMESTAMP(', CONCAT(A.SCALE, ') WITH LOCAL TIME ZONE')),             38, CONCAT('TIMESTAMP(', CONCAT(A.SCALE, ')')),             39, 'RAW',             40, CONCAT('INTERVAL YEAR(', CONCAT(A.SCALE, ') TO MONTH')),             41, CONCAT('INTERVAL DAY(', CONCAT(TRUNC(A.SCALE / 10), CONCAT(') TO SECOND(', CONCAT(MOD(A.SCALE, 10), ')')))),             42, 'FLOAT',             43, 'NVARCHAR2',             44, 'NCHAR',             45, 'UROWID',             46, DECODE(A.COLL_TYPE, 63, 'BLOB', 'CLOB'),             47, 'JSON',             48, 'GEOMETRY',             49, 'UDT',             50, 'NUMBER',             'NOT_SUPPORT')         ELSE t1.TYPE_NAME END AS VARCHAR2(324)) AS ATTR_TYPE_NAME,       A.LENGTH AS LENGTH,       A.NUMBER_PRECISION AS NUMBER_PRECISION,       A.SCALE AS SCALE,       CAST('CHAR_CS' AS CHAR(7)) AS CHARACTER_SET_NAME,       A.ATTRIBUTE AS ATTR_NO,       CAST('NO' AS CHAR(2)) AS INHERITED,       CAST('C' AS CHAR(1)) AS CHAR_USED     FROM       SYS.ALL_VIRTUAL_TYPE_REAL_AGENT T JOIN SYS.ALL_VIRTUAL_TYPE_ATTR_REAL_AGENT A         ON T.TYPE_ID = A.TYPE_ID         AND T.TENANT_ID = EFFECTIVE_TENANT_ID()         AND A.TENANT_ID = EFFECTIVE_TENANT_ID()       JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT D         ON T.TENANT_ID = SYS_CONTEXT('USERENV', 'CON_ID')           AND t.database_id = d.database_id           AND D.TENANT_ID = EFFECTIVE_TENANT_ID()       LEFT JOIN SYS.ALL_VIRTUAL_TYPE_REAL_AGENT T1         ON T1.TYPE_ID = A.TYPE_ATTR_ID         AND T1.TENANT_ID = EFFECTIVE_TENANT_ID()       LEFT JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT D1         ON T1.DATABASE_ID = D1.DATABASE_ID         AND D1.TENANT_ID = EFFECTIVE_TENANT_ID()     UNION ALL     SELECT /*+ USE_MERGE(TS, TAS, TS1) */       CAST('SYS' AS VARCHAR2(30)) AS OWNER,       TS.TYPE_NAME AS TYPE_NAME,       TAS.NAME AS ATTR_NAME,       CAST(NULL AS VARCHAR2(7)) AS ATTR_TYPE_MOD,       CAST(         CASE BITAND(TAS.PROPERTIES, 15)         WHEN 3 THEN NULL         ELSE 'SYS' END AS VARCHAR2(128)) AS ATTR_TYPE_OWNER,       CAST(         CASE BITAND(TAS.PROPERTIES, 15)         WHEN 3           THEN DECODE (TAS.TYPE_ATTR_ID,             0,  'NULL',             1,  'NUMBER',             2,  'NUMBER',             3,  'NUMBER',             4,  'NUMBER',             5,  'NUMBER',             6,  'NUMBER',             7,  'NUMBER',             8,  'NUMBER',             9,  'NUMBER',             10, 'NUMBER',             11, 'BINARY_FLOAT',             12, 'BINARY_DOUBLE',             13, 'NUMBER',             14, 'NUMBER',             15, 'NUMBER',             16, 'NUMBER',             17, 'DATE',             18, 'TIMESTAMP',             19, 'DATE',             20, 'TIME',             21, 'YEAR',             22, 'VARCHAR2',             23, 'CHAR',             24, 'HEX_STRING',             25, 'EXT',             26, 'UNKNOWN',             27, 'TINYTEXT',             28, 'TEXT',             29, 'MEDIUMTEXT',             30,  DECODE(TAS.COLL_TYPE, 63, 'BLOB', 'CLOB'),             31, 'BIT',             32, 'ENUM',             33, 'SET',             34, 'ENUM_INNER',             35, 'SET_INNER',             36, CONCAT('TIMESTAMP(', CONCAT(TAS.SCALE, ') WITH TIME ZONE')),             37, CONCAT('TIMESTAMP(', CONCAT(TAS.SCALE, ') WITH LOCAL TIME ZONE')),             38, CONCAT('TIMESTAMP(', CONCAT(TAS.SCALE, ')')),             39, 'RAW',             40, CONCAT('INTERVAL YEAR(', CONCAT(TAS.SCALE, ') TO MONTH')),             41, CONCAT('INTERVAL DAY(', CONCAT(TRUNC(TAS.SCALE / 10), CONCAT(') TO SECOND(', CONCAT(MOD(TAS.SCALE, 10), ')')))),             42, 'FLOAT',             43, 'NVARCHAR2',             44, 'NCHAR',             45, '',             46, DECODE(TAS.COLL_TYPE, 63, 'BLOB', 'CLOB'),             50, 'NUMBER',             'NOT_SUPPORT')         ELSE TS1.TYPE_NAME END AS VARCHAR2(324)) AS ATTR_TYPE_NAME,       TAS.LENGTH AS LENGTH,       TAS.NUMBER_PRECISION AS NUMBER_PRECISION,       TAS.SCALE AS SCALE,       CAST('CHAR_CS' AS CHAR(7)) AS CHARACTER_SET_NAME,       TAS.ATTRIBUTE AS ATTR_NO,       CAST('NO' AS CHAR(2)) AS INHERITED,       CAST('C' AS CHAR(1)) AS CHAR_USED     FROM       SYS.ALL_VIRTUAL_TYPE_SYS_AGENT TS JOIN SYS.ALL_VIRTUAL_TYPE_ATTR_SYS_AGENT TAS         ON TS.TYPE_ID = TAS.TYPE_ID       LEFT JOIN SYS.ALL_VIRTUAL_TYPE_SYS_AGENT TS1         ON TS1.TYPE_ID = TAS.TYPE_ATTR_ID )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::all_type_attrs_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_ALL_TYPE_ATTRS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_ALL_TYPE_ATTRS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT /*+ USE_MERGE(T, A, D, T1, D1) */       D.DATABASE_NAME AS OWNER,       T.TYPE_NAME AS TYPE_NAME,       A.NAME AS ATTR_NAME,       CAST(NULL AS VARCHAR2(7)) AS ATTR_TYPE_MOD,       CAST(         CASE BITAND(A.PROPERTIES, 15)         WHEN 3 THEN NULL         ELSE D1.DATABASE_NAME END AS VARCHAR2(128)) AS ATTR_TYPE_OWNER,       CAST(         CASE BITAND(A.PROPERTIES, 15)         WHEN 3           THEN DECODE (A.TYPE_ATTR_ID,             0,  'NULL',             1,  'NUMBER',             2,  'NUMBER',             3,  'NUMBER',             4,  'NUMBER',             5,  'NUMBER',             6,  'NUMBER',             7,  'NUMBER',             8,  'NUMBER',             9,  'NUMBER',             10, 'NUMBER',             11, 'BINARY_FLOAT',             12, 'BINARY_DOUBLE',             13, 'NUMBER',             14, 'NUMBER',             15, 'NUMBER',             16, 'NUMBER',             17, 'DATE',             18, 'TIMESTAMP',             19, 'DATE',             20, 'TIME',             21, 'YEAR',             22, 'VARCHAR2',             23, 'CHAR',             24, 'HEX_STRING',             25, 'EXT',             26, 'UNKNOWN',             27, 'TINYTEXT',             28, 'TEXT',             29, 'MEDIUMTEXT',             30,  DECODE(A.COLL_TYPE, 63, 'BLOB', 'CLOB'),             31, 'BIT',             32, 'ENUM',             33, 'SET',             34, 'ENUM_INNER',             35, 'SET_INNER',             36, CONCAT('TIMESTAMP(', CONCAT(A.SCALE, ') WITH TIME ZONE')),             37, CONCAT('TIMESTAMP(', CONCAT(A.SCALE, ') WITH LOCAL TIME ZONE')),             38, CONCAT('TIMESTAMP(', CONCAT(A.SCALE, ')')),             39, 'RAW',             40, CONCAT('INTERVAL YEAR(', CONCAT(A.SCALE, ') TO MONTH')),             41, CONCAT('INTERVAL DAY(', CONCAT(TRUNC(A.SCALE / 10), CONCAT(') TO SECOND(', CONCAT(MOD(A.SCALE, 10), ')')))),             42, 'FLOAT',             43, 'NVARCHAR2',             44, 'NCHAR',             45, '',             46, DECODE(A.COLL_TYPE, 63, 'BLOB', 'CLOB'),             50, 'NUMBER',             'NOT_SUPPORT')         ELSE t1.TYPE_NAME END AS VARCHAR2(324)) AS ATTR_TYPE_NAME,       A.LENGTH AS LENGTH,       A.NUMBER_PRECISION AS NUMBER_PRECISION,       A.SCALE AS SCALE,       CAST('CHAR_CS' AS CHAR(7)) AS CHARACTER_SET_NAME,       A.ATTRIBUTE AS ATTR_NO,       CAST('NO' AS CHAR(2)) AS INHERITED,       CAST('C' AS CHAR(1)) AS CHAR_USED     FROM       SYS.ALL_VIRTUAL_TYPE_REAL_AGENT T JOIN SYS.ALL_VIRTUAL_TYPE_ATTR_REAL_AGENT A         ON T.TYPE_ID = A.TYPE_ID         AND T.TENANT_ID = EFFECTIVE_TENANT_ID()         AND A.TENANT_ID = EFFECTIVE_TENANT_ID()       JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT D         ON T.TENANT_ID = SYS_CONTEXT('USERENV', 'CON_ID')           AND t.database_id = d.database_id           AND D.TENANT_ID = EFFECTIVE_TENANT_ID()           and (t.database_id = USERENV('SCHEMAID')                or USER_CAN_ACCESS_OBJ(4, t.type_id, t.database_id) = 1)       LEFT JOIN SYS.ALL_VIRTUAL_TYPE_REAL_AGENT T1         ON T1.TYPE_ID = A.TYPE_ATTR_ID         AND T1.TENANT_ID = EFFECTIVE_TENANT_ID()       LEFT JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT D1         ON T1.DATABASE_ID = D1.DATABASE_ID         AND D1.TENANT_ID = EFFECTIVE_TENANT_ID()     UNION ALL   SELECT /*+ USE_MERGE(TS, TAS, TS1) */       CAST('SYS' AS VARCHAR2(30)) AS OWNER,       TS.TYPE_NAME AS TYPE_NAME,       TAS.NAME AS ATTR_NAME,       CAST(NULL AS VARCHAR2(7)) AS ATTR_TYPE_MOD,       CAST(         CASE BITAND(TAS.PROPERTIES, 15)         WHEN 3 THEN NULL         ELSE 'SYS' END AS VARCHAR2(128)) AS ATTR_TYPE_OWNER,       CAST(         CASE BITAND(TAS.PROPERTIES, 15)         WHEN 3           THEN DECODE (TAS.TYPE_ATTR_ID,             0,  'NULL',             1,  'NUMBER',             2,  'NUMBER',             3,  'NUMBER',             4,  'NUMBER',             5,  'NUMBER',             6,  'NUMBER',             7,  'NUMBER',             8,  'NUMBER',             9,  'NUMBER',             10, 'NUMBER',             11, 'BINARY_FLOAT',             12, 'BINARY_DOUBLE',             13, 'NUMBER',             14, 'NUMBER',             15, 'NUMBER',             16, 'NUMBER',             17, 'DATE',             18, 'TIMESTAMP',             19, 'DATE',             20, 'TIME',             21, 'YEAR',             22, 'VARCHAR2',             23, 'CHAR',             24, 'HEX_STRING',             25, 'EXT',             26, 'UNKNOWN',             27, 'TINYTEXT',             28, 'TEXT',             29, 'MEDIUMTEXT',             30,  DECODE(TAS.COLL_TYPE, 63, 'BLOB', 'CLOB'),             31, 'BIT',             32, 'ENUM',             33, 'SET',             34, 'ENUM_INNER',             35, 'SET_INNER',             36, CONCAT('TIMESTAMP(', CONCAT(TAS.SCALE, ') WITH TIME ZONE')),             37, CONCAT('TIMESTAMP(', CONCAT(TAS.SCALE, ') WITH LOCAL TIME ZONE')),             38, CONCAT('TIMESTAMP(', CONCAT(TAS.SCALE, ')')),             39, 'RAW',             40, CONCAT('INTERVAL YEAR(', CONCAT(TAS.SCALE, ') TO MONTH')),             41, CONCAT('INTERVAL DAY(', CONCAT(TRUNC(TAS.SCALE / 10), CONCAT(') TO SECOND(', CONCAT(MOD(TAS.SCALE, 10), ')')))),             42, 'FLOAT',             43, 'NVARCHAR2',             44, 'NCHAR',             45, '',             46, DECODE(TAS.COLL_TYPE, 63, 'BLOB', 'CLOB'),             50, 'NUMBER',             'NOT_SUPPORT')         ELSE TS1.TYPE_NAME END AS VARCHAR2(324)) AS ATTR_TYPE_NAME,       TAS.LENGTH AS LENGTH,       TAS.NUMBER_PRECISION AS NUMBER_PRECISION,       TAS.SCALE AS SCALE,       CAST('CHAR_CS' AS CHAR(7)) AS CHARACTER_SET_NAME,       TAS.ATTRIBUTE AS ATTR_NO,       CAST('NO' AS CHAR(2)) AS INHERITED,       CAST('C' AS CHAR(1)) AS CHAR_USED     FROM       SYS.ALL_VIRTUAL_TYPE_SYS_AGENT TS JOIN SYS.ALL_VIRTUAL_TYPE_ATTR_SYS_AGENT TAS         ON TS.TYPE_ID = TAS.TYPE_ID       LEFT JOIN SYS.ALL_VIRTUAL_TYPE_SYS_AGENT TS1         ON TS1.TYPE_ID = TAS.TYPE_ATTR_ID )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}

int ObInnerTableSchema::user_type_attrs_schema(ObTableSchema &table_schema)
{
  int ret = OB_SUCCESS;
  uint64_t column_id = OB_APP_MIN_COLUMN_ID - 1;

  //generated fields:
  table_schema.set_tenant_id(OB_SYS_TENANT_ID);
  table_schema.set_tablegroup_id(OB_INVALID_ID);
  table_schema.set_database_id(OB_ORA_SYS_DATABASE_ID);
  table_schema.set_table_id(OB_USER_TYPE_ATTRS_TID);
  table_schema.set_rowkey_split_pos(0);
  table_schema.set_is_use_bloomfilter(false);
  table_schema.set_progressive_merge_num(0);
  table_schema.set_rowkey_column_num(0);
  table_schema.set_load_type(TABLE_LOAD_TYPE_IN_DISK);
  table_schema.set_table_type(SYSTEM_VIEW);
  table_schema.set_index_type(INDEX_TYPE_IS_NOT);
  table_schema.set_def_type(TABLE_DEF_TYPE_INTERNAL);

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_table_name(OB_USER_TYPE_ATTRS_TNAME))) {
      LOG_ERROR("fail to set table_name", K(ret));
    }
  }

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_compress_func_name(OB_DEFAULT_COMPRESS_FUNC_NAME))) {
      LOG_ERROR("fail to set compress_func_name", K(ret));
    }
  }
  table_schema.set_part_level(PARTITION_LEVEL_ZERO);
  table_schema.set_charset_type(ObCharset::get_default_charset());
  table_schema.set_collation_type(ObCharset::get_default_collation(ObCharset::get_default_charset()));

  if (OB_SUCC(ret)) {
    if (OB_FAIL(table_schema.set_view_definition(R"__(     SELECT /*+ USE_MERGE(T, A, D, T1, D1) */       T.TYPE_NAME AS TYPE_NAME,       A.NAME AS ATTR_NAME,       CAST(NULL AS VARCHAR2(7)) AS ATTR_TYPE_MOD,       CAST(         CASE BITAND(A.PROPERTIES, 15)         WHEN 3 THEN NULL         ELSE D1.DATABASE_NAME END AS VARCHAR2(128)) AS ATTR_TYPE_OWNER,       CAST(         CASE BITAND(A.PROPERTIES, 15)         WHEN 3           THEN DECODE (A.TYPE_ATTR_ID,             0,  'NULL',             1,  'NUMBER',             2,  'NUMBER',             3,  'NUMBER',             4,  'NUMBER',             5,  'NUMBER',             6,  'NUMBER',             7,  'NUMBER',             8,  'NUMBER',             9,  'NUMBER',             10, 'NUMBER',             11, 'BINARY_FLOAT',             12, 'BINARY_DOUBLE',             13, 'NUMBER',             14, 'NUMBER',             15, 'NUMBER',             16, 'NUMBER',             17, 'DATE',             18, 'TIMESTAMP',             19, 'DATE',             20, 'TIME',             21, 'YEAR',             22, 'VARCHAR2',             23, 'CHAR',             24, 'HEX_STRING',             25, 'EXT',             26, 'UNKNOWN',             27, 'TINYTEXT',             28, 'TEXT',             29, 'MEDIUMTEXT',             30,  DECODE(A.COLL_TYPE, 63, 'BLOB', 'CLOB'),             31, 'BIT',             32, 'ENUM',             33, 'SET',             34, 'ENUM_INNER',             35, 'SET_INNER',             36, CONCAT('TIMESTAMP(', CONCAT(A.SCALE, ') WITH TIME ZONE')),             37, CONCAT('TIMESTAMP(', CONCAT(A.SCALE, ') WITH LOCAL TIME ZONE')),             38, CONCAT('TIMESTAMP(', CONCAT(A.SCALE, ')')),             39, 'RAW',             40, CONCAT('INTERVAL YEAR(', CONCAT(A.SCALE, ') TO MONTH')),             41, CONCAT('INTERVAL DAY(', CONCAT(TRUNC(A.SCALE / 10), CONCAT(') TO SECOND(', CONCAT(MOD(A.SCALE, 10), ')')))),             42, 'FLOAT',             43, 'NVARCHAR2',             44, 'NCHAR',             45, '',             46, DECODE(A.COLL_TYPE, 63, 'BLOB', 'CLOB'),             50, 'NUMBER',             'NOT_SUPPORT')         ELSE t1.TYPE_NAME END AS VARCHAR2(324)) AS ATTR_TYPE_NAME,       A.LENGTH AS LENGTH,       A.NUMBER_PRECISION AS NUMBER_PRECISION,       A.SCALE AS SCALE,       CAST('CHAR_CS' AS CHAR(7)) AS CHARACTER_SET_NAME,       A.ATTRIBUTE AS ATTR_NO,       CAST('NO' AS CHAR(2)) AS INHERITED,       CAST('C' AS CHAR(1)) AS CHAR_USED     FROM       SYS.ALL_VIRTUAL_TYPE_REAL_AGENT T JOIN SYS.ALL_VIRTUAL_TYPE_ATTR_REAL_AGENT A         ON T.TYPE_ID = A.TYPE_ID         AND T.TENANT_ID = EFFECTIVE_TENANT_ID()         AND A.TENANT_ID = EFFECTIVE_TENANT_ID()       JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT D         ON T.TENANT_ID = SYS_CONTEXT('USERENV', 'CON_ID')         AND T.DATABASE_ID = D.DATABASE_ID         AND D.TENANT_ID = EFFECTIVE_TENANT_ID()         AND D.DATABASE_ID = USERENV('SCHEMAID')       LEFT JOIN SYS.ALL_VIRTUAL_TYPE_REAL_AGENT T1         ON T1.TYPE_ID = A.TYPE_ATTR_ID         AND T1.TENANT_ID = EFFECTIVE_TENANT_ID()       LEFT JOIN SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT D1         ON T1.DATABASE_ID = D1.DATABASE_ID         AND D1.TENANT_ID = EFFECTIVE_TENANT_ID() )__"))) {
      LOG_ERROR("fail to set view_definition", K(ret));
    }
  }
  table_schema.set_index_using_type(USING_BTREE);
  table_schema.set_row_store_type(ENCODING_ROW_STORE);
  table_schema.set_store_format(OB_STORE_FORMAT_DYNAMIC_MYSQL);
  table_schema.set_progressive_merge_round(1);
  table_schema.set_storage_format_version(3);
  table_schema.set_tablet_id(0);
  table_schema.set_micro_index_clustered(false);

  table_schema.set_max_used_column_id(column_id);
  return ret;
}


} // end namespace share
} // end namespace oceanbase
