/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#include "lib/string/ob_string.h"
#include "lib/hash/ob_hashmap.h"
#include "sql/engine/ob_exec_context.h"
#include "pl/sys_package/ob_dbms_upgrade.h"
#include "pl/sys_package/ob_dbms_stats.h"
#include "pl/sys_package/ob_dbms_scheduler_mysql.h"
#include "pl/sys_package/ob_dbms_application.h"
#include "pl/sys_package/ob_dbms_session.h"
#include "pl/sys_package/ob_dbms_monitor.h"
#include "pl/sys_package/ob_dbms_sql.h"
#include "pl/sys_package/ob_dbms_user_define_rule.h"
#ifdef OB_BUILD_ORACLE_PL
#include "pl/sys_package/ob_dbms_utl_encode.h"
#include "pl/ob_pl_warning.h"
#include "pl/ob_pl_lock.h"
#include "pl/ob_pl_error_log.h"
#include "pl/sys_package/ob_dbms_debug.h"
#include "pl/sys_package/ob_dbms_xa.h"
#include "pl/sys_package/ob_dbms_lob.h"
#include "pl/sys_package/ob_utl_raw.h"
#include "pl/sys_package/ob_utl_i18n.h"
#include "pl/sys_package/ob_pl_dbms_utility_helper.h"
#include "pl/sys_package/ob_dbms_anytype.h"
#include "pl/sys_package/ob_dbms_anydata.h"
#include "pl/sys_package/ob_dbms_xmlgen.h"
#include "pl/sys_package/ob_dbms_scheduler.h"
#include "pl/sys_package/ob_dbms_scheduler_mysql.h"
#include "pl/sys_package/ob_dbms_crypto.h"
#include "pl/sys_package/ob_dbms_ddl.h"
#include "pl/sys_package/ob_dbms_job.h"
#include "pl/sys_package/ob_pl_utl_file.h"
#include "pl/sys_package/ob_dbms_plan_cache.h"
#include "pl/sys_package/ob_dbms_sys_error.h"
#include "pl/sys_package/ob_dbms_preprocessor.h"
#include "pl/sys_package/ob_utl_inaddr.h"
#include "pl/sys_package/ob_pl_sa_sysdba.h"
#include "pl/sys_package/ob_pl_sa_session.h"
#include "pl/sys_package/ob_pl_sa_user_admin.h"
#include "pl/sys_package/ob_pl_sa_policy_admin.h"
#include "pl/sys_package/ob_pl_sa_label_admin.h"
#include "pl/sys_package/ob_pl_sa_components.h"
#include "pl/sys_package/ob_dbms_audit_mgmt.h"
#include "pl/sys_package/ob_dbms_application.h"
#include "pl/sys_package/ob_dbms_monitor.h"
#include "pl/sys_package/ob_dbms_xplan.h"
#include "pl/sys_package/ob_dbms_spm.h"
#include "pl/sys_package/ob_dbms_rls.h"
#include "pl/sys_package/ob_json_object_type.h"
#include "pl/sys_package/ob_json_element_type.h"
#include "pl/sys_package/ob_sdo_geometry.h"
#include "pl/sys_package/ob_dbms_mview.h"
#include "pl/sys_package/ob_dbms_mview_stats.h"
#include "pl/sys_package/ob_json_array_type.h"
#include "pl/sys_package/ob_xml_type.h"
#include "pl/sys_package/ob_sdo_geom.h"
#include "pl/sys_package/ob_dbms_profiler.h"
#include "pl/sys_package/ob_utl_tcp.h"
#include "pl/sys_package/ob_utl_smtp.h"
#endif
#include "pl/sys_package/ob_dbms_xplan.h"
#include "pl/sys_package/ob_pl_dbms_resource_manager.h"
#include "pl/sys_package/ob_dbms_session.h"
#include "pl/sys_package/ob_dbms_space.h"
#include "pl/sys_package/ob_dbms_workload_repository.h"
#include "pl/sys_package/ob_dbms_mview_mysql.h"
#include "pl/sys_package/ob_dbms_mview_stats_mysql.h"
#include "pl/sys_package/ob_pl_dbms_trusted_certificate_manager.h"
#include "pl/sys_package/ob_dbms_limit_calculator_mysql.h"
#include "pl/sys_package/ob_dbms_external_table.h"
#include "pl/sys_package/ob_dbms_vector_mysql.h"

#ifdef INTERFACE_DEF
  INTERFACE_DEF(INTERFACE_START, "TEST", (ObPLInterfaceImpl::call))

  /*************************.. add interface here ..*****************************/
  // start of __dbms_upgrade
  INTERFACE_DEF(INTERFACE_DBMS_UPGRADE_SINGLE, "UPGRADE_SINGLE", (ObDBMSUpgrade::upgrade_single))
  INTERFACE_DEF(INTERFACE_DBMS_UPGRADE_ALL, "UPGRADE_ALL", (ObDBMSUpgrade::upgrade_all))
  // end of __dbms_upgrade

#ifdef OB_BUILD_ORACLE_PL
  // start utl_encode package
  INTERFACE_DEF(INTERFACE_DBMS_BASE64_ENCODE, "BASE64_ENCODE", (ObDBMSUtlEncode::base64_encode))
  INTERFACE_DEF(INTERFACE_DBMS_BASE64_DECODE, "BASE64_DECODE", (ObDBMSUtlEncode::base64_decode))
  INTERFACE_DEF(INTERFACE_DBMS_QUOTED_PRINTABLE_ENCODE, "QUOTED_PRINTABLE_ENCODE",
               (ObDBMSUtlEncode::quoted_printable_encode))
  INTERFACE_DEF(INTERFACE_DBMS_QUOTED_PRINTABLE_DECODE, "QUOTED_PRINTABLE_DECODE",
               (ObDBMSUtlEncode::quoted_printable_decode))
  INTERFACE_DEF(INTERFACE_DBMS_MIMEHEADER_ENCODE, "MIMEHEADER_ENCODE",
              (ObDBMSUtlEncode::mimeheader_encode))
  INTERFACE_DEF(INTERFACE_DBMS_MIMEHEADER_DECODE, "MIMEHEADER_DECODE",
              (ObDBMSUtlEncode::mimeheader_decode))
  INTERFACE_DEF(INTERFACE_DBMS_TEXT_ENCODE, "TEXT_ENCODE", (ObDBMSUtlEncode::text_encode))
  INTERFACE_DEF(INTERFACE_DBMS_TEXT_DECODE, "TEXT_DECODE", (ObDBMSUtlEncode::text_decode))
  INTERFACE_DEF(INTERFACE_DBMS_UU_ENCODE, "UU_ENCODE", (ObDBMSUtlEncode::uu_encode))
  INTERFACE_DEF(INTERFACE_DBMS_UU_DECODE, "UU_DECODE", (ObDBMSUtlEncode::uu_decode))
  // end utl_encode package

  // dbms_warning
  INTERFACE_DEF(INTERFACE_WARNING_ADD_CAT, "WARNING_ADD_CAT", (PlCompilerWarningCategory::add_pl_warning_setting_cat))
  INTERFACE_DEF(INTERFACE_WARNING_ADD_NUM, "WARNING_ADD_NUM", (PlCompilerWarningCategory::add_pl_warning_setting_num))
  INTERFACE_DEF(INTERFACE_WARNING_SET, "WARNING_SET", (PlCompilerWarningCategory::set_pl_warning_setting))
  INTERFACE_DEF(INTERFACE_WARNING_GET_CAT, "WARNING_GET_CAT", (PlCompilerWarningCategory::get_category))
  INTERFACE_DEF(INTERFACE_WARNING_GET_SETTING_CAT, "WARNING_GET_SETTING_CAT", (PlCompilerWarningCategory::get_warning_setting_cat))
  INTERFACE_DEF(INTERFACE_WARNING_GET_SETTING_NUM, "WARNING_GET_SETTING_NUM", (PlCompilerWarningCategory::get_warning_setting_num))
  INTERFACE_DEF(INTERFACE_WARNING_GET_SETTING_STR, "WARNING_GET_SETTING_STR", (PlCompilerWarningCategory::get_warning_setting_string))
  // end dbms_warning

  // dbms_lock
  INTERFACE_DEF(INTERFACE_LOCK_SLEEP_LOCK, "SLEEP_LOCK", (PlPackageLock::sleep))
  INTERFACE_DEF(INTERFACE_LOCK_ALLOCATE_UNIQUE, "ALLOCATE_UNIQUE_LOCK", (PlPackageLock::allocate_unique_lock))
  // INTERFACE_DEF(INTERFACE_LOCK_CONVERT, "CONVERT_LOCK", (PlPackageLock::convert))
  INTERFACE_DEF(INTERFACE_LOCK_RELEASE, "RELEASE_LOCK", (PlPackageLock::release_lock))
  INTERFACE_DEF(INTERFACE_LOCK_REQUEST, "REQUEST_LOCK", (PlPackageLock::request_lock))
  // end dbms_lock

  // DBMS_ERRLOG
  INTERFACE_DEF(INTERFACE_CREATE_ERROR_LOG, "CREATE_ERROR_LOG", (PlPackageErrorLog::create_error_log))
  // end DBMS_ERRLOG

  // start of dbms_debug
#define DEFINE_DEBUG_INTERFACE(symbol, func) \
  INTERFACE_DEF(INTERFACE_DBMS_DEBUG_##symbol, #symbol, (func))

  DEFINE_DEBUG_INTERFACE(GET_VALUES, ObDBMSDebug::get_values)
  DEFINE_DEBUG_INTERFACE(TARGET_PROGRAM_RUNNING, ObDBMSDebug::target_program_running)
  DEFINE_DEBUG_INTERFACE(PING, ObDBMSDebug::ping)
  DEFINE_DEBUG_INTERFACE(GET_RUNTIME_INFO, ObDBMSDebug::get_runtime_info)
  DEFINE_DEBUG_INTERFACE(DEBUG_ON, ObDBMSDebug::on)
  DEFINE_DEBUG_INTERFACE(DEBUG_OFF, ObDBMSDebug::off)
  DEFINE_DEBUG_INTERFACE(INITIALIZE, ObDBMSDebug::initialize)
  DEFINE_DEBUG_INTERFACE(DETACH_SESSION, ObDBMSDebug::detach_session)
  DEFINE_DEBUG_INTERFACE(PRINT_BACKTRACE, ObDBMSDebug::print_backtrace)
  DEFINE_DEBUG_INTERFACE(PRINT_VARCHAR_BACKTRACE, ObDBMSDebug::print_varchar_backtrace)
  DEFINE_DEBUG_INTERFACE(SHOW_BREAKPOINTS, ObDBMSDebug::show_breakpoints)
  DEFINE_DEBUG_INTERFACE(GET_TIMEOUT_BEHAVIOUR, ObDBMSDebug::get_timeout_behaviour)
  DEFINE_DEBUG_INTERFACE(ATTACH_SESSION, ObDBMSDebug::attach_session)
  DEFINE_DEBUG_INTERFACE(DEBUG_CONTINUE, ObDBMSDebug::debug_continue)
  DEFINE_DEBUG_INTERFACE(DEL_BREAKPOINT, ObDBMSDebug::del_breakpoint)
  DEFINE_DEBUG_INTERFACE(ENABLE_BREAKPOINT, ObDBMSDebug::enable_breakpoint)
  DEFINE_DEBUG_INTERFACE(DISABLE_BREAKPOINT, ObDBMSDebug::disable_breakpoint)
  DEFINE_DEBUG_INTERFACE(SET_TIMEOUT, ObDBMSDebug::set_timeout)
  DEFINE_DEBUG_INTERFACE(SET_TIMEOUT_BEHAVIOUR, ObDBMSDebug::set_timeout_behaviour)
  DEFINE_DEBUG_INTERFACE(SET_BREAKPOINT, ObDBMSDebug::set_breakpoint)
  DEFINE_DEBUG_INTERFACE(GET_VALUE, ObDBMSDebug::get_value)
  DEFINE_DEBUG_INTERFACE(SYNCHRONIZE, ObDBMSDebug::synchronize)
  DEFINE_DEBUG_INTERFACE(GET_TARGET_DEBUG_ID, ObDBMSDebug::get_target_debug_id)
#undef DEFINE_DEBUG_INTERFACE
  // end of dbms_debug

  // start of dbms_sql
  INTERFACE_DEF(INTERFACE_DBMS_SQL_OPEN_CURSOR, "DBMS_SQL_OPEN_CURSOR", (ObPLDbmsSql::open_cursor))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_PARSE, "DBMS_SQL_PARSE", (ObPLDbmsSql::parse))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_BIND_VARIABLE, "DBMS_SQL_BIND_VARIABLE", (ObPLDbmsSql::bind_variable))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_EXECUTE, "DBMS_SQL_EXECUTE", (ObPLDbmsSql::execute))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_DEFINE_COLUMN, "DBMS_SQL_DEFINE_COLUMN", (ObPLDbmsSql::define_column))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_DEFINE_ARRAY, "DBMS_SQL_DEFINE_ARRAY", (ObPLDbmsSql::define_array))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_COLUMN_VALUE, "DBMS_SQL_COLUMN_VALUE", (ObPLDbmsSql::column_value))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_FETCH_ROWS, "DBMS_SQL_FETCH_ROWS", (ObPLDbmsSql::fetch_rows))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_CLOSE_CURSOR, "DBMS_SQL_CLOSE_CURSOR", (ObPLDbmsSql::close_cursor))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_DESCRIBE_COLUMNS, "DBMS_SQL_DESCRIBE_COLUMNS", (ObPLDbmsSql::describe_columns))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_DESCRIBE_COLUMNS2, "DBMS_SQL_DESCRIBE_COLUMNS2", (ObPLDbmsSql::describe_columns2))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_DESCRIBE_COLUMNS3, "DBMS_SQL_DESCRIBE_COLUMNS3", (ObPLDbmsSql::describe_columns3))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_IS_OPEN, "DBMS_SQL_IS_OPEN", (ObPLDbmsSql::is_open))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_EXECUTE_AND_FETCH, "DBMS_SQL_EXECUTE_AND_FETCH", (ObPLDbmsSql::execute_and_fetch))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_TO_CURSOR_NUMBER, "DBMS_SQL_TO_CURSOR_NUMBER", (ObPLDbmsSql::to_cursor_number))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_DEFINE_COLUMN_LONG, "DBMS_SQL_DEFINE_COLUMN_LONG", (ObPLDbmsSql::define_column_long))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_COLUMN_VALUE_LONG, "DBMS_SQL_COLUMN_VALUE_LONG", (ObPLDbmsSql::column_value_long))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_VARIABLE_VALUE, "DBMS_SQL_VARIABLE_VALUE", (ObPLDbmsSql::variable_value))
  INTERFACE_DEF(INTERFACE_DBMS_SQL_LAST_ERROR_POSITION, "DBMS_SQL_LAST_ERROR_POSITION", (ObPLDbmsSql::last_error_position))
  // end of dbms_sql

  //start of DBMS_XA
  INTERFACE_DEF(INTERFACE_DBMS_XA_XID, "INNER_XA_XID", (ObDbmsXA::xa_xid))
  INTERFACE_DEF(INTERFACE_DBMS_XA_START, "INNER_XA_START", (ObDbmsXA::xa_start))
  INTERFACE_DEF(INTERFACE_DBMS_XA_END, "INNER_XA_END", (ObDbmsXA::xa_end))
  INTERFACE_DEF(INTERFACE_DBMS_XA_PREPARE, "INNER_XA_PREPARE", (ObDbmsXA::xa_prepare))
  INTERFACE_DEF(INTERFACE_DBMS_XA_COMMIT, "INNER_XA_COMMIT", (ObDbmsXA::xa_commit))
  INTERFACE_DEF(INTERFACE_DBMS_XA_COMMIT_WITH_FLAGS, "INNER_XA_COMMIT_WITH_FLAGS", (ObDbmsXA::xa_commit_with_flags))
  INTERFACE_DEF(INTERFACE_DBMS_XA_FORGET, "INNER_XA_FORGET", (ObDbmsXA::xa_forget))
  INTERFACE_DEF(INTERFACE_DBMS_XA_GETLASTOER, "INNER_XA_GETLASTOER", (ObDbmsXA::xa_getlastoer))
  INTERFACE_DEF(INTERFACE_DBMS_XA_RECOVER, "INNER_XA_RECOVER", (ObDbmsXA::xa_recover))
  INTERFACE_DEF(INTERFACE_DBMS_XA_ROLLBACK, "INNER_XA_ROLLBACK", (ObDbmsXA::xa_rollback))
  INTERFACE_DEF(INTERFACE_DBMS_XA_SETTIMEOUT, "INNER_XA_SETTIMEOUT", (ObDbmsXA::xa_settimeout))
  INTERFACE_DEF(INTERFACE_DBMS_DIST_TXN_SYNC, "INNER_DIST_TXN_SYNC", (ObDbmsXA::dist_txn_sync))
  //end of DBMS_XA

  // start of dbms_lob
  INTERFACE_DEF(INTERFACE_DBMS_LOB_TRIM, "DBMS_LOB_TRIM", (ObDbmsLob::trim))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_APPEND, "DBMS_LOB_APPEND", (ObDbmsLob::append))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_WRITE, "DBMS_LOB_WRITE", (ObDbmsLob::write))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_OPEN, "DBMS_LOB_OPEN", (ObDbmsLob::open))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_CLOSE, "DBMS_LOB_CLOSE", (ObDbmsLob::close))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_ISOPEN, "DBMS_LOB_ISOPEN", (ObDbmsLob::isopen))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_GETLENGTH, "DBMS_LOB_GETLENGTH", (ObDbmsLob::getlength))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_READ, "DBMS_LOB_READ", (ObDbmsLob::read))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_SUBSTR, "DBMS_LOB_SUBSTR", (ObDbmsLob::substr))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_INSTR, "DBMS_LOB_INSTR", (ObDbmsLob::instr))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_WRITEAPPEND, "DBMS_LOB_WRITEAPPEND", (ObDbmsLob::writeappend))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_ERASE, "DBMS_LOB_ERASE", (ObDbmsLob::erase))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_COPY, "DBMS_LOB_COPY", (ObDbmsLob::copy))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_CREATETEMPORARY, "DBMS_LOB_CREATETEMPORARY", (ObDbmsLob::createtemporary))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_FREETEMPORARY, "DBMS_LOB_FREETEMPORARY", (ObDbmsLob::freetemporary))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_CONVERTTOBLOB, "DBMS_LOB_CONVERTTOBLOB", (ObDbmsLob::converttoblob))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_OBCI_WRITE, "DBMS_LOB_OBCI_WRITE", (ObDbmsLob::obci_write))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_COMPARE, "DBMS_LOB_COMPARE", (ObDbmsLob::compare))
  INTERFACE_DEF(INTERFACE_DBMS_LOB_ISTEMPORARY, "DBMS_LOB_ISTEMPORARY", (ObDbmsLob::istemporary))
  // end of dbms_lob

  // start of utl_raw
  INTERFACE_DEF(INTERFACE_UTL_RAW_CAST_TO_RAW, "UTL_RAW_CAST_TO_RAW", (ObUtlRaw::cast_to_raw))
  INTERFACE_DEF(INTERFACE_UTL_RAW_CAST_TO_VARCHAR2, "UTL_RAW_CAST_TO_VARCHAR2", (ObUtlRaw::cast_to_varchar2))
  INTERFACE_DEF(INTERFACE_UTL_RAW_CAST_TO_NVARCHAR2, "UTL_RAW_CAST_TO_NVARCHAR2", (ObUtlRaw::cast_to_nvarchar2))
  INTERFACE_DEF(INTERFACE_UTL_RAW_LENGTH, "UTL_RAW_LENGTH", (ObUtlRaw::length))
  INTERFACE_DEF(INTERFACE_UTL_RAW_BIT_COMPLEMENT, "UTL_RAW_BIT_COMPLEMENT", (ObUtlRaw::bit_complement))
  INTERFACE_DEF(INTERFACE_UTL_RAW_BIT_AND, "UTL_RAW_BIT_AND", (ObUtlRaw::bit_and))
  INTERFACE_DEF(INTERFACE_UTL_RAW_BIT_OR, "UTL_RAW_BIT_OR", (ObUtlRaw::bit_or))
  INTERFACE_DEF(INTERFACE_UTL_RAW_BIT_XOR, "UTL_RAW_BIT_XOR", (ObUtlRaw::bit_xor))
  INTERFACE_DEF(INTERFACE_UTL_RAW_COPIES, "UTL_RAW_COPIES", (ObUtlRaw::copies))
  INTERFACE_DEF(INTERFACE_UTL_RAW_COMPARE, "UTL_RAW_COMPARE", (ObUtlRaw::compare))
  INTERFACE_DEF(INTERFACE_UTL_RAW_CONCAT, "UTL_RAW_CONCAT", (ObUtlRaw::concat))
  INTERFACE_DEF(INTERFACE_UTL_RAW_SUBSTR, "UTL_RAW_SUBSTR", (ObUtlRaw::substr))
  INTERFACE_DEF(INTERFACE_UTL_RAW_REVERSE, "UTL_RAW_REVERSE", (ObUtlRaw::reverse))
  INTERFACE_DEF(INTERFACE_UTL_RAW_CAST_FROM_BINARY_INTEGER, "UTL_RAW_CAST_FROM_BINARY_INTEGER", (ObUtlRaw::cast_from_binary_integer))
  INTERFACE_DEF(INTERFACE_UTL_RAW_CAST_TO_BINARY_INTEGER, "UTL_RAW_CAST_TO_BINARY_INTEGER", (ObUtlRaw::cast_to_binary_integer))
  INTERFACE_DEF(INTERFACE_UTL_RAW_CAST_FROM_BINARY_FLOAT, "UTL_RAW_CAST_FROM_BINARY_FLOAT", (ObUtlRaw::cast_from_binary_float))
  INTERFACE_DEF(INTERFACE_UTL_RAW_CAST_TO_BINARY_FLOAT, "UTL_RAW_CAST_TO_BINARY_FLOAT", (ObUtlRaw::cast_to_binary_float))
  INTERFACE_DEF(INTERFACE_UTL_RAW_CAST_FROM_BINARY_DOUBLE, "UTL_RAW_CAST_FROM_BINARY_DOUBLE", (ObUtlRaw::cast_from_binary_double))
  INTERFACE_DEF(INTERFACE_UTL_RAW_CAST_TO_BINARY_DOUBLE, "UTL_RAW_CAST_TO_BINARY_DOUBLE", (ObUtlRaw::cast_to_binary_double))
  INTERFACE_DEF(INTERFACE_UTL_RAW_CAST_FROM_NUMBER, "UTL_RAW_CAST_FROM_NUMBER", (ObUtlRaw::cast_from_number))
  INTERFACE_DEF(INTERFACE_UTL_RAW_CAST_TO_NUMBER, "UTL_RAW_CAST_TO_NUMBER", (ObUtlRaw::cast_to_number))
  // end of utl_raw

  // start of utl_i18n
  INTERFACE_DEF(INTERFACE_UTL_I18N_STRING_TO_RAW, "UTL_I18N_STRING_TO_RAW", (ObUtlI18n::string_to_raw))
  INTERFACE_DEF(INTERFACE_UTL_I18N_RAW_TO_CHAR, "UTL_I18N_RAW_TO_CHAR", (ObUtlI18n::raw_to_char))
  // end of utl_i18n

  // start of utl_inaddr
  INTERFACE_DEF(INTERFACE_UTL_INADDR_GET_HOST_NAME, "UTL_INADDR_GET_HOST_NAME", (ObUtlInaddr::get_host_name))
  INTERFACE_DEF(INTERFACE_UTL_INADDR_GET_HOST_ADDERSS, "UTL_INADDR_GET_HOST_ADDRESS", (ObUtlInaddr::get_host_address))
  // end of utl_inaddr

  // start of dbms_plan_cache
  INTERFACE_DEF(INTERFACE_DBMS_PLAN_CACHE_PURGE, "PLAN_CACHE_PURGE", (ObDBMSPlanCache::purge_single_plan_by_sql_id))
  // end of dbms_plan_cache
#endif

  // start of dbms_application_info
  INTERFACE_DEF(INTERFACE_DBMS_READ_CLIENT_INFO, "READ_CLIENT_INFO", (ObDBMSAppInfo::read_client_info))
  INTERFACE_DEF(INTERFACE_DBMS_READ_MODULE, "READ_MODULE", (ObDBMSAppInfo::read_module))
  INTERFACE_DEF(INTERFACE_DBMS_SET_ACTION, "SET_ACTION", (ObDBMSAppInfo::set_action))
  INTERFACE_DEF(INTERFACE_DBMS_SET_CLIENT_INFO, "SET_CLIENT_INFO", (ObDBMSAppInfo::set_client_info))
  INTERFACE_DEF(INTERFACE_DBMS_SET_MODULE, "SET_MODULE", (ObDBMSAppInfo::set_module))
  // end of dbms_application_info

  // start of dbms_monitor
  INTERFACE_DEF(INTERFACE_DBMS_SESSION_TRACE_ENABLE, "OB_SESSION_TRACE_ENABLE", (ObDBMSMonitor::session_trace_enable))
  INTERFACE_DEF(INTERFACE_DBMS_SESSION_TRACE_DISABLE, "OB_SESSION_TRACE_DISABLE", (ObDBMSMonitor::session_trace_disable))
  INTERFACE_DEF(INTERFACE_DBMS_CLIENT_ID_TRACE_ENABLE, "OB_CLIENT_ID_TRACE_ENABLE", (ObDBMSMonitor::client_id_trace_enable))
  INTERFACE_DEF(INTERFACE_DBMS_CLIENT_ID_TRACE_DISABLE, "OB_CLIENT_ID_TRACE_DISABLE", (ObDBMSMonitor::client_id_trace_disable))
  INTERFACE_DEF(INTERFACE_DBMS_MOD_ACT_TRACE_ENABLE, "OB_MOD_ACT_TRACE_ENABLE", (ObDBMSMonitor::mod_act_trace_enable))
  INTERFACE_DEF(INTERFACE_DBMS_MOD_ACT_TRACE_DISABLE, "OB_MOD_ACT_TRACE_DISABLE", (ObDBMSMonitor::mod_act_trace_disable))
  INTERFACE_DEF(INTERFACE_DBMS_TENANT_TRACE_ENABLE, "OB_TENANT_TRACE_ENABLE", (ObDBMSMonitor::tenant_trace_enable))
  INTERFACE_DEF(INTERFACE_DBMS_TENANT_TRACE_DISABLE, "OB_TENANT_TRACE_DISABLE", (ObDBMSMonitor::tenant_trace_disable))
  // end of dbms_monitor

#ifdef OB_BUILD_ORACLE_PL
  // dbms_utility
  INTERFACE_DEF(INTERFACE_CALL_STACK, "FORMAT_CALL_STACK", (DbmsUtilityHelper::format_call_stack))
  INTERFACE_DEF(INTERFACE_ERROR_STACK, "FORMAT_ERROR_STACK", (DbmsUtilityHelper::format_error_stack))
  INTERFACE_DEF(INTERFACE_ERROR_BACKTRACE, "FORMAT_ERROR_BACKTRACE", (DbmsUtilityHelper::format_error_backtrace))
  INTERFACE_DEF(INTERFACE_NAME_TOKENIZE, "NAME_TOKENIZE", (DbmsUtilityHelper::name_tokenize))
  INTERFACE_DEF(INTERFACE_NAME_RESOLVE, "NAME_RESOLVE", (DbmsUtilityHelper::name_resolve))
  INTERFACE_DEF(INTERFACE_GET_PARAM_VALUE, "GET_PARAM_VALUE", (DbmsUtilityHelper::get_param_value))
  INTERFACE_DEF(INTERFACE_GET_SQL_HASH, "GETSQLHASH", (DbmsUtilityHelper::get_sql_hash))
  INTERFACE_DEF(INTERFACE_IS_BIT_SET, "IS_BIT_SET", (DbmsUtilityHelper::is_bit_set))
  INTERFACE_DEF(INTERFACE_CANONICALIZE, "CANONICALIZE", (DbmsUtilityHelper::canonicalize))
  INTERFACE_DEF(INTERFACE_GET_ENDIANESS, "GET_ENDIAN", (DbmsUtilityHelper::get_endian))
  INTERFACE_DEF(INTERFACE_GET_HASH_VALUE, "GET_HASH_VALUE", (DbmsUtilityHelper::get_hash_value))
  INTERFACE_DEF(INTERFACE_GET_DB_VERSION, "GET_DB_VERSION", (DbmsUtilityHelper::get_db_version))
  INTERFACE_DEF(INTERFACE_GET_PORT_STRING, "GET_PORT_STRING", (DbmsUtilityHelper::get_port_string))
  INTERFACE_DEF(INTERFACE_GET_TIME, "GET_TIME", (DbmsUtilityHelper::get_time))
  INTERFACE_DEF(INTERFACE_INVALIDATE, "INVALIDATE", (DbmsUtilityHelper::invalidate))
  INTERFACE_DEF(INTERFACE_VALIDATE, "VALIDATE", (DbmsUtilityHelper::validate))
  INTERFACE_DEF(INTERFACE_PSDANAM, "PSDANAM", (DbmsUtilityHelper::psdanam))
  // end dbms_utility

#endif

  //start of resource manager
  INTERFACE_DEF(INTERFACE_DBMS_RESOURCE_MANAGER_CREATE_PLAN, "CREATE_PLAN_INNER", (ObPlDBMSResourceManager::create_plan))
  INTERFACE_DEF(INTERFACE_DBMS_RESOURCE_MANAGER_DELETE_PLAN, "DELETE_PLAN_INNER", (ObPlDBMSResourceManager::delete_plan))
  INTERFACE_DEF(INTERFACE_DBMS_RESOURCE_MANAGER_CREATE_CONSUMER_GROUP, "CREATE_CONSUMER_GROUP_INNER", (ObPlDBMSResourceManager::create_consumer_group))
  INTERFACE_DEF(INTERFACE_DBMS_RESOURCE_MANAGER_DELETE_CONSUMER_GROUP, "DELETE_CONSUMER_GROUP_INNER", (ObPlDBMSResourceManager::delete_consumer_group))
  INTERFACE_DEF(INTERFACE_DBMS_RESOURCE_MANAGER_CREATE_PLAN_DIRECTIVE, "CREATE_PLAN_DIRECTIVE_INNER", (ObPlDBMSResourceManager::create_plan_directive))
  INTERFACE_DEF(INTERFACE_DBMS_RESOURCE_MANAGER_UPDATE_PLAN_DIRECTIVE, "UPDATE_PLAN_DIRECTIVE_INNER", (ObPlDBMSResourceManager::update_plan_directive))
  INTERFACE_DEF(INTERFACE_DBMS_RESOURCE_MANAGER_DELETE_PLAN_DIRECTIVE, "DELETE_PLAN_DIRECTIVE_INNER", (ObPlDBMSResourceManager::delete_plan_directive))
  INTERFACE_DEF(INTERFACE_DBMS_RESOURCE_MANAGER_SET_CONSUMER_GROUP_MAPPING, "SET_CONSUMER_GROUP_MAPPING_INNER", (ObPlDBMSResourceManager::set_consumer_group_mapping))
  //end of resource manager

  //start of dbms_stat
  INTERFACE_DEF(INTERFACE_DBMS_STATS_GATHER_TABLE_STATS, "GATHER_TABLE_STATS", (ObDbmsStats::gather_table_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_GATHER_SCHEMA_STATS, "GATHER_SCHEMA_STATS", (ObDbmsStats::gather_schema_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_SET_TABLE_STATS, "SET_TABLE_STATS", (ObDbmsStats::set_table_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_SET_COLUMN_STATS, "SET_COLUMN_STATS", (ObDbmsStats::set_column_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_DELETE_TABLE_STATS, "DELETE_TABLE_STATS", (ObDbmsStats::delete_table_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_DELETE_COLUMN_STATS, "DELETE_COLUMN_STATS", (ObDbmsStats::delete_column_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_DELETE_SCHEMA_STATS, "DELETE_SCHEMA_STATS", (ObDbmsStats::delete_schema_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_FLUSH_DATABASE_MONITORING_INFO, "FLUSH_DATABASE_MONITORING_INFO", (ObDbmsStats::flush_database_monitoring_info))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_CREATE_STAT_TABLE, "CREATE_STAT_TABLE", (ObDbmsStats::create_stat_table))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_DROP_STAT_TABLE, "DROP_STAT_TABLE", (ObDbmsStats::drop_stat_table))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_EXPORT_TABLE_STATS, "EXPORT_TABLE_STATS", (ObDbmsStats::export_table_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_EXPORT_COLUMN_STATS, "EXPORT_COLUMN_STATS", (ObDbmsStats::export_column_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_EXPORT_SCHEMA_STATS, "EXPORT_SCHEMA_STATS", (ObDbmsStats::export_schema_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_IMPORT_TABLE_STATS, "IMPORT_TABLE_STATS", (ObDbmsStats::import_table_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_IMPORT_COLUMN_STATS, "IMPORT_COLUMN_STATS", (ObDbmsStats::import_column_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_IMPORT_SCHEMA_STATS, "IMPORT_SCHEMA_STATS", (ObDbmsStats::import_schema_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_LOCK_TABLE_STATS, "LOCK_TABLE_STATS", (ObDbmsStats::lock_table_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_LOCK_PARTITION_STATS, "LOCK_PARTITION_STATS", (ObDbmsStats::lock_partition_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_LOCK_SCHEMA_STATS, "LOCK_SCHEMA_STATS", (ObDbmsStats::lock_schema_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_UNLOCK_TABLE_STATS, "UNLOCK_TABLE_STATS", (ObDbmsStats::unlock_table_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_UNLOCK_PARTITION_STATS, "UNLOCK_PARTITION_STATS", (ObDbmsStats::unlock_partition_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_UNLOCK_SCHEMA_STATS, "UNLOCK_SCHEMA_STATS", (ObDbmsStats::unlock_schema_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_GATHER_DATABASE_STATS_JOB_PROC, "GATHER_DATABASE_STATS_JOB_PROC", (ObDbmsStats::gather_database_stats_job_proc))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_RESTORE_TABLE_STATS, "RESTORE_TABLE_STATS", (ObDbmsStats::restore_table_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_RESTORE_SCHEMA_STATS, "RESTORE_SCHEMA_STATS", (ObDbmsStats::restore_schema_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_PURGE_STATS, "PURGE_STATS", (ObDbmsStats::purge_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_ALTER_STATS_HISTORY_RETENTION, "ALTER_STATS_HISTORY_RETENTION", (ObDbmsStats::alter_stats_history_retention))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_GET_STATS_HISTORY_AVAILABILITY, "GET_STATS_HISTORY_AVAILABILITY", (ObDbmsStats::get_stats_history_availability))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_GET_STATS_HISTORY_RETENTION, "GET_STATS_HISTORY_RETENTION", (ObDbmsStats::get_stats_history_retention))
  INTERFACE_DEF(INTERFACE_DBMS_RESET_GLOBAL_PREF_DEFAULTS, "RESET_GLOBAL_PREF_DEFAULTS", (ObDbmsStats::reset_global_pref_defaults))
  INTERFACE_DEF(INTERFACE_DBMS_SET_GLOBAL_PREFS, "SET_GLOBAL_PREFS", (ObDbmsStats::set_global_prefs))
  INTERFACE_DEF(INTERFACE_DBMS_SET_SCHEMA_PREFS, "SET_SCHEMA_PREFS", (ObDbmsStats::set_schema_prefs))
  INTERFACE_DEF(INTERFACE_DBMS_SET_TABLE_PREFS, "SET_TABLE_PREFS", (ObDbmsStats::set_table_prefs))
  INTERFACE_DEF(INTERFACE_DBMS_GET_PREFS, "GET_PREFS", (ObDbmsStats::get_prefs))
  INTERFACE_DEF(INTERFACE_DBMS_DELETE_SCHEMA_PREFS, "DELETE_SCHEMA_PREFS", (ObDbmsStats::delete_schema_prefs))
  INTERFACE_DEF(INTERFACE_DBMS_DELETE_TABLE_PREFS, "DELETE_TABLE_PREFS", (ObDbmsStats::delete_table_prefs))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_GATHER_INDEX_STATS, "GATHER_INDEX_STATS", (ObDbmsStats::gather_index_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_DELETE_INDEX_STATS, "DELETE_INDEX_STATS", (ObDbmsStats::delete_index_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_SET_INDEX_STATS, "SET_INDEX_STATS", (ObDbmsStats::set_index_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_EXPORT_INDEX_STATS, "EXPORT_INDEX_STATS", (ObDbmsStats::export_index_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_IMPORT_INDEX_STATS, "IMPORT_INDEX_STATS", (ObDbmsStats::import_index_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_COPY_TABLE_STATS, "COPY_TABLE_STATS", (ObDbmsStats::copy_table_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_CNACEL_GATHER_STATS, "CANCEL_GATHER_STATS", (ObDbmsStats::cancel_gather_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_GATHER_SYSTEM_STATS, "GATHER_SYSTEM_STATS", (ObDbmsStats::gather_system_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_DELETE_SYSTEM_STATS, "DELETE_SYSTEM_STATS", (ObDbmsStats::delete_system_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_SET_SYSTEM_STATS, "SET_SYSTEM_STATS", (ObDbmsStats::set_system_stats))
  INTERFACE_DEF(INTERFACE_DBMS_STATS_ASYNC_GATHER_STATS_JOB_PROC, "ASYNC_GATHER_STATS_JOB_PROC", (ObDbmsStats::async_gather_stats_job_proc))
  //end of dbms_stat

  //start of dbms xplan
  INTERFACE_DEF(INTERFACE_DBMS_XPLAN_ENABLE_OPT_TRACE, "ENABLE_OPT_TRACE", (ObDbmsXplan::enable_opt_trace))
  INTERFACE_DEF(INTERFACE_DBMS_XPLAN_DISABLE_OPT_TRACE, "DISABLE_OPT_TRACE", (ObDbmsXplan::disable_opt_trace))
  INTERFACE_DEF(INTERFACE_DBMS_XPLAN_SET_OPT_TRACE_PARAMETER, "SET_OPT_TRACE_PARAMETER", (ObDbmsXplan::set_opt_trace_parameter))
  INTERFACE_DEF(INTERFACE_DBMS_XPLAN_DISPLAY, "DISPLAY", (ObDbmsXplan::display))
  INTERFACE_DEF(INTERFACE_DBMS_XPLAN_DISPLAY_CURSOR, "DISPLAY_CURSOR", (ObDbmsXplan::display_cursor))
  INTERFACE_DEF(INTERFACE_DBMS_XPLAN_DISPLAY_SQL_PLAN_BASELINE, "DISPLAY_SQL_PLAN_BASELINE", (ObDbmsXplan::display_sql_plan_baseline))
  INTERFACE_DEF(INTERFACE_DBMS_XPLAN_DISPLAY_ACTIVE_SESSION_PLAN, "DISPLAY_ACTIVE_SESSION_PLAN", (ObDbmsXplan::display_active_session_plan))
  //end of dbms xplan

#ifdef OB_BUILD_ORACLE_PL

  // start of oracle label security
  // sysdba
  INTERFACE_DEF(INTERFACE_SA_SYSDBA_ALTER_POLICY, "SA_SYSDBA_ALTER_POLICY", (ObSASysdba::alter_policy))
  INTERFACE_DEF(INTERFACE_SA_SYSDBA_CREATE_POLICY, "SA_SYSDBA_CREATE_POLICY", (ObSASysdba::create_policy))
  INTERFACE_DEF(INTERFACE_SA_SYSDBA_ENABLE_POLICY, "SA_SYSDBA_ENABLE_POLICY", (ObSASysdba::enable_policy))
  INTERFACE_DEF(INTERFACE_SA_SYSDBA_DROP_POLICY, "SA_SYSDBA_DROP_POLICY", (ObSASysdba::drop_policy))
  INTERFACE_DEF(INTERFACE_SA_SYSDBA_DISABLE_POLICY, "SA_SYSDBA_DISABLE_POLICY", (ObSASysdba::disable_policy))

  //session
  //INTERFACE_DEF(INTERFACE_SA_SESSION_LABEL, "SA_SESSION_LABEL", (ObSASession::label))
  INTERFACE_DEF(INTERFACE_SA_SESSION_RESTORE_DEFAULT_LABELS, "SA_SESSION_RESTORE_DEFAULT_LABELS", (ObSASession::restore_default_labels))
  //INTERFACE_DEF(INTERFACE_SA_SESSION_ROW_LABEL, "SA_SESSION_ROW_LABEL", (ObSASession::row_label))
  INTERFACE_DEF(INTERFACE_SA_SESSION_SET_LABEL, "SA_SESSION_SET_LABEL", (ObSASession::set_label))
  INTERFACE_DEF(INTERFACE_SA_SESSION_SET_ROW_LABEL, "SA_SESSION_SET_ROW_LABEL", (ObSASession::set_row_label))

  //user admin
  INTERFACE_DEF(INTERFACE_SA_USER_ADMIN_SET_LEVELS, "SA_USER_ADMIN_SET_LEVELS", (ObSAUserAdmin::set_levels))

  //policy admin
  INTERFACE_DEF(INTERFACE_SA_POLICY_ADMIN_APPLY_TABLE_POLICY, "SA_POLICY_ADMIN_APPLY_TABLE_POLICY", (ObSAPolicyAdmin::apply_table_policy))
  INTERFACE_DEF(INTERFACE_SA_POLICY_ADMIN_DISABLE_TABLE_POLICY, "SA_POLICY_ADMIN_DISABLE_TABLE_POLICY", (ObSAPolicyAdmin::disable_table_policy))
  INTERFACE_DEF(INTERFACE_SA_POLICY_ADMIN_REMOVE_TABLE_POLICY, "SA_POLICY_ADMIN_REMOVE_TABLE_POLICY", (ObSAPolicyAdmin::remove_table_policy))
  INTERFACE_DEF(INTERFACE_SA_POLICY_ADMIN_ENABLE_TABLE_POLICY, "SA_POLICY_ADMIN_ENABLE_TABLE_POLICY", (ObSAPolicyAdmin::enable_table_policy))

  //label admin
  INTERFACE_DEF(INTERFACE_SA_LABEL_ADMIN_CRETAE_LABEL, "SA_LABEL_ADMIN_CRETAE_LABEL", (ObSALabelAdmin::create_label))
  INTERFACE_DEF(INTERFACE_SA_LABEL_ADMIN_ALTER_LABEL, "SA_LABEL_ADMIN_ALTER_LABEL", (ObSALabelAdmin::alter_label))
  INTERFACE_DEF(INTERFACE_SA_LABEL_ADMIN_DROP_LABEL, "SA_LABEL_ADMIN_DROP_LABEL", (ObSALabelAdmin::drop_label))

  //components
  INTERFACE_DEF(INTERFACE_SA_COMPONENTS_CREATE_LEVEL, "SA_COMPONENTS_CREATE_LEVEL", (ObSAComponents::create_level))
  INTERFACE_DEF(INTERFACE_SA_COMPONENTS_ALTER_LEVEL, "SA_COMPONENTS_ALTER_LEVEL", (ObSAComponents::alter_level))
  INTERFACE_DEF(INTERFACE_SA_COMPONENTS_DROP_LEVEL, "SA_COMPONENTS_DROP_LEVEL", (ObSAComponents::drop_level))
  // end of oracle label security

  //start of anytype
#define DEFINE_ANYTYPE_INTERFACE(symbol, func) \
  INTERFACE_DEF(INTERFACE_DBMS_ANYTYPE_##symbol, #symbol, (func))

  DEFINE_ANYTYPE_INTERFACE(BEGINCREATE_ANYTYPE, ObDBMSAnyType::begincreate)
  DEFINE_ANYTYPE_INTERFACE(SETINFO, ObDBMSAnyType::setinfo)
  DEFINE_ANYTYPE_INTERFACE(ADDATTR, ObDBMSAnyType::addattr)
  DEFINE_ANYTYPE_INTERFACE(ENDCREATE_ANYTYPE, ObDBMSAnyType::endcreate)
  DEFINE_ANYTYPE_INTERFACE(GETPERSISTENT, ObDBMSAnyType::getpersistent)
  DEFINE_ANYTYPE_INTERFACE(GETINFO, ObDBMSAnyType::getinfo)
  DEFINE_ANYTYPE_INTERFACE(GETATTRELEMINFO, ObDBMSAnyType::getattreleminfo)

#undef DEFINE_ANYTYPE_INTERFACE
  //end of anytype

  //start of anydata
#define PREFIX INTERFACE_DBMS_ANYDATA_
#define DEFINE_ANYDATA_INTERFACE(symbol, func) \
  INTERFACE_DEF(PREFIX##symbol, #symbol, (func))
#define DEFINE_ANYDATA_INTERFACE_WITH_TYPE(symbol, func) \
  DEFINE_ANYDATA_INTERFACE(symbol##NUMBER, func##number) \
  DEFINE_ANYDATA_INTERFACE(symbol##DATE, func##date) \
  DEFINE_ANYDATA_INTERFACE(symbol##CHAR, func##char) \
  DEFINE_ANYDATA_INTERFACE(symbol##VARCHAR, func##varchar) \
  DEFINE_ANYDATA_INTERFACE(symbol##VARCHAR2, func##varchar2) \
  DEFINE_ANYDATA_INTERFACE(symbol##RAW, func##raw) \
  DEFINE_ANYDATA_INTERFACE(symbol##BLOB, func##blob) \
  DEFINE_ANYDATA_INTERFACE(symbol##CLOB, func##clob) \
  DEFINE_ANYDATA_INTERFACE(symbol##BFILE, func##bfile) \
  DEFINE_ANYDATA_INTERFACE(symbol##OBJECT, func##object) \
  DEFINE_ANYDATA_INTERFACE(symbol##COLLECTION, func##collection) \
  DEFINE_ANYDATA_INTERFACE(symbol##TIMESTAMP, func##timestamp) \
  DEFINE_ANYDATA_INTERFACE(symbol##TIMESTAMPTZ, func##timestamptz) \
  DEFINE_ANYDATA_INTERFACE(symbol##TIMESTAMPLTZ, func##timestampltz) \
  DEFINE_ANYDATA_INTERFACE(symbol##INTERVALYM, func##intervalym) \
  DEFINE_ANYDATA_INTERFACE(symbol##INTERVALDS, func##intervalds) \
  DEFINE_ANYDATA_INTERFACE(symbol##NCHAR, func##nchar) \
  DEFINE_ANYDATA_INTERFACE(symbol##NVARCHAR2, func##nvarchar2) \
  DEFINE_ANYDATA_INTERFACE(symbol##NCLOB, func##nclob) \
  DEFINE_ANYDATA_INTERFACE(symbol##BFLOAT, func##bfloat) \
  DEFINE_ANYDATA_INTERFACE(symbol##BDOUBLE, func##bdouble) \
  DEFINE_ANYDATA_INTERFACE(symbol##UROWID, func##urowid)

  DEFINE_ANYDATA_INTERFACE_WITH_TYPE(CONVERT, ObDBMSAnyData::convert)
  DEFINE_ANYDATA_INTERFACE_WITH_TYPE(ACCESS, ObDBMSAnyData::access)
  DEFINE_ANYDATA_INTERFACE_WITH_TYPE(GET, ObDBMSAnyData::get)
  DEFINE_ANYDATA_INTERFACE_WITH_TYPE(SET, ObDBMSAnyData::set)
  DEFINE_ANYDATA_INTERFACE(BEGINCREATE_ANYDATA, ObDBMSAnyData::begincreate)
  DEFINE_ANYDATA_INTERFACE(ENDCREATE_ANYDATA, ObDBMSAnyData::endcreate)
  DEFINE_ANYDATA_INTERFACE(GETTYPE, ObDBMSAnyData::gettype)
  DEFINE_ANYDATA_INTERFACE(GETTYPENAME, ObDBMSAnyData::gettypename)
  DEFINE_ANYDATA_INTERFACE(PIECEWISE, ObDBMSAnyData::piecewise)

#undef DEFINE_ANYDATA_INTERFACE_WITH_TYPE
#undef DEFINE_ANYDATA_INTERFACE
#undef PREFIX
  //end of anydata

  //start of sdo_geometry
  INTERFACE_DEF(INTERFACE_SDO_GEOMETRY_GET_WKB, "SDO_GEOMETRY_GET_WKB", (ObSdoGeometry::get_wkb))
  INTERFACE_DEF(INTERFACE_SDO_GEOMETRY_GET_WKT, "SDO_GEOMETRY_GET_WKT", (ObSdoGeometry::get_wkt))
  INTERFACE_DEF(INTERFACE_SDO_GEOMETRY_GET_GTYPE, "SDO_GEOMETRY_GET_GTYPE", (ObSdoGeometry::get_gtype))
  INTERFACE_DEF(INTERFACE_SDO_GEOMETRY_GET_DIMS, "SDO_GEOMETRY_GET_DIMS", (ObSdoGeometry::get_dims))
  INTERFACE_DEF(INTERFACE_SDO_GEOMETRY_ST_COORDDIM, "SDO_GEOMETRY_ST_COORDDIM", (ObSdoGeometry::st_coorddim))
  INTERFACE_DEF(INTERFACE_SDO_GEOMETRY_ST_ISVALID, "SDO_GEOMETRY_ST_ISVALID", (ObSdoGeometry::st_isvalid))
  INTERFACE_DEF(INTERFACE_SDO_GEOMETRY_CONSTRUCTOR, "SDO_GEOMETRY_CONSTRUCTOR", (ObSdoGeometry::constructor))
  INTERFACE_DEF(INTERFACE_SDO_GEOMETRY_GET_GEOJSON, "SDO_GEOMETRY_GET_GEOJSON", (ObSdoGeometry::get_geojson))
  //end of sdo_geometry

  //start of sdo_geom
  INTERFACE_DEF(INTERFACE_SDO_GEOM_DISTANCE, "SDO_GEOM_DISTANCE", (ObSdoGeom::sdo_distance))
  //end of sdo_geom

  //start of xmltype
  INTERFACE_DEF(INTERFACE_XML_TYPE_TRANSFORM, "XML_TYPE_TRANSFORM", (ObXmlType::transform))
  INTERFACE_DEF(INTERFACE_XML_TYPE_GETCLOBVAL, "XML_TYPE_GETCLOBVAL", (ObXmlType::getclobval))
  INTERFACE_DEF(INTERFACE_XML_TYPE_GETSTRINGVAL, "XML_TYPE_GETSTRINGVAL", (ObXmlType::getstringval))
  INTERFACE_DEF(INTERFACE_XML_TYPE_EXISTSNODE, "XML_TYPE_EXISTSNODE", (ObXmlType::existsnode))
  INTERFACE_DEF(INTERFACE_XML_TYPE_EXTRACT, "XML_TYPE_EXTRACT", (ObXmlType::extract))
  INTERFACE_DEF(INTERFACE_XML_TYPE_CREATEXML, "XML_TYPE_CREATEXML", (ObXmlType::createxml))
  INTERFACE_DEF(INTERFACE_XML_TYPE_CONSTRUCTOR, "XML_TYPE_CONSTRUCTOR", (ObXmlType::constructor))
  //end of xmltype

  //start of dbms_xmlgen
  INTERFACE_DEF(INTERFACE_DBMS_XMLGEN_CONVERT, "DBMS_XMLGEN_CONVERT", (ObDbmsXmlGen::convert))
  //end of dbms_xmlgen

  //start of dbms_crypto
  INTERFACE_DEF(INTERFACE_DBMS_CRYPTO_ENCRYPT, "DBMS_CRYPTO_ENCRYPT", (ObDbmsCrypto::encrypt))
  INTERFACE_DEF(INTERFACE_DBMS_CRYPTO_DECRYPT, "DBMS_CRYPTO_DECRYPT", (ObDbmsCrypto::decrypt))
  INTERFACE_DEF(INTERFACE_DBMS_CRYPTO_HASH, "DBMS_CRYPTO_HASH", (ObDbmsCrypto::hash))
  //end of dbms_crypto

  //start of dbms_job
#define DEFINE_DBMS_JOB_INTERFACE(symbol, func) \
  INTERFACE_DEF(INTERFACE_##symbol, #symbol, (func))

  DEFINE_DBMS_JOB_INTERFACE(DBMS_JOB_SUBMIT, ObDBMSJob::submit)
  DEFINE_DBMS_JOB_INTERFACE(DBMS_JOB_REMOVE, ObDBMSJob::remove)
  DEFINE_DBMS_JOB_INTERFACE(DBMS_JOB_RUN, ObDBMSJob::run)
  DEFINE_DBMS_JOB_INTERFACE(DBMS_JOB_SET_AFFINITY, ObDBMSJob::set_affinity)
  DEFINE_DBMS_JOB_INTERFACE(DBMS_JOB_SET_WHAT, ObDBMSJob::set_what)
  DEFINE_DBMS_JOB_INTERFACE(DBMS_JOB_SET_NEXTDATE, ObDBMSJob::set_nextdate)
  DEFINE_DBMS_JOB_INTERFACE(DBMS_JOB_SET_INTERVAL, ObDBMSJob::set_interval)
  DEFINE_DBMS_JOB_INTERFACE(DBMS_JOB_SET_FLAG, ObDBMSJob::set_flag)
  DEFINE_DBMS_JOB_INTERFACE(DBMS_JOB_ZONE_CHECK, ObDBMSJob::zone_check)

#undef DEFINE_DBMS_JOB_INTERFACE
  //end of dbms_job

  //start of dbms_scheduler
#define DEFINE_DBMS_SCHEDULER_INTERFACE(symbol, func) \
  INTERFACE_DEF(INTERFACE_##symbol, #symbol, (func))

  DEFINE_DBMS_SCHEDULER_INTERFACE(DBMS_SCHEDULER_CREATE_JOB, ObDBMSScheduler::create_job)
  DEFINE_DBMS_SCHEDULER_INTERFACE(DBMS_SCHEDULER_DROP_JOB, ObDBMSScheduler::drop_job)
  DEFINE_DBMS_SCHEDULER_INTERFACE(DBMS_SCHEDULER_RUN_JOB, ObDBMSScheduler::run_job)
  DEFINE_DBMS_SCHEDULER_INTERFACE(DBMS_SCHEDULER_STOP_JOB, ObDBMSScheduler::stop_job)
  DEFINE_DBMS_SCHEDULER_INTERFACE(DBMS_SCHEDULER_GENERATE_JOB_NAME, ObDBMSScheduler::generate_job_name)
  DEFINE_DBMS_SCHEDULER_INTERFACE(DBMS_SCHEDULER_SET_JOB_ATTRIBUTE, ObDBMSScheduler::set_job_attribute)
  DEFINE_DBMS_SCHEDULER_INTERFACE(DBMS_SCHEDULER_DISABLE, ObDBMSScheduler::disable)
  DEFINE_DBMS_SCHEDULER_INTERFACE(DBMS_SCHEDULER_CREATE_PROGRAM, ObDBMSScheduler::create_program)
  DEFINE_DBMS_SCHEDULER_INTERFACE(DBMS_SCHEDULER_DEFINE_PROGRAM_ARGUMENT, ObDBMSScheduler::define_program_argument)
  DEFINE_DBMS_SCHEDULER_INTERFACE(DBMS_SCHEDULER_ENABLE, ObDBMSScheduler::enable)
  DEFINE_DBMS_SCHEDULER_INTERFACE(DBMS_SCHEDULER_DROP_PROGRAM, ObDBMSScheduler::drop_program)
  DEFINE_DBMS_SCHEDULER_INTERFACE(DBMS_SCHEDULER_CREATE_JOB_CLASS, ObDBMSScheduler::create_job_class)
  DEFINE_DBMS_SCHEDULER_INTERFACE(DBMS_SCHEDULER_DROP_JOB_CLASS, ObDBMSScheduler::drop_job_class)
  DEFINE_DBMS_SCHEDULER_INTERFACE(DBMS_SCHEDULER_SET_JOB_CLASS_ATTRIBUTE, ObDBMSScheduler::set_job_class_attribute)
  DEFINE_DBMS_SCHEDULER_INTERFACE(DBMS_SCHEDULER_PURGE_LOG, ObDBMSScheduler::purge_log)
  DEFINE_DBMS_SCHEDULER_INTERFACE(DBMS_SCHEDULER_GET_AND_INCREASE_JOB_ID, ObDBMSScheduler::get_and_increase_job_id)

#undef DEFINE_DBMS_SCHEDULER_INTERFACE
  //end of dbms_scheduler
#endif

  //start of dbms_scheduler_mysql
#define DEFINE_DBMS_SCHEDULER_MYSQL_INTERFACE(symbol, func) \
  INTERFACE_DEF(INTERFACE_##symbol, #symbol, (func))

  DEFINE_DBMS_SCHEDULER_MYSQL_INTERFACE(DBMS_SCHEDULER_MYSQL_DISABLE, ObDBMSSchedulerMysql::disable)
  DEFINE_DBMS_SCHEDULER_MYSQL_INTERFACE(DBMS_SCHEDULER_MYSQL_ENABLE, ObDBMSSchedulerMysql::enable)
  DEFINE_DBMS_SCHEDULER_MYSQL_INTERFACE(DBMS_SCHEDULER_MYSQL_SET_ATTRIBUTE, ObDBMSSchedulerMysql::set_attribute)
  DEFINE_DBMS_SCHEDULER_MYSQL_INTERFACE(DBMS_SCHEDULER_MYSQL_GET_AND_INCREASE_JOB_ID, ObDBMSSchedulerMysql::get_and_increase_job_id)

#undef DEFINE_DBMS_SCHEDULER_MYSQL_INTERFACE
  //end of dbms_scheduler_mysql

#ifdef OB_BUILD_ORACLE_PL
  //start of utl_file
  INTERFACE_DEF(INTERFACE_UTL_FILE_FOPEN, "UTL_FILE_FOPEN", (ObPLUtlFile::fopen))
  INTERFACE_DEF(INTERFACE_UTL_FILE_FCLOSE, "UTL_FILE_FCLOSE", (ObPLUtlFile::fclose))
  INTERFACE_DEF(INTERFACE_UTL_FILE_GET_LINE, "UTL_FILE_GET_LINE", (ObPLUtlFile::get_line))
  INTERFACE_DEF(INTERFACE_UTL_FILE_GET_LINE_RAW, "UTL_FILE_GET_LINE_RAW", (ObPLUtlFile::get_line_raw))
  INTERFACE_DEF(INTERFACE_UTL_FILE_PUT_BUFFER, "UTL_FILE_PUT_BUFFER", (ObPLUtlFile::put_buffer))
  INTERFACE_DEF(INTERFACE_UTL_FILE_FFLUSH, "UTL_FILE_FFLUSH", (ObPLUtlFile::fflush))
  INTERFACE_DEF(INTERFACE_UTL_FILE_FOPEN_NCHAR, "UTL_FILE_FOPEN_NCHAR", (ObPLUtlFile::fopen_nchar))
  INTERFACE_DEF(INTERFACE_UTL_FILE_PUT_RAW, "UTL_FILE_PUT_RAW", (ObPLUtlFile::put_raw))
  INTERFACE_DEF(INTERFACE_UTL_FILE_FSEEK, "UTL_FILE_FSEEK", (ObPLUtlFile::fseek))
  INTERFACE_DEF(INTERFACE_UTL_FILE_FREMOVE, "UTL_FILE_FREMOVE", (ObPLUtlFile::fremove))
  INTERFACE_DEF(INTERFACE_UTL_FILE_FCOPY, "UTL_FILE_FCOPY", (ObPLUtlFile::fcopy))
  INTERFACE_DEF(INTERFACE_UTL_FILE_FGETATTR, "UTL_FILE_FGETATTR", (ObPLUtlFile::fgetattr))
  INTERFACE_DEF(INTERFACE_UTL_FILE_FGETPOS, "UTL_FILE_FGETPOS", (ObPLUtlFile::fgetpos))
  INTERFACE_DEF(INTERFACE_UTL_FILE_FRENAME, "UTL_FILE_FRENAME", (ObPLUtlFile::frename))
  INTERFACE_DEF(INTERFACE_UTL_FILE_FIS_OPEN, "UTL_FILE_FIS_OPEN", (ObPLUtlFile::fis_open))
  //end of utl_file

  //start of utl_tcp
  INTERFACE_DEF(INTERFACE_UTL_TCP_OPEN_CONNECTION, "UTL_TCP_OPEN_CONNECTION", (ObPLUtlTcp::open_connection))
  INTERFACE_DEF(INTERFACE_UTL_TCP_CLOSE_CONNECTION, "UTL_TCP_CLOSE_CONNECTION", (ObPLUtlTcp::close_connection))
  INTERFACE_DEF(INTERFACE_UTL_TCP_CLOSE_ALL_CONNECTIONS, "UTL_TCP_CLOSE_ALL_CONNECTIONS", (ObPLUtlTcp::close_all_connections))
  INTERFACE_DEF(INTERFACE_UTL_TCP_WRITE_LINE, "UTL_TCP_WRITE_LINE", (ObPLUtlTcp::write_line))
  INTERFACE_DEF(INTERFACE_UTL_TCP_WRITE_TEXT, "UTL_TCP_WRITE_TEXT", (ObPLUtlTcp::write_text))
  INTERFACE_DEF(INTERFACE_UTL_TCP_WRITE_RAW, "UTL_TCP_WRITE_RAW", (ObPLUtlTcp::write_raw))
  INTERFACE_DEF(INTERFACE_UTL_TCP_READ_LINE, "UTL_TCP_READ_LINE", (ObPLUtlTcp::read_line))
  INTERFACE_DEF(INTERFACE_UTL_TCP_READ_TEXT, "UTL_TCP_READ_TEXT", (ObPLUtlTcp::read_text))

  //start of utl_smtp
  INTERFACE_DEF(INTERFACE_UTL_SMTP_RAISE, "UTL_SMTP_RAISE", (ObPLUtlSmtp::raise))
  INTERFACE_DEF(INTERFACE_UTL_SMTP_ESCAPE_DOT, "UTL_SMTP_ESCAPE_DOT", (ObPLUtlSmtp::escape_dot))

  //start of dbms_sys_error
  // begin (to maintain compatibility during upgrading from 4.2.5.0 to 4.2.5.1)
  INTERFACE_DEF(INTERFACE_SYS_ERROR_KKXERE0, "KKXERE0", (ObDBMSSysError::ere0))
  INTERFACE_DEF(INTERFACE_SYS_ERROR_KKXERE1, "KKXERE1", (ObDBMSSysError::ere1))
  INTERFACE_DEF(INTERFACE_SYS_ERROR_KKXERE2, "KKXERE2", (ObDBMSSysError::ere2))
  INTERFACE_DEF(INTERFACE_SYS_ERROR_KKXERE3, "KKXERE3", (ObDBMSSysError::ere3))
  INTERFACE_DEF(INTERFACE_SYS_ERROR_KKXERE4, "KKXERE4", (ObDBMSSysError::ere4))
  INTERFACE_DEF(INTERFACE_SYS_ERROR_KKXERE5, "KKXERE5", (ObDBMSSysError::ere5))
  INTERFACE_DEF(INTERFACE_SYS_ERROR_KKXERE6, "KKXERE6", (ObDBMSSysError::ere6))
  INTERFACE_DEF(INTERFACE_SYS_ERROR_KKXERE7, "KKXERE7", (ObDBMSSysError::ere7))
  INTERFACE_DEF(INTERFACE_SYS_ERROR_KKXERE8, "KKXERE8", (ObDBMSSysError::ere8))
  // end
  INTERFACE_DEF(INTERFACE_SYS_ERROR0_IMPL, "SYS_ERR0_IMPL", (ObDBMSSysError::ere0))
  INTERFACE_DEF(INTERFACE_SYS_ERROR1_IMPL, "SYS_ERR1_IMPL", (ObDBMSSysError::ere1))
  INTERFACE_DEF(INTERFACE_SYS_ERROR2_IMPL, "SYS_ERR2_IMPL", (ObDBMSSysError::ere2))
  INTERFACE_DEF(INTERFACE_SYS_ERROR3_IMPL, "SYS_ERR3_IMPL", (ObDBMSSysError::ere3))
  INTERFACE_DEF(INTERFACE_SYS_ERROR4_IMPL, "SYS_ERR4_IMPL", (ObDBMSSysError::ere4))
  INTERFACE_DEF(INTERFACE_SYS_ERROR5_IMPL, "SYS_ERR5_IMPL", (ObDBMSSysError::ere5))
  INTERFACE_DEF(INTERFACE_SYS_ERROR6_IMPL, "SYS_ERR6_IMPL", (ObDBMSSysError::ere6))
  INTERFACE_DEF(INTERFACE_SYS_ERROR7_IMPL, "SYS_ERR7_IMPL", (ObDBMSSysError::ere7))
  INTERFACE_DEF(INTERFACE_SYS_ERROR8_IMPL, "SYS_ERR8_IMPL", (ObDBMSSysError::ere8))
  //end of dbms_sys_error

  // start of dbms_preprocessor
  // begin (to maintain compatibility during upgrading from 4.2.5.0 to 4.2.5.1)
  INTERFACE_DEF(INTERFACE_PREPROCESSOR_KKXCCG1, "KKXCCG1", (ObDBMSPreprocessor::kkxccg1))
  INTERFACE_DEF(INTERFACE_PREPROCESSOR_KKXCCG2, "KKXCCG2", (ObDBMSPreprocessor::kkxccg2))
  INTERFACE_DEF(INTERFACE_PREPROCESSOR_KKXCCG3, "KKXCCG3", (ObDBMSPreprocessor::kkxccg3))
  // end
  INTERFACE_DEF(INTERFACE_PREPROCESSOR_GET_PP_SOURCE_I1, "GET_PP_SOURCE_I1", (ObDBMSPreprocessor::kkxccg1))
  INTERFACE_DEF(INTERFACE_PREPROCESSOR_GET_PP_SOURCE_I2, "GET_PP_SOURCE_I2", (ObDBMSPreprocessor::kkxccg2))
  INTERFACE_DEF(INTERFACE_PREPROCESSOR_GET_PP_SOURCE_I3, "GET_PP_SOURCE_I3", (ObDBMSPreprocessor::kkxccg3))
  // end of dbms_preprocessor
#endif

#ifdef OB_BUILD_SPM
  // start of dbms_spm
  INTERFACE_DEF(INTERFACE_DBMS_SPM_ACCEPT_SQL_PLAN_BASELINE, "ACCEPT_SQL_PLAN_BASELINE", (ObDBMSSpm::accept_baseline))
  INTERFACE_DEF(INTERFACE_DBMS_SPM_ALTER_SQL_PLAN_BASELINE, "ALTER_SQL_PLAN_BASELINE", (ObDBMSSpm::alter_baseline))
  INTERFACE_DEF(INTERFACE_DBMS_SPM_CANCEL_EVOLVE_TASK, "CANCEL_EVOLVE_TASK", (ObDBMSSpm::cancel_evolve_task))
  INTERFACE_DEF(INTERFACE_DBMS_SPM_CONFIGURE, "CONFIGURE", (ObDBMSSpm::configure))
  INTERFACE_DEF(INTERFACE_DBMS_SPM_DROP_SQL_PLAN_BASELINE, "DROP_SQL_PLAN_BASELINE", (ObDBMSSpm::drop_baseline))
  INTERFACE_DEF(INTERFACE_DBMS_SPM_BATCH_DROP_SQL_PLAN_BASELINE, "BATCH_DROP_SQL_PLAN_BASELINE", (ObDBMSSpm::batch_drop_baseline))
  INTERFACE_DEF(INTERFACE_DBMS_SPM_LOAD_PLANS_FROM_CURSOR_CACHE, "LOAD_PLANS_FROM_CURSOR_CACHE", (ObDBMSSpm::load_plans_from_cursor_cache))
  INTERFACE_DEF(INTERFACE_DBMS_SPM_BATCH_LOAD_PLANS_FROM_CURSOR_CACHE, "BATCH_LOAD_PLANS_FROM_CURSOR_CACHE", (ObDBMSSpm::batch_load_plans_from_cursor_cache))
  INTERFACE_DEF(INTERFACE_DBMS_SPM_AUTO_PURGE_SQL_PLAN_BASELINE, "AUTO_PURGE_SQL_PLAN_BASELINE", (ObDBMSSpm::auto_purge_sql_plan_baseline))
  INTERFACE_DEF(INTERFACE_DBMS_SPM_UNPACK_STGTAB_BASELINE, "UNPACK_STGTAB_BASELINE", (ObDBMSSpm::unpack_table_baseline))
  INTERFACE_DEF(INTERFACE_DBMS_SPM_PACK_CSV_BASELINE, "PACK_CSV_BASELINE", (ObDBMSSpm::pack_csv_baseline))
  INTERFACE_DEF(INTERFACE_DBMS_SPM_UNPACK_CSV_BASELINE, "UNPACK_CSV_BASELINE", (ObDBMSSpm::unpack_csv_baseline))
  INTERFACE_DEF(INTERFACE_DBMS_SPM_HANDLE_SPM_STATS_JOB_PROC, "HANDLE_SPM_STATS_JOB_PROC", (ObDBMSSpm::handle_spm_stats_job_proc))
  // end of dbms_spm
#endif

#ifdef OB_BUILD_ORACLE_PL
  // start of dbms_audit_mgmt
  INTERFACE_DEF(INTERFACE_DBMS_AUDIT_MGMT_CLEAN_TRAIL, "CLEAN_AUDIT_TRAIL", (ObDbmsAuditMgmt::clean_audit_trail))
  INTERFACE_DEF(INTERFACE_DBMS_AUDIT_MGMT_SET_ARCH_TS, "SET_LAST_ARCH_TS", (ObDbmsAuditMgmt::update_last_arch_ts_info))
  INTERFACE_DEF(INTERFACE_DBMS_AUDIT_MGMT_DEL_ARCH_TS, "DEL_LAST_ARCH_TS", (ObDbmsAuditMgmt::delete_last_arch_ts_info))
  INTERFACE_DEF(INTERFACE_DBMS_AUDIT_MGMT_UPDATE_JOB_INFO, "UPDATE_JOB_INFO", (ObDbmsAuditMgmt::update_clean_job_info))
  INTERFACE_DEF(INTERFACE_DBMS_AUDIT_MGMT_UPDATE_JOB_INTERVAL, "UPDATE_JOB_INTERVAL", (ObDbmsAuditMgmt::update_job_interval_oracle))
  INTERFACE_DEF(INTERFACE_DBMS_AUDIT_MGMT_UPDATE_JOB_STATUS, "UPDATE_JOB_STATUS", (ObDbmsAuditMgmt::set_purge_job_status_oracle))
  INTERFACE_DEF(INTERFACE_DBMS_AUDIT_MGMT_DROP_CLEANUP_JOB, "DROP_PURGE_JOB", (ObDbmsAuditMgmt::drop_purge_job_oracle))
  // end of dbms_audit_mgmt
#endif

  // start of dbms_session
  INTERFACE_DEF(INTERFACE_DBMS_SESSION_CLEAR_ALL_CONTEXT, "CLEAR_ALL_CONTEXT", (ObDBMSSession::clear_all_context))
  INTERFACE_DEF(INTERFACE_DBMS_SESSION_CLEAR_CONTEXT, "CLEAR_CONTEXT", (ObDBMSSession::clear_context))
  INTERFACE_DEF(INTERFACE_DBMS_SESSION_CLEAR_IDENTIFIER, "CLEAR_IDENTIFIER", (ObDBMSSession::clear_identifier))
  INTERFACE_DEF(INTERFACE_DBMS_SESSION_SET_CONTEXT, "SET_CONTEXT", (ObDBMSSession::set_context))
  INTERFACE_DEF(INTERFACE_DBMS_SESSION_SET_IDENTIFIER, "SET_IDENTIFIER", (ObDBMSSession::set_identifier))
  INTERFACE_DEF(INTERFACE_DBMS_SESSION_RESET_PACKAGE, "RESET_PACKAGE", (ObDBMSSession::reset_package))
  // end of dbms_session

  // start of dbms_space
  INTERFACE_DEF(INTERFACE_DBMS_SPACE_CREATE_INDEX_COST, "CREATE_INDEX_COST", (ObDbmsSpace::create_index_cost))
  // end of dbms_space

#ifdef OB_BUILD_ORACLE_PL
  // start of dbms_rls
  INTERFACE_DEF(INTERFACE_RLS_ADD_GROUPED_POLICY, "RLS_ADD_GROUPED_POLICY", (ObDBMSRls::add_grouped_policy))
  INTERFACE_DEF(INTERFACE_RLS_ADD_POLICY, "RLS_ADD_POLICY", (ObDBMSRls::add_policy))
  INTERFACE_DEF(INTERFACE_RLS_ADD_POLICY_CONTEXT, "RLS_ADD_POLICY_CONTEXT", (ObDBMSRls::add_policy_context))
  INTERFACE_DEF(INTERFACE_RLS_ALTER_POLICY, "RLS_ALTER_POLICY", (ObDBMSRls::alter_policy))
  INTERFACE_DEF(INTERFACE_RLS_ALTER_GROUPED_POLICY, "RLS_ALTER_GROUPED_POLICY", (ObDBMSRls::alter_grouped_policy))
  INTERFACE_DEF(INTERFACE_RLS_CREATE_POLICY_GROUP, "RLS_CREATE_POLICY_GROUP", (ObDBMSRls::create_policy_group))
  INTERFACE_DEF(INTERFACE_RLS_DELETE_POLICY_GROUP, "RLS_DELETE_POLICY_GROUP", (ObDBMSRls::delete_policy_group))
  INTERFACE_DEF(INTERFACE_RLS_DISABLE_GROUPED_POLICY, "RLS_DISABLE_GROUPED_POLICY", (ObDBMSRls::disable_grouped_policy))
  INTERFACE_DEF(INTERFACE_RLS_DROP_GROUPED_POLICY, "RLS_DROP_GROUPED_POLICY", (ObDBMSRls::drop_grouped_policy))
  INTERFACE_DEF(INTERFACE_RLS_DROP_POLICY, "RLS_DROP_POLICY", (ObDBMSRls::drop_policy))
  INTERFACE_DEF(INTERFACE_RLS_DROP_POLICY_CONTEXT, "RLS_DROP_POLICY_CONTEXT", (ObDBMSRls::drop_policy_context))
  INTERFACE_DEF(INTERFACE_RLS_ENABLE_GROUPED_POLICY, "RLS_ENABLE_GROUPED_POLICY", (ObDBMSRls::enable_grouped_policy))
  INTERFACE_DEF(INTERFACE_RLS_ENABLE_POLICY, "RLS_ENABLE_POLICY", (ObDBMSRls::enable_policy))
  INTERFACE_DEF(INTERFACE_RLS_REFRESH_GROUPED_POLICY, "RLS_REFRESH_GROUPED_POLICY", (ObDBMSRls::refresh_grouped_policy))
  INTERFACE_DEF(INTERFACE_RLS_REFRESH_POLICY, "RLS_REFRESH_POLICY", (ObDBMSRls::refresh_policy))
  // end of dbms_rls

  // start of json_element_t
  INTERFACE_DEF(INTERFACE_JSON_ELEMENT_ON_ERROR, "JSON_ELEMENT_ON_ERROR", (ObPlJsonElement::set_on_error))
  INTERFACE_DEF(INTERFACE_JSON_ELEMENT_PARSE, "JSON_ELEMENT_PARSE", (ObPlJsonElement::parse))
  INTERFACE_DEF(INTERFACE_JSON_IS_ARRAY, "JSON_IS_ARRAY", (ObPlJsonElement::is_array))
  INTERFACE_DEF(INTERFACE_JSON_IS_OBJECT, "JSON_IS_OBJECT", (ObPlJsonElement::is_object))
  INTERFACE_DEF(INTERFACE_JSON_IS_SCALAR, "JSON_IS_SCALAR", (ObPlJsonElement::is_scalar))
  INTERFACE_DEF(INTERFACE_JSON_IS_STRING, "JSON_IS_STRING", (ObPlJsonElement::is_string))
  INTERFACE_DEF(INTERFACE_JSON_IS_NUMBER, "JSON_IS_NUMBER", (ObPlJsonElement::is_number))
  INTERFACE_DEF(INTERFACE_JSON_IS_BOOLEAN, "JSON_IS_BOOLEAN", (ObPlJsonElement::is_boolean))
  INTERFACE_DEF(INTERFACE_JSON_IS_TRUE, "JSON_IS_TRUE", (ObPlJsonElement::is_true))
  INTERFACE_DEF(INTERFACE_JSON_IS_FALSE, "JSON_IS_FALSE", (ObPlJsonElement::is_false))
  INTERFACE_DEF(INTERFACE_JSON_IS_NULL, "JSON_IS_NULL", (ObPlJsonElement::is_null))
  INTERFACE_DEF(INTERFACE_JSON_IS_DATE, "JSON_IS_DATE", (ObPlJsonElement::is_date))
  INTERFACE_DEF(INTERFACE_JSON_IS_TIMESTAMP, "JSON_IS_TIMESTAMP", (ObPlJsonElement::is_timestamp))
  INTERFACE_DEF(INTERFACE_JSON_TO_STRING, "JSON_TO_STRING", (ObPlJsonElement::to_string))
  INTERFACE_DEF(INTERFACE_JSON_TO_NUMBER, "JSON_TO_NUMBER", (ObPlJsonElement::to_number))
  INTERFACE_DEF(INTERFACE_JSON_TO_DATE, "JSON_TO_DATE", (ObPlJsonElement::to_date))
  INTERFACE_DEF(INTERFACE_JSON_TO_TIMESTAMP, "JSON_TO_TIMESTAMP", (ObPlJsonElement::to_timestamp))
  INTERFACE_DEF(INTERFACE_JSON_TO_BOOLEAN, "JSON_TO_BOOLEAN", (ObPlJsonElement::to_boolean))
  INTERFACE_DEF(INTERFACE_JSON_TO_CLOB, "JSON_TO_CLOB", (ObPlJsonElement::to_clob))
  INTERFACE_DEF(INTERFACE_JSON_TO_BLOB, "JSON_TO_BLOB", (ObPlJsonElement::to_blob))
  INTERFACE_DEF(INTERFACE_JSON_TO_CLOB_PROC, "JSON_TO_CLOB_PROC", (ObPlJsonElement::to_clob_proc))
  INTERFACE_DEF(INTERFACE_JSON_TO_BLOB_PROC, "JSON_TO_BLOB_PROC", (ObPlJsonElement::to_blob_proc))
  INTERFACE_DEF(INTERFACE_JSON_GET_SIZE, "JSON_GET_SIZE", (ObPlJsonElement::get_size))
  // end of json_element_t

  // start of json_object_t
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_ON_ERROR, "JSON_OBJECT_ON_ERROR", (ObPlJsonObject::set_on_error))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_PARSE, "JSON_OBJECT_PARSE", (ObPlJsonObject::parse))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_GETSTR, "JSON_OBJECT_GETSTR", (ObPlJsonObject::get_string))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_GET_NUMBER, "JSON_OBJECT_GET_NUMBER", (ObPlJsonObject::get_number))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_PUT, "JSON_OBJECT_PUT", (ObPlJsonObject::put))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_PUT_BLOB, "JSON_OBJECT_PUT_BLOB", (ObPlJsonObject::put_blob))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_PUT_CLOB, "JSON_OBJECT_PUT_CLOB", (ObPlJsonObject::put_clob))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_PUT_JSON, "JSON_OBJECT_PUT_JSON", (ObPlJsonObject::put_json))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_PUT_VARCHAR, "JSON_OBJECT_PUT_VARCHAR", (ObPlJsonObject::put_varchar))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_PUT_BOOL, "JSON_OBJECT_PUT_BOOL", (ObPlJsonObject::put_boolean))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_PUT_NULL, "JSON_OBJECT_PUT_NULL", (ObPlJsonObject::put_null))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_CONSTRUCTOR, "JSON_OBJECT_CONSTRUCTOR", (ObPlJsonObject::constructor))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_GET_DATE, "JSON_OBJECT_GET_DATE", (ObPlJsonObject::get_date))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_GET_TIMESTAMP, "JSON_OBJECT_GET_TIMESTAMP", (ObPlJsonObject::get_timestamp))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_GET_BOOLEAN, "JSON_OBJECT_GET_BOOLEAN", (ObPlJsonObject::get_boolean))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_GET_CLOB, "JSON_OBJECT_GET_CLOB", (ObPlJsonObject::get_clob))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_GET_BLOB, "JSON_OBJECT_GET_BLOB", (ObPlJsonObject::get_blob))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_GET_BLOB_PROC, "JSON_OBJECT_GET_BLOB_PROC", (ObPlJsonObject::get_blob_proc))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_GET_CLOB_PROC, "JSON_OBJECT_GET_CLOB_PROC", (ObPlJsonObject::get_clob_proc))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_GET_OBJECT, "JSON_OBJECT_GET_OBJECT", (ObPlJsonObject::get_object))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_GET_ELEMENT, "JSON_OBJECT_GET_ELEMENT", (ObPlJsonObject::get_element))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_HAS, "JSON_OBJECT_HAS", (ObPlJsonObject::exist))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_GET_TYPE, "JSON_OBJECT_GET_TYPE", (ObPlJsonObject::get_type))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_REMOVE, "JSON_OBJECT_REMOVE", (ObPlJsonObject::remove))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_RENAME_KEY, "JSON_OBJECT_RENAME_KEY", (ObPlJsonObject::rename_key))
  INTERFACE_DEF(INTERFACE_JSON_OBJECT_CLONE, "JSON_OBJECT_CLONE", (ObPlJsonObject::clone))
  // end of json_object_t

  // start of json_array_t
  INTERFACE_DEF(INTERFACE_JSON_ARRAY_ON_ERROR, "JSON_ARRAY_ON_ERROR", (ObPlJsonArray::set_on_error))
  INTERFACE_DEF(INTERFACE_JSON_ARRAY_PARSE, "JSON_ARRAY_PARSE", (ObPlJsonArray::parse))
  INTERFACE_DEF(INTERFACE_JSON_ARRAY_GET, "JSON_ARRAY_GET", (ObPlJsonArray::get))
  INTERFACE_DEF(INTERFACE_JSON_ARRAY_GET_TYPE, "JSON_ARRAY_GET_TYPE", (ObPlJsonArray::get_type))
  INTERFACE_DEF(INTERFACE_JSON_ARRAY_CONSTRUCTOR, "JSON_ARRAY_CONSTRUCTOR", (ObPlJsonArray::constructor))
  INTERFACE_DEF(INTERFACE_JSON_ARRAY_CLONE, "JSON_ARRAY_CLONE", (ObPlJsonArray::clone))
  // end of json_array_t
#endif

#ifdef OB_BUILD_ORACLE_PL
  // start of dbms_mview
#define DEFINE_DBMS_MVIEW_INTERFACE(symbol, func) \
  INTERFACE_DEF(INTERFACE_##symbol, #symbol, (func))

  DEFINE_DBMS_MVIEW_INTERFACE(DBMS_MVIEW_PURGE_LOG, ObDBMSMView::purge_log)
  DEFINE_DBMS_MVIEW_INTERFACE(DBMS_MVIEW_REFRESH, ObDBMSMView::refresh)

#undef DEFINE_DBMS_MVIEW_INTERFACE
  // end of dbms_mview

  // start of dbms_mview_stats
#define DEFINE_DBMS_MVIEW_STATS_INTERFACE(symbol, func) \
  INTERFACE_DEF(INTERFACE_##symbol, #symbol, (func))

  DEFINE_DBMS_MVIEW_STATS_INTERFACE(DBMS_MVIEW_STATS_SET_SYS_DEFAULT, ObDBMSMViewStats::set_system_default)
  DEFINE_DBMS_MVIEW_STATS_INTERFACE(DBMS_MVIEW_STATS_SET_MVREF_STATS_PARAMS, ObDBMSMViewStats::set_mvref_stats_params)
  DEFINE_DBMS_MVIEW_STATS_INTERFACE(DBMS_MVIEW_STATS_PURGE_REFRESH_STATS, ObDBMSMViewStats::purge_refresh_stats)

#undef DEFINE_DBMS_MVIEW_STATS_INTERFACE
  // end of dbms_mview_stats
#endif

  // start of dbms_mview_mysql
#define DEFINE_DBMS_MVIEW_MYSQL_INTERFACE(symbol, func) \
  INTERFACE_DEF(INTERFACE_##symbol, #symbol, (func))

  DEFINE_DBMS_MVIEW_MYSQL_INTERFACE(DBMS_MVIEW_MYSQL_PURGE_LOG, ObDBMSMViewMysql::purge_log)
  DEFINE_DBMS_MVIEW_MYSQL_INTERFACE(DBMS_MVIEW_MYSQL_REFRESH, ObDBMSMViewMysql::refresh)

#undef DEFINE_DBMS_MVIEW_MYSQL_INTERFACE
  // end of dbms_mview_mysql

  // start of dbms_mview_stats_mysql
#define DEFINE_DBMS_MVIEW_STATS_MYSQL_INTERFACE(symbol, func) \
  INTERFACE_DEF(INTERFACE_##symbol, #symbol, (func))

  DEFINE_DBMS_MVIEW_STATS_MYSQL_INTERFACE(DBMS_MVIEW_STATS_MYSQL_SET_SYS_DEFAULT, ObDBMSMViewStatsMysql::set_system_default)
  DEFINE_DBMS_MVIEW_STATS_MYSQL_INTERFACE(DBMS_MVIEW_STATS_MYSQL_SET_MVREF_STATS_PARAMS, ObDBMSMViewStatsMysql::set_mvref_stats_params)
  DEFINE_DBMS_MVIEW_STATS_MYSQL_INTERFACE(DBMS_MVIEW_STATS_MYSQL_PURGE_REFRESH_STATS, ObDBMSMViewStatsMysql::purge_refresh_stats)

#undef DEFINE_DBMS_MVIEW_STATS_MYSQL_INTERFACE
  // end of dbms_mview_stats_mysql

  // start of dbms_udr
  INTERFACE_DEF(INTERFACE_DBMS_UDR_CREATE_RULE, "CREATE_RULE", (ObDBMSUserDefineRule::create_rule))
  INTERFACE_DEF(INTERFACE_DBMS_UDR_REMOVE_RULE, "REMOVE_RULE", (ObDBMSUserDefineRule::remove_rule))
  INTERFACE_DEF(INTERFACE_DBMS_UDR_ENABLE_RULE, "ENABLE_RULE", (ObDBMSUserDefineRule::enable_rule))
  INTERFACE_DEF(INTERFACE_DBMS_UDR_DISABLE_RULE, "DISABLE_RULE", (ObDBMSUserDefineRule::disable_rule))
  // end of dbms_udr

  // start of dbms_workload_repository
  INTERFACE_DEF(INTERFACE_DBMS_WR_CREATE_SNAPSHOT, "WR_CREATE_SNAPSHOT", (ObDbmsWorkloadRepository::create_snapshot))
  INTERFACE_DEF(INTERFACE_DBMS_WR_DROP_SNAPSHOT_RANGE, "WR_DROP_SNAPSHOT_RANGE", (ObDbmsWorkloadRepository::drop_snapshot_range))
  INTERFACE_DEF(INTERFACE_DBMS_WR_MODIFY_SNAPSHOT_SETTINGS, "WR_MODIFY_SNAPSHOT_SETTINGS", (ObDbmsWorkloadRepository::modify_snapshot_settings))
  INTERFACE_DEF(INTERFACE_DBMS_GENERATE_ASH_REPORT_TEXT, "GENERATE_ASH_REPORT_TEXT", (ObDbmsWorkloadRepository::generate_ash_report_text))
  // end of dbms_workload_repository

#ifdef OB_BUILD_ORACLE_PL
  // start of dbms_profiler
  INTERFACE_DEF(INTERFACE_DBMS_PROFILER_CHECK_VERSION, "DBMS_PROFILER_CHECK_VERSION", (ObDBMSProfiler::check_version))
  INTERFACE_DEF(INTERFACE_DBMS_PROFILER_START, "DBMS_PROFILER_START_PROFILER", (ObDBMSProfiler::start_profiler))
  INTERFACE_DEF(INTERFACE_DBMS_PROFILER_STOP, "DBMS_PROFILER_STOP_PROFILER", (ObDBMSProfiler::stop_profiler))
  INTERFACE_DEF(INTERFACE_DBMS_PROFILER_CHANGE_STATE, "DBMS_PROFILER_CHANGE_STATE", (ObDBMSProfiler::change_state))
  INTERFACE_DEF(INTERFACE_DBMS_PROFILER_FLUSH_DATA, "DBMS_PROFILER_FLUSH_DATA", (ObDBMSProfiler::flush_data))
  INTERFACE_DEF(INTERFACE_DBMS_PROFILER_INIT_OBJECTS, "DBMS_PROFILER_INIT_OBJECTS", (ObDBMSProfiler::init_objects))
  INTERFACE_DEF(INTERFACE_DBMS_PROFILER_DROP_OBJECTS, "DBMS_PROFILER_DROP_OBJECTS", (ObDBMSProfiler::drop_objects))
  // end of dbms_profiler
#endif // OB_BUILD_ORACLE_PL

    // start of dbms_vector_mysql
#define DEFINE_DBMS_VECTOR_MYSQL_INTERFACE(symbol, func) \
  INTERFACE_DEF(INTERFACE_##symbol, #symbol, (func))

  DEFINE_DBMS_VECTOR_MYSQL_INTERFACE(DBMS_VECTOR_MYSQL_REFRESH_INDEX, ObDBMSVectorMySql::refresh_index)
  DEFINE_DBMS_VECTOR_MYSQL_INTERFACE(DBMS_VECTOR_MYSQL_REBUILD_INDEX, ObDBMSVectorMySql::rebuild_index)
  DEFINE_DBMS_VECTOR_MYSQL_INTERFACE(DBMS_VECTOR_MYSQL_REFRESH_INDEX_INNER, ObDBMSVectorMySql::refresh_index_inner)
  DEFINE_DBMS_VECTOR_MYSQL_INTERFACE(DBMS_VECTOR_MYSQL_REBUILD_INDEX_INNER, ObDBMSVectorMySql::rebuild_index_inner)

#undef DEFINE_DBMS_VECTOR_MYSQL_INTERFACE
  // end of dbms_vector_mysql

  /****************************************************************************/

  // start of dbms_trusted_certificate_manager
  INTERFACE_DEF(INTERFACE_DBMS_ADD_TRUSTED_CERTIFICATE, "ADD_TRUSTED_CERTIFICATE", (ObPlDBMSTrustedCertificateManager::add_trusted_certificate))
  INTERFACE_DEF(INTERFACE_DBMS_DELETE_TRUSTED_CERTIFICATE, "DELETE_TRUSTED_CERTIFICATE", (ObPlDBMSTrustedCertificateManager::delete_trusted_certificate))
  INTERFACE_DEF(INTERFACE_DBMS_UPDATE_TRUSTED_CERTIFICATE, "UPDATE_TRUSTED_CERTIFICATE", (ObPlDBMSTrustedCertificateManager::update_trusted_certificate))
  // end of end of dbms_workload_repository

  // start of dbms_ob_limit_calculator
  INTERFACE_DEF(INTERFACE_DBMS_OB_LIMIT_CALCULATOR_PHY_RES_CALCULATE_BY_LOGIC_RES, "PHY_RES_CALCULATE_BY_LOGIC_RES", (ObDBMSLimitCalculator::phy_res_calculate_by_logic_res))
  INTERFACE_DEF(INTERFACE_DBMS_OB_LIMIT_CALCULATOR_PHY_RES_CALCULATE_BY_UNIT, "PHY_RES_CALCULATE_BY_UNIT", (ObDBMSLimitCalculator::phy_res_calculate_by_unit))
  INTERFACE_DEF(INTERFACE_DBMS_OB_LIMIT_CALCULATOR_PHY_RES_CALCULATE_BY_STADNBY_TENANT, "PHY_RES_CALCULATE_BY_STANDBY_TENANT", (ObDBMSLimitCalculator::phy_res_calculate_by_standby_tenant))
  // end of dbms_ob_limit_calculator

  // start of dbms_external_table
  INTERFACE_DEF(INTERFACE_DBMS_EXTERNAL_TABLE_AUTO_REFRESH_EXTERNAL_TABLE, "AUTO_REFRESH_EXTERNAL_TABLE", (ObDBMSExternalTable::auto_refresh_external_table))
  //end of dbms_external_table

  // start of dbms_ddl
#ifdef OB_BUILD_ORACLE_PL
  INTERFACE_DEF(INTERFACE_DBMS_DDL_WRAP, "DBMS_DDL_WRAP", (ObDbmsDDL::wrap))
  INTERFACE_DEF(INTERFACE_DBMS_DDL_WRAP_VS, "DBMS_DDL_WRAP_VS", (ObDbmsDDL::wrap_clob))
  INTERFACE_DEF(INTERFACE_DBMS_DDL_WRAP_VA, "DBMS_DDL_WRAP_VA", (ObDbmsDDL::wrap_clob))
  INTERFACE_DEF(INTERFACE_DBMS_DDL_CREATE_WRAPPED, "DBMS_DDL_CREATE_WRAPPED", (ObDbmsDDL::create_wrapped))
  INTERFACE_DEF(INTERFACE_DBMS_DDL_CREATE_WRAPPED_VS, "DBMS_DDL_CREATE_WRAPPED_VS", (ObDbmsDDL::create_wrapped))
  INTERFACE_DEF(INTERFACE_DBMS_DDL_CREATE_WRAPPED_VA, "DBMS_DDL_CREATE_WRAPPED_VA", (ObDbmsDDL::create_wrapped))
#endif
  // end of dbms_ddl

  INTERFACE_DEF(INTERFACE_END, "INVALID", (nullptr))
#endif

#ifndef OCEANBASE_SRC_PL_OB_PL_INTERFACE_PRAGMA_H_
#define OCEANBASE_SRC_PL_OB_PL_INTERFACE_PRAGMA_H_

namespace oceanbase
{
namespace pl
{

typedef int(*PL_C_INTERFACE_t)(ObPLExecCtx&, ParamStore&, ObObj&);

enum ObPLInterfaceType
{
#define INTERFACE_DEF(type, name, entry) type,
#include "pl/ob_pl_interface_pragma.h"
#undef INTERFACE_DEF
};

class ObPLInterfaceService
{
public:
  ObPLInterfaceService() {}
  virtual ~ObPLInterfaceService() {}

  PL_C_INTERFACE_t get_entry(common::ObString &name) const;
  int init();

private:

  ObPLInterfaceType get_type(common::ObString &name) const;

private:
  typedef common::hash::ObHashMap<common::ObString, ObPLInterfaceType,
      common::hash::NoPthreadDefendMode> InterfaceMap;
  InterfaceMap interface_map_;
};

class ObPLInterfaceImpl
{
public:
  ObPLInterfaceImpl() {}
  virtual ~ObPLInterfaceImpl() {}

public:
  static int call(sql::ObExecContext &ctx, sql::ParamStore &params, common::ObObj &result);
  virtual int check_params() = 0;

};

}
}

#endif /* OCEANBASE_SRC_PL_OB_PL_INTERFACE_PRAGMA_H_ */
