; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt < %s -passes=loop-reroll -S | FileCheck %s
target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

; int foo(int a);
; void bar(int *x) {
;   for (int i = 0; i < 500; i += 3) {
;     foo(i);
;     foo(i+1);
;     foo(i+2);
;   }
; }

define void @bar(ptr nocapture readnone %x) #0 {
; CHECK-LABEL: define void @bar
; CHECK-SAME: (ptr nocapture readnone [[X:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVAR:%.*]] = phi i32 [ [[INDVAR_NEXT:%.*]], [[FOR_BODY]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @foo(i32 [[INDVAR]]) #[[ATTR1:[0-9]+]]
; CHECK-NEXT:    [[INDVAR_NEXT]] = add i32 [[INDVAR]], 1
; CHECK-NEXT:    [[EXITCOND1:%.*]] = icmp eq i32 [[INDVAR]], 500
; CHECK-NEXT:    br i1 [[EXITCOND1]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %i.08 = phi i32 [ 0, %entry ], [ %add3, %for.body ]
  %call = tail call i32 @foo(i32 %i.08) #1
  %add = add nsw i32 %i.08, 1
  %call1 = tail call i32 @foo(i32 %add) #1
  %add2 = add nsw i32 %i.08, 2
  %call3 = tail call i32 @foo(i32 %add2) #1
  %add3 = add nsw i32 %i.08, 3
  %exitcond = icmp sge i32 %add3, 500
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  ret void
}

declare i32 @foo(i32)

; void hi1(int *x) {
;   for (int i = 0; i < 1500; i += 3) {
;     x[i] = foo(0);
;     x[i+1] = foo(0);
;     x[i+2] = foo(0);
;   }
; }

; Function Attrs: nounwind uwtable
define void @hi1(ptr nocapture %x) #0 {
; CHECK-LABEL: define void @hi1
; CHECK-SAME: (ptr nocapture [[X:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVAR:%.*]] = phi i64 [ [[INDVAR_NEXT:%.*]], [[FOR_BODY]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TMP0:%.*]] = trunc i64 [[INDVAR]] to i32
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @foo(i32 0) #[[ATTR1]]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[X]], i64 [[INDVAR]]
; CHECK-NEXT:    store i32 [[CALL]], ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[INDVAR_NEXT]] = add i64 [[INDVAR]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i32 [[TMP0]], 1499
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:                                         ; preds = %entry, %for.body
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %call = tail call i32 @foo(i32 0) #1
  %arrayidx = getelementptr inbounds i32, ptr %x, i64 %indvars.iv
  store i32 %call, ptr %arrayidx, align 4
  %call1 = tail call i32 @foo(i32 0) #1
  %0 = add nsw i64 %indvars.iv, 1
  %arrayidx3 = getelementptr inbounds i32, ptr %x, i64 %0
  store i32 %call1, ptr %arrayidx3, align 4
  %call4 = tail call i32 @foo(i32 0) #1
  %1 = add nsw i64 %indvars.iv, 2
  %arrayidx7 = getelementptr inbounds i32, ptr %x, i64 %1
  store i32 %call4, ptr %arrayidx7, align 4
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 3
  %2 = trunc i64 %indvars.iv.next to i32
  %cmp = icmp slt i32 %2, 1500
  br i1 %cmp, label %for.body, label %for.end

for.end:                                          ; preds = %for.body
  ret void
}

; void hi2(int *x) {
;   for (int i = 0; i < 500; ++i) {
;     x[3*i] = foo(0);
;     x[3*i+1] = foo(0);
;     x[3*i+2] = foo(0);
;   }
; }

; Function Attrs: nounwind uwtable
define void @hi2(ptr nocapture %x) #0 {
; CHECK-LABEL: define void @hi2
; CHECK-SAME: (ptr nocapture [[X:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @foo(i32 0) #[[ATTR1]]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[X]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    store i32 [[CALL]], ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[EXITCOND1:%.*]] = icmp eq i64 [[INDVARS_IV]], 1499
; CHECK-NEXT:    br i1 [[EXITCOND1]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %call = tail call i32 @foo(i32 0) #1
  %0 = mul nsw i64 %indvars.iv, 3
  %arrayidx = getelementptr inbounds i32, ptr %x, i64 %0
  store i32 %call, ptr %arrayidx, align 4
  %call1 = tail call i32 @foo(i32 0) #1
  %1 = add nsw i64 %0, 1
  %arrayidx4 = getelementptr inbounds i32, ptr %x, i64 %1
  store i32 %call1, ptr %arrayidx4, align 4
  %call5 = tail call i32 @foo(i32 0) #1
  %2 = add nsw i64 %0, 2
  %arrayidx9 = getelementptr inbounds i32, ptr %x, i64 %2
  store i32 %call5, ptr %arrayidx9, align 4
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond = icmp eq i64 %indvars.iv.next, 500
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  ret void
}

; void goo(float alpha, float *a, float *b) {
;   for (int i = 0; i < 3200; i += 5) {
;     a[i] += alpha * b[i];
;     a[i + 1] += alpha * b[i + 1];
;     a[i + 2] += alpha * b[i + 2];
;     a[i + 3] += alpha * b[i + 3];
;     a[i + 4] += alpha * b[i + 4];
;   }
; }

; Function Attrs: nounwind uwtable
define void @goo(float %alpha, ptr nocapture %a, ptr nocapture readonly %b) #0 {
; CHECK-LABEL: define void @goo
; CHECK-SAME: (float [[ALPHA:%.*]], ptr nocapture [[A:%.*]], ptr nocapture readonly [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVAR:%.*]] = phi i64 [ [[INDVAR_NEXT:%.*]], [[FOR_BODY]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TMP0:%.*]] = trunc i64 [[INDVAR]] to i32
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr [[B]], i64 [[INDVAR]]
; CHECK-NEXT:    [[TMP1:%.*]] = load float, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[MUL:%.*]] = fmul float [[TMP1]], [[ALPHA]]
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, ptr [[A]], i64 [[INDVAR]]
; CHECK-NEXT:    [[TMP2:%.*]] = load float, ptr [[ARRAYIDX2]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = fadd float [[TMP2]], [[MUL]]
; CHECK-NEXT:    store float [[ADD]], ptr [[ARRAYIDX2]], align 4
; CHECK-NEXT:    [[INDVAR_NEXT]] = add i64 [[INDVAR]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i32 [[TMP0]], 3199
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:                                         ; preds = %entry, %for.body
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %arrayidx = getelementptr inbounds float, ptr %b, i64 %indvars.iv
  %0 = load float, ptr %arrayidx, align 4
  %mul = fmul float %0, %alpha
  %arrayidx2 = getelementptr inbounds float, ptr %a, i64 %indvars.iv
  %1 = load float, ptr %arrayidx2, align 4
  %add = fadd float %1, %mul
  store float %add, ptr %arrayidx2, align 4
  %2 = add nsw i64 %indvars.iv, 1
  %arrayidx5 = getelementptr inbounds float, ptr %b, i64 %2
  %3 = load float, ptr %arrayidx5, align 4
  %mul6 = fmul float %3, %alpha
  %arrayidx9 = getelementptr inbounds float, ptr %a, i64 %2
  %4 = load float, ptr %arrayidx9, align 4
  %add10 = fadd float %4, %mul6
  store float %add10, ptr %arrayidx9, align 4
  %5 = add nsw i64 %indvars.iv, 2
  %arrayidx13 = getelementptr inbounds float, ptr %b, i64 %5
  %6 = load float, ptr %arrayidx13, align 4
  %mul14 = fmul float %6, %alpha
  %arrayidx17 = getelementptr inbounds float, ptr %a, i64 %5
  %7 = load float, ptr %arrayidx17, align 4
  %add18 = fadd float %7, %mul14
  store float %add18, ptr %arrayidx17, align 4
  %8 = add nsw i64 %indvars.iv, 3
  %arrayidx21 = getelementptr inbounds float, ptr %b, i64 %8
  %9 = load float, ptr %arrayidx21, align 4
  %mul22 = fmul float %9, %alpha
  %arrayidx25 = getelementptr inbounds float, ptr %a, i64 %8
  %10 = load float, ptr %arrayidx25, align 4
  %add26 = fadd float %10, %mul22
  store float %add26, ptr %arrayidx25, align 4
  %11 = add nsw i64 %indvars.iv, 4
  %arrayidx29 = getelementptr inbounds float, ptr %b, i64 %11
  %12 = load float, ptr %arrayidx29, align 4
  %mul30 = fmul float %12, %alpha
  %arrayidx33 = getelementptr inbounds float, ptr %a, i64 %11
  %13 = load float, ptr %arrayidx33, align 4
  %add34 = fadd float %13, %mul30
  store float %add34, ptr %arrayidx33, align 4
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 5
  %14 = trunc i64 %indvars.iv.next to i32
  %cmp = icmp slt i32 %14, 3200
  br i1 %cmp, label %for.body, label %for.end

for.end:                                          ; preds = %for.body
  ret void
}

; void hoo(float alpha, float *a, float *b, int *ip) {
;   for (int i = 0; i < 3200; i += 5) {
;     a[i] += alpha * b[ip[i]];
;     a[i + 1] += alpha * b[ip[i + 1]];
;     a[i + 2] += alpha * b[ip[i + 2]];
;     a[i + 3] += alpha * b[ip[i + 3]];
;     a[i + 4] += alpha * b[ip[i + 4]];
;   }
; }

; Function Attrs: nounwind uwtable
define void @hoo(float %alpha, ptr nocapture %a, ptr nocapture readonly %b, ptr nocapture readonly %ip) #0 {
; CHECK-LABEL: define void @hoo
; CHECK-SAME: (float [[ALPHA:%.*]], ptr nocapture [[A:%.*]], ptr nocapture readonly [[B:%.*]], ptr nocapture readonly [[IP:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVAR:%.*]] = phi i64 [ [[INDVAR_NEXT:%.*]], [[FOR_BODY]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TMP0:%.*]] = trunc i64 [[INDVAR]] to i32
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[IP]], i64 [[INDVAR]]
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[IDXPROM1:%.*]] = sext i32 [[TMP1]] to i64
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, ptr [[B]], i64 [[IDXPROM1]]
; CHECK-NEXT:    [[TMP2:%.*]] = load float, ptr [[ARRAYIDX2]], align 4
; CHECK-NEXT:    [[MUL:%.*]] = fmul float [[TMP2]], [[ALPHA]]
; CHECK-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, ptr [[A]], i64 [[INDVAR]]
; CHECK-NEXT:    [[TMP3:%.*]] = load float, ptr [[ARRAYIDX4]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = fadd float [[TMP3]], [[MUL]]
; CHECK-NEXT:    store float [[ADD]], ptr [[ARRAYIDX4]], align 4
; CHECK-NEXT:    [[INDVAR_NEXT]] = add i64 [[INDVAR]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i32 [[TMP0]], 3199
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:                                         ; preds = %entry, %for.body
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %ip, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %idxprom1 = sext i32 %0 to i64
  %arrayidx2 = getelementptr inbounds float, ptr %b, i64 %idxprom1
  %1 = load float, ptr %arrayidx2, align 4
  %mul = fmul float %1, %alpha
  %arrayidx4 = getelementptr inbounds float, ptr %a, i64 %indvars.iv
  %2 = load float, ptr %arrayidx4, align 4
  %add = fadd float %2, %mul
  store float %add, ptr %arrayidx4, align 4
  %3 = add nsw i64 %indvars.iv, 1
  %arrayidx7 = getelementptr inbounds i32, ptr %ip, i64 %3
  %4 = load i32, ptr %arrayidx7, align 4
  %idxprom8 = sext i32 %4 to i64
  %arrayidx9 = getelementptr inbounds float, ptr %b, i64 %idxprom8
  %5 = load float, ptr %arrayidx9, align 4
  %mul10 = fmul float %5, %alpha
  %arrayidx13 = getelementptr inbounds float, ptr %a, i64 %3
  %6 = load float, ptr %arrayidx13, align 4
  %add14 = fadd float %6, %mul10
  store float %add14, ptr %arrayidx13, align 4
  %7 = add nsw i64 %indvars.iv, 2
  %arrayidx17 = getelementptr inbounds i32, ptr %ip, i64 %7
  %8 = load i32, ptr %arrayidx17, align 4
  %idxprom18 = sext i32 %8 to i64
  %arrayidx19 = getelementptr inbounds float, ptr %b, i64 %idxprom18
  %9 = load float, ptr %arrayidx19, align 4
  %mul20 = fmul float %9, %alpha
  %arrayidx23 = getelementptr inbounds float, ptr %a, i64 %7
  %10 = load float, ptr %arrayidx23, align 4
  %add24 = fadd float %10, %mul20
  store float %add24, ptr %arrayidx23, align 4
  %11 = add nsw i64 %indvars.iv, 3
  %arrayidx27 = getelementptr inbounds i32, ptr %ip, i64 %11
  %12 = load i32, ptr %arrayidx27, align 4
  %idxprom28 = sext i32 %12 to i64
  %arrayidx29 = getelementptr inbounds float, ptr %b, i64 %idxprom28
  %13 = load float, ptr %arrayidx29, align 4
  %mul30 = fmul float %13, %alpha
  %arrayidx33 = getelementptr inbounds float, ptr %a, i64 %11
  %14 = load float, ptr %arrayidx33, align 4
  %add34 = fadd float %14, %mul30
  store float %add34, ptr %arrayidx33, align 4
  %15 = add nsw i64 %indvars.iv, 4
  %arrayidx37 = getelementptr inbounds i32, ptr %ip, i64 %15
  %16 = load i32, ptr %arrayidx37, align 4
  %idxprom38 = sext i32 %16 to i64
  %arrayidx39 = getelementptr inbounds float, ptr %b, i64 %idxprom38
  %17 = load float, ptr %arrayidx39, align 4
  %mul40 = fmul float %17, %alpha
  %arrayidx43 = getelementptr inbounds float, ptr %a, i64 %15
  %18 = load float, ptr %arrayidx43, align 4
  %add44 = fadd float %18, %mul40
  store float %add44, ptr %arrayidx43, align 4
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 5
  %19 = trunc i64 %indvars.iv.next to i32
  %cmp = icmp slt i32 %19, 3200
  br i1 %cmp, label %for.body, label %for.end




for.end:                                          ; preds = %for.body
  ret void
}

; void multi1(int *x) {
;   y = foo(0)
;   for (int i = 0; i < 500; ++i) {
;     x[3*i] = y;
;     x[3*i+1] = y;
;     x[3*i+2] = y;
;     x[3*i+6] = y;
;     x[3*i+7] = y;
;     x[3*i+8] = y;
;   }
; }

; Function Attrs: nounwind uwtable
define void @multi1(ptr nocapture %x) #0 {
; CHECK-LABEL: define void @multi1
; CHECK-SAME: (ptr nocapture [[X:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @foo(i32 0) #[[ATTR1]]
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[TMP0:%.*]] = add i64 [[INDVARS_IV]], 6
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[X]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    store i32 [[CALL]], ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i32, ptr [[X]], i64 [[TMP0]]
; CHECK-NEXT:    store i32 [[CALL]], ptr [[ARRAYIDX6]], align 4
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[EXITCOND1:%.*]] = icmp eq i64 [[INDVARS_IV]], 1499
; CHECK-NEXT:    br i1 [[EXITCOND1]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  %call = tail call i32 @foo(i32 0) #1
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %0 = mul nsw i64 %indvars.iv, 3
  %arrayidx = getelementptr inbounds i32, ptr %x, i64 %0
  store i32 %call, ptr %arrayidx, align 4
  %1 = add nsw i64 %0, 1
  %arrayidx4 = getelementptr inbounds i32, ptr %x, i64 %1
  store i32 %call, ptr %arrayidx4, align 4
  %2 = add nsw i64 %0, 2
  %arrayidx9 = getelementptr inbounds i32, ptr %x, i64 %2
  store i32 %call, ptr %arrayidx9, align 4
  %3 = add nsw i64 %0, 6
  %arrayidx6 = getelementptr inbounds i32, ptr %x, i64 %3
  store i32 %call, ptr %arrayidx6, align 4
  %4 = add nsw i64 %0, 7
  %arrayidx7 = getelementptr inbounds i32, ptr %x, i64 %4
  store i32 %call, ptr %arrayidx7, align 4
  %5 = add nsw i64 %0, 8
  %arrayidx8 = getelementptr inbounds i32, ptr %x, i64 %5
  store i32 %call, ptr %arrayidx8, align 4
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond = icmp eq i64 %indvars.iv.next, 500
  br i1 %exitcond, label %for.end, label %for.body



for.end:                                          ; preds = %for.body
  ret void
}

; void multi2(int *x) {
;   y = foo(0)
;   for (int i = 0; i < 500; ++i) {
;     x[3*i] = y;
;     x[3*i+1] = y;
;     x[3*i+2] = y;
;     x[3*(i+1)] = y;
;     x[3*(i+1)+1] = y;
;     x[3*(i+1)+2] = y;
;   }
; }

; Function Attrs: nounwind uwtable
define void @multi2(ptr nocapture %x) #0 {
; CHECK-LABEL: define void @multi2
; CHECK-SAME: (ptr nocapture [[X:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @foo(i32 0) #[[ATTR1]]
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[TMP0:%.*]] = add i64 [[INDVARS_IV]], 3
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[X]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    store i32 [[CALL]], ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i32, ptr [[X]], i64 [[TMP0]]
; CHECK-NEXT:    store i32 [[CALL]], ptr [[ARRAYIDX6]], align 4
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[EXITCOND1:%.*]] = icmp eq i64 [[INDVARS_IV]], 1499
; CHECK-NEXT:    br i1 [[EXITCOND1]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  %call = tail call i32 @foo(i32 0) #1
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %0 = mul nsw i64 %indvars.iv, 3
  %add = add nsw i64 %indvars.iv, 1
  %newmul = mul nsw i64 %add, 3
  %arrayidx = getelementptr inbounds i32, ptr %x, i64 %0
  store i32 %call, ptr %arrayidx, align 4
  %1 = add nsw i64 %0, 1
  %arrayidx4 = getelementptr inbounds i32, ptr %x, i64 %1
  store i32 %call, ptr %arrayidx4, align 4
  %2 = add nsw i64 %0, 2
  %arrayidx9 = getelementptr inbounds i32, ptr %x, i64 %2
  store i32 %call, ptr %arrayidx9, align 4
  %arrayidx6 = getelementptr inbounds i32, ptr %x, i64 %newmul
  store i32 %call, ptr %arrayidx6, align 4
  %3 = add nsw i64 %newmul, 1
  %arrayidx7 = getelementptr inbounds i32, ptr %x, i64 %3
  store i32 %call, ptr %arrayidx7, align 4
  %4 = add nsw i64 %newmul, 2
  %arrayidx8 = getelementptr inbounds i32, ptr %x, i64 %4
  store i32 %call, ptr %arrayidx8, align 4
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond = icmp eq i64 %indvars.iv.next, 500
  br i1 %exitcond, label %for.end, label %for.body



for.end:                                          ; preds = %for.body
  ret void
}

; void multi3(int *x) {
;   y = foo(0)
;   for (int i = 0; i < 500; ++i) {
;     // Note: No zero index
;     x[3*i+3] = y;
;     x[3*i+4] = y;
;     x[3*i+5] = y;
;   }
; }

; Function Attrs: nounwind uwtable
define void @multi3(ptr nocapture %x) #0 {
; CHECK-LABEL: define void @multi3
; CHECK-SAME: (ptr nocapture [[X:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @foo(i32 0) #[[ATTR1]]
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[TMP0:%.*]] = add i64 [[INDVARS_IV]], 3
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[X]], i64 [[TMP0]]
; CHECK-NEXT:    store i32 [[CALL]], ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[EXITCOND1:%.*]] = icmp eq i64 [[INDVARS_IV]], 1499
; CHECK-NEXT:    br i1 [[EXITCOND1]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  %call = tail call i32 @foo(i32 0) #1
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %0 = mul nsw i64 %indvars.iv, 3
  %x0 = add nsw i64 %0, 3
  %add = add nsw i64 %indvars.iv, 1
  %arrayidx = getelementptr inbounds i32, ptr %x, i64 %x0
  store i32 %call, ptr %arrayidx, align 4
  %1 = add nsw i64 %0, 4
  %arrayidx4 = getelementptr inbounds i32, ptr %x, i64 %1
  store i32 %call, ptr %arrayidx4, align 4
  %2 = add nsw i64 %0, 5
  %arrayidx9 = getelementptr inbounds i32, ptr %x, i64 %2
  store i32 %call, ptr %arrayidx9, align 4
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond = icmp eq i64 %indvars.iv.next, 500
  br i1 %exitcond, label %for.end, label %for.body


for.end:                                          ; preds = %for.body
  ret void
}

; int foo(int a);
; void bar2(int *x, int y, int z) {
;   for (int i = 0; i < 500; i += 3) {
;     foo(i+y+i*z); // Slightly reordered instruction order
;     foo(i+1+y+(i+1)*z);
;     foo(i+2+y+(i+2)*z);
;   }
; }

; Function Attrs: nounwind uwtable
define void @bar2(ptr nocapture readnone %x, i32 %y, i32 %z) #0 {
; CHECK-LABEL: define void @bar2
; CHECK-SAME: (ptr nocapture readnone [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVAR:%.*]] = phi i32 [ [[INDVAR_NEXT:%.*]], [[FOR_BODY]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = add i32 [[INDVAR]], [[Y]]
; CHECK-NEXT:    [[TMP2:%.*]] = mul i32 [[INDVAR]], [[Z]]
; CHECK-NEXT:    [[TMP3:%.*]] = add i32 [[TMP2]], [[TMP1]]
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @foo(i32 [[TMP3]]) #[[ATTR1]]
; CHECK-NEXT:    [[INDVAR_NEXT]] = add i32 [[INDVAR]], 1
; CHECK-NEXT:    [[EXITCOND1:%.*]] = icmp eq i32 [[INDVAR]], 500
; CHECK-NEXT:    br i1 [[EXITCOND1]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %i.08 = phi i32 [ 0, %entry ], [ %add3, %for.body ]

  %tmp1 = add i32 %i.08, %y
  %tmp2 = mul i32 %i.08, %z
  %tmp3 = add i32 %tmp2, %tmp1
  %call = tail call i32 @foo(i32 %tmp3) #1

  %add = add nsw i32 %i.08, 1
  %tmp2a = mul i32 %add, %z
  %tmp1a = add i32 %add, %y
  %tmp3a = add i32 %tmp2a, %tmp1a
  %calla = tail call i32 @foo(i32 %tmp3a) #1

  %add2 = add nsw i32 %i.08, 2
  %tmp2b = mul i32 %add2, %z
  %tmp1b = add i32 %add2, %y
  %tmp3b = add i32 %tmp2b, %tmp1b
  %callb = tail call i32 @foo(i32 %tmp3b) #1

  %add3 = add nsw i32 %i.08, 3

  %exitcond = icmp sge i32 %add3, 500
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  ret void
}

%struct.s = type { i32, i32 }

; Function Attrs: nounwind uwtable
define void @gep1(ptr nocapture %x) #0 {
; CHECK-LABEL: define void @gep1
; CHECK-SAME: (ptr nocapture [[X:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @foo(i32 0) #[[ATTR1]]
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[TMP0:%.*]] = mul nsw i64 [[INDVARS_IV]], 3
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[X]], i64 [[TMP0]], i32 0
; CHECK-NEXT:    store i32 [[CALL]], ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = add nsw i64 [[TMP0]], 1
; CHECK-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[X]], i64 [[TMP1]], i32 0
; CHECK-NEXT:    store i32 [[CALL]], ptr [[ARRAYIDX4]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = add nsw i64 [[TMP0]], 2
; CHECK-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[X]], i64 [[TMP2]], i32 0
; CHECK-NEXT:    store i32 [[CALL]], ptr [[ARRAYIDX9]], align 4
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT]], 500
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  %call = tail call i32 @foo(i32 0) #1
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %0 = mul nsw i64 %indvars.iv, 3
  %arrayidx = getelementptr inbounds %struct.s, ptr %x, i64 %0, i32 0
  store i32 %call, ptr %arrayidx, align 4
  %1 = add nsw i64 %0, 1
  %arrayidx4 = getelementptr inbounds %struct.s, ptr %x, i64 %1, i32 0
  store i32 %call, ptr %arrayidx4, align 4
  %2 = add nsw i64 %0, 2
  %arrayidx9 = getelementptr inbounds %struct.s, ptr %x, i64 %2, i32 0
  store i32 %call, ptr %arrayidx9, align 4
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond = icmp eq i64 %indvars.iv.next, 500
  br i1 %exitcond, label %for.end, label %for.body

; This test is a crash test only.
for.end:                                          ; preds = %for.body
  ret void
}

define void @gep-indexing(ptr nocapture %x) {
; CHECK-LABEL: define void @gep-indexing
; CHECK-SAME: (ptr nocapture [[X:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @foo(i32 0) #[[ATTR1]]
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[TMP0:%.*]] = shl nuw nsw i64 [[INDVARS_IV]], 2
; CHECK-NEXT:    [[SCEVGEP:%.*]] = getelementptr i8, ptr [[X]], i64 [[TMP0]]
; CHECK-NEXT:    store i32 [[CALL]], ptr [[SCEVGEP]], align 4
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[EXITCOND1:%.*]] = icmp eq i64 [[INDVARS_IV]], 1499
; CHECK-NEXT:    br i1 [[EXITCOND1]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  %call = tail call i32 @foo(i32 0) #1
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %0 = mul nsw i64 %indvars.iv, 3
  %arrayidx = getelementptr inbounds i32, ptr %x, i64 %0
  store i32 %call, ptr %arrayidx, align 4
  %arrayidx4 = getelementptr inbounds i32, ptr %arrayidx, i64 1
  store i32 %call, ptr %arrayidx4, align 4
  %arrayidx9 = getelementptr inbounds i32, ptr %arrayidx, i64 2
  store i32 %call, ptr %arrayidx9, align 4
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond = icmp eq i64 %indvars.iv.next, 500
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  ret void
}


define void @unordered_atomic_ops(ptr noalias %buf_0, ptr noalias %buf_1) {
; CHECK-LABEL: define void @unordered_atomic_ops
; CHECK-SAME: (ptr noalias [[BUF_0:%.*]], ptr noalias [[BUF_1:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVAR:%.*]] = phi i32 [ [[INDVAR_NEXT:%.*]], [[FOR_BODY]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[BUF0_A:%.*]] = getelementptr i32, ptr [[BUF_0]], i32 [[INDVAR]]
; CHECK-NEXT:    [[BUF1_A:%.*]] = getelementptr i32, ptr [[BUF_1]], i32 [[INDVAR]]
; CHECK-NEXT:    [[VA:%.*]] = load atomic i32, ptr [[BUF0_A]] unordered, align 4
; CHECK-NEXT:    store atomic i32 [[VA]], ptr [[BUF1_A]] unordered, align 4
; CHECK-NEXT:    [[INDVAR_NEXT]] = add i32 [[INDVAR]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i32 [[INDVAR]], 3199
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:
  %indvars.iv = phi i32 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %indvars.iv.next = add i32 %indvars.iv, 2
  %indvars.mid = add i32 %indvars.iv, 1
  %buf0_a = getelementptr i32, ptr %buf_0, i32 %indvars.iv
  %buf0_b = getelementptr i32, ptr %buf_0, i32 %indvars.mid
  %buf1_a = getelementptr i32, ptr %buf_1, i32 %indvars.iv
  %buf1_b = getelementptr i32, ptr %buf_1, i32 %indvars.mid
  %va = load atomic i32, ptr %buf0_a unordered, align 4
  %vb = load atomic i32, ptr %buf0_b unordered, align 4
  store atomic i32 %va, ptr %buf1_a unordered, align 4
  store atomic i32 %vb, ptr %buf1_b unordered, align 4
  %cmp = icmp slt i32 %indvars.iv.next, 3200
  br i1 %cmp, label %for.body, label %for.end

for.end:
  ret void
}

define void @unordered_atomic_ops_nomatch(ptr noalias %buf_0, ptr noalias %buf_1) {
; Negative test
; CHECK-LABEL: define void @unordered_atomic_ops_nomatch
; CHECK-SAME: (ptr noalias [[BUF_0:%.*]], ptr noalias [[BUF_1:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add i32 [[INDVARS_IV]], 2
; CHECK-NEXT:    [[INDVARS_MID:%.*]] = add i32 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[BUF0_A:%.*]] = getelementptr i32, ptr [[BUF_0]], i32 [[INDVARS_IV]]
; CHECK-NEXT:    [[BUF0_B:%.*]] = getelementptr i32, ptr [[BUF_0]], i32 [[INDVARS_MID]]
; CHECK-NEXT:    [[BUF1_A:%.*]] = getelementptr i32, ptr [[BUF_1]], i32 [[INDVARS_IV]]
; CHECK-NEXT:    [[BUF1_B:%.*]] = getelementptr i32, ptr [[BUF_1]], i32 [[INDVARS_MID]]
; CHECK-NEXT:    [[VA:%.*]] = load atomic i32, ptr [[BUF0_A]] unordered, align 4
; CHECK-NEXT:    [[VB:%.*]] = load atomic i32, ptr [[BUF0_B]] unordered, align 4
; CHECK-NEXT:    store i32 [[VA]], ptr [[BUF1_A]], align 4
; CHECK-NEXT:    store atomic i32 [[VB]], ptr [[BUF1_B]] unordered, align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[INDVARS_IV_NEXT]], 3200
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_END:%.*]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:

  %indvars.iv = phi i32 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %indvars.iv.next = add i32 %indvars.iv, 2
  %indvars.mid = add i32 %indvars.iv, 1
  %buf0_a = getelementptr i32, ptr %buf_0, i32 %indvars.iv
  %buf0_b = getelementptr i32, ptr %buf_0, i32 %indvars.mid
  %buf1_a = getelementptr i32, ptr %buf_1, i32 %indvars.iv
  %buf1_b = getelementptr i32, ptr %buf_1, i32 %indvars.mid
  %va = load atomic i32, ptr %buf0_a unordered, align 4
  %vb = load atomic i32, ptr %buf0_b unordered, align 4
  store i32 %va, ptr %buf1_a, align 4  ;; Not atomic
  store atomic i32 %vb, ptr %buf1_b unordered, align 4
  %cmp = icmp slt i32 %indvars.iv.next, 3200
  br i1 %cmp, label %for.body, label %for.end

for.end:
  ret void
}

define void @ordered_atomic_ops(ptr noalias %buf_0, ptr noalias %buf_1) {
; Negative test
; CHECK-LABEL: define void @ordered_atomic_ops
; CHECK-SAME: (ptr noalias [[BUF_0:%.*]], ptr noalias [[BUF_1:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add i32 [[INDVARS_IV]], 2
; CHECK-NEXT:    [[INDVARS_MID:%.*]] = add i32 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[BUF0_A:%.*]] = getelementptr i32, ptr [[BUF_0]], i32 [[INDVARS_IV]]
; CHECK-NEXT:    [[BUF0_B:%.*]] = getelementptr i32, ptr [[BUF_0]], i32 [[INDVARS_MID]]
; CHECK-NEXT:    [[BUF1_A:%.*]] = getelementptr i32, ptr [[BUF_1]], i32 [[INDVARS_IV]]
; CHECK-NEXT:    [[BUF1_B:%.*]] = getelementptr i32, ptr [[BUF_1]], i32 [[INDVARS_MID]]
; CHECK-NEXT:    [[VA:%.*]] = load atomic i32, ptr [[BUF0_A]] acquire, align 4
; CHECK-NEXT:    [[VB:%.*]] = load atomic i32, ptr [[BUF0_B]] acquire, align 4
; CHECK-NEXT:    store atomic i32 [[VA]], ptr [[BUF1_A]] release, align 4
; CHECK-NEXT:    store atomic i32 [[VB]], ptr [[BUF1_B]] release, align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[INDVARS_IV_NEXT]], 3200
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_END:%.*]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:

  %indvars.iv = phi i32 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %indvars.iv.next = add i32 %indvars.iv, 2
  %indvars.mid = add i32 %indvars.iv, 1
  %buf0_a = getelementptr i32, ptr %buf_0, i32 %indvars.iv
  %buf0_b = getelementptr i32, ptr %buf_0, i32 %indvars.mid
  %buf1_a = getelementptr i32, ptr %buf_1, i32 %indvars.iv
  %buf1_b = getelementptr i32, ptr %buf_1, i32 %indvars.mid
  %va = load atomic i32, ptr %buf0_a acquire, align 4
  %vb = load atomic i32, ptr %buf0_b acquire, align 4
  store atomic i32 %va, ptr %buf1_a release, align 4
  store atomic i32 %vb, ptr %buf1_b release, align 4
  %cmp = icmp slt i32 %indvars.iv.next, 3200
  br i1 %cmp, label %for.body, label %for.end

for.end:
  ret void
}

define void @unordered_atomic_ops_with_fence(ptr noalias %buf_0, ptr noalias %buf_1) {
; CHECK-LABEL: define void @unordered_atomic_ops_with_fence
; CHECK-SAME: (ptr noalias [[BUF_0:%.*]], ptr noalias [[BUF_1:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add i32 [[INDVARS_IV]], 2
; CHECK-NEXT:    [[INDVARS_MID:%.*]] = add i32 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[BUF0_A:%.*]] = getelementptr i32, ptr [[BUF_0]], i32 [[INDVARS_IV]]
; CHECK-NEXT:    [[BUF0_B:%.*]] = getelementptr i32, ptr [[BUF_0]], i32 [[INDVARS_MID]]
; CHECK-NEXT:    [[BUF1_A:%.*]] = getelementptr i32, ptr [[BUF_1]], i32 [[INDVARS_IV]]
; CHECK-NEXT:    [[BUF1_B:%.*]] = getelementptr i32, ptr [[BUF_1]], i32 [[INDVARS_MID]]
; CHECK-NEXT:    [[VA:%.*]] = load atomic i32, ptr [[BUF0_A]] unordered, align 4
; CHECK-NEXT:    [[VB:%.*]] = load atomic i32, ptr [[BUF0_B]] unordered, align 4
; CHECK-NEXT:    fence seq_cst
; CHECK-NEXT:    store atomic i32 [[VA]], ptr [[BUF1_A]] unordered, align 4
; CHECK-NEXT:    store atomic i32 [[VB]], ptr [[BUF1_B]] unordered, align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[INDVARS_IV_NEXT]], 3200
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_END:%.*]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:

  %indvars.iv = phi i32 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %indvars.iv.next = add i32 %indvars.iv, 2
  %indvars.mid = add i32 %indvars.iv, 1
  %buf0_a = getelementptr i32, ptr %buf_0, i32 %indvars.iv
  %buf0_b = getelementptr i32, ptr %buf_0, i32 %indvars.mid
  %buf1_a = getelementptr i32, ptr %buf_1, i32 %indvars.iv
  %buf1_b = getelementptr i32, ptr %buf_1, i32 %indvars.mid
  %va = load atomic i32, ptr %buf0_a unordered, align 4
  %vb = load atomic i32, ptr %buf0_b unordered, align 4
  fence seq_cst
  store atomic i32 %va, ptr %buf1_a unordered, align 4
  store atomic i32 %vb, ptr %buf1_b unordered, align 4
  %cmp = icmp slt i32 %indvars.iv.next, 3200
  br i1 %cmp, label %for.body, label %for.end

for.end:
  ret void
}

define void @pointer_bitcast_baseinst(ptr %arg, ptr %arg1, i64 %arg2) {
; CHECK-LABEL: define void @pointer_bitcast_baseinst
; CHECK-SAME: (ptr [[ARG:%.*]], ptr [[ARG1:%.*]], i64 [[ARG2:%.*]]) {
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[TMP0:%.*]] = add i64 [[ARG2]], -17
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i64 [[TMP0]], 4
; CHECK-NEXT:    [[TMP2:%.*]] = shl nuw nsw i64 [[TMP1]], 1
; CHECK-NEXT:    [[TMP3:%.*]] = add nuw nsw i64 [[TMP2]], 1
; CHECK-NEXT:    br label [[BB3:%.*]]
; CHECK:       bb3:
; CHECK-NEXT:    [[INDVAR:%.*]] = phi i64 [ [[INDVAR_NEXT:%.*]], [[BB3]] ], [ 0, [[BB:%.*]] ]
; CHECK-NEXT:    [[TMP4:%.*]] = shl nuw i64 [[INDVAR]], 3
; CHECK-NEXT:    [[TMP5:%.*]] = add i64 [[TMP4]], 1
; CHECK-NEXT:    [[INST5:%.*]] = shl nuw i64 [[TMP5]], 1
; CHECK-NEXT:    [[INST6:%.*]] = getelementptr i8, ptr [[ARG1]], i64 [[INST5]]
; CHECK-NEXT:    [[INST8:%.*]] = load <8 x i16>, ptr [[INST6]], align 2
; CHECK-NEXT:    [[INST13:%.*]] = getelementptr i16, ptr [[ARG]], i64 [[TMP5]]
; CHECK-NEXT:    store <8 x i16> [[INST8]], ptr [[INST13]], align 2
; CHECK-NEXT:    [[INDVAR_NEXT]] = add i64 [[INDVAR]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[INDVAR]], [[TMP3]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[BB19:%.*]], label [[BB3]]
; CHECK:       bb19:
; CHECK-NEXT:    ret void
;
bb:
  br label %bb3

bb3:                                              ; preds = %bb3, %bb
  %inst = phi i64 [ 1, %bb ], [ %inst17, %bb3 ]
  %inst4 = add nuw i64 %inst, 8
  %inst5 = shl nuw i64 %inst, 1
  %inst6 = getelementptr i8, ptr %arg1, i64 %inst5
  %inst8 = load <8 x i16>, ptr %inst6, align 2
  %inst9 = shl i64 %inst4, 1
  %inst10 = getelementptr i8, ptr %arg1, i64 %inst9
  %inst12 = load <8 x i16>, ptr %inst10, align 2
  %inst13 = getelementptr i16, ptr %arg, i64 %inst
  store <8 x i16> %inst8, ptr %inst13, align 2
  %inst15 = getelementptr i16, ptr %arg, i64 %inst4
  store <8 x i16> %inst12, ptr %inst15, align 2
  %inst17 = add nuw nsw i64 %inst, 16
  %inst18 = icmp eq i64 %inst17, %arg2
  br i1 %inst18, label %bb19, label %bb3

bb19:                                             ; preds = %bb3
  ret void
}

define void @bad_step(ptr nocapture readnone %x) #0 {
; CHECK-LABEL: define void @bad_step
; CHECK-SAME: (ptr nocapture readnone [[X:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[I_08:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[ADD3:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[CALL:%.*]] = tail call i32 @foo(i32 [[I_08]]) #[[ATTR1]]
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[I_08]], 2
; CHECK-NEXT:    [[CALL1:%.*]] = tail call i32 @foo(i32 [[ADD]]) #[[ATTR1]]
; CHECK-NEXT:    [[ADD2:%.*]] = add nsw i32 [[I_08]], 3
; CHECK-NEXT:    [[CALL3:%.*]] = tail call i32 @foo(i32 [[ADD2]]) #[[ATTR1]]
; CHECK-NEXT:    [[ADD3]] = add nsw i32 [[I_08]], 6
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp sge i32 [[ADD3]], 500
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %i.08 = phi i32 [ 0, %entry ], [ %add3, %for.body ]
  %call = tail call i32 @foo(i32 %i.08) #1
  %add = add nsw i32 %i.08, 2
  %call1 = tail call i32 @foo(i32 %add) #1
  %add2 = add nsw i32 %i.08, 3
  %call3 = tail call i32 @foo(i32 %add2) #1
  %add3 = add nsw i32 %i.08, 6
  %exitcond = icmp sge i32 %add3, 500
  br i1 %exitcond, label %for.end, label %for.body


for.end:                                          ; preds = %for.body
  ret void
}

@a = external global [2 x [512 x i64]], align 16
@b = external global [512 x [4 x i64]], align 16

define void @ptr_step_crash() {
; CHECK-LABEL: define void @ptr_step_crash() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY42_3:%.*]]
; CHECK:       for.body42.3:
; CHECK-NEXT:    [[K_2207_3:%.*]] = phi i32 [ -512, [[ENTRY:%.*]] ], [ [[INC63_3:%.*]], [[FOR_BODY42_3]] ]
; CHECK-NEXT:    [[SUB46_3:%.*]] = add nsw i32 [[K_2207_3]], 512
; CHECK-NEXT:    [[IDXPROM47_3:%.*]] = zext i32 [[SUB46_3]] to i64
; CHECK-NEXT:    [[ARRAYIDX48_3:%.*]] = getelementptr inbounds [2 x [512 x i64]], ptr @a, i64 0, i64 0, i64 [[IDXPROM47_3]]
; CHECK-NEXT:    [[ARRAYIDX55_3:%.*]] = getelementptr inbounds [512 x [4 x i64]], ptr @b, i64 0, i64 [[IDXPROM47_3]], i64 3
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[ARRAYIDX55_3]], align 8
; CHECK-NEXT:    [[INC63_3]] = add nsw i32 [[K_2207_3]], 1
; CHECK-NEXT:    br i1 true, label [[FOR_INC65_3:%.*]], label [[FOR_BODY42_3]]
; CHECK:       for.inc65.3:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body42.3

for.body42.3:                                     ; preds = %for.body42.3, %entry
  %k.2207.3 = phi i32 [ -512, %entry ], [ %inc63.3, %for.body42.3 ]
  %sub46.3 = add nsw i32 %k.2207.3, 512
  %idxprom47.3 = zext i32 %sub46.3 to i64
  %arrayidx48.3 = getelementptr inbounds [2 x [512 x i64]], ptr @a, i64 0, i64 0, i64 %idxprom47.3
  %arrayidx55.3 = getelementptr inbounds [512 x [4 x i64]], ptr @b, i64 0, i64 %idxprom47.3, i64 3
  %0 = load i64, ptr %arrayidx55.3, align 8
  %inc63.3 = add nsw i32 %k.2207.3, 1
  br i1 undef, label %for.inc65.3, label %for.body42.3

for.inc65.3:                                      ; preds = %for.body42.3
  ret void
}

attributes #0 = { nounwind uwtable }
attributes #1 = { nounwind }
