; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse4.2 -post-RA-scheduler=true | FileCheck %s

; Widen a v3i16 to v8i16 to do a vector add

@.str = internal constant [4 x i8] c"%d \00"
@.str1 = internal constant [2 x i8] c"\0A\00"

define void @update(ptr %dst, ptr %src, i32 %n) nounwind {
; CHECK-LABEL: update:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushl %ebp
; CHECK-NEXT:    movl %esp, %ebp
; CHECK-NEXT:    andl $-8, %esp
; CHECK-NEXT:    subl $16, %esp
; CHECK-NEXT:    pcmpeqd %xmm0, %xmm0
; CHECK-NEXT:    movw $1, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl $65537, {{[0-9]+}}(%esp) # imm = 0x10001
; CHECK-NEXT:    movl $0, {{[0-9]+}}(%esp)
; CHECK-NEXT:    .p2align 4, 0x90
; CHECK-NEXT:  .LBB0_1: # %forcond
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    cmpl 16(%ebp), %eax
; CHECK-NEXT:    jge .LBB0_3
; CHECK-NEXT:  # %bb.2: # %forbody
; CHECK-NEXT:    # in Loop: Header=BB0_1 Depth=1
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movl 12(%ebp), %edx
; CHECK-NEXT:    movl 8(%ebp), %ecx
; CHECK-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; CHECK-NEXT:    pinsrw $2, 4(%edx,%eax,8), %xmm1
; CHECK-NEXT:    psubw %xmm0, %xmm1
; CHECK-NEXT:    pextrw $2, %xmm1, 4(%ecx,%eax,8)
; CHECK-NEXT:    movd %xmm1, (%ecx,%eax,8)
; CHECK-NEXT:    incl {{[0-9]+}}(%esp)
; CHECK-NEXT:    jmp .LBB0_1
; CHECK-NEXT:  .LBB0_3: # %afterfor
; CHECK-NEXT:    movl %ebp, %esp
; CHECK-NEXT:    popl %ebp
; CHECK-NEXT:    retl
entry:
	%dst.addr = alloca ptr
	%src.addr = alloca ptr
	%n.addr = alloca i32
	%v = alloca <3 x i16>, align 8
	%i = alloca i32, align 4
	store ptr %dst, ptr %dst.addr
	store ptr %src, ptr %src.addr
	store i32 %n, ptr %n.addr
	store <3 x i16> < i16 1, i16 1, i16 1 >, ptr %v
	store i32 0, ptr %i
	br label %forcond

forcond:
	%tmp = load i32, ptr %i
	%tmp1 = load i32, ptr %n.addr
	%cmp = icmp slt i32 %tmp, %tmp1
	br i1 %cmp, label %forbody, label %afterfor

forbody:
	%tmp2 = load i32, ptr %i
	%tmp3 = load ptr, ptr %dst.addr
	%arrayidx = getelementptr <3 x i16>, ptr %tmp3, i32 %tmp2
	%tmp4 = load i32, ptr %i
	%tmp5 = load ptr, ptr %src.addr
	%arrayidx6 = getelementptr <3 x i16>, ptr %tmp5, i32 %tmp4
	%tmp7 = load <3 x i16>, ptr %arrayidx6
	%add = add <3 x i16> %tmp7, < i16 1, i16 1, i16 1 >
	store <3 x i16> %add, ptr %arrayidx
	br label %forinc

forinc:
	%tmp8 = load i32, ptr %i
	%inc = add i32 %tmp8, 1
	store i32 %inc, ptr %i
	br label %forcond

afterfor:
	ret void
}

