; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -mcpu=gfx1100 -mattr="+wavefrontsize32" -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX11,SDAG-GFX11 %s
; RUN: llc -march=amdgcn -mcpu=gfx1010 -mattr="+wavefrontsize32" -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX10,SDAG-GFX10 %s

; RUN: llc -global-isel -march=amdgcn -mcpu=gfx1100 -mattr="+wavefrontsize32" -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX11,GISEL-GFX11 %s
; RUN: llc -global-isel -march=amdgcn -mcpu=gfx1010 -mattr="+wavefrontsize32" -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX10,GISEL-GFX10 %s

declare i32 @llvm.amdgcn.fcmp.f32(float, float, i32) #0
declare i32 @llvm.amdgcn.fcmp.f64(double, double, i32) #0
declare float @llvm.fabs.f32(float) #0

declare i32 @llvm.amdgcn.fcmp.f16(half, half, i32) #0
declare half @llvm.fabs.f16(half) #0

define amdgpu_kernel void @v_fcmp_f32_oeq_with_fabs(ptr addrspace(1) %out, float %src, float %a) {
; SDAG-GFX11-LABEL: v_fcmp_f32_oeq_with_fabs:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_eq_f32_e64 s2, s2, |s3|
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f32_oeq_with_fabs:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_eq_f32_e64 s2, s2, |s3|
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f32_oeq_with_fabs:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_eq_f32_e64 s2, s2, |s3|
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f32_oeq_with_fabs:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_eq_f32_e64 s2, s2, |s3|
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GISEL-GFX10-NEXT:    s_endpgm
  %temp = call float @llvm.fabs.f32(float %a)
  %result = call i32 @llvm.amdgcn.fcmp.f32(float %src, float %temp, i32 1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_oeq_both_operands_with_fabs(ptr addrspace(1) %out, float %src, float %a) {
; SDAG-GFX11-LABEL: v_fcmp_f32_oeq_both_operands_with_fabs:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_eq_f32_e64 s2, |s2|, |s3|
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f32_oeq_both_operands_with_fabs:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_eq_f32_e64 s2, |s2|, |s3|
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f32_oeq_both_operands_with_fabs:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_eq_f32_e64 s2, |s2|, |s3|
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f32_oeq_both_operands_with_fabs:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_eq_f32_e64 s2, |s2|, |s3|
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GISEL-GFX10-NEXT:    s_endpgm
  %temp = call float @llvm.fabs.f32(float %a)
  %src_input = call float @llvm.fabs.f32(float %src)
  %result = call i32 @llvm.amdgcn.fcmp.f32(float %src_input, float %temp, i32 1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32(ptr addrspace(1) %out, float %src) {
; SDAG-GFX11-LABEL: v_fcmp_f32:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f32:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f32:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    global_store_b32 v0, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f32:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    global_store_dword v0, v0, s[0:1]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 -1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_oeq(ptr addrspace(1) %out, float %src) {
; SDAG-GFX11-LABEL: v_fcmp_f32_oeq:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_eq_f32_e64 s2, 0x42c80000, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f32_oeq:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_eq_f32_e64 s0, 0x42c80000, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f32_oeq:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_eq_f32_e64 s2, 0x42c80000, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f32_oeq:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_eq_f32_e64 s0, 0x42c80000, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_one(ptr addrspace(1) %out, float %src) {
; SDAG-GFX11-LABEL: v_fcmp_f32_one:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_neq_f32_e64 s2, 0x42c80000, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f32_one:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_neq_f32_e64 s0, 0x42c80000, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f32_one:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_neq_f32_e64 s2, 0x42c80000, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f32_one:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_neq_f32_e64 s0, 0x42c80000, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 6)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_ogt(ptr addrspace(1) %out, float %src) {
; SDAG-GFX11-LABEL: v_fcmp_f32_ogt:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_lt_f32_e64 s2, 0x42c80000, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f32_ogt:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_lt_f32_e64 s0, 0x42c80000, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f32_ogt:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_lt_f32_e64 s2, 0x42c80000, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f32_ogt:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_lt_f32_e64 s0, 0x42c80000, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 2)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_oge(ptr addrspace(1) %out, float %src) {
; SDAG-GFX11-LABEL: v_fcmp_f32_oge:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_le_f32_e64 s2, 0x42c80000, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f32_oge:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_le_f32_e64 s0, 0x42c80000, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f32_oge:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_le_f32_e64 s2, 0x42c80000, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f32_oge:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_le_f32_e64 s0, 0x42c80000, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 3)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_olt(ptr addrspace(1) %out, float %src) {
; SDAG-GFX11-LABEL: v_fcmp_f32_olt:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_gt_f32_e64 s2, 0x42c80000, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f32_olt:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_gt_f32_e64 s0, 0x42c80000, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f32_olt:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_gt_f32_e64 s2, 0x42c80000, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f32_olt:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_gt_f32_e64 s0, 0x42c80000, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 4)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_ole(ptr addrspace(1) %out, float %src) {
; SDAG-GFX11-LABEL: v_fcmp_f32_ole:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_ge_f32_e64 s2, 0x42c80000, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f32_ole:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_ge_f32_e64 s0, 0x42c80000, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f32_ole:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_ge_f32_e64 s2, 0x42c80000, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f32_ole:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_ge_f32_e64 s0, 0x42c80000, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 5)
  store i32 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f32_ueq(ptr addrspace(1) %out, float %src) {
; SDAG-GFX11-LABEL: v_fcmp_f32_ueq:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_nlg_f32_e64 s2, 0x42c80000, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f32_ueq:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_nlg_f32_e64 s0, 0x42c80000, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f32_ueq:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_nlg_f32_e64 s2, 0x42c80000, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f32_ueq:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_nlg_f32_e64 s0, 0x42c80000, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 9)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_une(ptr addrspace(1) %out, float %src) {
; SDAG-GFX11-LABEL: v_fcmp_f32_une:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_neq_f32_e64 s2, 0x42c80000, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f32_une:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_neq_f32_e64 s0, 0x42c80000, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f32_une:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_neq_f32_e64 s2, 0x42c80000, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f32_une:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_neq_f32_e64 s0, 0x42c80000, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 14)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_ugt(ptr addrspace(1) %out, float %src) {
; SDAG-GFX11-LABEL: v_fcmp_f32_ugt:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_nge_f32_e64 s2, 0x42c80000, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f32_ugt:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_nge_f32_e64 s0, 0x42c80000, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f32_ugt:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_nge_f32_e64 s2, 0x42c80000, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f32_ugt:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_nge_f32_e64 s0, 0x42c80000, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 10)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_uge(ptr addrspace(1) %out, float %src) {
; SDAG-GFX11-LABEL: v_fcmp_f32_uge:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_ngt_f32_e64 s2, 0x42c80000, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f32_uge:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_ngt_f32_e64 s0, 0x42c80000, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f32_uge:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_ngt_f32_e64 s2, 0x42c80000, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f32_uge:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_ngt_f32_e64 s0, 0x42c80000, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 11)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_ult(ptr addrspace(1) %out, float %src) {
; SDAG-GFX11-LABEL: v_fcmp_f32_ult:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_nle_f32_e64 s2, 0x42c80000, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f32_ult:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_nle_f32_e64 s0, 0x42c80000, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f32_ult:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_nle_f32_e64 s2, 0x42c80000, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f32_ult:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_nle_f32_e64 s0, 0x42c80000, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 12)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_ule(ptr addrspace(1) %out, float %src) {
; SDAG-GFX11-LABEL: v_fcmp_f32_ule:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_nlt_f32_e64 s2, 0x42c80000, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f32_ule:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_nlt_f32_e64 s0, 0x42c80000, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f32_ule:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_nlt_f32_e64 s2, 0x42c80000, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f32_ule:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_nlt_f32_e64 s0, 0x42c80000, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 13)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_oeq(ptr addrspace(1) %out, double %src) {
; SDAG-GFX11-LABEL: v_fcmp_f64_oeq:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_eq_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f64_oeq:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_eq_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f64_oeq:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GISEL-GFX11-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_eq_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f64_oeq:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_eq_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_one(ptr addrspace(1) %out, double %src) {
; SDAG-GFX11-LABEL: v_fcmp_f64_one:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_neq_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f64_one:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_neq_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f64_one:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GISEL-GFX11-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_neq_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f64_one:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_neq_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 6)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ogt(ptr addrspace(1) %out, double %src) {
; SDAG-GFX11-LABEL: v_fcmp_f64_ogt:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_gt_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f64_ogt:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_gt_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f64_ogt:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GISEL-GFX11-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_gt_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f64_ogt:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_gt_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 2)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_oge(ptr addrspace(1) %out, double %src) {
; SDAG-GFX11-LABEL: v_fcmp_f64_oge:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_ge_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f64_oge:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_ge_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f64_oge:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GISEL-GFX11-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_ge_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f64_oge:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_ge_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 3)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_olt(ptr addrspace(1) %out, double %src) {
; SDAG-GFX11-LABEL: v_fcmp_f64_olt:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_lt_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f64_olt:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_lt_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f64_olt:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GISEL-GFX11-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_lt_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f64_olt:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_lt_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 4)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ole(ptr addrspace(1) %out, double %src) {
; SDAG-GFX11-LABEL: v_fcmp_f64_ole:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_le_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f64_ole:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_le_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f64_ole:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GISEL-GFX11-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_le_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f64_ole:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_le_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 5)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ueq(ptr addrspace(1) %out, double %src) {
; SDAG-GFX11-LABEL: v_fcmp_f64_ueq:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_nlg_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f64_ueq:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_nlg_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f64_ueq:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GISEL-GFX11-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_nlg_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f64_ueq:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_nlg_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 9)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_une(ptr addrspace(1) %out, double %src) {
; SDAG-GFX11-LABEL: v_fcmp_f64_une:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_neq_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f64_une:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_neq_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f64_une:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GISEL-GFX11-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_neq_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f64_une:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_neq_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 14)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ugt(ptr addrspace(1) %out, double %src) {
; SDAG-GFX11-LABEL: v_fcmp_f64_ugt:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_nle_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f64_ugt:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_nle_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f64_ugt:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GISEL-GFX11-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_nle_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f64_ugt:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_nle_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 10)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_uge(ptr addrspace(1) %out, double %src) {
; SDAG-GFX11-LABEL: v_fcmp_f64_uge:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_nlt_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f64_uge:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_nlt_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f64_uge:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GISEL-GFX11-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_nlt_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f64_uge:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_nlt_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 11)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ult(ptr addrspace(1) %out, double %src) {
; SDAG-GFX11-LABEL: v_fcmp_f64_ult:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_nge_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f64_ult:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_nge_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f64_ult:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GISEL-GFX11-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_nge_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f64_ult:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_nge_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 12)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ule(ptr addrspace(1) %out, double %src) {
; SDAG-GFX11-LABEL: v_fcmp_f64_ule:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_ngt_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f64_ule:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    s_mov_b32 s4, 0
; SDAG-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_ngt_f64_e64 s2, s[2:3], s[4:5]
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f64_ule:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GISEL-GFX11-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_ngt_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f64_ule:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX10-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_ngt_f64_e64 s2, s[2:3], s[4:5]
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[0:1]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 13)
  store i32 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_oeq_with_fabs(ptr addrspace(1) %out, half %src, half %a) {
; SDAG-GFX11-LABEL: v_fcmp_f16_oeq_with_fabs:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    s_lshr_b32 s3, s2, 16
; SDAG-GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_cmp_eq_f16_e64 s2, s2, |s3|
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f16_oeq_with_fabs:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    s_lshr_b32 s0, s4, 16
; SDAG-GFX10-NEXT:    v_cmp_eq_f16_e64 s0, s4, |s0|
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f16_oeq_with_fabs:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    s_lshr_b32 s3, s2, 16
; GISEL-GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_cmp_eq_f16_e64 s2, s2, |s3|
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f16_oeq_with_fabs:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    s_lshr_b32 s0, s4, 16
; GISEL-GFX10-NEXT:    v_cmp_eq_f16_e64 s0, s4, |s0|
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %temp = call half @llvm.fabs.f16(half %a)
  %result = call i32 @llvm.amdgcn.fcmp.f16(half %src, half %temp, i32 1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_oeq_both_operands_with_fabs(ptr addrspace(1) %out, half %src, half %a) {
; SDAG-GFX11-LABEL: v_fcmp_f16_oeq_both_operands_with_fabs:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    s_lshr_b32 s3, s2, 16
; SDAG-GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_cmp_eq_f16_e64 s2, |s2|, |s3|
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f16_oeq_both_operands_with_fabs:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    s_lshr_b32 s0, s4, 16
; SDAG-GFX10-NEXT:    v_cmp_eq_f16_e64 s0, |s4|, |s0|
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f16_oeq_both_operands_with_fabs:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    s_lshr_b32 s3, s2, 16
; GISEL-GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_cmp_eq_f16_e64 s2, |s2|, |s3|
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f16_oeq_both_operands_with_fabs:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    s_lshr_b32 s0, s4, 16
; GISEL-GFX10-NEXT:    v_cmp_eq_f16_e64 s0, |s4|, |s0|
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %temp = call half @llvm.fabs.f16(half %a)
  %src_input = call half @llvm.fabs.f16(half %src)
  %result = call i32 @llvm.amdgcn.fcmp.f16(half %src_input, half %temp, i32 1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f16(ptr addrspace(1) %out, half %src) {
; SDAG-GFX11-LABEL: v_fcmp_f16:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f16:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f16:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    global_store_b32 v0, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f16:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    global_store_dword v0, v0, s[0:1]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 -1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_oeq(ptr addrspace(1) %out, half %src) {
; SDAG-GFX11-LABEL: v_fcmp_f16_oeq:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_eq_f16_e64 s2, 0x5640, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f16_oeq:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_eq_f16_e64 s0, 0x5640, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f16_oeq:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_eq_f16_e64 s2, 0x5640, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f16_oeq:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_eq_f16_e64 s0, 0x5640, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_one(ptr addrspace(1) %out, half %src) {
; SDAG-GFX11-LABEL: v_fcmp_f16_one:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_neq_f16_e64 s2, 0x5640, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f16_one:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_neq_f16_e64 s0, 0x5640, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f16_one:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_neq_f16_e64 s2, 0x5640, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f16_one:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_neq_f16_e64 s0, 0x5640, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 6)
  store i32 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_ogt(ptr addrspace(1) %out, half %src) {
; SDAG-GFX11-LABEL: v_fcmp_f16_ogt:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_lt_f16_e64 s2, 0x5640, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f16_ogt:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_lt_f16_e64 s0, 0x5640, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f16_ogt:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_lt_f16_e64 s2, 0x5640, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f16_ogt:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_lt_f16_e64 s0, 0x5640, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 2)
  store i32 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_oge(ptr addrspace(1) %out, half %src) {
; SDAG-GFX11-LABEL: v_fcmp_f16_oge:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_le_f16_e64 s2, 0x5640, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f16_oge:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_le_f16_e64 s0, 0x5640, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f16_oge:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_le_f16_e64 s2, 0x5640, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f16_oge:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_le_f16_e64 s0, 0x5640, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 3)
  store i32 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_olt(ptr addrspace(1) %out, half %src) {
; SDAG-GFX11-LABEL: v_fcmp_f16_olt:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_gt_f16_e64 s2, 0x5640, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f16_olt:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_gt_f16_e64 s0, 0x5640, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f16_olt:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_gt_f16_e64 s2, 0x5640, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f16_olt:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_gt_f16_e64 s0, 0x5640, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 4)
  store i32 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_ole(ptr addrspace(1) %out, half %src) {
; SDAG-GFX11-LABEL: v_fcmp_f16_ole:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_ge_f16_e64 s2, 0x5640, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f16_ole:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_ge_f16_e64 s0, 0x5640, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f16_ole:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_ge_f16_e64 s2, 0x5640, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f16_ole:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_ge_f16_e64 s0, 0x5640, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 5)
  store i32 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_ueq(ptr addrspace(1) %out, half %src) {
; SDAG-GFX11-LABEL: v_fcmp_f16_ueq:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_nlg_f16_e64 s2, 0x5640, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f16_ueq:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_nlg_f16_e64 s0, 0x5640, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f16_ueq:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_nlg_f16_e64 s2, 0x5640, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f16_ueq:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_nlg_f16_e64 s0, 0x5640, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 9)
  store i32 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_une(ptr addrspace(1) %out, half %src) {
; SDAG-GFX11-LABEL: v_fcmp_f16_une:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_neq_f16_e64 s2, 0x5640, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f16_une:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_neq_f16_e64 s0, 0x5640, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f16_une:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_neq_f16_e64 s2, 0x5640, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f16_une:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_neq_f16_e64 s0, 0x5640, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 14)
  store i32 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_ugt(ptr addrspace(1) %out, half %src) {
; SDAG-GFX11-LABEL: v_fcmp_f16_ugt:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_nge_f16_e64 s2, 0x5640, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f16_ugt:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_nge_f16_e64 s0, 0x5640, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f16_ugt:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_nge_f16_e64 s2, 0x5640, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f16_ugt:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_nge_f16_e64 s0, 0x5640, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 10)
  store i32 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_uge(ptr addrspace(1) %out, half %src) {
; SDAG-GFX11-LABEL: v_fcmp_f16_uge:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_ngt_f16_e64 s2, 0x5640, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f16_uge:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_ngt_f16_e64 s0, 0x5640, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f16_uge:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_ngt_f16_e64 s2, 0x5640, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f16_uge:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_ngt_f16_e64 s0, 0x5640, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 11)
  store i32 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_ult(ptr addrspace(1) %out, half %src) {
; SDAG-GFX11-LABEL: v_fcmp_f16_ult:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_nle_f16_e64 s2, 0x5640, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f16_ult:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_nle_f16_e64 s0, 0x5640, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f16_ult:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_nle_f16_e64 s2, 0x5640, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f16_ult:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_nle_f16_e64 s0, 0x5640, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 12)
  store i32 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_ule(ptr addrspace(1) %out, half %src) {
; SDAG-GFX11-LABEL: v_fcmp_f16_ule:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_clause 0x1
; SDAG-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; SDAG-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; SDAG-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_cmp_nlt_f16_e64 s2, 0x5640, s2
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; SDAG-GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-GFX10-LABEL: v_fcmp_f16_ule:
; SDAG-GFX10:       ; %bb.0:
; SDAG-GFX10-NEXT:    s_clause 0x1
; SDAG-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; SDAG-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX10-NEXT:    v_cmp_nlt_f16_e64 s0, 0x5640, s4
; SDAG-GFX10-NEXT:    v_mov_b32_e32 v1, s0
; SDAG-GFX10-NEXT:    global_store_dword v0, v1, s[2:3]
; SDAG-GFX10-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f16_ule:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_clause 0x1
; GISEL-GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_cmp_nlt_f16_e64 s2, 0x5640, s2
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-GFX10-LABEL: v_fcmp_f16_ule:
; GISEL-GFX10:       ; %bb.0:
; GISEL-GFX10-NEXT:    s_clause 0x1
; GISEL-GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GISEL-GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX10-NEXT:    v_cmp_nlt_f16_e64 s0, 0x5640, s4
; GISEL-GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GISEL-GFX10-NEXT:    s_endpgm
  %result = call i32 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 13)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

attributes #0 = { nounwind readnone convergent }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GCN: {{.*}}
; GFX10: {{.*}}
; GFX11: {{.*}}
