; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instcombine -S | FileCheck %s

declare void @use8(i8)

define i6 @add_shl_same_amount(i6 %x, i6 %y, i6 %z) {
; CHECK-LABEL: @add_shl_same_amount(
; CHECK-NEXT:    [[TMP1:%.*]] = add i6 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl i6 [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret i6 [[DIFF]]
;
  %xs = shl i6 %x, %z
  %ys = shl i6 %y, %z
  %diff = add i6 %xs, %ys
  ret i6 %diff
}

define <2 x i4> @add_shl_same_amount_nsw(<2 x i4> %x, <2 x i4> %y, <2 x i4> %z) {
; CHECK-LABEL: @add_shl_same_amount_nsw(
; CHECK-NEXT:    [[TMP1:%.*]] = add nsw <2 x i4> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl nsw <2 x i4> [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret <2 x i4> [[DIFF]]
;
  %xs = shl nsw <2 x i4> %x, %z
  %ys = shl nsw <2 x i4> %y, %z
  %diff = add nsw <2 x i4> %xs, %ys
  ret <2 x i4> %diff
}

define i64 @add_shl_same_amount_nuw(i64 %x, i64 %y, i64 %z) {
; CHECK-LABEL: @add_shl_same_amount_nuw(
; CHECK-NEXT:    [[TMP1:%.*]] = add nuw i64 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl nuw i64 [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret i64 [[DIFF]]
;
  %xs = shl nuw i64 %x, %z
  %ys = shl nuw i64 %y, %z
  %diff = add nuw i64 %xs, %ys
  ret i64 %diff
}

define i8 @add_shl_same_amount_nsw_extra_use1(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @add_shl_same_amount_nsw_extra_use1(
; CHECK-NEXT:    [[XS:%.*]] = shl nuw nsw i8 [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    call void @use8(i8 [[XS]])
; CHECK-NEXT:    [[TMP1:%.*]] = add nsw i8 [[X]], [[Y:%.*]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl nsw i8 [[TMP1]], [[Z]]
; CHECK-NEXT:    ret i8 [[DIFF]]
;
  %xs = shl nsw nuw i8 %x, %z
  call void @use8(i8 %xs)
  %ys = shl nsw nuw i8 %y, %z
  %diff = add nsw i8 %xs, %ys
  ret i8 %diff
}

define i8 @add_shl_same_amount_nuw_extra_use2(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @add_shl_same_amount_nuw_extra_use2(
; CHECK-NEXT:    [[YS:%.*]] = shl nuw nsw i8 [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    call void @use8(i8 [[YS]])
; CHECK-NEXT:    [[TMP1:%.*]] = add nuw i8 [[X:%.*]], [[Y]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl nuw i8 [[TMP1]], [[Z]]
; CHECK-NEXT:    ret i8 [[DIFF]]
;
  %xs = shl nuw i8 %x, %z
  %ys = shl nsw nuw i8 %y, %z
  call void @use8(i8 %ys)
  %diff = add nsw nuw i8 %xs, %ys
  ret i8 %diff
}

define i8 @add_shl_same_amount_nsw_nuw_extra_use3(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @add_shl_same_amount_nsw_nuw_extra_use3(
; CHECK-NEXT:    [[XS:%.*]] = shl nuw nsw i8 [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    call void @use8(i8 [[XS]])
; CHECK-NEXT:    [[YS:%.*]] = shl nuw nsw i8 [[Y:%.*]], [[Z]]
; CHECK-NEXT:    call void @use8(i8 [[YS]])
; CHECK-NEXT:    [[DIFF:%.*]] = add nuw nsw i8 [[XS]], [[YS]]
; CHECK-NEXT:    ret i8 [[DIFF]]
;
  %xs = shl nsw nuw i8 %x, %z
  call void @use8(i8 %xs)
  %ys = shl nsw nuw i8 %y, %z
  call void @use8(i8 %ys)
  %diff = add nsw nuw i8 %xs, %ys
  ret i8 %diff
}

define i6 @add_shl_same_amount_partial_nsw1(i6 %x, i6 %y, i6 %z) {
; CHECK-LABEL: @add_shl_same_amount_partial_nsw1(
; CHECK-NEXT:    [[TMP1:%.*]] = add i6 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl i6 [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret i6 [[DIFF]]
;
  %xs = shl nsw i6 %x, %z
  %ys = shl nsw i6 %y, %z
  %diff = add i6 %xs, %ys
  ret i6 %diff
}

define i6 @add_shl_same_amount_partial_nsw2(i6 %x, i6 %y, i6 %z) {
; CHECK-LABEL: @add_shl_same_amount_partial_nsw2(
; CHECK-NEXT:    [[TMP1:%.*]] = add i6 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl i6 [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret i6 [[DIFF]]
;
  %xs = shl i6 %x, %z
  %ys = shl nsw i6 %y, %z
  %diff = add nsw i6 %xs, %ys
  ret i6 %diff
}

define i6 @add_shl_same_amount_partial_nuw1(i6 %x, i6 %y, i6 %z) {
; CHECK-LABEL: @add_shl_same_amount_partial_nuw1(
; CHECK-NEXT:    [[TMP1:%.*]] = add i6 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl i6 [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret i6 [[DIFF]]
;
  %xs = shl nuw i6 %x, %z
  %ys = shl nuw i6 %y, %z
  %diff = add i6 %xs, %ys
  ret i6 %diff
}

define i6 @add_shl_same_amount_partial_nuw2(i6 %x, i6 %y, i6 %z) {
; CHECK-LABEL: @add_shl_same_amount_partial_nuw2(
; CHECK-NEXT:    [[TMP1:%.*]] = add i6 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl i6 [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret i6 [[DIFF]]
;
  %xs = shl nuw i6 %x, %z
  %ys = shl i6 %y, %z
  %diff = add nuw i6 %xs, %ys
  ret i6 %diff
}

define i6 @sub_shl_same_amount(i6 %x, i6 %y, i6 %z) {
; CHECK-LABEL: @sub_shl_same_amount(
; CHECK-NEXT:    [[TMP1:%.*]] = sub i6 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl i6 [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret i6 [[DIFF]]
;
  %xs = shl i6 %x, %z
  %ys = shl i6 %y, %z
  %diff = sub i6 %xs, %ys
  ret i6 %diff
}

define <2 x i4> @sub_shl_same_amount_nsw(<2 x i4> %x, <2 x i4> %y, <2 x i4> %z) {
; CHECK-LABEL: @sub_shl_same_amount_nsw(
; CHECK-NEXT:    [[TMP1:%.*]] = sub nsw <2 x i4> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl nsw <2 x i4> [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret <2 x i4> [[DIFF]]
;
  %xs = shl nsw <2 x i4> %x, %z
  %ys = shl nsw <2 x i4> %y, %z
  %diff = sub nsw <2 x i4> %xs, %ys
  ret <2 x i4> %diff
}

define i64 @sub_shl_same_amount_nuw(i64 %x, i64 %y, i64 %z) {
; CHECK-LABEL: @sub_shl_same_amount_nuw(
; CHECK-NEXT:    [[TMP1:%.*]] = sub nuw i64 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl nuw i64 [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret i64 [[DIFF]]
;
  %xs = shl nuw i64 %x, %z
  %ys = shl nuw i64 %y, %z
  %diff = sub nuw i64 %xs, %ys
  ret i64 %diff
}

define i8 @sub_shl_same_amount_nsw_extra_use1(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @sub_shl_same_amount_nsw_extra_use1(
; CHECK-NEXT:    [[XS:%.*]] = shl nuw nsw i8 [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    call void @use8(i8 [[XS]])
; CHECK-NEXT:    [[TMP1:%.*]] = sub nsw i8 [[X]], [[Y:%.*]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl nsw i8 [[TMP1]], [[Z]]
; CHECK-NEXT:    ret i8 [[DIFF]]
;
  %xs = shl nsw nuw i8 %x, %z
  call void @use8(i8 %xs)
  %ys = shl nsw nuw i8 %y, %z
  %diff = sub nsw i8 %xs, %ys
  ret i8 %diff
}

define i8 @sub_shl_same_amount_nuw_extra_use2(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @sub_shl_same_amount_nuw_extra_use2(
; CHECK-NEXT:    [[YS:%.*]] = shl nuw nsw i8 [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    call void @use8(i8 [[YS]])
; CHECK-NEXT:    [[TMP1:%.*]] = sub nuw i8 [[X:%.*]], [[Y]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl nuw i8 [[TMP1]], [[Z]]
; CHECK-NEXT:    ret i8 [[DIFF]]
;
  %xs = shl nuw i8 %x, %z
  %ys = shl nsw nuw i8 %y, %z
  call void @use8(i8 %ys)
  %diff = sub nsw nuw i8 %xs, %ys
  ret i8 %diff
}

define i8 @sub_shl_same_amount_nsw_nuw_extra_use3(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @sub_shl_same_amount_nsw_nuw_extra_use3(
; CHECK-NEXT:    [[XS:%.*]] = shl nuw nsw i8 [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    call void @use8(i8 [[XS]])
; CHECK-NEXT:    [[YS:%.*]] = shl nuw nsw i8 [[Y:%.*]], [[Z]]
; CHECK-NEXT:    call void @use8(i8 [[YS]])
; CHECK-NEXT:    [[DIFF:%.*]] = sub nuw nsw i8 [[XS]], [[YS]]
; CHECK-NEXT:    ret i8 [[DIFF]]
;
  %xs = shl nsw nuw i8 %x, %z
  call void @use8(i8 %xs)
  %ys = shl nsw nuw i8 %y, %z
  call void @use8(i8 %ys)
  %diff = sub nsw nuw i8 %xs, %ys
  ret i8 %diff
}

define i6 @sub_shl_same_amount_partial_nsw1(i6 %x, i6 %y, i6 %z) {
; CHECK-LABEL: @sub_shl_same_amount_partial_nsw1(
; CHECK-NEXT:    [[TMP1:%.*]] = sub i6 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl i6 [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret i6 [[DIFF]]
;
  %xs = shl nsw i6 %x, %z
  %ys = shl nsw i6 %y, %z
  %diff = sub i6 %xs, %ys
  ret i6 %diff
}

define i6 @sub_shl_same_amount_partial_nsw2(i6 %x, i6 %y, i6 %z) {
; CHECK-LABEL: @sub_shl_same_amount_partial_nsw2(
; CHECK-NEXT:    [[TMP1:%.*]] = sub i6 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl i6 [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret i6 [[DIFF]]
;
  %xs = shl i6 %x, %z
  %ys = shl nsw i6 %y, %z
  %diff = sub nsw i6 %xs, %ys
  ret i6 %diff
}

define i6 @sub_shl_same_amount_partial_nuw1(i6 %x, i6 %y, i6 %z) {
; CHECK-LABEL: @sub_shl_same_amount_partial_nuw1(
; CHECK-NEXT:    [[TMP1:%.*]] = sub i6 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl i6 [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret i6 [[DIFF]]
;
  %xs = shl nuw i6 %x, %z
  %ys = shl nuw i6 %y, %z
  %diff = sub i6 %xs, %ys
  ret i6 %diff
}

define i6 @sub_shl_same_amount_partial_nuw2(i6 %x, i6 %y, i6 %z) {
; CHECK-LABEL: @sub_shl_same_amount_partial_nuw2(
; CHECK-NEXT:    [[TMP1:%.*]] = sub i6 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[DIFF:%.*]] = shl i6 [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret i6 [[DIFF]]
;
  %xs = shl nuw i6 %x, %z
  %ys = shl i6 %y, %z
  %diff = sub nuw i6 %xs, %ys
  ret i6 %diff
}

