; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=m68k-linux-gnu -verify-machineinstrs | FileCheck %s

declare {i32, i1} @llvm.umul.with.overflow.i32(i32 %a, i32 %b)

define i1 @a(i32 %x)  nounwind {
; CHECK-LABEL: a:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    sub.l #20, %sp
; CHECK-NEXT:    move.l #3, (12,%sp)
; CHECK-NEXT:    move.l #0, (8,%sp)
; CHECK-NEXT:    move.l (24,%sp), (4,%sp)
; CHECK-NEXT:    move.l #0, (%sp)
; CHECK-NEXT:    jsr __muldi3
; CHECK-NEXT:    cmpi.l #0, %d0
; CHECK-NEXT:    sne %d0
; CHECK-NEXT:    add.l #20, %sp
; CHECK-NEXT:    rts
  %res = call {i32, i1} @llvm.umul.with.overflow.i32(i32 %x, i32 3)
  %obil = extractvalue {i32, i1} %res, 1
  ret i1 %obil
}

define i32 @test2(i32 %a, i32 %b) nounwind readnone {
; CHECK-LABEL: test2:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    move.l (8,%sp), %d0
; CHECK-NEXT:    add.l (4,%sp), %d0
; CHECK-NEXT:    add.l %d0, %d0
; CHECK-NEXT:    rts
entry:
	%tmp0 = add i32 %b, %a
	%tmp1 = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 %tmp0, i32 2)
	%tmp2 = extractvalue { i32, i1 } %tmp1, 0
	ret i32 %tmp2
}

; It shouldn't fallback to builtin in this scenario
; Since we don't need the overflow bit here
define i32 @test3(i32 %a, i32 %b) nounwind readnone {
; CHECK-LABEL: test3:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    move.l (8,%sp), %d0
; CHECK-NEXT:    add.l (4,%sp), %d0
; CHECK-NEXT:    lsl.l #2, %d0
; CHECK-NEXT:    rts
entry:
	%tmp0 = add i32 %b, %a
	%tmp1 = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 %tmp0, i32 4)
	%tmp2 = extractvalue { i32, i1 } %tmp1, 0
	ret i32 %tmp2
}
