/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CPSuri;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyId;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyInfo;
import org.mozilla.jss.netscape.security.x509.DisplayText;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.NoticeReference;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.PolicyQualifierInfo;
import org.mozilla.jss.netscape.security.x509.PolicyQualifiers;
import org.mozilla.jss.netscape.security.x509.UserNotice;

public class CertificatePoliciesExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = -3729294064061837367L;
    public static final String IDENT = "x509.info.extensions.CertificatePolicies";
    public static final String NAME = "CertificatePolicies";
    public static final String INFOS = "infos";
    private Vector<CertificatePolicyInfo> mInfos;
    private static final String[] NAMES = new String[]{"infos"};

    private void encodeThis() throws IOException {
        try (DerOutputStream os = new DerOutputStream();){
            DerOutputStream tmp = new DerOutputStream();
            for (int i = 0; i < this.mInfos.size(); ++i) {
                this.mInfos.elementAt(i).encode(tmp);
            }
            os.write((byte)48, tmp);
            this.extensionValue = os.toByteArray();
        }
    }

    public CertificatePoliciesExtension(boolean critical, Vector<CertificatePolicyInfo> infos) throws IOException {
        this.mInfos = infos;
        this.extensionId = PKIXExtensions.CertificatePolicies_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public CertificatePoliciesExtension(Vector<CertificatePolicyInfo> infos) throws IOException {
        this.mInfos = infos;
        this.extensionId = PKIXExtensions.CertificatePolicies_Id;
        this.critical = false;
        this.encodeThis();
    }

    public CertificatePoliciesExtension() {
        this.extensionId = PKIXExtensions.CertificatePolicies_Id;
        this.critical = false;
        this.mInfos = new Vector(1, 1);
    }

    public CertificatePoliciesExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.CertificatePolicies_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for CertificatePoliciesExtension.");
        }
        this.mInfos = new Vector(1, 1);
        while (val.data.available() != 0) {
            DerValue seq = val.data.getDerValue();
            CertificatePolicyInfo info = new CertificatePolicyInfo(seq);
            this.mInfos.addElement(info);
        }
    }

    @Override
    public String toString() {
        if (this.mInfos == null) {
            return "";
        }
        String s = super.toString() + "Certificate Policies [\n" + this.mInfos.toString() + "]\n";
        return s;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.CertificatePolicies_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        this.clearValue();
        if (name.equalsIgnoreCase(INFOS)) {
            if (!(obj instanceof Vector)) {
                throw new IOException("Attribute value should be of type Vector.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificatePoliciesExtension.");
        }
        this.mInfos = (Vector)obj;
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(INFOS)) {
            return this.mInfos;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificatePoliciesExtension.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(INFOS)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificatePoliciesExtension.");
        }
        this.mInfos = null;
    }

    public Enumeration<Vector<CertificatePolicyInfo>> getAttributes() {
        Vector<Vector<CertificatePolicyInfo>> elements = new Vector<Vector<CertificatePolicyInfo>>();
        elements.addElement(this.mInfos);
        return elements.elements();
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(Arrays.asList(NAMES));
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static void main(String[] args) {
        CertificatePolicyId plcyId0 = new CertificatePolicyId(new ObjectIdentifier("1.2.3.5"));
        PolicyQualifiers qualifiers0 = new PolicyQualifiers();
        CPSuri cpsQualifier0 = new CPSuri("http://home.netscape.com");
        PolicyQualifierInfo qualifierInfo0 = new PolicyQualifierInfo(PolicyQualifierInfo.QT_CPS, cpsQualifier0);
        qualifiers0.add(qualifierInfo0);
        CertificatePolicyInfo info0 = new CertificatePolicyInfo(plcyId0, qualifiers0);
        CertificatePolicyId plcyId1 = new CertificatePolicyId(new ObjectIdentifier("2.3.5"));
        PolicyQualifiers qualifiers1 = new PolicyQualifiers();
        DisplayText org1 = new DisplayText(30, "org");
        int[] nums = new int[]{1, 2};
        NoticeReference nr1 = new NoticeReference(org1, nums);
        DisplayText dt1 = new DisplayText(30, "dt");
        UserNotice userNotice1 = new UserNotice(nr1, dt1);
        PolicyQualifierInfo qualifierInfo1 = new PolicyQualifierInfo(PolicyQualifierInfo.QT_UNOTICE, userNotice1);
        qualifiers1.add(qualifierInfo0);
        qualifiers1.add(qualifierInfo1);
        CertificatePolicyInfo info1 = new CertificatePolicyInfo(plcyId1, qualifiers1);
        Vector<CertificatePolicyInfo> infos = new Vector<CertificatePolicyInfo>();
        infos.addElement(info0);
        infos.addElement(info1);
        try {
            CertificatePoliciesExtension ext = new CertificatePoliciesExtension(infos);
            System.out.println(Utils.base64encode(ext.getExtensionValue(), true));
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }
}

