"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const axios_1 = tslib_1.__importDefault(require("axios"));
const grafanaURL = (owner, repo) => `https://api.github.com/repos/${owner}/${repo}`;
const enterpriseURL = 'https://api.github.com/repos/grafana/grafana-enterprise';
class GithubClient {
    constructor({ required = false, enterprise = false, owner = 'grafana', repo = 'grafana' } = {}) {
        const username = process.env.GITHUB_USERNAME;
        const token = process.env.GITHUB_ACCESS_TOKEN;
        const clientConfig = {
            baseURL: enterprise ? enterpriseURL : grafanaURL(owner, repo),
            timeout: 10000,
        };
        if (required && !username && !token) {
            throw new Error('operation needs a GITHUB_USERNAME and GITHUB_ACCESS_TOKEN environment variables');
        }
        if (username && token) {
            clientConfig.auth = { username: username, password: token };
        }
        this.client = this.createClient(clientConfig);
    }
    createClient(clientConfig) {
        return axios_1.default.create(clientConfig);
    }
}
exports.default = GithubClient;
//# sourceMappingURL=githubClient.js.map