/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.taglib.servlet.taglib;

import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONDeserializerUtil;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.taglib.servlet.ServletContextUtil;
import com.liferay.dynamic.data.mapping.taglib.servlet.taglib.base.BaseHTMLTag;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverterUtil;
import com.liferay.dynamic.data.mapping.util.DDMUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class HTMLTag
extends BaseHTMLTag {
    private static final Log _log = LogFactoryUtil.getLog(HTMLTag.class);

    @Override
    public int doStartTag() throws JspException {
        DDMFormValues ddmFormValues;
        if (!this.getIgnoreRequestValue() && (ddmFormValues = this.getDDMFormValuesFromRequest()) != null) {
            this.setDdmFormValues(ddmFormValues);
        }
        return super.doStartTag();
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.setServletContext(ServletContextUtil.getServletContext());
    }

    protected DDMForm getDDMForm() {
        try {
            return DDMUtil.getDDMForm((long)this.getClassNameId(), (long)this.getClassPK());
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)this.getLogMessage(), (Throwable)pe);
            }
            return null;
        }
    }

    protected DDMFormValues getDDMFormValuesFromRequest() {
        block3: {
            String serializedDDMFormValues = ParamUtil.getString((HttpServletRequest)this.request, (String)this.getDDMFormValuesInputName());
            if (Validator.isNotNull((String)serializedDDMFormValues)) {
                DDMForm ddmForm = this.getDDMForm();
                try {
                    return DDMFormValuesJSONDeserializerUtil.deserialize((DDMForm)ddmForm, (String)serializedDDMFormValues);
                }
                catch (PortalException e) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)e, (Throwable)e);
                }
            }
        }
        return null;
    }

    protected String getDDMFormValuesInputName() {
        String fieldsNamespace = GetterUtil.getString((String)this.getFieldsNamespace());
        return fieldsNamespace + "ddmFormValues";
    }

    protected Fields getFields() {
        block4: {
            try {
                long ddmStructureId = this.getClassPK();
                if (this.getClassNameId() == PortalUtil.getClassNameId(DDMTemplate.class)) {
                    DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)this.getClassPK());
                    ddmStructureId = ddmTemplate.getClassPK();
                }
                DDMStructure ddmStructure = DDMStructureServiceUtil.getStructure((long)ddmStructureId);
                if (this.getDdmFormValues() != null) {
                    return DDMFormValuesToFieldsConverterUtil.convert((DDMStructure)ddmStructure, (DDMFormValues)this.getDdmFormValues());
                }
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)this.getLogMessage(), (Throwable)pe);
            }
        }
        return null;
    }

    protected String getLogMessage() {
        if (this.getClassNameId() == PortalUtil.getClassNameId(DDMTemplate.class)) {
            return "Unable to retrieve DDM template with class PK " + this.getClassPK();
        }
        return "Unable to retrieve DDM structure with class PK " + this.getClassPK();
    }

    protected String getMode() {
        if (this.getClassNameId() != PortalUtil.getClassNameId(DDMTemplate.class)) {
            return null;
        }
        try {
            DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)this.getClassPK());
            return ddmTemplate.getMode();
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)this.getLogMessage(), (Throwable)pe);
            }
            return null;
        }
    }

    protected String getRandomNamespace() {
        return PortalUtil.generateRandomKey((HttpServletRequest)this.request, (String)"taglib_ddm_init-ext");
    }

    @Override
    protected void setAttributes(HttpServletRequest request) {
        super.setAttributes(request);
        this.setNamespacedAttribute(request, "ddmForm", this.getDDMForm());
        this.setNamespacedAttribute(request, "ddmFormValuesInputName", this.getDDMFormValuesInputName());
        this.setNamespacedAttribute(request, "fields", this.getFields());
        this.setNamespacedAttribute(request, "mode", this.getMode());
        this.setNamespacedAttribute(request, "randomNamespace", this.getRandomNamespace());
    }
}

