/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.volatility;

import org.jquantlib.lang.reflect.TypeToken;
import org.jquantlib.math.IntervalPrice;
import org.jquantlib.model.volatility.GarmanKlassAbstract;
import org.jquantlib.model.volatility.LocalVolatilityEstimator;
import org.jquantlib.util.Date;
import org.jquantlib.util.TimeSeries;
import org.jquantlib.util.TimeSeriesDouble;

public class GarmanKlassOpenClose<T extends GarmanKlassAbstract>
implements LocalVolatilityEstimator<IntervalPrice> {
    private double f;
    private double a;
    private T delegate = null;

    public GarmanKlassOpenClose(double y, double marketOpenFraction, double a) {
        try {
            this.delegate = (GarmanKlassAbstract)TypeToken.getClazz(this.getClass()).getConstructor(Double.TYPE).newInstance(y);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.f = marketOpenFraction;
        this.a = a;
    }

    @Override
    public TimeSeriesDouble calculate(TimeSeries<IntervalPrice> quoteSeries) {
        Date[] dates = quoteSeries.dates();
        IntervalPrice[] values = quoteSeries.values().toArray(new IntervalPrice[0]);
        TimeSeriesDouble retval = new TimeSeriesDouble();
        IntervalPrice prev = null;
        IntervalPrice cur = null;
        for (int i = 1; i < values.length; ++i) {
            cur = values[i];
            prev = values[i - 1];
            double c0 = Math.log(prev.close());
            double o1 = Math.log(cur.open());
            double sigma2 = this.a * (o1 - c0) * (o1 - c0) / this.f + (1.0 - this.a) * ((GarmanKlassAbstract)this.delegate).calculatePoint(cur) / (1.0 - this.f);
            double s = Math.sqrt(sigma2 / ((GarmanKlassAbstract)this.delegate).getYearFraction());
            retval.add(dates[i], s);
        }
        return retval;
    }
}

