/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.daycounters.Actual365Fixed;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.calendars.Target;
import org.jquantlib.util.Date;

public abstract class ForwardRateStructure
extends YieldTermStructure {
    protected ForwardRateStructure() {
        this(Actual365Fixed.getDayCounter());
    }

    protected ForwardRateStructure(DayCounter dc) {
        super(dc);
    }

    protected ForwardRateStructure(Date refDate, Calendar cal) {
        this(refDate, cal, (DayCounter)Actual365Fixed.getDayCounter());
    }

    protected ForwardRateStructure(Date refDate, DayCounter dc) {
        this(refDate, (Calendar)Target.getCalendar(), dc);
    }

    protected ForwardRateStructure(Date refDate) {
        this(refDate, (Calendar)Target.getCalendar(), (DayCounter)Actual365Fixed.getDayCounter());
    }

    protected ForwardRateStructure(Date refDate, Calendar cal, DayCounter dc) {
        super(refDate, cal, dc);
    }

    protected ForwardRateStructure(int settlDays, Calendar cal) {
        super(settlDays, cal, (DayCounter)Actual365Fixed.getDayCounter());
    }

    protected ForwardRateStructure(int settlDays, Calendar cal, DayCounter dc) {
        super(settlDays, cal, dc);
    }

    protected abstract double forwardImpl(double var1);

    protected double zeroYieldImpl(double t) {
        double dt;
        if (t == 0.0) {
            return this.forwardImpl(0.0);
        }
        double sum = 0.5 * this.forwardImpl(0.0);
        int n = 1000;
        for (double i = dt = t / (double)n; i < t; i += dt) {
            sum += this.forwardImpl(i);
        }
        return (sum += 0.5 * this.forwardImpl(t)) * dt / t;
    }

    @Override
    protected double discountImpl(double t) {
        double r = this.zeroYieldImpl(t);
        return Math.exp(-r * t);
    }
}

