/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.mina.common.ByteBuffer;

public class ByteBufferProxy
extends ByteBuffer {
    protected ByteBuffer buf;

    protected ByteBufferProxy(ByteBuffer buf) {
        if (buf == null) {
            throw new NullPointerException("buf");
        }
        this.buf = buf;
    }

    public void acquire() {
        this.buf.acquire();
    }

    public void release() {
        this.buf.release();
    }

    public boolean isDirect() {
        return this.buf.isDirect();
    }

    public java.nio.ByteBuffer buf() {
        return this.buf.buf();
    }

    public int capacity() {
        return this.buf.capacity();
    }

    public int position() {
        return this.buf.position();
    }

    public ByteBuffer position(int newPosition) {
        this.buf.position(newPosition);
        return this;
    }

    public int limit() {
        return this.buf.limit();
    }

    public ByteBuffer limit(int newLimit) {
        this.buf.limit(newLimit);
        return this;
    }

    public ByteBuffer mark() {
        this.buf.mark();
        return this;
    }

    public ByteBuffer reset() {
        this.buf.reset();
        return this;
    }

    public ByteBuffer clear() {
        this.buf.clear();
        return this;
    }

    public ByteBuffer sweep() {
        this.buf.sweep();
        return this;
    }

    public ByteBuffer sweep(byte value) {
        this.buf.sweep(value);
        return this;
    }

    public ByteBuffer flip() {
        this.buf.flip();
        return this;
    }

    public ByteBuffer rewind() {
        this.buf.rewind();
        return this;
    }

    public int remaining() {
        return this.buf.remaining();
    }

    public boolean hasRemaining() {
        return this.buf.hasRemaining();
    }

    public byte get() {
        return this.buf.get();
    }

    public short getUnsigned() {
        return this.buf.getUnsigned();
    }

    public ByteBuffer put(byte b) {
        this.buf.put(b);
        return this;
    }

    public byte get(int index) {
        return this.buf.get(index);
    }

    public short getUnsigned(int index) {
        return this.buf.getUnsigned(index);
    }

    public ByteBuffer put(int index, byte b) {
        this.buf.put(index, b);
        return this;
    }

    public ByteBuffer get(byte[] dst, int offset, int length) {
        this.buf.get(dst, offset, length);
        return this;
    }

    public ByteBuffer get(byte[] dst) {
        this.buf.get(dst);
        return this;
    }

    public ByteBuffer put(ByteBuffer src) {
        this.buf.put(src);
        return this;
    }

    public ByteBuffer put(java.nio.ByteBuffer src) {
        this.buf.put(src);
        return this;
    }

    public ByteBuffer put(byte[] src, int offset, int length) {
        this.buf.put(src, offset, length);
        return this;
    }

    public ByteBuffer put(byte[] src) {
        this.buf.put(src);
        return this;
    }

    public ByteBuffer compact() {
        this.buf.compact();
        return this;
    }

    public String toString() {
        return this.buf.toString();
    }

    public int hashCode() {
        return this.buf.hashCode();
    }

    public boolean equals(Object ob) {
        return this.buf.equals(ob);
    }

    public int compareTo(Object o) {
        return this.buf.compareTo(o);
    }

    public ByteOrder order() {
        return this.buf.order();
    }

    public ByteBuffer order(ByteOrder bo) {
        this.buf.order(bo);
        return this;
    }

    public char getChar() {
        return this.buf.getChar();
    }

    public ByteBuffer putChar(char value) {
        this.buf.putChar(value);
        return this;
    }

    public char getChar(int index) {
        return this.buf.getChar(index);
    }

    public ByteBuffer putChar(int index, char value) {
        this.buf.putChar(index, value);
        return this;
    }

    public CharBuffer asCharBuffer() {
        return this.buf.asCharBuffer();
    }

    public short getShort() {
        return this.buf.getShort();
    }

    public int getUnsignedShort() {
        return this.buf.getUnsignedShort();
    }

    public ByteBuffer putShort(short value) {
        this.buf.putShort(value);
        return this;
    }

    public short getShort(int index) {
        return this.buf.getShort(index);
    }

    public int getUnsignedShort(int index) {
        return this.buf.getUnsignedShort(index);
    }

    public ByteBuffer putShort(int index, short value) {
        this.buf.putShort(index, value);
        return this;
    }

    public ShortBuffer asShortBuffer() {
        return this.buf.asShortBuffer();
    }

    public int getInt() {
        return this.buf.getInt();
    }

    public long getUnsignedInt() {
        return this.buf.getUnsignedInt();
    }

    public ByteBuffer putInt(int value) {
        this.buf.putInt(value);
        return this;
    }

    public int getInt(int index) {
        return this.buf.getInt(index);
    }

    public long getUnsignedInt(int index) {
        return this.buf.getUnsignedInt(index);
    }

    public ByteBuffer putInt(int index, int value) {
        this.buf.putInt(index, value);
        return this;
    }

    public IntBuffer asIntBuffer() {
        return this.buf.asIntBuffer();
    }

    public long getLong() {
        return this.buf.getLong();
    }

    public ByteBuffer putLong(long value) {
        this.buf.putLong(value);
        return this;
    }

    public long getLong(int index) {
        return this.buf.getLong(index);
    }

    public ByteBuffer putLong(int index, long value) {
        this.buf.putLong(index, value);
        return this;
    }

    public LongBuffer asLongBuffer() {
        return this.buf.asLongBuffer();
    }

    public float getFloat() {
        return this.buf.getFloat();
    }

    public ByteBuffer putFloat(float value) {
        this.buf.putFloat(value);
        return this;
    }

    public float getFloat(int index) {
        return this.buf.getFloat(index);
    }

    public ByteBuffer putFloat(int index, float value) {
        this.buf.putFloat(index, value);
        return this;
    }

    public FloatBuffer asFloatBuffer() {
        return this.buf.asFloatBuffer();
    }

    public double getDouble() {
        return this.buf.getDouble();
    }

    public ByteBuffer putDouble(double value) {
        this.buf.putDouble(value);
        return this;
    }

    public double getDouble(int index) {
        return this.buf.getDouble(index);
    }

    public ByteBuffer putDouble(int index, double value) {
        this.buf.putDouble(index, value);
        return this;
    }

    public DoubleBuffer asDoubleBuffer() {
        return this.buf.asDoubleBuffer();
    }

    public String getHexDump() {
        return this.buf.getHexDump();
    }

    public String getString(int fieldSize, CharsetDecoder decoder) throws CharacterCodingException {
        return this.buf.getString(fieldSize, decoder);
    }

    public String getString(CharsetDecoder decoder) throws CharacterCodingException {
        return this.buf.getString(decoder);
    }

    public String getPrefixedString(CharsetDecoder decoder) throws CharacterCodingException {
        return this.buf.getPrefixedString(decoder);
    }

    public String getPrefixedString(int prefixLength, CharsetDecoder decoder) throws CharacterCodingException {
        return this.buf.getPrefixedString(prefixLength, decoder);
    }

    public ByteBuffer putString(CharSequence in, int fieldSize, CharsetEncoder encoder) throws CharacterCodingException {
        this.buf.putString(in, fieldSize, encoder);
        return this;
    }

    public ByteBuffer putString(CharSequence in, CharsetEncoder encoder) throws CharacterCodingException {
        this.buf.putString(in, encoder);
        return this;
    }

    public ByteBuffer putPrefixedString(CharSequence in, CharsetEncoder encoder) throws CharacterCodingException {
        this.buf.putPrefixedString(in, encoder);
        return this;
    }

    public ByteBuffer putPrefixedString(CharSequence in, int prefixLength, CharsetEncoder encoder) throws CharacterCodingException {
        this.buf.putPrefixedString(in, prefixLength, encoder);
        return this;
    }

    public ByteBuffer putPrefixedString(CharSequence in, int prefixLength, int padding, CharsetEncoder encoder) throws CharacterCodingException {
        this.buf.putPrefixedString(in, prefixLength, padding, encoder);
        return this;
    }

    public ByteBuffer putPrefixedString(CharSequence in, int prefixLength, int padding, byte padValue, CharsetEncoder encoder) throws CharacterCodingException {
        this.buf.putPrefixedString(in, prefixLength, padding, padValue, encoder);
        return this;
    }

    public ByteBuffer skip(int size) {
        this.buf.skip(size);
        return this;
    }

    public ByteBuffer fill(byte value, int size) {
        this.buf.fill(value, size);
        return this;
    }

    public ByteBuffer fillAndReset(byte value, int size) {
        this.buf.fillAndReset(value, size);
        return this;
    }

    public ByteBuffer fill(int size) {
        this.buf.fill(size);
        return this;
    }

    public ByteBuffer fillAndReset(int size) {
        this.buf.fillAndReset(size);
        return this;
    }

    public boolean isAutoExpand() {
        return this.buf.isAutoExpand();
    }

    public ByteBuffer setAutoExpand(boolean autoExpand) {
        this.buf.setAutoExpand(autoExpand);
        return this;
    }

    public ByteBuffer expand(int pos, int expectedRemaining) {
        this.buf.expand(pos, expectedRemaining);
        return this;
    }

    public ByteBuffer expand(int expectedRemaining) {
        this.buf.expand(expectedRemaining);
        return this;
    }

    public boolean isPooled() {
        return this.buf.isPooled();
    }

    public void setPooled(boolean pooled) {
        this.buf.setPooled(pooled);
    }

    public Object getObject() throws ClassNotFoundException {
        return this.buf.getObject();
    }

    public Object getObject(ClassLoader classLoader) throws ClassNotFoundException {
        return this.buf.getObject(classLoader);
    }

    public ByteBuffer putObject(Object o) {
        this.buf.putObject(o);
        return this;
    }

    public InputStream asInputStream() {
        return this.buf.asInputStream();
    }

    public OutputStream asOutputStream() {
        return this.buf.asOutputStream();
    }

    public ByteBuffer duplicate() {
        return this.buf.duplicate();
    }

    public ByteBuffer slice() {
        return this.buf.slice();
    }

    public ByteBuffer asReadOnlyBuffer() {
        return this.buf.asReadOnlyBuffer();
    }

    public byte[] array() {
        return this.buf.array();
    }

    public int arrayOffset() {
        return this.buf.arrayOffset();
    }

    public ByteBuffer capacity(int newCapacity) {
        this.buf.capacity(newCapacity);
        return this;
    }

    public boolean isReadOnly() {
        return this.buf.isReadOnly();
    }

    public int markValue() {
        return this.buf.markValue();
    }
}

