/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla.finitedifferences;

import org.jquantlib.math.SampledCurve;
import org.jquantlib.methods.finitedifferences.StandardFiniteDifferenceModel;
import org.jquantlib.pricingengines.Greeks;
import org.jquantlib.pricingengines.OneAssetOptionEngine;
import org.jquantlib.pricingengines.results.OneAssetOptionResults;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDVanillaEngine;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public class FDEuropeanEngine
extends OneAssetOptionEngine {
    private final FDVanillaEngine fdVanillaEngine;
    private SampledCurve prices;

    public FDEuropeanEngine(GeneralizedBlackScholesProcess process, int timeSteps, int gridPoints, boolean timeDependent) {
        this.fdVanillaEngine = new FDVanillaEngine(process, timeSteps, gridPoints, timeDependent);
        this.prices = new SampledCurve(gridPoints);
    }

    public FDEuropeanEngine(GeneralizedBlackScholesProcess stochProcess, int binomialSteps, int samples) {
        this(stochProcess, binomialSteps, samples, false);
    }

    @Override
    public void calculate() {
        this.fdVanillaEngine.setupArguments(this.arguments);
        this.fdVanillaEngine.setGridLimits();
        this.fdVanillaEngine.initializeInitialCondition();
        this.fdVanillaEngine.initializeOperator();
        this.fdVanillaEngine.initializeBoundaryConditions();
        StandardFiniteDifferenceModel model = new StandardFiniteDifferenceModel(this.fdVanillaEngine.finiteDifferenceOperator, this.fdVanillaEngine.bcS);
        this.prices = new SampledCurve(this.fdVanillaEngine.intrinsicValues);
        this.prices.setValues(model.rollback(this.prices.values(), this.fdVanillaEngine.getResidualTime(), 0.0, this.fdVanillaEngine.timeSteps));
        ((OneAssetOptionResults)this.results).value = this.prices.valueAtCenter();
        ((OneAssetOptionResults)this.results).delta = this.prices.firstDerivativeAtCenter();
        ((OneAssetOptionResults)this.results).gamma = this.prices.secondDerivativeAtCenter();
        ((OneAssetOptionResults)this.results).theta = Greeks.blackScholesTheta(this.fdVanillaEngine.process, ((OneAssetOptionResults)this.results).value, ((OneAssetOptionResults)this.results).delta, ((OneAssetOptionResults)this.results).gamma);
        ((OneAssetOptionResults)this.results).addAdditionalResult("priceCurve", this.prices);
    }
}

