/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the ContainerManifestResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ContainerManifestResponse{}

// ContainerManifestResponse Serializer for Manifests.
type ContainerManifestResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	// Artifact file representing the physical content
	Artifact string `json:"artifact"`
	// sha256 of the Manifest file
	Digest string `json:"digest"`
	// Manifest schema version
	SchemaVersion int64 `json:"schema_version"`
	// Manifest media type of the file
	MediaType string `json:"media_type"`
	// Manifests that are referenced by this Manifest List
	ListedManifests []string `json:"listed_manifests"`
	// Blob that contains configuration for this Manifest
	ConfigBlob *string `json:"config_blob,omitempty"`
	// Blobs that are referenced by this Manifest
	Blobs []string `json:"blobs"`
	AdditionalProperties map[string]interface{}
}

type _ContainerManifestResponse ContainerManifestResponse

// NewContainerManifestResponse instantiates a new ContainerManifestResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewContainerManifestResponse(artifact string, digest string, schemaVersion int64, mediaType string, listedManifests []string, blobs []string) *ContainerManifestResponse {
	this := ContainerManifestResponse{}
	this.Artifact = artifact
	this.Digest = digest
	this.SchemaVersion = schemaVersion
	this.MediaType = mediaType
	this.ListedManifests = listedManifests
	this.Blobs = blobs
	return &this
}

// NewContainerManifestResponseWithDefaults instantiates a new ContainerManifestResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewContainerManifestResponseWithDefaults() *ContainerManifestResponse {
	this := ContainerManifestResponse{}
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *ContainerManifestResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ContainerManifestResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *ContainerManifestResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *ContainerManifestResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *ContainerManifestResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ContainerManifestResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *ContainerManifestResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *ContainerManifestResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetArtifact returns the Artifact field value
func (o *ContainerManifestResponse) GetArtifact() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Artifact
}

// GetArtifactOk returns a tuple with the Artifact field value
// and a boolean to check if the value has been set.
func (o *ContainerManifestResponse) GetArtifactOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Artifact, true
}

// SetArtifact sets field value
func (o *ContainerManifestResponse) SetArtifact(v string) {
	o.Artifact = v
}

// GetDigest returns the Digest field value
func (o *ContainerManifestResponse) GetDigest() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Digest
}

// GetDigestOk returns a tuple with the Digest field value
// and a boolean to check if the value has been set.
func (o *ContainerManifestResponse) GetDigestOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Digest, true
}

// SetDigest sets field value
func (o *ContainerManifestResponse) SetDigest(v string) {
	o.Digest = v
}

// GetSchemaVersion returns the SchemaVersion field value
func (o *ContainerManifestResponse) GetSchemaVersion() int64 {
	if o == nil {
		var ret int64
		return ret
	}

	return o.SchemaVersion
}

// GetSchemaVersionOk returns a tuple with the SchemaVersion field value
// and a boolean to check if the value has been set.
func (o *ContainerManifestResponse) GetSchemaVersionOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return &o.SchemaVersion, true
}

// SetSchemaVersion sets field value
func (o *ContainerManifestResponse) SetSchemaVersion(v int64) {
	o.SchemaVersion = v
}

// GetMediaType returns the MediaType field value
func (o *ContainerManifestResponse) GetMediaType() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.MediaType
}

// GetMediaTypeOk returns a tuple with the MediaType field value
// and a boolean to check if the value has been set.
func (o *ContainerManifestResponse) GetMediaTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.MediaType, true
}

// SetMediaType sets field value
func (o *ContainerManifestResponse) SetMediaType(v string) {
	o.MediaType = v
}

// GetListedManifests returns the ListedManifests field value
func (o *ContainerManifestResponse) GetListedManifests() []string {
	if o == nil {
		var ret []string
		return ret
	}

	return o.ListedManifests
}

// GetListedManifestsOk returns a tuple with the ListedManifests field value
// and a boolean to check if the value has been set.
func (o *ContainerManifestResponse) GetListedManifestsOk() ([]string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ListedManifests, true
}

// SetListedManifests sets field value
func (o *ContainerManifestResponse) SetListedManifests(v []string) {
	o.ListedManifests = v
}

// GetConfigBlob returns the ConfigBlob field value if set, zero value otherwise.
func (o *ContainerManifestResponse) GetConfigBlob() string {
	if o == nil || IsNil(o.ConfigBlob) {
		var ret string
		return ret
	}
	return *o.ConfigBlob
}

// GetConfigBlobOk returns a tuple with the ConfigBlob field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ContainerManifestResponse) GetConfigBlobOk() (*string, bool) {
	if o == nil || IsNil(o.ConfigBlob) {
		return nil, false
	}
	return o.ConfigBlob, true
}

// HasConfigBlob returns a boolean if a field has been set.
func (o *ContainerManifestResponse) HasConfigBlob() bool {
	if o != nil && !IsNil(o.ConfigBlob) {
		return true
	}

	return false
}

// SetConfigBlob gets a reference to the given string and assigns it to the ConfigBlob field.
func (o *ContainerManifestResponse) SetConfigBlob(v string) {
	o.ConfigBlob = &v
}

// GetBlobs returns the Blobs field value
func (o *ContainerManifestResponse) GetBlobs() []string {
	if o == nil {
		var ret []string
		return ret
	}

	return o.Blobs
}

// GetBlobsOk returns a tuple with the Blobs field value
// and a boolean to check if the value has been set.
func (o *ContainerManifestResponse) GetBlobsOk() ([]string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Blobs, true
}

// SetBlobs sets field value
func (o *ContainerManifestResponse) SetBlobs(v []string) {
	o.Blobs = v
}

func (o ContainerManifestResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ContainerManifestResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	toSerialize["artifact"] = o.Artifact
	toSerialize["digest"] = o.Digest
	toSerialize["schema_version"] = o.SchemaVersion
	toSerialize["media_type"] = o.MediaType
	toSerialize["listed_manifests"] = o.ListedManifests
	if !IsNil(o.ConfigBlob) {
		toSerialize["config_blob"] = o.ConfigBlob
	}
	toSerialize["blobs"] = o.Blobs

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *ContainerManifestResponse) UnmarshalJSON(bytes []byte) (err error) {
	varContainerManifestResponse := _ContainerManifestResponse{}

	if err = json.Unmarshal(bytes, &varContainerManifestResponse); err == nil {
		*o = ContainerManifestResponse(varContainerManifestResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "artifact")
		delete(additionalProperties, "digest")
		delete(additionalProperties, "schema_version")
		delete(additionalProperties, "media_type")
		delete(additionalProperties, "listed_manifests")
		delete(additionalProperties, "config_blob")
		delete(additionalProperties, "blobs")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableContainerManifestResponse struct {
	value *ContainerManifestResponse
	isSet bool
}

func (v NullableContainerManifestResponse) Get() *ContainerManifestResponse {
	return v.value
}

func (v *NullableContainerManifestResponse) Set(val *ContainerManifestResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableContainerManifestResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableContainerManifestResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableContainerManifestResponse(val *ContainerManifestResponse) *NullableContainerManifestResponse {
	return &NullableContainerManifestResponse{value: val, isSet: true}
}

func (v NullableContainerManifestResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableContainerManifestResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


