/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the ArtifactRefResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ArtifactRefResponse{}

// ArtifactRefResponse A serializer for an Artifact reference.
type ArtifactRefResponse struct {
	Filename string `json:"filename"`
	Sha256 string `json:"sha256"`
	Size int64 `json:"size"`
	AdditionalProperties map[string]interface{}
}

type _ArtifactRefResponse ArtifactRefResponse

// NewArtifactRefResponse instantiates a new ArtifactRefResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewArtifactRefResponse(filename string, sha256 string, size int64) *ArtifactRefResponse {
	this := ArtifactRefResponse{}
	this.Filename = filename
	this.Sha256 = sha256
	this.Size = size
	return &this
}

// NewArtifactRefResponseWithDefaults instantiates a new ArtifactRefResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewArtifactRefResponseWithDefaults() *ArtifactRefResponse {
	this := ArtifactRefResponse{}
	return &this
}

// GetFilename returns the Filename field value
func (o *ArtifactRefResponse) GetFilename() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Filename
}

// GetFilenameOk returns a tuple with the Filename field value
// and a boolean to check if the value has been set.
func (o *ArtifactRefResponse) GetFilenameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Filename, true
}

// SetFilename sets field value
func (o *ArtifactRefResponse) SetFilename(v string) {
	o.Filename = v
}

// GetSha256 returns the Sha256 field value
func (o *ArtifactRefResponse) GetSha256() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Sha256
}

// GetSha256Ok returns a tuple with the Sha256 field value
// and a boolean to check if the value has been set.
func (o *ArtifactRefResponse) GetSha256Ok() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Sha256, true
}

// SetSha256 sets field value
func (o *ArtifactRefResponse) SetSha256(v string) {
	o.Sha256 = v
}

// GetSize returns the Size field value
func (o *ArtifactRefResponse) GetSize() int64 {
	if o == nil {
		var ret int64
		return ret
	}

	return o.Size
}

// GetSizeOk returns a tuple with the Size field value
// and a boolean to check if the value has been set.
func (o *ArtifactRefResponse) GetSizeOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Size, true
}

// SetSize sets field value
func (o *ArtifactRefResponse) SetSize(v int64) {
	o.Size = v
}

func (o ArtifactRefResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ArtifactRefResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["filename"] = o.Filename
	toSerialize["sha256"] = o.Sha256
	toSerialize["size"] = o.Size

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *ArtifactRefResponse) UnmarshalJSON(bytes []byte) (err error) {
	varArtifactRefResponse := _ArtifactRefResponse{}

	if err = json.Unmarshal(bytes, &varArtifactRefResponse); err == nil {
		*o = ArtifactRefResponse(varArtifactRefResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "filename")
		delete(additionalProperties, "sha256")
		delete(additionalProperties, "size")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableArtifactRefResponse struct {
	value *ArtifactRefResponse
	isSet bool
}

func (v NullableArtifactRefResponse) Get() *ArtifactRefResponse {
	return v.value
}

func (v *NullableArtifactRefResponse) Set(val *ArtifactRefResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableArtifactRefResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableArtifactRefResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableArtifactRefResponse(val *ArtifactRefResponse) *NullableArtifactRefResponse {
	return &NullableArtifactRefResponse{value: val, isSet: true}
}

func (v NullableArtifactRefResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableArtifactRefResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


