/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// PulpAnsibleApiV3CollectionVersionsAllAPIService PulpAnsibleApiV3CollectionVersionsAllAPI service
type PulpAnsibleApiV3CollectionVersionsAllAPIService service

type PulpAnsibleApiV3CollectionVersionsAllAPIPulpAnsibleGalaxyApiV3CollectionVersionsAllListRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleApiV3CollectionVersionsAllAPIService
	path string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r PulpAnsibleApiV3CollectionVersionsAllAPIPulpAnsibleGalaxyApiV3CollectionVersionsAllListRequest) Fields(fields []string) PulpAnsibleApiV3CollectionVersionsAllAPIPulpAnsibleGalaxyApiV3CollectionVersionsAllListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PulpAnsibleApiV3CollectionVersionsAllAPIPulpAnsibleGalaxyApiV3CollectionVersionsAllListRequest) ExcludeFields(excludeFields []string) PulpAnsibleApiV3CollectionVersionsAllAPIPulpAnsibleGalaxyApiV3CollectionVersionsAllListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PulpAnsibleApiV3CollectionVersionsAllAPIPulpAnsibleGalaxyApiV3CollectionVersionsAllListRequest) Execute() ([]UnpaginatedCollectionVersionResponse, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyApiV3CollectionVersionsAllListExecute(r)
}

/*
PulpAnsibleGalaxyApiV3CollectionVersionsAllList Method for PulpAnsibleGalaxyApiV3CollectionVersionsAllList

Legacy v3 endpoint.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param path
 @return PulpAnsibleApiV3CollectionVersionsAllAPIPulpAnsibleGalaxyApiV3CollectionVersionsAllListRequest

Deprecated
*/
func (a *PulpAnsibleApiV3CollectionVersionsAllAPIService) PulpAnsibleGalaxyApiV3CollectionVersionsAllList(ctx context.Context, path string) PulpAnsibleApiV3CollectionVersionsAllAPIPulpAnsibleGalaxyApiV3CollectionVersionsAllListRequest {
	return PulpAnsibleApiV3CollectionVersionsAllAPIPulpAnsibleGalaxyApiV3CollectionVersionsAllListRequest{
		ApiService: a,
		ctx: ctx,
		path: path,
	}
}

// Execute executes the request
//  @return []UnpaginatedCollectionVersionResponse
// Deprecated
func (a *PulpAnsibleApiV3CollectionVersionsAllAPIService) PulpAnsibleGalaxyApiV3CollectionVersionsAllListExecute(r PulpAnsibleApiV3CollectionVersionsAllAPIPulpAnsibleGalaxyApiV3CollectionVersionsAllListRequest) ([]UnpaginatedCollectionVersionResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  []UnpaginatedCollectionVersionResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleApiV3CollectionVersionsAllAPIService.PulpAnsibleGalaxyApiV3CollectionVersionsAllList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/{path}/api/v3/collection_versions/all/"
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", parameterValueToString(r.path, "path"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
