; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple riscv32-unknown-elf -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV32
; RUN: llc -mtriple riscv32-unknown-elf -mattr=+f -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV32-F
; RUN: llc -mtriple riscv32-unknown-elf -mattr=+f,+d -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV32-FD
;
; RUN: llc -mtriple riscv64-unknown-elf -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV64
; RUN: llc -mtriple riscv64-unknown-elf -mattr=+f -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV64-F
; RUN: llc -mtriple riscv64-unknown-elf -mattr=+f,+d -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV64-FD

;
; Checking for special return instructions (sret, mret).
;
define void @foo_supervisor() #0 {
; CHECK-LABEL: foo_supervisor:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sret
  ret void
}

define void @foo_machine() #1 {
; CHECK-LABEL: foo_machine:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mret
  ret void
}

;
; Checking all Caller saved registers (arguments and temps)
; and FP registers are all saved when the handler calls another function.
;
; extern int otherfoo();
;
; __attribute__((interrupt)) void foo_with_call() {
;   otherfoo();
; }
;

declare i32 @otherfoo(...)
define void @foo_with_call() #1 {
;
; CHECK-RV32-LABEL: foo_with_call:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -64
; CHECK-RV32-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t0, 56(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t1, 52(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t2, 48(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a0, 44(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a1, 40(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a2, 36(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a3, 32(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a4, 28(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a5, 24(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a6, 20(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a7, 16(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t3, 12(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t4, 8(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t5, 4(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t6, 0(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    call otherfoo@plt
; CHECK-RV32-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t0, 56(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t1, 52(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t2, 48(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a0, 44(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a1, 40(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a2, 36(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a3, 32(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a4, 28(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a5, 24(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a6, 20(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a7, 16(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t3, 12(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t4, 8(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t5, 4(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t6, 0(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    addi sp, sp, 64
; CHECK-RV32-NEXT:    mret
;
; CHECK-RV32-F-LABEL: foo_with_call:
; CHECK-RV32-F:       # %bb.0:
; CHECK-RV32-F-NEXT:    addi sp, sp, -192
; CHECK-RV32-F-NEXT:    sw ra, 188(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t0, 184(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t1, 180(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t2, 176(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a0, 172(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a1, 168(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a2, 164(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a3, 160(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a4, 156(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a5, 152(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a6, 148(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a7, 144(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t3, 140(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t4, 136(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t5, 132(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t6, 128(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft0, 124(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft1, 120(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft2, 116(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft3, 112(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft4, 108(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft5, 104(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft6, 100(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft7, 96(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs0, 92(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs1, 88(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa0, 84(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa1, 80(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa2, 76(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa3, 72(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa4, 68(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa5, 64(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa6, 60(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa7, 56(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs2, 52(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs3, 48(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs4, 44(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs5, 40(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs6, 36(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs7, 32(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs8, 28(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs9, 24(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs10, 20(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs11, 16(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft8, 12(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft9, 8(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft10, 4(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft11, 0(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    call otherfoo@plt
; CHECK-RV32-F-NEXT:    lw ra, 188(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t0, 184(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t1, 180(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t2, 176(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a0, 172(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a1, 168(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a2, 164(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a3, 160(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a4, 156(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a5, 152(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a6, 148(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a7, 144(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t3, 140(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t4, 136(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t5, 132(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t6, 128(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft0, 124(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft1, 120(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft2, 116(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft3, 112(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft4, 108(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft5, 104(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft6, 100(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft7, 96(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs0, 92(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs1, 88(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa0, 84(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa1, 80(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa2, 76(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa3, 72(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa4, 68(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa5, 64(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa6, 60(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa7, 56(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs2, 52(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs3, 48(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs4, 44(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs5, 40(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs6, 36(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs7, 32(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs8, 28(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs9, 24(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs10, 20(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs11, 16(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft8, 12(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft9, 8(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft10, 4(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft11, 0(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    addi sp, sp, 192
; CHECK-RV32-F-NEXT:    mret
;
; CHECK-RV32-FD-LABEL: foo_with_call:
; CHECK-RV32-FD:       # %bb.0:
; CHECK-RV32-FD-NEXT:    addi sp, sp, -320
; CHECK-RV32-FD-NEXT:    sw ra, 316(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t0, 312(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t1, 308(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t2, 304(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a0, 300(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a1, 296(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a2, 292(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a3, 288(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a4, 284(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a5, 280(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a6, 276(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a7, 272(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t3, 268(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t4, 264(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t5, 260(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t6, 256(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft0, 248(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft1, 240(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft2, 232(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft3, 224(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft4, 216(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft5, 208(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft6, 200(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft7, 192(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs0, 184(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs1, 176(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa0, 168(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa1, 160(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa2, 152(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa3, 144(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa4, 136(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa5, 128(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa6, 120(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa7, 112(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs2, 104(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs3, 96(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs4, 88(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs5, 80(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs6, 72(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs7, 64(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs8, 56(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs9, 48(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs10, 40(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs11, 32(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft8, 24(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft9, 16(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft10, 8(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft11, 0(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    call otherfoo@plt
; CHECK-RV32-FD-NEXT:    lw ra, 316(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t0, 312(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t1, 308(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t2, 304(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a0, 300(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a1, 296(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a2, 292(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a3, 288(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a4, 284(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a5, 280(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a6, 276(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a7, 272(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t3, 268(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t4, 264(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t5, 260(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t6, 256(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft0, 248(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft1, 240(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft2, 232(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft3, 224(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft4, 216(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft5, 208(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft6, 200(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft7, 192(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs0, 184(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs1, 176(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa0, 168(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa1, 160(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa2, 152(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa3, 144(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa4, 136(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa5, 128(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa6, 120(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa7, 112(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs2, 104(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs3, 96(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs4, 88(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs5, 80(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs6, 72(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs7, 64(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs8, 56(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs9, 48(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs10, 40(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs11, 32(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft8, 24(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft9, 16(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft10, 8(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft11, 0(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    addi sp, sp, 320
; CHECK-RV32-FD-NEXT:    mret
;
; CHECK-RV64-LABEL: foo_with_call:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    addi sp, sp, -128
; CHECK-RV64-NEXT:    sd ra, 120(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t0, 112(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t1, 104(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t2, 96(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a0, 88(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a1, 80(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a2, 72(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a3, 64(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a4, 56(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a5, 48(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a6, 40(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a7, 32(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t3, 24(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t4, 16(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t5, 8(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t6, 0(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    call otherfoo@plt
; CHECK-RV64-NEXT:    ld ra, 120(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t0, 112(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t1, 104(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t2, 96(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a0, 88(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a1, 80(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a2, 72(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a3, 64(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a4, 56(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a5, 48(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a6, 40(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a7, 32(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t3, 24(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t4, 16(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t5, 8(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t6, 0(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    addi sp, sp, 128
; CHECK-RV64-NEXT:    mret
;
; CHECK-RV64-F-LABEL: foo_with_call:
; CHECK-RV64-F:       # %bb.0:
; CHECK-RV64-F-NEXT:    addi sp, sp, -256
; CHECK-RV64-F-NEXT:    sd ra, 248(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t0, 240(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t1, 232(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t2, 224(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a0, 216(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a1, 208(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a2, 200(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a3, 192(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a4, 184(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a5, 176(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a6, 168(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a7, 160(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t3, 152(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t4, 144(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t5, 136(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t6, 128(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft0, 124(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft1, 120(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft2, 116(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft3, 112(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft4, 108(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft5, 104(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft6, 100(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft7, 96(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs0, 92(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs1, 88(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa0, 84(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa1, 80(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa2, 76(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa3, 72(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa4, 68(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa5, 64(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa6, 60(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa7, 56(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs2, 52(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs3, 48(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs4, 44(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs5, 40(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs6, 36(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs7, 32(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs8, 28(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs9, 24(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs10, 20(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs11, 16(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft8, 12(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft9, 8(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft10, 4(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft11, 0(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    call otherfoo@plt
; CHECK-RV64-F-NEXT:    ld ra, 248(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t0, 240(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t1, 232(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t2, 224(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a0, 216(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a1, 208(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a2, 200(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a3, 192(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a4, 184(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a5, 176(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a6, 168(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a7, 160(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t3, 152(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t4, 144(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t5, 136(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t6, 128(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft0, 124(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft1, 120(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft2, 116(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft3, 112(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft4, 108(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft5, 104(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft6, 100(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft7, 96(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs0, 92(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs1, 88(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa0, 84(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa1, 80(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa2, 76(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa3, 72(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa4, 68(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa5, 64(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa6, 60(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa7, 56(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs2, 52(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs3, 48(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs4, 44(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs5, 40(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs6, 36(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs7, 32(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs8, 28(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs9, 24(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs10, 20(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs11, 16(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft8, 12(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft9, 8(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft10, 4(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft11, 0(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    addi sp, sp, 256
; CHECK-RV64-F-NEXT:    mret
;
; CHECK-RV64-FD-LABEL: foo_with_call:
; CHECK-RV64-FD:       # %bb.0:
; CHECK-RV64-FD-NEXT:    addi sp, sp, -384
; CHECK-RV64-FD-NEXT:    sd ra, 376(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t0, 368(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t1, 360(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t2, 352(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a0, 344(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a1, 336(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a2, 328(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a3, 320(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a4, 312(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a5, 304(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a6, 296(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a7, 288(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t3, 280(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t4, 272(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t5, 264(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t6, 256(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft0, 248(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft1, 240(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft2, 232(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft3, 224(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft4, 216(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft5, 208(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft6, 200(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft7, 192(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs0, 184(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs1, 176(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa0, 168(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa1, 160(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa2, 152(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa3, 144(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa4, 136(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa5, 128(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa6, 120(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa7, 112(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs2, 104(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs3, 96(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs4, 88(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs5, 80(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs6, 72(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs7, 64(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs8, 56(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs9, 48(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs10, 40(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs11, 32(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft8, 24(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft9, 16(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft10, 8(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft11, 0(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    call otherfoo@plt
; CHECK-RV64-FD-NEXT:    ld ra, 376(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t0, 368(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t1, 360(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t2, 352(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a0, 344(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a1, 336(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a2, 328(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a3, 320(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a4, 312(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a5, 304(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a6, 296(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a7, 288(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t3, 280(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t4, 272(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t5, 264(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t6, 256(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft0, 248(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft1, 240(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft2, 232(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft3, 224(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft4, 216(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft5, 208(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft6, 200(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft7, 192(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs0, 184(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs1, 176(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa0, 168(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa1, 160(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa2, 152(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa3, 144(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa4, 136(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa5, 128(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa6, 120(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa7, 112(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs2, 104(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs3, 96(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs4, 88(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs5, 80(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs6, 72(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs7, 64(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs8, 56(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs9, 48(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs10, 40(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs11, 32(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft8, 24(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft9, 16(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft10, 8(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft11, 0(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    addi sp, sp, 384
; CHECK-RV64-FD-NEXT:    mret
  %call = call i32 @otherfoo()
  ret void
}

;
; Additionally check frame pointer and return address are properly saved.
;
define void @foo_fp_with_call() #2 {
;
; CHECK-RV32-LABEL: foo_fp_with_call:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -80
; CHECK-RV32-NEXT:    sw ra, 76(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t0, 72(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t1, 68(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t2, 64(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s0, 60(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a0, 56(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a1, 52(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a2, 48(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a3, 44(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a4, 40(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a5, 36(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a6, 32(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a7, 28(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t3, 24(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t4, 20(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t5, 16(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t6, 12(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    addi s0, sp, 80
; CHECK-RV32-NEXT:    call otherfoo@plt
; CHECK-RV32-NEXT:    lw ra, 76(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t0, 72(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t1, 68(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t2, 64(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s0, 60(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a0, 56(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a1, 52(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a2, 48(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a3, 44(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a4, 40(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a5, 36(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a6, 32(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a7, 28(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t3, 24(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t4, 20(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t5, 16(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t6, 12(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    addi sp, sp, 80
; CHECK-RV32-NEXT:    mret
;
; CHECK-RV32-F-LABEL: foo_fp_with_call:
; CHECK-RV32-F:       # %bb.0:
; CHECK-RV32-F-NEXT:    addi sp, sp, -208
; CHECK-RV32-F-NEXT:    sw ra, 204(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t0, 200(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t1, 196(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t2, 192(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw s0, 188(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a0, 184(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a1, 180(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a2, 176(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a3, 172(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a4, 168(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a5, 164(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a6, 160(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a7, 156(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t3, 152(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t4, 148(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t5, 144(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t6, 140(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft0, 136(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft1, 132(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft2, 128(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft3, 124(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft4, 120(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft5, 116(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft6, 112(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft7, 108(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs0, 104(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs1, 100(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa0, 96(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa1, 92(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa2, 88(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa3, 84(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa4, 80(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa5, 76(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa6, 72(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa7, 68(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs2, 64(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs3, 60(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs4, 56(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs5, 52(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs6, 48(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs7, 44(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs8, 40(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs9, 36(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs10, 32(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fs11, 28(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft8, 24(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft9, 20(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft10, 16(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft11, 12(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    addi s0, sp, 208
; CHECK-RV32-F-NEXT:    call otherfoo@plt
; CHECK-RV32-F-NEXT:    lw ra, 204(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t0, 200(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t1, 196(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t2, 192(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw s0, 188(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a0, 184(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a1, 180(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a2, 176(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a3, 172(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a4, 168(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a5, 164(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a6, 160(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a7, 156(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t3, 152(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t4, 148(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t5, 144(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t6, 140(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft0, 136(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft1, 132(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft2, 128(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft3, 124(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft4, 120(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft5, 116(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft6, 112(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft7, 108(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs0, 104(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs1, 100(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa0, 96(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa1, 92(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa2, 88(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa3, 84(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa4, 80(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa5, 76(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa6, 72(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa7, 68(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs2, 64(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs3, 60(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs4, 56(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs5, 52(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs6, 48(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs7, 44(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs8, 40(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs9, 36(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs10, 32(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fs11, 28(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft8, 24(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft9, 20(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft10, 16(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft11, 12(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    addi sp, sp, 208
; CHECK-RV32-F-NEXT:    mret
;
; CHECK-RV32-FD-LABEL: foo_fp_with_call:
; CHECK-RV32-FD:       # %bb.0:
; CHECK-RV32-FD-NEXT:    addi sp, sp, -336
; CHECK-RV32-FD-NEXT:    sw ra, 332(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t0, 328(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t1, 324(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t2, 320(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw s0, 316(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a0, 312(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a1, 308(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a2, 304(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a3, 300(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a4, 296(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a5, 292(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a6, 288(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a7, 284(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t3, 280(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t4, 276(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t5, 272(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t6, 268(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft0, 256(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft1, 248(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft2, 240(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft3, 232(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft4, 224(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft5, 216(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft6, 208(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft7, 200(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs0, 192(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs1, 184(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa0, 176(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa1, 168(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa2, 160(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa3, 152(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa4, 144(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa5, 136(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa6, 128(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa7, 120(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs2, 112(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs3, 104(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs4, 96(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs5, 88(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs6, 80(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs7, 72(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs8, 64(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs9, 56(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs10, 48(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fs11, 40(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft8, 32(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft9, 24(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft10, 16(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft11, 8(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    addi s0, sp, 336
; CHECK-RV32-FD-NEXT:    call otherfoo@plt
; CHECK-RV32-FD-NEXT:    lw ra, 332(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t0, 328(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t1, 324(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t2, 320(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw s0, 316(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a0, 312(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a1, 308(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a2, 304(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a3, 300(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a4, 296(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a5, 292(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a6, 288(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a7, 284(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t3, 280(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t4, 276(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t5, 272(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t6, 268(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft0, 256(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft1, 248(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft2, 240(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft3, 232(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft4, 224(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft5, 216(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft6, 208(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft7, 200(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs0, 192(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs1, 184(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa0, 176(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa1, 168(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa2, 160(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa3, 152(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa4, 144(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa5, 136(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa6, 128(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa7, 120(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs2, 112(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs3, 104(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs4, 96(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs5, 88(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs6, 80(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs7, 72(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs8, 64(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs9, 56(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs10, 48(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fs11, 40(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft8, 32(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft9, 24(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft10, 16(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft11, 8(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    addi sp, sp, 336
; CHECK-RV32-FD-NEXT:    mret
;
; CHECK-RV64-LABEL: foo_fp_with_call:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    addi sp, sp, -144
; CHECK-RV64-NEXT:    sd ra, 136(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t0, 128(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t1, 120(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t2, 112(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s0, 104(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a0, 96(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a1, 88(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a2, 80(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a3, 72(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a4, 64(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a5, 56(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a6, 48(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a7, 40(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t3, 32(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t4, 24(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t5, 16(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t6, 8(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    addi s0, sp, 144
; CHECK-RV64-NEXT:    call otherfoo@plt
; CHECK-RV64-NEXT:    ld ra, 136(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t0, 128(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t1, 120(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t2, 112(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s0, 104(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a0, 96(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a1, 88(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a2, 80(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a3, 72(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a4, 64(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a5, 56(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a6, 48(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a7, 40(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t3, 32(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t4, 24(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t5, 16(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t6, 8(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    addi sp, sp, 144
; CHECK-RV64-NEXT:    mret
;
; CHECK-RV64-F-LABEL: foo_fp_with_call:
; CHECK-RV64-F:       # %bb.0:
; CHECK-RV64-F-NEXT:    addi sp, sp, -272
; CHECK-RV64-F-NEXT:    sd ra, 264(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t0, 256(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t1, 248(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t2, 240(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd s0, 232(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a0, 224(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a1, 216(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a2, 208(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a3, 200(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a4, 192(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a5, 184(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a6, 176(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a7, 168(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t3, 160(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t4, 152(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t5, 144(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t6, 136(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft0, 132(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft1, 128(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft2, 124(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft3, 120(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft4, 116(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft5, 112(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft6, 108(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft7, 104(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs0, 100(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs1, 96(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa0, 92(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa1, 88(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa2, 84(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa3, 80(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa4, 76(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa5, 72(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa6, 68(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa7, 64(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs2, 60(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs3, 56(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs4, 52(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs5, 48(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs6, 44(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs7, 40(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs8, 36(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs9, 32(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs10, 28(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fs11, 24(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft8, 20(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft9, 16(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft10, 12(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft11, 8(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    addi s0, sp, 272
; CHECK-RV64-F-NEXT:    call otherfoo@plt
; CHECK-RV64-F-NEXT:    ld ra, 264(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t0, 256(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t1, 248(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t2, 240(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld s0, 232(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a0, 224(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a1, 216(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a2, 208(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a3, 200(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a4, 192(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a5, 184(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a6, 176(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a7, 168(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t3, 160(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t4, 152(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t5, 144(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t6, 136(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft0, 132(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft1, 128(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft2, 124(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft3, 120(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft4, 116(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft5, 112(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft6, 108(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft7, 104(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs0, 100(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs1, 96(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa0, 92(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa1, 88(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa2, 84(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa3, 80(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa4, 76(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa5, 72(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa6, 68(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa7, 64(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs2, 60(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs3, 56(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs4, 52(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs5, 48(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs6, 44(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs7, 40(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs8, 36(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs9, 32(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs10, 28(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fs11, 24(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft8, 20(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft9, 16(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft10, 12(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft11, 8(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    addi sp, sp, 272
; CHECK-RV64-F-NEXT:    mret
;
; CHECK-RV64-FD-LABEL: foo_fp_with_call:
; CHECK-RV64-FD:       # %bb.0:
; CHECK-RV64-FD-NEXT:    addi sp, sp, -400
; CHECK-RV64-FD-NEXT:    sd ra, 392(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t0, 384(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t1, 376(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t2, 368(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd s0, 360(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a0, 352(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a1, 344(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a2, 336(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a3, 328(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a4, 320(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a5, 312(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a6, 304(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a7, 296(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t3, 288(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t4, 280(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t5, 272(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t6, 264(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft0, 256(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft1, 248(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft2, 240(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft3, 232(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft4, 224(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft5, 216(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft6, 208(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft7, 200(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs0, 192(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs1, 184(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa0, 176(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa1, 168(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa2, 160(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa3, 152(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa4, 144(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa5, 136(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa6, 128(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa7, 120(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs2, 112(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs3, 104(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs4, 96(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs5, 88(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs6, 80(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs7, 72(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs8, 64(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs9, 56(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs10, 48(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fs11, 40(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft8, 32(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft9, 24(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft10, 16(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft11, 8(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    addi s0, sp, 400
; CHECK-RV64-FD-NEXT:    call otherfoo@plt
; CHECK-RV64-FD-NEXT:    ld ra, 392(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t0, 384(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t1, 376(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t2, 368(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld s0, 360(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a0, 352(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a1, 344(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a2, 336(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a3, 328(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a4, 320(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a5, 312(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a6, 304(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a7, 296(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t3, 288(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t4, 280(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t5, 272(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t6, 264(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft0, 256(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft1, 248(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft2, 240(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft3, 232(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft4, 224(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft5, 216(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft6, 208(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft7, 200(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs0, 192(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs1, 184(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa0, 176(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa1, 168(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa2, 160(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa3, 152(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa4, 144(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa5, 136(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa6, 128(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa7, 120(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs2, 112(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs3, 104(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs4, 96(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs5, 88(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs6, 80(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs7, 72(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs8, 64(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs9, 56(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs10, 48(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fs11, 40(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft8, 32(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft9, 24(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft10, 16(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft11, 8(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    addi sp, sp, 400
; CHECK-RV64-FD-NEXT:    mret
  %call = call i32 @otherfoo()
  ret void
}

attributes #0 = { nounwind "interrupt"="supervisor" }
attributes #1 = { nounwind "interrupt"="machine" }
attributes #2 = { nounwind "interrupt"="machine" "frame-pointer"="all" }
