; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible-sve  < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

;
; FADD
;

define <2 x half> @fadd_v2f16(<2 x half> %op1, <2 x half> %op2) {
; CHECK-LABEL: fadd_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = fadd <2 x half> %op1, %op2
  ret <2 x half> %res
}

define <4 x half> @fadd_v4f16(<4 x half> %op1, <4 x half> %op2) {
; CHECK-LABEL: fadd_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = fadd <4 x half> %op1, %op2
  ret <4 x half> %res
}

define <8 x half> @fadd_v8f16(<8 x half> %op1, <8 x half> %op2) {
; CHECK-LABEL: fadd_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = fadd <8 x half> %op1, %op2
  ret <8 x half> %res
}

define void @fadd_v16f16(ptr %a, ptr %b) {
; CHECK-LABEL: fadd_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q2, q3, [x1]
; CHECK-NEXT:    fadd z0.h, p0/m, z0.h, z2.h
; CHECK-NEXT:    fadd z1.h, p0/m, z1.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x half>, ptr %a
  %op2 = load <16 x half>, ptr %b
  %res = fadd <16 x half> %op1, %op2
  store <16 x half> %res, ptr %a
  ret void
}

define <2 x float> @fadd_v2f32(<2 x float> %op1, <2 x float> %op2) {
; CHECK-LABEL: fadd_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = fadd <2 x float> %op1, %op2
  ret <2 x float> %res
}

define <4 x float> @fadd_v4f32(<4 x float> %op1, <4 x float> %op2) {
; CHECK-LABEL: fadd_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = fadd <4 x float> %op1, %op2
  ret <4 x float> %res
}

define void @fadd_v8f32(ptr %a, ptr %b) {
; CHECK-LABEL: fadd_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q2, q3, [x1]
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, z2.s
; CHECK-NEXT:    fadd z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x float>, ptr %a
  %op2 = load <8 x float>, ptr %b
  %res = fadd <8 x float> %op1, %op2
  store <8 x float> %res, ptr %a
  ret void
}

define <2 x double> @fadd_v2f64(<2 x double> %op1, <2 x double> %op2) {
; CHECK-LABEL: fadd_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = fadd <2 x double> %op1, %op2
  ret <2 x double> %res
}

define void @fadd_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: fadd_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q2, q3, [x1]
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, z2.d
; CHECK-NEXT:    fadd z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x double>, ptr %a
  %op2 = load <4 x double>, ptr %b
  %res = fadd <4 x double> %op1, %op2
  store <4 x double> %res, ptr %a
  ret void
}

;
; FDIV
;

define <2 x half> @fdiv_v2f16(<2 x half> %op1, <2 x half> %op2) {
; CHECK-LABEL: fdiv_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fdiv z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = fdiv <2 x half> %op1, %op2
  ret <2 x half> %res
}

define <4 x half> @fdiv_v4f16(<4 x half> %op1, <4 x half> %op2) {
; CHECK-LABEL: fdiv_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fdiv z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = fdiv <4 x half> %op1, %op2
  ret <4 x half> %res
}

define <8 x half> @fdiv_v8f16(<8 x half> %op1, <8 x half> %op2) {
; CHECK-LABEL: fdiv_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fdiv z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = fdiv <8 x half> %op1, %op2
  ret <8 x half> %res
}

define void @fdiv_v16f16(ptr %a, ptr %b) {
; CHECK-LABEL: fdiv_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q2, q3, [x1]
; CHECK-NEXT:    fdiv z0.h, p0/m, z0.h, z2.h
; CHECK-NEXT:    fdiv z1.h, p0/m, z1.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x half>, ptr %a
  %op2 = load <16 x half>, ptr %b
  %res = fdiv <16 x half> %op1, %op2
  store <16 x half> %res, ptr %a
  ret void
}

define <2 x float> @fdiv_v2f32(<2 x float> %op1, <2 x float> %op2) {
; CHECK-LABEL: fdiv_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = fdiv <2 x float> %op1, %op2
  ret <2 x float> %res
}

define <4 x float> @fdiv_v4f32(<4 x float> %op1, <4 x float> %op2) {
; CHECK-LABEL: fdiv_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = fdiv <4 x float> %op1, %op2
  ret <4 x float> %res
}

define void @fdiv_v8f32(ptr %a, ptr %b) {
; CHECK-LABEL: fdiv_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q2, q3, [x1]
; CHECK-NEXT:    fdiv z0.s, p0/m, z0.s, z2.s
; CHECK-NEXT:    fdiv z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x float>, ptr %a
  %op2 = load <8 x float>, ptr %b
  %res = fdiv <8 x float> %op1, %op2
  store <8 x float> %res, ptr %a
  ret void
}

define <2 x double> @fdiv_v2f64(<2 x double> %op1, <2 x double> %op2) {
; CHECK-LABEL: fdiv_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fdiv z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = fdiv <2 x double> %op1, %op2
  ret <2 x double> %res
}

define void @fdiv_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: fdiv_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q2, q3, [x1]
; CHECK-NEXT:    fdiv z0.d, p0/m, z0.d, z2.d
; CHECK-NEXT:    fdiv z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x double>, ptr %a
  %op2 = load <4 x double>, ptr %b
  %res = fdiv <4 x double> %op1, %op2
  store <4 x double> %res, ptr %a
  ret void
}

;
; FMA
;

define <2 x half> @fma_v2f16(<2 x half> %op1, <2 x half> %op2, <2 x half> %op3) {
; CHECK-LABEL: fma_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmad z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x half> @llvm.fma.v2f16(<2 x half> %op1, <2 x half> %op2, <2 x half> %op3)
  ret <2 x half> %res
}

define <4 x half> @fma_v4f16(<4 x half> %op1, <4 x half> %op2, <4 x half> %op3) {
; CHECK-LABEL: fma_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmad z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x half> @llvm.fma.v4f16(<4 x half> %op1, <4 x half> %op2, <4 x half> %op3)
  ret <4 x half> %res
}

define <8 x half> @fma_v8f16(<8 x half> %op1, <8 x half> %op2, <8 x half> %op3) {
; CHECK-LABEL: fma_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q2 killed $q2 def $z2
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmad z0.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <8 x half> @llvm.fma.v8f16(<8 x half> %op1, <8 x half> %op2, <8 x half> %op3)
  ret <8 x half> %res
}

define void @fma_v16f16(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: fma_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    ldp q4, q5, [x2]
; CHECK-NEXT:    fmad z0.h, p0/m, z1.h, z4.h
; CHECK-NEXT:    movprfx z1, z5
; CHECK-NEXT:    fmla z1.h, p0/m, z2.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x half>, ptr %a
  %op2 = load <16 x half>, ptr %b
  %op3 = load <16 x half>, ptr %c
  %res = call <16 x half> @llvm.fma.v16f16(<16 x half> %op1, <16 x half> %op2, <16 x half> %op3)
  store <16 x half> %res, ptr %a
  ret void
}

define <2 x float> @fma_v2f32(<2 x float> %op1, <2 x float> %op2, <2 x float> %op3) {
; CHECK-LABEL: fma_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmad z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x float> @llvm.fma.v2f32(<2 x float> %op1, <2 x float> %op2, <2 x float> %op3)
  ret <2 x float> %res
}

define <4 x float> @fma_v4f32(<4 x float> %op1, <4 x float> %op2, <4 x float> %op3) {
; CHECK-LABEL: fma_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q2 killed $q2 def $z2
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmad z0.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x float> @llvm.fma.v4f32(<4 x float> %op1, <4 x float> %op2, <4 x float> %op3)
  ret <4 x float> %res
}

define void @fma_v8f32(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: fma_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    ldp q4, q5, [x2]
; CHECK-NEXT:    fmad z0.s, p0/m, z1.s, z4.s
; CHECK-NEXT:    movprfx z1, z5
; CHECK-NEXT:    fmla z1.s, p0/m, z2.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x float>, ptr %a
  %op2 = load <8 x float>, ptr %b
  %op3 = load <8 x float>, ptr %c
  %res = call <8 x float> @llvm.fma.v8f32(<8 x float> %op1, <8 x float> %op2, <8 x float> %op3)
  store <8 x float> %res, ptr %a
  ret void
}

define <2 x double> @fma_v2f64(<2 x double> %op1, <2 x double> %op2, <2 x double> %op3) {
; CHECK-LABEL: fma_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q2 killed $q2 def $z2
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmad z0.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x double> @llvm.fma.v2f64(<2 x double> %op1, <2 x double> %op2, <2 x double> %op3)
  ret <2 x double> %res
}

define void @fma_v4f64(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: fma_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    ldp q4, q5, [x2]
; CHECK-NEXT:    fmad z0.d, p0/m, z1.d, z4.d
; CHECK-NEXT:    movprfx z1, z5
; CHECK-NEXT:    fmla z1.d, p0/m, z2.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x double>, ptr %a
  %op2 = load <4 x double>, ptr %b
  %op3 = load <4 x double>, ptr %c
  %res = call <4 x double> @llvm.fma.v4f64(<4 x double> %op1, <4 x double> %op2, <4 x double> %op3)
  store <4 x double> %res, ptr %a
  ret void
}

;
; FMUL
;

define <2 x half> @fmul_v2f16(<2 x half> %op1, <2 x half> %op2) {
; CHECK-LABEL: fmul_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmul z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = fmul <2 x half> %op1, %op2
  ret <2 x half> %res
}

define <4 x half> @fmul_v4f16(<4 x half> %op1, <4 x half> %op2) {
; CHECK-LABEL: fmul_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmul z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = fmul <4 x half> %op1, %op2
  ret <4 x half> %res
}

define <8 x half> @fmul_v8f16(<8 x half> %op1, <8 x half> %op2) {
; CHECK-LABEL: fmul_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmul z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = fmul <8 x half> %op1, %op2
  ret <8 x half> %res
}

define void @fmul_v16f16(ptr %a, ptr %b) {
; CHECK-LABEL: fmul_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q2, q3, [x1]
; CHECK-NEXT:    fmul z0.h, p0/m, z0.h, z2.h
; CHECK-NEXT:    fmul z1.h, p0/m, z1.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x half>, ptr %a
  %op2 = load <16 x half>, ptr %b
  %res = fmul <16 x half> %op1, %op2
  store <16 x half> %res, ptr %a
  ret void
}

define <2 x float> @fmul_v2f32(<2 x float> %op1, <2 x float> %op2) {
; CHECK-LABEL: fmul_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fmul z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = fmul <2 x float> %op1, %op2
  ret <2 x float> %res
}

define <4 x float> @fmul_v4f32(<4 x float> %op1, <4 x float> %op2) {
; CHECK-LABEL: fmul_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmul z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = fmul <4 x float> %op1, %op2
  ret <4 x float> %res
}

define void @fmul_v8f32(ptr %a, ptr %b) {
; CHECK-LABEL: fmul_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q2, q3, [x1]
; CHECK-NEXT:    fmul z0.s, p0/m, z0.s, z2.s
; CHECK-NEXT:    fmul z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x float>, ptr %a
  %op2 = load <8 x float>, ptr %b
  %res = fmul <8 x float> %op1, %op2
  store <8 x float> %res, ptr %a
  ret void
}

define <2 x double> @fmul_v2f64(<2 x double> %op1, <2 x double> %op2) {
; CHECK-LABEL: fmul_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fmul z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = fmul <2 x double> %op1, %op2
  ret <2 x double> %res
}

define void @fmul_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: fmul_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q2, q3, [x1]
; CHECK-NEXT:    fmul z0.d, p0/m, z0.d, z2.d
; CHECK-NEXT:    fmul z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x double>, ptr %a
  %op2 = load <4 x double>, ptr %b
  %res = fmul <4 x double> %op1, %op2
  store <4 x double> %res, ptr %a
  ret void
}

;
; FNEG
;

define <2 x half> @fneg_v2f16(<2 x half> %op) {
; CHECK-LABEL: fneg_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    fneg z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = fneg <2 x half> %op
  ret <2 x half> %res
}

define <4 x half> @fneg_v4f16(<4 x half> %op) {
; CHECK-LABEL: fneg_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    fneg z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = fneg <4 x half> %op
  ret <4 x half> %res
}

define <8 x half> @fneg_v8f16(<8 x half> %op) {
; CHECK-LABEL: fneg_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    fneg z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = fneg <8 x half> %op
  ret <8 x half> %res
}

define void @fneg_v16f16(ptr %a, ptr %b) {
; CHECK-LABEL: fneg_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    fneg z0.h, p0/m, z0.h
; CHECK-NEXT:    fneg z1.h, p0/m, z1.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op = load <16 x half>, ptr %a
  %res = fneg <16 x half> %op
  store <16 x half> %res, ptr %a
  ret void
}

define <2 x float> @fneg_v2f32(<2 x float> %op) {
; CHECK-LABEL: fneg_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    fneg z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = fneg <2 x float> %op
  ret <2 x float> %res
}

define <4 x float> @fneg_v4f32(<4 x float> %op) {
; CHECK-LABEL: fneg_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    fneg z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = fneg <4 x float> %op
  ret <4 x float> %res
}

define void @fneg_v8f32(ptr %a) {
; CHECK-LABEL: fneg_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    fneg z0.s, p0/m, z0.s
; CHECK-NEXT:    fneg z1.s, p0/m, z1.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op = load <8 x float>, ptr %a
  %res = fneg <8 x float> %op
  store <8 x float> %res, ptr %a
  ret void
}

define <2 x double> @fneg_v2f64(<2 x double> %op) {
; CHECK-LABEL: fneg_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    fneg z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = fneg <2 x double> %op
  ret <2 x double> %res
}

define void @fneg_v4f64(ptr %a) {
; CHECK-LABEL: fneg_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    fneg z0.d, p0/m, z0.d
; CHECK-NEXT:    fneg z1.d, p0/m, z1.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op = load <4 x double>, ptr %a
  %res = fneg <4 x double> %op
  store <4 x double> %res, ptr %a
  ret void
}

;
; FSQRT
;

define <2 x half> @fsqrt_v2f16(<2 x half> %op) {
; CHECK-LABEL: fsqrt_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    fsqrt z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x half> @llvm.sqrt.v2f16(<2 x half> %op)
  ret <2 x half> %res
}

define <4 x half> @fsqrt_v4f16(<4 x half> %op) {
; CHECK-LABEL: fsqrt_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    fsqrt z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x half> @llvm.sqrt.v4f16(<4 x half> %op)
  ret <4 x half> %res
}

define <8 x half> @fsqrt_v8f16(<8 x half> %op) {
; CHECK-LABEL: fsqrt_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    fsqrt z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <8 x half> @llvm.sqrt.v8f16(<8 x half> %op)
  ret <8 x half> %res
}

define void @fsqrt_v16f16(ptr %a, ptr %b) {
; CHECK-LABEL: fsqrt_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    fsqrt z0.h, p0/m, z0.h
; CHECK-NEXT:    fsqrt z1.h, p0/m, z1.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op = load <16 x half>, ptr %a
  %res = call <16 x half> @llvm.sqrt.v16f16(<16 x half> %op)
  store <16 x half> %res, ptr %a
  ret void
}

define <2 x float> @fsqrt_v2f32(<2 x float> %op) {
; CHECK-LABEL: fsqrt_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    fsqrt z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x float> @llvm.sqrt.v2f32(<2 x float> %op)
  ret <2 x float> %res
}

define <4 x float> @fsqrt_v4f32(<4 x float> %op) {
; CHECK-LABEL: fsqrt_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    fsqrt z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x float> @llvm.sqrt.v4f32(<4 x float> %op)
  ret <4 x float> %res
}

define void @fsqrt_v8f32(ptr %a) {
; CHECK-LABEL: fsqrt_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    fsqrt z0.s, p0/m, z0.s
; CHECK-NEXT:    fsqrt z1.s, p0/m, z1.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op = load <8 x float>, ptr %a
  %res = call <8 x float> @llvm.sqrt.v8f32(<8 x float> %op)
  store <8 x float> %res, ptr %a
  ret void
}

define <2 x double> @fsqrt_v2f64(<2 x double> %op) {
; CHECK-LABEL: fsqrt_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    fsqrt z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x double> @llvm.sqrt.v2f64(<2 x double> %op)
  ret <2 x double> %res
}

define void @fsqrt_v4f64(ptr %a) {
; CHECK-LABEL: fsqrt_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    fsqrt z0.d, p0/m, z0.d
; CHECK-NEXT:    fsqrt z1.d, p0/m, z1.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op = load <4 x double>, ptr %a
  %res = call <4 x double> @llvm.sqrt.v4f64(<4 x double> %op)
  store <4 x double> %res, ptr %a
  ret void
}

;
; FSUB
;

define <2 x half> @fsub_v2f16(<2 x half> %op1, <2 x half> %op2) {
; CHECK-LABEL: fsub_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fsub z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = fsub <2 x half> %op1, %op2
  ret <2 x half> %res
}

define <4 x half> @fsub_v4f16(<4 x half> %op1, <4 x half> %op2) {
; CHECK-LABEL: fsub_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fsub z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = fsub <4 x half> %op1, %op2
  ret <4 x half> %res
}

define <8 x half> @fsub_v8f16(<8 x half> %op1, <8 x half> %op2) {
; CHECK-LABEL: fsub_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fsub z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = fsub <8 x half> %op1, %op2
  ret <8 x half> %res
}

define void @fsub_v16f16(ptr %a, ptr %b) {
; CHECK-LABEL: fsub_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q2, q3, [x1]
; CHECK-NEXT:    fsub z0.h, p0/m, z0.h, z2.h
; CHECK-NEXT:    fsub z1.h, p0/m, z1.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x half>, ptr %a
  %op2 = load <16 x half>, ptr %b
  %res = fsub <16 x half> %op1, %op2
  store <16 x half> %res, ptr %a
  ret void
}

define <2 x float> @fsub_v2f32(<2 x float> %op1, <2 x float> %op2) {
; CHECK-LABEL: fsub_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fsub z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = fsub <2 x float> %op1, %op2
  ret <2 x float> %res
}

define <4 x float> @fsub_v4f32(<4 x float> %op1, <4 x float> %op2) {
; CHECK-LABEL: fsub_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fsub z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = fsub <4 x float> %op1, %op2
  ret <4 x float> %res
}

define void @fsub_v8f32(ptr %a, ptr %b) {
; CHECK-LABEL: fsub_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q2, q3, [x1]
; CHECK-NEXT:    fsub z0.s, p0/m, z0.s, z2.s
; CHECK-NEXT:    fsub z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x float>, ptr %a
  %op2 = load <8 x float>, ptr %b
  %res = fsub <8 x float> %op1, %op2
  store <8 x float> %res, ptr %a
  ret void
}

define <2 x double> @fsub_v2f64(<2 x double> %op1, <2 x double> %op2) {
; CHECK-LABEL: fsub_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fsub z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = fsub <2 x double> %op1, %op2
  ret <2 x double> %res
}

define void @fsub_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: fsub_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q2, q3, [x1]
; CHECK-NEXT:    fsub z0.d, p0/m, z0.d, z2.d
; CHECK-NEXT:    fsub z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x double>, ptr %a
  %op2 = load <4 x double>, ptr %b
  %res = fsub <4 x double> %op1, %op2
  store <4 x double> %res, ptr %a
  ret void
}

;
; FABS
;

define <2 x half> @fabs_v2f16(<2 x half> %op) {
; CHECK-LABEL: fabs_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x half> @llvm.fabs.v2f16(<2 x half> %op)
  ret <2 x half> %res
}

define <4 x half> @fabs_v4f16(<4 x half> %op) {
; CHECK-LABEL: fabs_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x half> @llvm.fabs.v4f16(<4 x half> %op)
  ret <4 x half> %res
}

define <8 x half> @fabs_v8f16(<8 x half> %op) {
; CHECK-LABEL: fabs_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <8 x half> @llvm.fabs.v8f16(<8 x half> %op)
  ret <8 x half> %res
}

define void @fabs_v16f16(ptr %a) {
; CHECK-LABEL: fabs_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NEXT:    fabs z1.h, p0/m, z1.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op = load <16 x half>, ptr %a
  %res = call <16 x half> @llvm.fabs.v16f16(<16 x half> %op)
  store <16 x half> %res, ptr %a
  ret void
}

define <2 x float> @fabs_v2f32(<2 x float> %op) {
; CHECK-LABEL: fabs_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x float> @llvm.fabs.v2f32(<2 x float> %op)
  ret <2 x float> %res
}

define <4 x float> @fabs_v4f32(<4 x float> %op) {
; CHECK-LABEL: fabs_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <4 x float> @llvm.fabs.v4f32(<4 x float> %op)
  ret <4 x float> %res
}

define void @fabs_v8f32(ptr %a) {
; CHECK-LABEL: fabs_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NEXT:    fabs z1.s, p0/m, z1.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op = load <8 x float>, ptr %a
  %res = call <8 x float> @llvm.fabs.v8f32(<8 x float> %op)
  store <8 x float> %res, ptr %a
  ret void
}

define <2 x double> @fabs_v2f64(<2 x double> %op) {
; CHECK-LABEL: fabs_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    fabs z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = call <2 x double> @llvm.fabs.v2f64(<2 x double> %op)
  ret <2 x double> %res
}

define void @fabs_v4f64(ptr %a) {
; CHECK-LABEL: fabs_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    fabs z0.d, p0/m, z0.d
; CHECK-NEXT:    fabs z1.d, p0/m, z1.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op = load <4 x double>, ptr %a
  %res = call <4 x double> @llvm.fabs.v4f64(<4 x double> %op)
  store <4 x double> %res, ptr %a
  ret void
}

declare <2 x half> @llvm.fma.v2f16(<2 x half>, <2 x half>, <2 x half>)
declare <4 x half> @llvm.fma.v4f16(<4 x half>, <4 x half>, <4 x half>)
declare <8 x half> @llvm.fma.v8f16(<8 x half>, <8 x half>, <8 x half>)
declare <16 x half> @llvm.fma.v16f16(<16 x half>, <16 x half>, <16 x half>)
declare <2 x float> @llvm.fma.v2f32(<2 x float>, <2 x float>, <2 x float>)
declare <4 x float> @llvm.fma.v4f32(<4 x float>, <4 x float>, <4 x float>)
declare <8 x float> @llvm.fma.v8f32(<8 x float>, <8 x float>, <8 x float>)
declare <2 x double> @llvm.fma.v2f64(<2 x double>, <2 x double>, <2 x double>)
declare <4 x double> @llvm.fma.v4f64(<4 x double>, <4 x double>, <4 x double>)

declare <2 x half> @llvm.sqrt.v2f16(<2 x half>)
declare <4 x half> @llvm.sqrt.v4f16(<4 x half>)
declare <8 x half> @llvm.sqrt.v8f16(<8 x half>)
declare <16 x half> @llvm.sqrt.v16f16(<16 x half>)
declare <2 x float> @llvm.sqrt.v2f32(<2 x float>)
declare <4 x float> @llvm.sqrt.v4f32(<4 x float>)
declare <8 x float> @llvm.sqrt.v8f32(<8 x float>)
declare <2 x double> @llvm.sqrt.v2f64(<2 x double>)
declare <4 x double> @llvm.sqrt.v4f64(<4 x double>)

declare <2 x half> @llvm.fabs.v2f16(<2 x half>)
declare <4 x half> @llvm.fabs.v4f16(<4 x half>)
declare <8 x half> @llvm.fabs.v8f16(<8 x half>)
declare <16 x half> @llvm.fabs.v16f16(<16 x half>)
declare <2 x float> @llvm.fabs.v2f32(<2 x float>)
declare <4 x float> @llvm.fabs.v4f32(<4 x float>)
declare <8 x float> @llvm.fabs.v8f32(<8 x float>)
declare <2 x double> @llvm.fabs.v2f64(<2 x double>)
declare <4 x double> @llvm.fabs.v4f64(<4 x double>)
