; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; This test is a copy of mma-intrinsics.ll except that it uses mcpu=future.
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=future -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=future -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr < %s | FileCheck %s --check-prefix=CHECK-BE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=future -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -O0 < %s | FileCheck %s --check-prefix=CHECK-O0
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=future -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr -O0 < %s | FileCheck %s --check-prefix=CHECK-O0-BE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-aix- \
; RUN:   -mcpu=future -vec-extabi \
; RUN:   -ppc-vsr-nums-as-vr < %s | FileCheck %s --check-prefix=CHECK-AIX64
; RUN: llc -verify-machineinstrs -mtriple=powerpc-aix- \
; RUN:   -mcpu=future -vec-extabi \
; RUN:   -ppc-vsr-nums-as-vr < %s | FileCheck %s --check-prefix=CHECK-AIX32

; TODO: This test is missing some of the tests from mma-intrinsics.ll because
;       those tests do not work for mcpu=future. Once the fixes are in they
;       should be added back to this file.

; assemble_acc
declare <512 x i1> @llvm.ppc.mma.assemble.acc(<16 x i8>, <16 x i8>, <16 x i8>, <16 x i8>)
define void @ass_acc(ptr %ptr, <16 x i8> %vc) {
; CHECK-LABEL: ass_acc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmr v3, v2
; CHECK-NEXT:    dmxxinstfdmr512 wacc0, vsp34, vsp34, 0
; CHECK-NEXT:    dmxxextfdmr512 wacc0, vsp34, vsp36, 0
; CHECK-NEXT:    stxv v4, 48(r3)
; CHECK-NEXT:    stxv v5, 32(r3)
; CHECK-NEXT:    stxv v2, 16(r3)
; CHECK-NEXT:    stxv v3, 0(r3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: ass_acc:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vmr v3, v2
; CHECK-BE-NEXT:    dmxxinstfdmr512 wacc0, vsp34, vsp34, 0
; CHECK-BE-NEXT:    dmxxextfdmr512 wacc0, vsp34, vsp36, 0
; CHECK-BE-NEXT:    stxv v5, 48(r3)
; CHECK-BE-NEXT:    stxv v4, 32(r3)
; CHECK-BE-NEXT:    stxv v3, 16(r3)
; CHECK-BE-NEXT:    stxv v2, 0(r3)
; CHECK-BE-NEXT:    blr
;
; CHECK-O0-LABEL: ass_acc:
; CHECK-O0:       # %bb.0: # %entry
; CHECK-O0-NEXT:    vmr v4, v2
; CHECK-O0-NEXT:    # implicit-def: $vsrp17
; CHECK-O0-NEXT:    vmr v3, v4
; CHECK-O0-NEXT:    vmr v2, v4
; CHECK-O0-NEXT:    dmxxinstfdmr512 wacc0, vsp34, vsp34, 0
; CHECK-O0-NEXT:    dmxxextfdmr512 wacc0, vsp34, vsp36, 0
; CHECK-O0-NEXT:    xxlor vs0, v4, v4
; CHECK-O0-NEXT:    stxv vs0, 48(r3)
; CHECK-O0-NEXT:    xxlor vs0, v5, v5
; CHECK-O0-NEXT:    stxv vs0, 32(r3)
; CHECK-O0-NEXT:    xxlor vs0, v2, v2
; CHECK-O0-NEXT:    stxv vs0, 16(r3)
; CHECK-O0-NEXT:    xxlor vs0, v3, v3
; CHECK-O0-NEXT:    stxv vs0, 0(r3)
; CHECK-O0-NEXT:    blr
;
; CHECK-O0-BE-LABEL: ass_acc:
; CHECK-O0-BE:       # %bb.0: # %entry
; CHECK-O0-BE-NEXT:    vmr v4, v2
; CHECK-O0-BE-NEXT:    # implicit-def: $vsrp17
; CHECK-O0-BE-NEXT:    vmr v3, v4
; CHECK-O0-BE-NEXT:    vmr v2, v4
; CHECK-O0-BE-NEXT:    dmxxinstfdmr512 wacc0, vsp34, vsp34, 0
; CHECK-O0-BE-NEXT:    dmxxextfdmr512 wacc0, vsp34, vsp36, 0
; CHECK-O0-BE-NEXT:    xxlor vs0, v5, v5
; CHECK-O0-BE-NEXT:    stxv vs0, 48(r3)
; CHECK-O0-BE-NEXT:    xxlor vs0, v4, v4
; CHECK-O0-BE-NEXT:    stxv vs0, 32(r3)
; CHECK-O0-BE-NEXT:    xxlor vs0, v3, v3
; CHECK-O0-BE-NEXT:    stxv vs0, 16(r3)
; CHECK-O0-BE-NEXT:    xxlor vs0, v2, v2
; CHECK-O0-BE-NEXT:    stxv vs0, 0(r3)
; CHECK-O0-BE-NEXT:    blr
;
; CHECK-AIX64-LABEL: ass_acc:
; CHECK-AIX64:       # %bb.0: # %entry
; CHECK-AIX64-NEXT:    vmr 3, 2
; CHECK-AIX64-NEXT:    dmxxinstfdmr512 0, 34, 34, 0
; CHECK-AIX64-NEXT:    dmxxextfdmr512 0, 34, 36, 0
; CHECK-AIX64-NEXT:    stxv 5, 48(3)
; CHECK-AIX64-NEXT:    stxv 4, 32(3)
; CHECK-AIX64-NEXT:    stxv 3, 16(3)
; CHECK-AIX64-NEXT:    stxv 2, 0(3)
; CHECK-AIX64-NEXT:    blr
;
; CHECK-AIX32-LABEL: ass_acc:
; CHECK-AIX32:       # %bb.0: # %entry
; CHECK-AIX32-NEXT:    vmr 3, 2
; CHECK-AIX32-NEXT:    dmxxinstfdmr512 0, 34, 34, 0
; CHECK-AIX32-NEXT:    dmxxextfdmr512 0, 34, 36, 0
; CHECK-AIX32-NEXT:    stxv 5, 48(3)
; CHECK-AIX32-NEXT:    stxv 4, 32(3)
; CHECK-AIX32-NEXT:    stxv 3, 16(3)
; CHECK-AIX32-NEXT:    stxv 2, 0(3)
; CHECK-AIX32-NEXT:    blr
entry:
  %0 = tail call <512 x i1> @llvm.ppc.mma.assemble.acc(<16 x i8> %vc, <16 x i8> %vc, <16 x i8> %vc, <16 x i8> %vc)
  store <512 x i1> %0, ptr %ptr, align 64
  ret void
}

; xxsetaccz
declare <512 x i1> @llvm.ppc.mma.xxsetaccz()
define void @int_xxsetaccz(ptr %ptr) {
; CHECK-LABEL: int_xxsetaccz:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxsetaccz wacc0
; CHECK-NEXT:    dmxxextfdmr512 wacc0, vsp34, vsp36, 0
; CHECK-NEXT:    stxv v4, 48(r3)
; CHECK-NEXT:    stxv v5, 32(r3)
; CHECK-NEXT:    stxv v2, 16(r3)
; CHECK-NEXT:    stxv v3, 0(r3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: int_xxsetaccz:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    xxsetaccz wacc0
; CHECK-BE-NEXT:    dmxxextfdmr512 wacc0, vsp34, vsp36, 0
; CHECK-BE-NEXT:    stxv v5, 48(r3)
; CHECK-BE-NEXT:    stxv v4, 32(r3)
; CHECK-BE-NEXT:    stxv v3, 16(r3)
; CHECK-BE-NEXT:    stxv v2, 0(r3)
; CHECK-BE-NEXT:    blr
;
; CHECK-O0-LABEL: int_xxsetaccz:
; CHECK-O0:       # %bb.0: # %entry
; CHECK-O0-NEXT:    xxsetaccz wacc0
; CHECK-O0-NEXT:    dmxxextfdmr512 wacc0, vsp34, vsp36, 0
; CHECK-O0-NEXT:    xxlor vs0, v4, v4
; CHECK-O0-NEXT:    stxv vs0, 48(r3)
; CHECK-O0-NEXT:    xxlor vs0, v5, v5
; CHECK-O0-NEXT:    stxv vs0, 32(r3)
; CHECK-O0-NEXT:    xxlor vs0, v2, v2
; CHECK-O0-NEXT:    stxv vs0, 16(r3)
; CHECK-O0-NEXT:    xxlor vs0, v3, v3
; CHECK-O0-NEXT:    stxv vs0, 0(r3)
; CHECK-O0-NEXT:    blr
;
; CHECK-O0-BE-LABEL: int_xxsetaccz:
; CHECK-O0-BE:       # %bb.0: # %entry
; CHECK-O0-BE-NEXT:    xxsetaccz wacc0
; CHECK-O0-BE-NEXT:    dmxxextfdmr512 wacc0, vsp34, vsp36, 0
; CHECK-O0-BE-NEXT:    xxlor vs0, v5, v5
; CHECK-O0-BE-NEXT:    stxv vs0, 48(r3)
; CHECK-O0-BE-NEXT:    xxlor vs0, v4, v4
; CHECK-O0-BE-NEXT:    stxv vs0, 32(r3)
; CHECK-O0-BE-NEXT:    xxlor vs0, v3, v3
; CHECK-O0-BE-NEXT:    stxv vs0, 16(r3)
; CHECK-O0-BE-NEXT:    xxlor vs0, v2, v2
; CHECK-O0-BE-NEXT:    stxv vs0, 0(r3)
; CHECK-O0-BE-NEXT:    blr
;
; CHECK-AIX64-LABEL: int_xxsetaccz:
; CHECK-AIX64:       # %bb.0: # %entry
; CHECK-AIX64-NEXT:    xxsetaccz 0
; CHECK-AIX64-NEXT:    dmxxextfdmr512 0, 34, 36, 0
; CHECK-AIX64-NEXT:    stxv 5, 48(3)
; CHECK-AIX64-NEXT:    stxv 4, 32(3)
; CHECK-AIX64-NEXT:    stxv 3, 16(3)
; CHECK-AIX64-NEXT:    stxv 2, 0(3)
; CHECK-AIX64-NEXT:    blr
;
; CHECK-AIX32-LABEL: int_xxsetaccz:
; CHECK-AIX32:       # %bb.0: # %entry
; CHECK-AIX32-NEXT:    xxsetaccz 0
; CHECK-AIX32-NEXT:    dmxxextfdmr512 0, 34, 36, 0
; CHECK-AIX32-NEXT:    stxv 5, 48(3)
; CHECK-AIX32-NEXT:    stxv 4, 32(3)
; CHECK-AIX32-NEXT:    stxv 3, 16(3)
; CHECK-AIX32-NEXT:    stxv 2, 0(3)
; CHECK-AIX32-NEXT:    blr
entry:
  %0 = tail call <512 x i1> @llvm.ppc.mma.xxsetaccz()
  store <512 x i1> %0, ptr %ptr, align 64
  ret void
}

; disassemble_acc
declare { <16 x i8>, <16 x i8>, <16 x i8>, <16 x i8> } @llvm.ppc.mma.disassemble.acc(<512 x i1>)
define void @disass_acc(ptr %ptr1, ptr %ptr2, ptr %ptr3, ptr %ptr4) {
; CHECK-LABEL: disass_acc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxsetaccz wacc0
; CHECK-NEXT:    dmxxextfdmr512 wacc0, vsp34, vsp36, 0
; CHECK-NEXT:    stxv v5, 0(r3)
; CHECK-NEXT:    stxv v4, 0(r4)
; CHECK-NEXT:    stxv v3, 0(r5)
; CHECK-NEXT:    stxv v2, 0(r6)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: disass_acc:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    xxsetaccz wacc0
; CHECK-BE-NEXT:    dmxxextfdmr512 wacc0, vsp34, vsp36, 0
; CHECK-BE-NEXT:    stxv v2, 0(r3)
; CHECK-BE-NEXT:    stxv v3, 0(r4)
; CHECK-BE-NEXT:    stxv v4, 0(r5)
; CHECK-BE-NEXT:    stxv v5, 0(r6)
; CHECK-BE-NEXT:    blr
;
; CHECK-O0-LABEL: disass_acc:
; CHECK-O0:       # %bb.0: # %entry
; CHECK-O0-NEXT:    xxsetaccz wacc0
; CHECK-O0-NEXT:    dmxxextfdmr512 wacc0, vsp32, vsp36, 0
; CHECK-O0-NEXT:    vmr v2, v0
; CHECK-O0-NEXT:    xxlor vs0, v1, v1
; CHECK-O0-NEXT:    xxlor vs1, v4, v4
; CHECK-O0-NEXT:    xxlor vs2, v5, v5
; CHECK-O0-NEXT:    stxv vs2, 0(r3)
; CHECK-O0-NEXT:    stxv vs1, 0(r4)
; CHECK-O0-NEXT:    stxv vs0, 0(r5)
; CHECK-O0-NEXT:    stxv v2, 0(r6)
; CHECK-O0-NEXT:    blr
;
; CHECK-O0-BE-LABEL: disass_acc:
; CHECK-O0-BE:       # %bb.0: # %entry
; CHECK-O0-BE-NEXT:    xxsetaccz wacc0
; CHECK-O0-BE-NEXT:    dmxxextfdmr512 wacc0, vsp36, vsp32, 0
; CHECK-O0-BE-NEXT:    vmr v2, v1
; CHECK-O0-BE-NEXT:    xxlor vs0, v0, v0
; CHECK-O0-BE-NEXT:    xxlor vs1, v5, v5
; CHECK-O0-BE-NEXT:    xxlor vs2, v4, v4
; CHECK-O0-BE-NEXT:    stxv vs2, 0(r3)
; CHECK-O0-BE-NEXT:    stxv vs1, 0(r4)
; CHECK-O0-BE-NEXT:    stxv vs0, 0(r5)
; CHECK-O0-BE-NEXT:    stxv v2, 0(r6)
; CHECK-O0-BE-NEXT:    blr
;
; CHECK-AIX64-LABEL: disass_acc:
; CHECK-AIX64:       # %bb.0: # %entry
; CHECK-AIX64-NEXT:    xxsetaccz 0
; CHECK-AIX64-NEXT:    dmxxextfdmr512 0, 34, 36, 0
; CHECK-AIX64-NEXT:    stxv 2, 0(3)
; CHECK-AIX64-NEXT:    stxv 3, 0(4)
; CHECK-AIX64-NEXT:    stxv 4, 0(5)
; CHECK-AIX64-NEXT:    stxv 5, 0(6)
; CHECK-AIX64-NEXT:    blr
;
; CHECK-AIX32-LABEL: disass_acc:
; CHECK-AIX32:       # %bb.0: # %entry
; CHECK-AIX32-NEXT:    xxsetaccz 0
; CHECK-AIX32-NEXT:    dmxxextfdmr512 0, 34, 36, 0
; CHECK-AIX32-NEXT:    stxv 2, 0(3)
; CHECK-AIX32-NEXT:    stxv 3, 0(4)
; CHECK-AIX32-NEXT:    stxv 4, 0(5)
; CHECK-AIX32-NEXT:    stxv 5, 0(6)
; CHECK-AIX32-NEXT:    blr
entry:
  %0 = tail call <512 x i1> @llvm.ppc.mma.xxsetaccz()
  %1 = tail call { <16 x i8>, <16 x i8>, <16 x i8>, <16 x i8> } @llvm.ppc.mma.disassemble.acc(<512 x i1> %0)
  %2 = extractvalue { <16 x i8>, <16 x i8>, <16 x i8>, <16 x i8> } %1, 0
  %3 = extractvalue { <16 x i8>, <16 x i8>, <16 x i8>, <16 x i8> } %1, 1
  %4 = extractvalue { <16 x i8>, <16 x i8>, <16 x i8>, <16 x i8> } %1, 2
  %5 = extractvalue { <16 x i8>, <16 x i8>, <16 x i8>, <16 x i8> } %1, 3
  store <16 x i8> %2, ptr %ptr1, align 16
  store <16 x i8> %3, ptr %ptr2, align 16
  store <16 x i8> %4, ptr %ptr3, align 16
  store <16 x i8> %5, ptr %ptr4, align 16
  ret void
}

declare <512 x i1> @llvm.ppc.mma.xvf32gerpp(<512 x i1>, <16 x i8>, <16 x i8>)
declare <512 x i1> @llvm.ppc.mma.xvf32gerpn(<512 x i1>, <16 x i8>, <16 x i8>)
declare <512 x i1> @llvm.ppc.mma.xvf32gernp(<512 x i1>, <16 x i8>, <16 x i8>)

define void @testcse(ptr %res, <16 x i8> %vc) {
; CHECK-LABEL: testcse:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxsetaccz wacc0
; CHECK-NEXT:    xvf32gerpp wacc0, v2, v2
; CHECK-NEXT:    dmxxextfdmr512 wacc0, vsp34, vsp36, 0
; CHECK-NEXT:    stxv v4, 48(r3)
; CHECK-NEXT:    stxv v5, 32(r3)
; CHECK-NEXT:    stxv v2, 16(r3)
; CHECK-NEXT:    stxv v3, 0(r3)
; CHECK-NEXT:    stxv v4, 112(r3)
; CHECK-NEXT:    stxv v5, 96(r3)
; CHECK-NEXT:    stxv v2, 80(r3)
; CHECK-NEXT:    stxv v3, 64(r3)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: testcse:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    xxsetaccz wacc0
; CHECK-BE-NEXT:    xvf32gerpp wacc0, v2, v2
; CHECK-BE-NEXT:    dmxxextfdmr512 wacc0, vsp34, vsp36, 0
; CHECK-BE-NEXT:    stxv v5, 48(r3)
; CHECK-BE-NEXT:    stxv v4, 32(r3)
; CHECK-BE-NEXT:    stxv v3, 16(r3)
; CHECK-BE-NEXT:    stxv v2, 0(r3)
; CHECK-BE-NEXT:    stxv v5, 112(r3)
; CHECK-BE-NEXT:    stxv v4, 96(r3)
; CHECK-BE-NEXT:    stxv v3, 80(r3)
; CHECK-BE-NEXT:    stxv v2, 64(r3)
; CHECK-BE-NEXT:    blr
;
; CHECK-O0-LABEL: testcse:
; CHECK-O0:       # %bb.0: # %entry
; CHECK-O0-NEXT:    xxsetaccz wacc0
; CHECK-O0-NEXT:    xvf32gerpp wacc0, v2, v2
; CHECK-O0-NEXT:    dmxxextfdmr512 wacc0, vsp34, vsp36, 0
; CHECK-O0-NEXT:    xxlor vs3, v4, v4
; CHECK-O0-NEXT:    stxv vs3, 48(r3)
; CHECK-O0-NEXT:    xxlor vs2, v5, v5
; CHECK-O0-NEXT:    stxv vs2, 32(r3)
; CHECK-O0-NEXT:    xxlor vs1, v2, v2
; CHECK-O0-NEXT:    stxv vs1, 16(r3)
; CHECK-O0-NEXT:    xxlor vs0, v3, v3
; CHECK-O0-NEXT:    stxv vs0, 0(r3)
; CHECK-O0-NEXT:    stxv vs3, 112(r3)
; CHECK-O0-NEXT:    stxv vs2, 96(r3)
; CHECK-O0-NEXT:    stxv vs1, 80(r3)
; CHECK-O0-NEXT:    stxv vs0, 64(r3)
; CHECK-O0-NEXT:    blr
;
; CHECK-O0-BE-LABEL: testcse:
; CHECK-O0-BE:       # %bb.0: # %entry
; CHECK-O0-BE-NEXT:    xxsetaccz wacc0
; CHECK-O0-BE-NEXT:    xvf32gerpp wacc0, v2, v2
; CHECK-O0-BE-NEXT:    dmxxextfdmr512 wacc0, vsp34, vsp36, 0
; CHECK-O0-BE-NEXT:    xxlor vs3, v5, v5
; CHECK-O0-BE-NEXT:    stxv vs3, 48(r3)
; CHECK-O0-BE-NEXT:    xxlor vs2, v4, v4
; CHECK-O0-BE-NEXT:    stxv vs2, 32(r3)
; CHECK-O0-BE-NEXT:    xxlor vs1, v3, v3
; CHECK-O0-BE-NEXT:    stxv vs1, 16(r3)
; CHECK-O0-BE-NEXT:    xxlor vs0, v2, v2
; CHECK-O0-BE-NEXT:    stxv vs0, 0(r3)
; CHECK-O0-BE-NEXT:    stxv vs3, 112(r3)
; CHECK-O0-BE-NEXT:    stxv vs2, 96(r3)
; CHECK-O0-BE-NEXT:    stxv vs1, 80(r3)
; CHECK-O0-BE-NEXT:    stxv vs0, 64(r3)
; CHECK-O0-BE-NEXT:    blr
;
; CHECK-AIX64-LABEL: testcse:
; CHECK-AIX64:       # %bb.0: # %entry
; CHECK-AIX64-NEXT:    xxsetaccz 0
; CHECK-AIX64-NEXT:    xvf32gerpp 0, 2, 2
; CHECK-AIX64-NEXT:    dmxxextfdmr512 0, 34, 36, 0
; CHECK-AIX64-NEXT:    stxv 5, 48(3)
; CHECK-AIX64-NEXT:    stxv 4, 32(3)
; CHECK-AIX64-NEXT:    stxv 3, 16(3)
; CHECK-AIX64-NEXT:    stxv 2, 0(3)
; CHECK-AIX64-NEXT:    stxv 5, 112(3)
; CHECK-AIX64-NEXT:    stxv 4, 96(3)
; CHECK-AIX64-NEXT:    stxv 3, 80(3)
; CHECK-AIX64-NEXT:    stxv 2, 64(3)
; CHECK-AIX64-NEXT:    blr
;
; CHECK-AIX32-LABEL: testcse:
; CHECK-AIX32:       # %bb.0: # %entry
; CHECK-AIX32-NEXT:    xxsetaccz 0
; CHECK-AIX32-NEXT:    xvf32gerpp 0, 2, 2
; CHECK-AIX32-NEXT:    dmxxextfdmr512 0, 34, 36, 0
; CHECK-AIX32-NEXT:    stxv 5, 48(3)
; CHECK-AIX32-NEXT:    stxv 4, 32(3)
; CHECK-AIX32-NEXT:    stxv 3, 16(3)
; CHECK-AIX32-NEXT:    stxv 2, 0(3)
; CHECK-AIX32-NEXT:    stxv 5, 112(3)
; CHECK-AIX32-NEXT:    stxv 4, 96(3)
; CHECK-AIX32-NEXT:    stxv 3, 80(3)
; CHECK-AIX32-NEXT:    stxv 2, 64(3)
; CHECK-AIX32-NEXT:    blr
entry:
  %0 = call <512 x i1> @llvm.ppc.mma.xxsetaccz()
  %1 = call <512 x i1> @llvm.ppc.mma.xxsetaccz()
  %2 = call <512 x i1> @llvm.ppc.mma.xvf32gerpp(<512 x i1> %0, <16 x i8> %vc, <16 x i8> %vc)
  %3 = call <512 x i1> @llvm.ppc.mma.xvf32gerpp(<512 x i1> %1, <16 x i8> %vc, <16 x i8> %vc)
  %4 = getelementptr inbounds <512 x i1>, ptr %res, i64 0
  %5 = getelementptr inbounds <512 x i1>, ptr %res, i64 1
  store <512 x i1> %2, ptr %4, align 64
  store <512 x i1> %3, ptr %5, align 64
  ret void
}
