; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -mtriple=aarch64  %s -o - | FileCheck %s --check-prefixes=CHECK

; These tests just check that the plumbing is in place for @llvm.smax, @llvm.umax,
; @llvm.smin, @llvm.umin.

; tests for smax:

define <vscale x 16 x i8> @smax_select_i8(<vscale x 16 x i1> %pg, <vscale x 16 x i8> %a, <vscale x 16 x i8> %b) {
; CHECK-LABEL: smax_select_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    smax z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
  %sel = call <vscale x 16 x i8> @llvm.smax.nxv16i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b)
  %out = select <vscale x 16 x i1> %pg, <vscale x 16 x i8> %sel, <vscale x 16 x i8> %a
  ret <vscale x 16 x i8> %out
}

define <vscale x 8 x i16> @smax_select_i16(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %a, <vscale x 8 x i16> %b) {
; CHECK-LABEL: smax_select_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    smax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
  %sel = call <vscale x 8 x i16> @llvm.smax.nxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b)
  %out = select <vscale x 8 x i1> %pg, <vscale x 8 x i16> %sel, <vscale x 8 x i16> %a
  ret <vscale x 8 x i16> %out
}

define <vscale x 4 x i32> @smax_select_i32(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-LABEL: smax_select_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    smax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
  %sel = call <vscale x 4 x i32> @llvm.smax.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b)
  %out = select <vscale x 4 x i1> %pg, <vscale x 4 x i32> %sel, <vscale x 4 x i32> %a
  ret <vscale x 4 x i32> %out
}

define <vscale x 2 x i64> @smax_select_i64(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-LABEL: smax_select_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    smax z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
  %sel = call <vscale x 2 x i64> @llvm.smax.nxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b)
  %out = select <vscale x 2 x i1> %pg, <vscale x 2 x i64> %sel, <vscale x 2 x i64> %a
  ret <vscale x 2 x i64> %out
}

; tests for umax:

define <vscale x 16 x i8> @umax_select_i8(<vscale x 16 x i1> %pg, <vscale x 16 x i8> %a, <vscale x 16 x i8> %b) {
; CHECK-LABEL: umax_select_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umax z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
  %sel = call <vscale x 16 x i8> @llvm.umax.nxv16i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b)
  %out = select <vscale x 16 x i1> %pg, <vscale x 16 x i8> %sel, <vscale x 16 x i8> %a
  ret <vscale x 16 x i8> %out
}

define <vscale x 8 x i16> @umax_select_i16(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %a, <vscale x 8 x i16> %b) {
; CHECK-LABEL: umax_select_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
  %sel = call <vscale x 8 x i16> @llvm.umax.nxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b)
  %out = select <vscale x 8 x i1> %pg, <vscale x 8 x i16> %sel, <vscale x 8 x i16> %a
  ret <vscale x 8 x i16> %out
}

define <vscale x 4 x i32> @umax_select_i32(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-LABEL: umax_select_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
  %sel = call <vscale x 4 x i32> @llvm.umax.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b)
  %out = select <vscale x 4 x i1> %pg, <vscale x 4 x i32> %sel, <vscale x 4 x i32> %a
  ret <vscale x 4 x i32> %out
}

define <vscale x 2 x i64> @umax_select_i64(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-LABEL: umax_select_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umax z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
  %sel = call <vscale x 2 x i64> @llvm.umax.nxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b)
  %out = select <vscale x 2 x i1> %pg, <vscale x 2 x i64> %sel, <vscale x 2 x i64> %a
  ret <vscale x 2 x i64> %out
}

; tests for smin:

define <vscale x 16 x i8> @smin_select_i8(<vscale x 16 x i1> %pg, <vscale x 16 x i8> %a, <vscale x 16 x i8> %b) {
; CHECK-LABEL: smin_select_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    smin z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
  %sel = call <vscale x 16 x i8> @llvm.smin.nxv16i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b)
  %out = select <vscale x 16 x i1> %pg, <vscale x 16 x i8> %sel, <vscale x 16 x i8> %a
  ret <vscale x 16 x i8> %out
}

define <vscale x 8 x i16> @smin_select_i16(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %a, <vscale x 8 x i16> %b) {
; CHECK-LABEL: smin_select_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    smin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
  %sel = call <vscale x 8 x i16> @llvm.smin.nxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b)
  %out = select <vscale x 8 x i1> %pg, <vscale x 8 x i16> %sel, <vscale x 8 x i16> %a
  ret <vscale x 8 x i16> %out
}

define <vscale x 4 x i32> @smin_select_i32(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-LABEL: smin_select_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    smin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
  %sel = call <vscale x 4 x i32> @llvm.smin.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b)
  %out = select <vscale x 4 x i1> %pg, <vscale x 4 x i32> %sel, <vscale x 4 x i32> %a
  ret <vscale x 4 x i32> %out
}

define <vscale x 2 x i64> @smin_select_i64(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-LABEL: smin_select_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    smin z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
  %sel = call <vscale x 2 x i64> @llvm.smin.nxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b)
  %out = select <vscale x 2 x i1> %pg, <vscale x 2 x i64> %sel, <vscale x 2 x i64> %a
  ret <vscale x 2 x i64> %out
}

; tests for umin:

define <vscale x 16 x i8> @umin_select_i8(<vscale x 16 x i1> %pg, <vscale x 16 x i8> %a, <vscale x 16 x i8> %b) {
; CHECK-LABEL: umin_select_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umin z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    ret
  %sel = call <vscale x 16 x i8> @llvm.umin.nxv16i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b)
  %out = select <vscale x 16 x i1> %pg, <vscale x 16 x i8> %sel, <vscale x 16 x i8> %a
  ret <vscale x 16 x i8> %out
}

define <vscale x 8 x i16> @umin_select_i16(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %a, <vscale x 8 x i16> %b) {
; CHECK-LABEL: umin_select_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
  %sel = call <vscale x 8 x i16> @llvm.umin.nxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b)
  %out = select <vscale x 8 x i1> %pg, <vscale x 8 x i16> %sel, <vscale x 8 x i16> %a
  ret <vscale x 8 x i16> %out
}

define <vscale x 4 x i32> @umin_select_i32(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b) {
; CHECK-LABEL: umin_select_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
  %sel = call <vscale x 4 x i32> @llvm.umin.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b)
  %out = select <vscale x 4 x i1> %pg, <vscale x 4 x i32> %sel, <vscale x 4 x i32> %a
  ret <vscale x 4 x i32> %out
}

define <vscale x 2 x i64> @umin_select_i64(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %a, <vscale x 2 x i64> %b) {
; CHECK-LABEL: umin_select_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umin z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
  %sel = call <vscale x 2 x i64> @llvm.umin.nxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b)
  %out = select <vscale x 2 x i1> %pg, <vscale x 2 x i64> %sel, <vscale x 2 x i64> %a
  ret <vscale x 2 x i64> %out
}


declare <vscale x  16 x i8> @llvm.smax.nxv16i8(<vscale x  16 x i8>, <vscale x  16 x i8>)
declare <vscale x  8 x i16> @llvm.smax.nxv8i16(<vscale x  8 x i16>, <vscale x  8 x i16>)
declare <vscale x  4 x i32> @llvm.smax.nxv4i32(<vscale x  4 x i32>, <vscale x  4 x i32>)
declare <vscale x  2 x i64> @llvm.smax.nxv2i64(<vscale x  2 x i64>, <vscale x  2 x i64>)

declare <vscale x  16 x i8> @llvm.umax.nxv16i8(<vscale x  16 x i8>, <vscale x  16 x i8>)
declare <vscale x  8 x i16> @llvm.umax.nxv8i16(<vscale x  8 x i16>, <vscale x  8 x i16>)
declare <vscale x  4 x i32> @llvm.umax.nxv4i32(<vscale x  4 x i32>, <vscale x  4 x i32>)
declare <vscale x  2 x i64> @llvm.umax.nxv2i64(<vscale x  2 x i64>, <vscale x  2 x i64>)

declare <vscale x  16 x i8> @llvm.smin.nxv16i8(<vscale x  16 x i8>, <vscale x  16 x i8>)
declare <vscale x  8 x i16> @llvm.smin.nxv8i16(<vscale x  8 x i16>, <vscale x  8 x i16>)
declare <vscale x  4 x i32> @llvm.smin.nxv4i32(<vscale x  4 x i32>, <vscale x  4 x i32>)
declare <vscale x  2 x i64> @llvm.smin.nxv2i64(<vscale x  2 x i64>, <vscale x  2 x i64>)

declare <vscale x  16 x i8> @llvm.umin.nxv16i8(<vscale x  16 x i8>, <vscale x  16 x i8>)
declare <vscale x  8 x i16> @llvm.umin.nxv8i16(<vscale x  8 x i16>, <vscale x  8 x i16>)
declare <vscale x  4 x i32> @llvm.umin.nxv4i32(<vscale x  4 x i32>, <vscale x  4 x i32>)
declare <vscale x  2 x i64> @llvm.umin.nxv2i64(<vscale x  2 x i64>, <vscale x  2 x i64>)
