"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.execTask = void 0;
const tslib_1 = require("tslib");
/* eslint-disable no-console */
const chalk_1 = tslib_1.__importDefault(require("chalk"));
const execTask = (task) => (options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    if (!options.silent) {
        console.log(chalk_1.default.yellow(`Running ${chalk_1.default.bold(task.name)} task`));
    }
    task.setOptions(options);
    try {
        console.group();
        yield task.exec();
        console.groupEnd();
    }
    catch (e) {
        console.trace(e);
        process.exit(1);
    }
});
exports.execTask = execTask;
//# sourceMappingURL=execTask.js.map