import { RefObject } from 'react';
export interface State {
    isPanning: boolean;
    position: {
        x: number;
        y: number;
    };
}
interface Options {
    scale?: number;
    bounds?: {
        top: number;
        bottom: number;
        right: number;
        left: number;
    };
}
/**
 * Based on https://github.com/streamich/react-use/blob/master/src/useSlider.ts
 * Returns position x/y coordinates which can be directly used in transform: translate().
 * @param scale Can be used when we want to scale the movement if we are moving a scaled element. We need to do it
 *   here because we don't want to change the pos when scale changes.
 * @param bounds If set the panning cannot go outside of those bounds.
 */
export declare function usePanning<T extends Element>({ scale, bounds }?: Options): {
    state: State;
    ref: RefObject<T>;
};
export {};
