static const char* video_degradation_cl_source =
"__kernel void gegl_video_degradation (__global const float4 *input,           \n"
"                                      __global float4 *output,                \n"
"                                      __global const int *pattern,            \n"
"                                      const int pat_w,                        \n"
"                                      const int pat_h,                        \n"
"                                      const int additive,                     \n"
"                                      const int rotated)                      \n"
"{                                                                             \n"
"  const size_t gidx   = get_global_id(0);                                     \n"
"  const size_t gidy   = get_global_id(1);                                     \n"
"  const size_t gid    = gidx - get_global_offset(0) +                         \n"
"                       (gidy - get_global_offset(1)) *                        \n"
"                        get_global_size(0);                                   \n"
"  const float4 indata = input[gid];                                           \n"
"                                                                              \n"
"  /* Get channel to keep in this input pixel */                               \n"
"  const int sel_b = pattern[rotated ? pat_w * (gidx % pat_h) + gidy % pat_w:  \n"
"                                      pat_w * (gidy % pat_h) + gidx % pat_w]; \n"
"                                                                              \n"
"  /* Mask channels according to sel_b variable */                             \n"
"  float4 value = select(0.f, indata, sel_b == (int4)(0, 1, 2, 3));            \n"
"                                                                              \n"
"  /* Add original pixel if enabled */                                         \n"
"  if (additive)                                                               \n"
"      value = fmin(value + indata, 1.0f);                                     \n"
"                                                                              \n"
"  /* Maintain original alpha channel */                                       \n"
"  value.w = indata.w;                                                         \n"
"                                                                              \n"
"  output[gid] = value;                                                        \n"
"}                                                                             \n"
;
