// Copyright 2020 The TensorFlow Runtime Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This test is auto generated by: //utils/eigen:gen_conv2d_grad_filter_tests

// RUN: bef_executor %s.bef | FileCheck %s --dump-input=always
// RUN: bef_executor %s.bef --work_queue_type=mstd:1 | FileCheck %s --dump-input=always
// RUN: bef_executor %s.bef --work_queue_type=mstd:2 | FileCheck %s --dump-input=always
// RUN: bef_executor %s.bef --work_queue_type=mstd:4 | FileCheck %s --dump-input=always
// RUN: bef_executor %s.bef --work_queue_type=mstd:8 | FileCheck %s --dump-input=always

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 0
  %out_grad_index = tfrt.constant.i32 1
  %expected_index = tfrt.constant.i32 2

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 3
  %out_grad_index = tfrt.constant.i32 4
  %expected_index = tfrt.constant.i32 5

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 6
  %out_grad_index = tfrt.constant.i32 7
  %expected_index = tfrt.constant.i32 8

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 9
  %out_grad_index = tfrt.constant.i32 10
  %expected_index = tfrt.constant.i32 11

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 12
  %out_grad_index = tfrt.constant.i32 13
  %expected_index = tfrt.constant.i32 14

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 15
  %out_grad_index = tfrt.constant.i32 16
  %expected_index = tfrt.constant.i32 17

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 18
  %out_grad_index = tfrt.constant.i32 19
  %expected_index = tfrt.constant.i32 20

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 21
  %out_grad_index = tfrt.constant.i32 22
  %expected_index = tfrt.constant.i32 23

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 24
  %out_grad_index = tfrt.constant.i32 25
  %expected_index = tfrt.constant.i32 26

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 27
  %out_grad_index = tfrt.constant.i32 28
  %expected_index = tfrt.constant.i32 29

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 30
  %out_grad_index = tfrt.constant.i32 31
  %expected_index = tfrt.constant.i32 32

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 33
  %out_grad_index = tfrt.constant.i32 34
  %expected_index = tfrt.constant.i32 35

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 36
  %out_grad_index = tfrt.constant.i32 37
  %expected_index = tfrt.constant.i32 38

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 39
  %out_grad_index = tfrt.constant.i32 40
  %expected_index = tfrt.constant.i32 41

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 42
  %out_grad_index = tfrt.constant.i32 43
  %expected_index = tfrt.constant.i32 44

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 45
  %out_grad_index = tfrt.constant.i32 46
  %expected_index = tfrt.constant.i32 47

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 48
  %out_grad_index = tfrt.constant.i32 49
  %expected_index = tfrt.constant.i32 50

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 51
  %out_grad_index = tfrt.constant.i32 52
  %expected_index = tfrt.constant.i32 53

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 54
  %out_grad_index = tfrt.constant.i32 55
  %expected_index = tfrt.constant.i32 56

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 57
  %out_grad_index = tfrt.constant.i32 58
  %expected_index = tfrt.constant.i32 59

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 60
  %out_grad_index = tfrt.constant.i32 61
  %expected_index = tfrt.constant.i32 62

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 63
  %out_grad_index = tfrt.constant.i32 64
  %expected_index = tfrt.constant.i32 65

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 66
  %out_grad_index = tfrt.constant.i32 67
  %expected_index = tfrt.constant.i32 68

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_1x1_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 69
  %out_grad_index = tfrt.constant.i32 70
  %expected_index = tfrt.constant.i32 71

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 72
  %out_grad_index = tfrt.constant.i32 73
  %expected_index = tfrt.constant.i32 74

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 75
  %out_grad_index = tfrt.constant.i32 76
  %expected_index = tfrt.constant.i32 77

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 78
  %out_grad_index = tfrt.constant.i32 79
  %expected_index = tfrt.constant.i32 80

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 81
  %out_grad_index = tfrt.constant.i32 82
  %expected_index = tfrt.constant.i32 83

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 84
  %out_grad_index = tfrt.constant.i32 85
  %expected_index = tfrt.constant.i32 86

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 87
  %out_grad_index = tfrt.constant.i32 88
  %expected_index = tfrt.constant.i32 89

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 90
  %out_grad_index = tfrt.constant.i32 91
  %expected_index = tfrt.constant.i32 92

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 93
  %out_grad_index = tfrt.constant.i32 94
  %expected_index = tfrt.constant.i32 95

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 96
  %out_grad_index = tfrt.constant.i32 97
  %expected_index = tfrt.constant.i32 98

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 99
  %out_grad_index = tfrt.constant.i32 100
  %expected_index = tfrt.constant.i32 101

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 102
  %out_grad_index = tfrt.constant.i32 103
  %expected_index = tfrt.constant.i32 104

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 105
  %out_grad_index = tfrt.constant.i32 106
  %expected_index = tfrt.constant.i32 107

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 108
  %out_grad_index = tfrt.constant.i32 109
  %expected_index = tfrt.constant.i32 110

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 111
  %out_grad_index = tfrt.constant.i32 112
  %expected_index = tfrt.constant.i32 113

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 114
  %out_grad_index = tfrt.constant.i32 115
  %expected_index = tfrt.constant.i32 116

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 117
  %out_grad_index = tfrt.constant.i32 118
  %expected_index = tfrt.constant.i32 119

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 120
  %out_grad_index = tfrt.constant.i32 121
  %expected_index = tfrt.constant.i32 122

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 123
  %out_grad_index = tfrt.constant.i32 124
  %expected_index = tfrt.constant.i32 125

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 126
  %out_grad_index = tfrt.constant.i32 127
  %expected_index = tfrt.constant.i32 128

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 129
  %out_grad_index = tfrt.constant.i32 130
  %expected_index = tfrt.constant.i32 131

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 132
  %out_grad_index = tfrt.constant.i32 133
  %expected_index = tfrt.constant.i32 134

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 135
  %out_grad_index = tfrt.constant.i32 136
  %expected_index = tfrt.constant.i32 137

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 138
  %out_grad_index = tfrt.constant.i32 139
  %expected_index = tfrt.constant.i32 140

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 141
  %out_grad_index = tfrt.constant.i32 142
  %expected_index = tfrt.constant.i32 143

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 144
  %out_grad_index = tfrt.constant.i32 145
  %expected_index = tfrt.constant.i32 146

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 147
  %out_grad_index = tfrt.constant.i32 148
  %expected_index = tfrt.constant.i32 149

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 150
  %out_grad_index = tfrt.constant.i32 151
  %expected_index = tfrt.constant.i32 152

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 153
  %out_grad_index = tfrt.constant.i32 154
  %expected_index = tfrt.constant.i32 155

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 156
  %out_grad_index = tfrt.constant.i32 157
  %expected_index = tfrt.constant.i32 158

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 159
  %out_grad_index = tfrt.constant.i32 160
  %expected_index = tfrt.constant.i32 161

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 162
  %out_grad_index = tfrt.constant.i32 163
  %expected_index = tfrt.constant.i32 164

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 165
  %out_grad_index = tfrt.constant.i32 166
  %expected_index = tfrt.constant.i32 167

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 168
  %out_grad_index = tfrt.constant.i32 169
  %expected_index = tfrt.constant.i32 170

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 171
  %out_grad_index = tfrt.constant.i32 172
  %expected_index = tfrt.constant.i32 173

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 174
  %out_grad_index = tfrt.constant.i32 175
  %expected_index = tfrt.constant.i32 176

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 177
  %out_grad_index = tfrt.constant.i32 178
  %expected_index = tfrt.constant.i32 179

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 180
  %out_grad_index = tfrt.constant.i32 181
  %expected_index = tfrt.constant.i32 182

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 183
  %out_grad_index = tfrt.constant.i32 184
  %expected_index = tfrt.constant.i32 185

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 186
  %out_grad_index = tfrt.constant.i32 187
  %expected_index = tfrt.constant.i32 188

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 189
  %out_grad_index = tfrt.constant.i32 190
  %expected_index = tfrt.constant.i32 191

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 192
  %out_grad_index = tfrt.constant.i32 193
  %expected_index = tfrt.constant.i32 194

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 195
  %out_grad_index = tfrt.constant.i32 196
  %expected_index = tfrt.constant.i32 197

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 198
  %out_grad_index = tfrt.constant.i32 199
  %expected_index = tfrt.constant.i32 200

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 201
  %out_grad_index = tfrt.constant.i32 202
  %expected_index = tfrt.constant.i32 203

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 204
  %out_grad_index = tfrt.constant.i32 205
  %expected_index = tfrt.constant.i32 206

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 207
  %out_grad_index = tfrt.constant.i32 208
  %expected_index = tfrt.constant.i32 209

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 210
  %out_grad_index = tfrt.constant.i32 211
  %expected_index = tfrt.constant.i32 212

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_2x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 213
  %out_grad_index = tfrt.constant.i32 214
  %expected_index = tfrt.constant.i32 215

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 216
  %out_grad_index = tfrt.constant.i32 217
  %expected_index = tfrt.constant.i32 218

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 219
  %out_grad_index = tfrt.constant.i32 220
  %expected_index = tfrt.constant.i32 221

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 222
  %out_grad_index = tfrt.constant.i32 223
  %expected_index = tfrt.constant.i32 224

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 225
  %out_grad_index = tfrt.constant.i32 226
  %expected_index = tfrt.constant.i32 227

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 228
  %out_grad_index = tfrt.constant.i32 229
  %expected_index = tfrt.constant.i32 230

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 231
  %out_grad_index = tfrt.constant.i32 232
  %expected_index = tfrt.constant.i32 233

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 234
  %out_grad_index = tfrt.constant.i32 235
  %expected_index = tfrt.constant.i32 236

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 237
  %out_grad_index = tfrt.constant.i32 238
  %expected_index = tfrt.constant.i32 239

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 240
  %out_grad_index = tfrt.constant.i32 241
  %expected_index = tfrt.constant.i32 242

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 243
  %out_grad_index = tfrt.constant.i32 244
  %expected_index = tfrt.constant.i32 245

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 246
  %out_grad_index = tfrt.constant.i32 247
  %expected_index = tfrt.constant.i32 248

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 249
  %out_grad_index = tfrt.constant.i32 250
  %expected_index = tfrt.constant.i32 251

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 252
  %out_grad_index = tfrt.constant.i32 253
  %expected_index = tfrt.constant.i32 254

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 255
  %out_grad_index = tfrt.constant.i32 256
  %expected_index = tfrt.constant.i32 257

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 258
  %out_grad_index = tfrt.constant.i32 259
  %expected_index = tfrt.constant.i32 260

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 261
  %out_grad_index = tfrt.constant.i32 262
  %expected_index = tfrt.constant.i32 263

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 264
  %out_grad_index = tfrt.constant.i32 265
  %expected_index = tfrt.constant.i32 266

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 267
  %out_grad_index = tfrt.constant.i32 268
  %expected_index = tfrt.constant.i32 269

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 270
  %out_grad_index = tfrt.constant.i32 271
  %expected_index = tfrt.constant.i32 272

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 273
  %out_grad_index = tfrt.constant.i32 274
  %expected_index = tfrt.constant.i32 275

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 276
  %out_grad_index = tfrt.constant.i32 277
  %expected_index = tfrt.constant.i32 278

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 279
  %out_grad_index = tfrt.constant.i32 280
  %expected_index = tfrt.constant.i32 281

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 282
  %out_grad_index = tfrt.constant.i32 283
  %expected_index = tfrt.constant.i32 284

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x8_f_3x2_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 285
  %out_grad_index = tfrt.constant.i32 286
  %expected_index = tfrt.constant.i32 287

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 288
  %out_grad_index = tfrt.constant.i32 289
  %expected_index = tfrt.constant.i32 290

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 291
  %out_grad_index = tfrt.constant.i32 292
  %expected_index = tfrt.constant.i32 293

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 294
  %out_grad_index = tfrt.constant.i32 295
  %expected_index = tfrt.constant.i32 296

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 297
  %out_grad_index = tfrt.constant.i32 298
  %expected_index = tfrt.constant.i32 299

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 300
  %out_grad_index = tfrt.constant.i32 301
  %expected_index = tfrt.constant.i32 302

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 303
  %out_grad_index = tfrt.constant.i32 304
  %expected_index = tfrt.constant.i32 305

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 306
  %out_grad_index = tfrt.constant.i32 307
  %expected_index = tfrt.constant.i32 308

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 309
  %out_grad_index = tfrt.constant.i32 310
  %expected_index = tfrt.constant.i32 311

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 312
  %out_grad_index = tfrt.constant.i32 313
  %expected_index = tfrt.constant.i32 314

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 315
  %out_grad_index = tfrt.constant.i32 316
  %expected_index = tfrt.constant.i32 317

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 318
  %out_grad_index = tfrt.constant.i32 319
  %expected_index = tfrt.constant.i32 320

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 321
  %out_grad_index = tfrt.constant.i32 322
  %expected_index = tfrt.constant.i32 323

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 324
  %out_grad_index = tfrt.constant.i32 325
  %expected_index = tfrt.constant.i32 326

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 327
  %out_grad_index = tfrt.constant.i32 328
  %expected_index = tfrt.constant.i32 329

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 330
  %out_grad_index = tfrt.constant.i32 331
  %expected_index = tfrt.constant.i32 332

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 333
  %out_grad_index = tfrt.constant.i32 334
  %expected_index = tfrt.constant.i32 335

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 336
  %out_grad_index = tfrt.constant.i32 337
  %expected_index = tfrt.constant.i32 338

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 339
  %out_grad_index = tfrt.constant.i32 340
  %expected_index = tfrt.constant.i32 341

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 342
  %out_grad_index = tfrt.constant.i32 343
  %expected_index = tfrt.constant.i32 344

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 345
  %out_grad_index = tfrt.constant.i32 346
  %expected_index = tfrt.constant.i32 347

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 348
  %out_grad_index = tfrt.constant.i32 349
  %expected_index = tfrt.constant.i32 350

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 351
  %out_grad_index = tfrt.constant.i32 352
  %expected_index = tfrt.constant.i32 353

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 354
  %out_grad_index = tfrt.constant.i32 355
  %expected_index = tfrt.constant.i32 356

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_1x1_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 357
  %out_grad_index = tfrt.constant.i32 358
  %expected_index = tfrt.constant.i32 359

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 360
  %out_grad_index = tfrt.constant.i32 361
  %expected_index = tfrt.constant.i32 362

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 363
  %out_grad_index = tfrt.constant.i32 364
  %expected_index = tfrt.constant.i32 365

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 366
  %out_grad_index = tfrt.constant.i32 367
  %expected_index = tfrt.constant.i32 368

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 369
  %out_grad_index = tfrt.constant.i32 370
  %expected_index = tfrt.constant.i32 371

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 372
  %out_grad_index = tfrt.constant.i32 373
  %expected_index = tfrt.constant.i32 374

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 375
  %out_grad_index = tfrt.constant.i32 376
  %expected_index = tfrt.constant.i32 377

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 378
  %out_grad_index = tfrt.constant.i32 379
  %expected_index = tfrt.constant.i32 380

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 381
  %out_grad_index = tfrt.constant.i32 382
  %expected_index = tfrt.constant.i32 383

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 384
  %out_grad_index = tfrt.constant.i32 385
  %expected_index = tfrt.constant.i32 386

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 387
  %out_grad_index = tfrt.constant.i32 388
  %expected_index = tfrt.constant.i32 389

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 390
  %out_grad_index = tfrt.constant.i32 391
  %expected_index = tfrt.constant.i32 392

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 393
  %out_grad_index = tfrt.constant.i32 394
  %expected_index = tfrt.constant.i32 395

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 396
  %out_grad_index = tfrt.constant.i32 397
  %expected_index = tfrt.constant.i32 398

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 399
  %out_grad_index = tfrt.constant.i32 400
  %expected_index = tfrt.constant.i32 401

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 402
  %out_grad_index = tfrt.constant.i32 403
  %expected_index = tfrt.constant.i32 404

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 405
  %out_grad_index = tfrt.constant.i32 406
  %expected_index = tfrt.constant.i32 407

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 408
  %out_grad_index = tfrt.constant.i32 409
  %expected_index = tfrt.constant.i32 410

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 411
  %out_grad_index = tfrt.constant.i32 412
  %expected_index = tfrt.constant.i32 413

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 414
  %out_grad_index = tfrt.constant.i32 415
  %expected_index = tfrt.constant.i32 416

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 417
  %out_grad_index = tfrt.constant.i32 418
  %expected_index = tfrt.constant.i32 419

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 420
  %out_grad_index = tfrt.constant.i32 421
  %expected_index = tfrt.constant.i32 422

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 423
  %out_grad_index = tfrt.constant.i32 424
  %expected_index = tfrt.constant.i32 425

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 426
  %out_grad_index = tfrt.constant.i32 427
  %expected_index = tfrt.constant.i32 428

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 429
  %out_grad_index = tfrt.constant.i32 430
  %expected_index = tfrt.constant.i32 431

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 432
  %out_grad_index = tfrt.constant.i32 433
  %expected_index = tfrt.constant.i32 434

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 435
  %out_grad_index = tfrt.constant.i32 436
  %expected_index = tfrt.constant.i32 437

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 438
  %out_grad_index = tfrt.constant.i32 439
  %expected_index = tfrt.constant.i32 440

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 441
  %out_grad_index = tfrt.constant.i32 442
  %expected_index = tfrt.constant.i32 443

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 444
  %out_grad_index = tfrt.constant.i32 445
  %expected_index = tfrt.constant.i32 446

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 447
  %out_grad_index = tfrt.constant.i32 448
  %expected_index = tfrt.constant.i32 449

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 450
  %out_grad_index = tfrt.constant.i32 451
  %expected_index = tfrt.constant.i32 452

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 453
  %out_grad_index = tfrt.constant.i32 454
  %expected_index = tfrt.constant.i32 455

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 456
  %out_grad_index = tfrt.constant.i32 457
  %expected_index = tfrt.constant.i32 458

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 459
  %out_grad_index = tfrt.constant.i32 460
  %expected_index = tfrt.constant.i32 461

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 462
  %out_grad_index = tfrt.constant.i32 463
  %expected_index = tfrt.constant.i32 464

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 465
  %out_grad_index = tfrt.constant.i32 466
  %expected_index = tfrt.constant.i32 467

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 468
  %out_grad_index = tfrt.constant.i32 469
  %expected_index = tfrt.constant.i32 470

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 471
  %out_grad_index = tfrt.constant.i32 472
  %expected_index = tfrt.constant.i32 473

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 474
  %out_grad_index = tfrt.constant.i32 475
  %expected_index = tfrt.constant.i32 476

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 477
  %out_grad_index = tfrt.constant.i32 478
  %expected_index = tfrt.constant.i32 479

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 480
  %out_grad_index = tfrt.constant.i32 481
  %expected_index = tfrt.constant.i32 482

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 483
  %out_grad_index = tfrt.constant.i32 484
  %expected_index = tfrt.constant.i32 485

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 486
  %out_grad_index = tfrt.constant.i32 487
  %expected_index = tfrt.constant.i32 488

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 489
  %out_grad_index = tfrt.constant.i32 490
  %expected_index = tfrt.constant.i32 491

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 492
  %out_grad_index = tfrt.constant.i32 493
  %expected_index = tfrt.constant.i32 494

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 495
  %out_grad_index = tfrt.constant.i32 496
  %expected_index = tfrt.constant.i32 497

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 498
  %out_grad_index = tfrt.constant.i32 499
  %expected_index = tfrt.constant.i32 500

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_2x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 501
  %out_grad_index = tfrt.constant.i32 502
  %expected_index = tfrt.constant.i32 503

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 504
  %out_grad_index = tfrt.constant.i32 505
  %expected_index = tfrt.constant.i32 506

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 507
  %out_grad_index = tfrt.constant.i32 508
  %expected_index = tfrt.constant.i32 509

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 510
  %out_grad_index = tfrt.constant.i32 511
  %expected_index = tfrt.constant.i32 512

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 513
  %out_grad_index = tfrt.constant.i32 514
  %expected_index = tfrt.constant.i32 515

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 516
  %out_grad_index = tfrt.constant.i32 517
  %expected_index = tfrt.constant.i32 518

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 519
  %out_grad_index = tfrt.constant.i32 520
  %expected_index = tfrt.constant.i32 521

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 522
  %out_grad_index = tfrt.constant.i32 523
  %expected_index = tfrt.constant.i32 524

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 525
  %out_grad_index = tfrt.constant.i32 526
  %expected_index = tfrt.constant.i32 527

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 528
  %out_grad_index = tfrt.constant.i32 529
  %expected_index = tfrt.constant.i32 530

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 531
  %out_grad_index = tfrt.constant.i32 532
  %expected_index = tfrt.constant.i32 533

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 534
  %out_grad_index = tfrt.constant.i32 535
  %expected_index = tfrt.constant.i32 536

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 537
  %out_grad_index = tfrt.constant.i32 538
  %expected_index = tfrt.constant.i32 539

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 540
  %out_grad_index = tfrt.constant.i32 541
  %expected_index = tfrt.constant.i32 542

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 543
  %out_grad_index = tfrt.constant.i32 544
  %expected_index = tfrt.constant.i32 545

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 546
  %out_grad_index = tfrt.constant.i32 547
  %expected_index = tfrt.constant.i32 548

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 549
  %out_grad_index = tfrt.constant.i32 550
  %expected_index = tfrt.constant.i32 551

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 552
  %out_grad_index = tfrt.constant.i32 553
  %expected_index = tfrt.constant.i32 554

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 555
  %out_grad_index = tfrt.constant.i32 556
  %expected_index = tfrt.constant.i32 557

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 558
  %out_grad_index = tfrt.constant.i32 559
  %expected_index = tfrt.constant.i32 560

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 561
  %out_grad_index = tfrt.constant.i32 562
  %expected_index = tfrt.constant.i32 563

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 564
  %out_grad_index = tfrt.constant.i32 565
  %expected_index = tfrt.constant.i32 566

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 567
  %out_grad_index = tfrt.constant.i32 568
  %expected_index = tfrt.constant.i32 569

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 570
  %out_grad_index = tfrt.constant.i32 571
  %expected_index = tfrt.constant.i32 572

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x8_f_3x2_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 573
  %out_grad_index = tfrt.constant.i32 574
  %expected_index = tfrt.constant.i32 575

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 576
  %out_grad_index = tfrt.constant.i32 577
  %expected_index = tfrt.constant.i32 578

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 579
  %out_grad_index = tfrt.constant.i32 580
  %expected_index = tfrt.constant.i32 581

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 582
  %out_grad_index = tfrt.constant.i32 583
  %expected_index = tfrt.constant.i32 584

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 585
  %out_grad_index = tfrt.constant.i32 586
  %expected_index = tfrt.constant.i32 587

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 588
  %out_grad_index = tfrt.constant.i32 589
  %expected_index = tfrt.constant.i32 590

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 591
  %out_grad_index = tfrt.constant.i32 592
  %expected_index = tfrt.constant.i32 593

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 594
  %out_grad_index = tfrt.constant.i32 595
  %expected_index = tfrt.constant.i32 596

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 597
  %out_grad_index = tfrt.constant.i32 598
  %expected_index = tfrt.constant.i32 599

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 600
  %out_grad_index = tfrt.constant.i32 601
  %expected_index = tfrt.constant.i32 602

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 603
  %out_grad_index = tfrt.constant.i32 604
  %expected_index = tfrt.constant.i32 605

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 606
  %out_grad_index = tfrt.constant.i32 607
  %expected_index = tfrt.constant.i32 608

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 609
  %out_grad_index = tfrt.constant.i32 610
  %expected_index = tfrt.constant.i32 611

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 612
  %out_grad_index = tfrt.constant.i32 613
  %expected_index = tfrt.constant.i32 614

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 615
  %out_grad_index = tfrt.constant.i32 616
  %expected_index = tfrt.constant.i32 617

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 618
  %out_grad_index = tfrt.constant.i32 619
  %expected_index = tfrt.constant.i32 620

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 621
  %out_grad_index = tfrt.constant.i32 622
  %expected_index = tfrt.constant.i32 623

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 624
  %out_grad_index = tfrt.constant.i32 625
  %expected_index = tfrt.constant.i32 626

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 627
  %out_grad_index = tfrt.constant.i32 628
  %expected_index = tfrt.constant.i32 629

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 630
  %out_grad_index = tfrt.constant.i32 631
  %expected_index = tfrt.constant.i32 632

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 633
  %out_grad_index = tfrt.constant.i32 634
  %expected_index = tfrt.constant.i32 635

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 636
  %out_grad_index = tfrt.constant.i32 637
  %expected_index = tfrt.constant.i32 638

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 639
  %out_grad_index = tfrt.constant.i32 640
  %expected_index = tfrt.constant.i32 641

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 642
  %out_grad_index = tfrt.constant.i32 643
  %expected_index = tfrt.constant.i32 644

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_1x1_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 645
  %out_grad_index = tfrt.constant.i32 646
  %expected_index = tfrt.constant.i32 647

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 648
  %out_grad_index = tfrt.constant.i32 649
  %expected_index = tfrt.constant.i32 650

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 651
  %out_grad_index = tfrt.constant.i32 652
  %expected_index = tfrt.constant.i32 653

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 654
  %out_grad_index = tfrt.constant.i32 655
  %expected_index = tfrt.constant.i32 656

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 657
  %out_grad_index = tfrt.constant.i32 658
  %expected_index = tfrt.constant.i32 659

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 660
  %out_grad_index = tfrt.constant.i32 661
  %expected_index = tfrt.constant.i32 662

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 663
  %out_grad_index = tfrt.constant.i32 664
  %expected_index = tfrt.constant.i32 665

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 666
  %out_grad_index = tfrt.constant.i32 667
  %expected_index = tfrt.constant.i32 668

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 669
  %out_grad_index = tfrt.constant.i32 670
  %expected_index = tfrt.constant.i32 671

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 672
  %out_grad_index = tfrt.constant.i32 673
  %expected_index = tfrt.constant.i32 674

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 675
  %out_grad_index = tfrt.constant.i32 676
  %expected_index = tfrt.constant.i32 677

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 678
  %out_grad_index = tfrt.constant.i32 679
  %expected_index = tfrt.constant.i32 680

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 681
  %out_grad_index = tfrt.constant.i32 682
  %expected_index = tfrt.constant.i32 683

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 684
  %out_grad_index = tfrt.constant.i32 685
  %expected_index = tfrt.constant.i32 686

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 687
  %out_grad_index = tfrt.constant.i32 688
  %expected_index = tfrt.constant.i32 689

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 690
  %out_grad_index = tfrt.constant.i32 691
  %expected_index = tfrt.constant.i32 692

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 693
  %out_grad_index = tfrt.constant.i32 694
  %expected_index = tfrt.constant.i32 695

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 696
  %out_grad_index = tfrt.constant.i32 697
  %expected_index = tfrt.constant.i32 698

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 699
  %out_grad_index = tfrt.constant.i32 700
  %expected_index = tfrt.constant.i32 701

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 702
  %out_grad_index = tfrt.constant.i32 703
  %expected_index = tfrt.constant.i32 704

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 705
  %out_grad_index = tfrt.constant.i32 706
  %expected_index = tfrt.constant.i32 707

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 708
  %out_grad_index = tfrt.constant.i32 709
  %expected_index = tfrt.constant.i32 710

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 711
  %out_grad_index = tfrt.constant.i32 712
  %expected_index = tfrt.constant.i32 713

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 714
  %out_grad_index = tfrt.constant.i32 715
  %expected_index = tfrt.constant.i32 716

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 717
  %out_grad_index = tfrt.constant.i32 718
  %expected_index = tfrt.constant.i32 719

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 720
  %out_grad_index = tfrt.constant.i32 721
  %expected_index = tfrt.constant.i32 722

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 723
  %out_grad_index = tfrt.constant.i32 724
  %expected_index = tfrt.constant.i32 725

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 726
  %out_grad_index = tfrt.constant.i32 727
  %expected_index = tfrt.constant.i32 728

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 729
  %out_grad_index = tfrt.constant.i32 730
  %expected_index = tfrt.constant.i32 731

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 732
  %out_grad_index = tfrt.constant.i32 733
  %expected_index = tfrt.constant.i32 734

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 735
  %out_grad_index = tfrt.constant.i32 736
  %expected_index = tfrt.constant.i32 737

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 738
  %out_grad_index = tfrt.constant.i32 739
  %expected_index = tfrt.constant.i32 740

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 741
  %out_grad_index = tfrt.constant.i32 742
  %expected_index = tfrt.constant.i32 743

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 744
  %out_grad_index = tfrt.constant.i32 745
  %expected_index = tfrt.constant.i32 746

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 747
  %out_grad_index = tfrt.constant.i32 748
  %expected_index = tfrt.constant.i32 749

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 750
  %out_grad_index = tfrt.constant.i32 751
  %expected_index = tfrt.constant.i32 752

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 753
  %out_grad_index = tfrt.constant.i32 754
  %expected_index = tfrt.constant.i32 755

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 756
  %out_grad_index = tfrt.constant.i32 757
  %expected_index = tfrt.constant.i32 758

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 759
  %out_grad_index = tfrt.constant.i32 760
  %expected_index = tfrt.constant.i32 761

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 762
  %out_grad_index = tfrt.constant.i32 763
  %expected_index = tfrt.constant.i32 764

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 765
  %out_grad_index = tfrt.constant.i32 766
  %expected_index = tfrt.constant.i32 767

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 768
  %out_grad_index = tfrt.constant.i32 769
  %expected_index = tfrt.constant.i32 770

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 771
  %out_grad_index = tfrt.constant.i32 772
  %expected_index = tfrt.constant.i32 773

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 774
  %out_grad_index = tfrt.constant.i32 775
  %expected_index = tfrt.constant.i32 776

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 777
  %out_grad_index = tfrt.constant.i32 778
  %expected_index = tfrt.constant.i32 779

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 780
  %out_grad_index = tfrt.constant.i32 781
  %expected_index = tfrt.constant.i32 782

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 783
  %out_grad_index = tfrt.constant.i32 784
  %expected_index = tfrt.constant.i32 785

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 786
  %out_grad_index = tfrt.constant.i32 787
  %expected_index = tfrt.constant.i32 788

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_2x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 789
  %out_grad_index = tfrt.constant.i32 790
  %expected_index = tfrt.constant.i32 791

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 792
  %out_grad_index = tfrt.constant.i32 793
  %expected_index = tfrt.constant.i32 794

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 795
  %out_grad_index = tfrt.constant.i32 796
  %expected_index = tfrt.constant.i32 797

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 798
  %out_grad_index = tfrt.constant.i32 799
  %expected_index = tfrt.constant.i32 800

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 801
  %out_grad_index = tfrt.constant.i32 802
  %expected_index = tfrt.constant.i32 803

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 804
  %out_grad_index = tfrt.constant.i32 805
  %expected_index = tfrt.constant.i32 806

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 807
  %out_grad_index = tfrt.constant.i32 808
  %expected_index = tfrt.constant.i32 809

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 810
  %out_grad_index = tfrt.constant.i32 811
  %expected_index = tfrt.constant.i32 812

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 813
  %out_grad_index = tfrt.constant.i32 814
  %expected_index = tfrt.constant.i32 815

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 816
  %out_grad_index = tfrt.constant.i32 817
  %expected_index = tfrt.constant.i32 818

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 819
  %out_grad_index = tfrt.constant.i32 820
  %expected_index = tfrt.constant.i32 821

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 822
  %out_grad_index = tfrt.constant.i32 823
  %expected_index = tfrt.constant.i32 824

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 825
  %out_grad_index = tfrt.constant.i32 826
  %expected_index = tfrt.constant.i32 827

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 828
  %out_grad_index = tfrt.constant.i32 829
  %expected_index = tfrt.constant.i32 830

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 831
  %out_grad_index = tfrt.constant.i32 832
  %expected_index = tfrt.constant.i32 833

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 834
  %out_grad_index = tfrt.constant.i32 835
  %expected_index = tfrt.constant.i32 836

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 837
  %out_grad_index = tfrt.constant.i32 838
  %expected_index = tfrt.constant.i32 839

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 840
  %out_grad_index = tfrt.constant.i32 841
  %expected_index = tfrt.constant.i32 842

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 843
  %out_grad_index = tfrt.constant.i32 844
  %expected_index = tfrt.constant.i32 845

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 846
  %out_grad_index = tfrt.constant.i32 847
  %expected_index = tfrt.constant.i32 848

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 849
  %out_grad_index = tfrt.constant.i32 850
  %expected_index = tfrt.constant.i32 851

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 852
  %out_grad_index = tfrt.constant.i32 853
  %expected_index = tfrt.constant.i32 854

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 855
  %out_grad_index = tfrt.constant.i32 856
  %expected_index = tfrt.constant.i32 857

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 858
  %out_grad_index = tfrt.constant.i32 859
  %expected_index = tfrt.constant.i32 860

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x8_f_3x2_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 861
  %out_grad_index = tfrt.constant.i32 862
  %expected_index = tfrt.constant.i32 863

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 864
  %out_grad_index = tfrt.constant.i32 865
  %expected_index = tfrt.constant.i32 866

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 867
  %out_grad_index = tfrt.constant.i32 868
  %expected_index = tfrt.constant.i32 869

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 870
  %out_grad_index = tfrt.constant.i32 871
  %expected_index = tfrt.constant.i32 872

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 873
  %out_grad_index = tfrt.constant.i32 874
  %expected_index = tfrt.constant.i32 875

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 876
  %out_grad_index = tfrt.constant.i32 877
  %expected_index = tfrt.constant.i32 878

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 879
  %out_grad_index = tfrt.constant.i32 880
  %expected_index = tfrt.constant.i32 881

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 882
  %out_grad_index = tfrt.constant.i32 883
  %expected_index = tfrt.constant.i32 884

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 885
  %out_grad_index = tfrt.constant.i32 886
  %expected_index = tfrt.constant.i32 887

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 888
  %out_grad_index = tfrt.constant.i32 889
  %expected_index = tfrt.constant.i32 890

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 891
  %out_grad_index = tfrt.constant.i32 892
  %expected_index = tfrt.constant.i32 893

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 894
  %out_grad_index = tfrt.constant.i32 895
  %expected_index = tfrt.constant.i32 896

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 897
  %out_grad_index = tfrt.constant.i32 898
  %expected_index = tfrt.constant.i32 899

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 900
  %out_grad_index = tfrt.constant.i32 901
  %expected_index = tfrt.constant.i32 902

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 903
  %out_grad_index = tfrt.constant.i32 904
  %expected_index = tfrt.constant.i32 905

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 906
  %out_grad_index = tfrt.constant.i32 907
  %expected_index = tfrt.constant.i32 908

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 909
  %out_grad_index = tfrt.constant.i32 910
  %expected_index = tfrt.constant.i32 911

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 912
  %out_grad_index = tfrt.constant.i32 913
  %expected_index = tfrt.constant.i32 914

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 915
  %out_grad_index = tfrt.constant.i32 916
  %expected_index = tfrt.constant.i32 917

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 918
  %out_grad_index = tfrt.constant.i32 919
  %expected_index = tfrt.constant.i32 920

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 921
  %out_grad_index = tfrt.constant.i32 922
  %expected_index = tfrt.constant.i32 923

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 924
  %out_grad_index = tfrt.constant.i32 925
  %expected_index = tfrt.constant.i32 926

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 927
  %out_grad_index = tfrt.constant.i32 928
  %expected_index = tfrt.constant.i32 929

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 930
  %out_grad_index = tfrt.constant.i32 931
  %expected_index = tfrt.constant.i32 932

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_1x1_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 933
  %out_grad_index = tfrt.constant.i32 934
  %expected_index = tfrt.constant.i32 935

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 936
  %out_grad_index = tfrt.constant.i32 937
  %expected_index = tfrt.constant.i32 938

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 939
  %out_grad_index = tfrt.constant.i32 940
  %expected_index = tfrt.constant.i32 941

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 942
  %out_grad_index = tfrt.constant.i32 943
  %expected_index = tfrt.constant.i32 944

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 945
  %out_grad_index = tfrt.constant.i32 946
  %expected_index = tfrt.constant.i32 947

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 948
  %out_grad_index = tfrt.constant.i32 949
  %expected_index = tfrt.constant.i32 950

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 951
  %out_grad_index = tfrt.constant.i32 952
  %expected_index = tfrt.constant.i32 953

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 954
  %out_grad_index = tfrt.constant.i32 955
  %expected_index = tfrt.constant.i32 956

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 957
  %out_grad_index = tfrt.constant.i32 958
  %expected_index = tfrt.constant.i32 959

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 960
  %out_grad_index = tfrt.constant.i32 961
  %expected_index = tfrt.constant.i32 962

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 963
  %out_grad_index = tfrt.constant.i32 964
  %expected_index = tfrt.constant.i32 965

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 966
  %out_grad_index = tfrt.constant.i32 967
  %expected_index = tfrt.constant.i32 968

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 969
  %out_grad_index = tfrt.constant.i32 970
  %expected_index = tfrt.constant.i32 971

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 972
  %out_grad_index = tfrt.constant.i32 973
  %expected_index = tfrt.constant.i32 974

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 975
  %out_grad_index = tfrt.constant.i32 976
  %expected_index = tfrt.constant.i32 977

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 978
  %out_grad_index = tfrt.constant.i32 979
  %expected_index = tfrt.constant.i32 980

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 981
  %out_grad_index = tfrt.constant.i32 982
  %expected_index = tfrt.constant.i32 983

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 984
  %out_grad_index = tfrt.constant.i32 985
  %expected_index = tfrt.constant.i32 986

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 987
  %out_grad_index = tfrt.constant.i32 988
  %expected_index = tfrt.constant.i32 989

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 990
  %out_grad_index = tfrt.constant.i32 991
  %expected_index = tfrt.constant.i32 992

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 993
  %out_grad_index = tfrt.constant.i32 994
  %expected_index = tfrt.constant.i32 995

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 996
  %out_grad_index = tfrt.constant.i32 997
  %expected_index = tfrt.constant.i32 998

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 999
  %out_grad_index = tfrt.constant.i32 1000
  %expected_index = tfrt.constant.i32 1001

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1002
  %out_grad_index = tfrt.constant.i32 1003
  %expected_index = tfrt.constant.i32 1004

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1005
  %out_grad_index = tfrt.constant.i32 1006
  %expected_index = tfrt.constant.i32 1007

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1008
  %out_grad_index = tfrt.constant.i32 1009
  %expected_index = tfrt.constant.i32 1010

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1011
  %out_grad_index = tfrt.constant.i32 1012
  %expected_index = tfrt.constant.i32 1013

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1014
  %out_grad_index = tfrt.constant.i32 1015
  %expected_index = tfrt.constant.i32 1016

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1017
  %out_grad_index = tfrt.constant.i32 1018
  %expected_index = tfrt.constant.i32 1019

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1020
  %out_grad_index = tfrt.constant.i32 1021
  %expected_index = tfrt.constant.i32 1022

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1023
  %out_grad_index = tfrt.constant.i32 1024
  %expected_index = tfrt.constant.i32 1025

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1026
  %out_grad_index = tfrt.constant.i32 1027
  %expected_index = tfrt.constant.i32 1028

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1029
  %out_grad_index = tfrt.constant.i32 1030
  %expected_index = tfrt.constant.i32 1031

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1032
  %out_grad_index = tfrt.constant.i32 1033
  %expected_index = tfrt.constant.i32 1034

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1035
  %out_grad_index = tfrt.constant.i32 1036
  %expected_index = tfrt.constant.i32 1037

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1038
  %out_grad_index = tfrt.constant.i32 1039
  %expected_index = tfrt.constant.i32 1040

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1041
  %out_grad_index = tfrt.constant.i32 1042
  %expected_index = tfrt.constant.i32 1043

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1044
  %out_grad_index = tfrt.constant.i32 1045
  %expected_index = tfrt.constant.i32 1046

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1047
  %out_grad_index = tfrt.constant.i32 1048
  %expected_index = tfrt.constant.i32 1049

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1050
  %out_grad_index = tfrt.constant.i32 1051
  %expected_index = tfrt.constant.i32 1052

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1053
  %out_grad_index = tfrt.constant.i32 1054
  %expected_index = tfrt.constant.i32 1055

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1056
  %out_grad_index = tfrt.constant.i32 1057
  %expected_index = tfrt.constant.i32 1058

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1059
  %out_grad_index = tfrt.constant.i32 1060
  %expected_index = tfrt.constant.i32 1061

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1062
  %out_grad_index = tfrt.constant.i32 1063
  %expected_index = tfrt.constant.i32 1064

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1065
  %out_grad_index = tfrt.constant.i32 1066
  %expected_index = tfrt.constant.i32 1067

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1068
  %out_grad_index = tfrt.constant.i32 1069
  %expected_index = tfrt.constant.i32 1070

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1071
  %out_grad_index = tfrt.constant.i32 1072
  %expected_index = tfrt.constant.i32 1073

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1074
  %out_grad_index = tfrt.constant.i32 1075
  %expected_index = tfrt.constant.i32 1076

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_2x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1077
  %out_grad_index = tfrt.constant.i32 1078
  %expected_index = tfrt.constant.i32 1079

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1080
  %out_grad_index = tfrt.constant.i32 1081
  %expected_index = tfrt.constant.i32 1082

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1083
  %out_grad_index = tfrt.constant.i32 1084
  %expected_index = tfrt.constant.i32 1085

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1086
  %out_grad_index = tfrt.constant.i32 1087
  %expected_index = tfrt.constant.i32 1088

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1089
  %out_grad_index = tfrt.constant.i32 1090
  %expected_index = tfrt.constant.i32 1091

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1092
  %out_grad_index = tfrt.constant.i32 1093
  %expected_index = tfrt.constant.i32 1094

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1095
  %out_grad_index = tfrt.constant.i32 1096
  %expected_index = tfrt.constant.i32 1097

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1098
  %out_grad_index = tfrt.constant.i32 1099
  %expected_index = tfrt.constant.i32 1100

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1101
  %out_grad_index = tfrt.constant.i32 1102
  %expected_index = tfrt.constant.i32 1103

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1104
  %out_grad_index = tfrt.constant.i32 1105
  %expected_index = tfrt.constant.i32 1106

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1107
  %out_grad_index = tfrt.constant.i32 1108
  %expected_index = tfrt.constant.i32 1109

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1110
  %out_grad_index = tfrt.constant.i32 1111
  %expected_index = tfrt.constant.i32 1112

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1113
  %out_grad_index = tfrt.constant.i32 1114
  %expected_index = tfrt.constant.i32 1115

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1116
  %out_grad_index = tfrt.constant.i32 1117
  %expected_index = tfrt.constant.i32 1118

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1119
  %out_grad_index = tfrt.constant.i32 1120
  %expected_index = tfrt.constant.i32 1121

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1122
  %out_grad_index = tfrt.constant.i32 1123
  %expected_index = tfrt.constant.i32 1124

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1125
  %out_grad_index = tfrt.constant.i32 1126
  %expected_index = tfrt.constant.i32 1127

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1128
  %out_grad_index = tfrt.constant.i32 1129
  %expected_index = tfrt.constant.i32 1130

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1131
  %out_grad_index = tfrt.constant.i32 1132
  %expected_index = tfrt.constant.i32 1133

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1134
  %out_grad_index = tfrt.constant.i32 1135
  %expected_index = tfrt.constant.i32 1136

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1137
  %out_grad_index = tfrt.constant.i32 1138
  %expected_index = tfrt.constant.i32 1139

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1140
  %out_grad_index = tfrt.constant.i32 1141
  %expected_index = tfrt.constant.i32 1142

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1143
  %out_grad_index = tfrt.constant.i32 1144
  %expected_index = tfrt.constant.i32 1145

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1146
  %out_grad_index = tfrt.constant.i32 1147
  %expected_index = tfrt.constant.i32 1148

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x9x10_f_3x2_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1149
  %out_grad_index = tfrt.constant.i32 1150
  %expected_index = tfrt.constant.i32 1151

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1152
  %out_grad_index = tfrt.constant.i32 1153
  %expected_index = tfrt.constant.i32 1154

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1155
  %out_grad_index = tfrt.constant.i32 1156
  %expected_index = tfrt.constant.i32 1157

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1158
  %out_grad_index = tfrt.constant.i32 1159
  %expected_index = tfrt.constant.i32 1160

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1161
  %out_grad_index = tfrt.constant.i32 1162
  %expected_index = tfrt.constant.i32 1163

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1164
  %out_grad_index = tfrt.constant.i32 1165
  %expected_index = tfrt.constant.i32 1166

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1167
  %out_grad_index = tfrt.constant.i32 1168
  %expected_index = tfrt.constant.i32 1169

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1170
  %out_grad_index = tfrt.constant.i32 1171
  %expected_index = tfrt.constant.i32 1172

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1173
  %out_grad_index = tfrt.constant.i32 1174
  %expected_index = tfrt.constant.i32 1175

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1176
  %out_grad_index = tfrt.constant.i32 1177
  %expected_index = tfrt.constant.i32 1178

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1179
  %out_grad_index = tfrt.constant.i32 1180
  %expected_index = tfrt.constant.i32 1181

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1182
  %out_grad_index = tfrt.constant.i32 1183
  %expected_index = tfrt.constant.i32 1184

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1185
  %out_grad_index = tfrt.constant.i32 1186
  %expected_index = tfrt.constant.i32 1187

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1188
  %out_grad_index = tfrt.constant.i32 1189
  %expected_index = tfrt.constant.i32 1190

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1191
  %out_grad_index = tfrt.constant.i32 1192
  %expected_index = tfrt.constant.i32 1193

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1194
  %out_grad_index = tfrt.constant.i32 1195
  %expected_index = tfrt.constant.i32 1196

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1197
  %out_grad_index = tfrt.constant.i32 1198
  %expected_index = tfrt.constant.i32 1199

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1200
  %out_grad_index = tfrt.constant.i32 1201
  %expected_index = tfrt.constant.i32 1202

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1203
  %out_grad_index = tfrt.constant.i32 1204
  %expected_index = tfrt.constant.i32 1205

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1206
  %out_grad_index = tfrt.constant.i32 1207
  %expected_index = tfrt.constant.i32 1208

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1209
  %out_grad_index = tfrt.constant.i32 1210
  %expected_index = tfrt.constant.i32 1211

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1212
  %out_grad_index = tfrt.constant.i32 1213
  %expected_index = tfrt.constant.i32 1214

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1215
  %out_grad_index = tfrt.constant.i32 1216
  %expected_index = tfrt.constant.i32 1217

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1218
  %out_grad_index = tfrt.constant.i32 1219
  %expected_index = tfrt.constant.i32 1220

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_1x1_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1221
  %out_grad_index = tfrt.constant.i32 1222
  %expected_index = tfrt.constant.i32 1223

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1224
  %out_grad_index = tfrt.constant.i32 1225
  %expected_index = tfrt.constant.i32 1226

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1227
  %out_grad_index = tfrt.constant.i32 1228
  %expected_index = tfrt.constant.i32 1229

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1230
  %out_grad_index = tfrt.constant.i32 1231
  %expected_index = tfrt.constant.i32 1232

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1233
  %out_grad_index = tfrt.constant.i32 1234
  %expected_index = tfrt.constant.i32 1235

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1236
  %out_grad_index = tfrt.constant.i32 1237
  %expected_index = tfrt.constant.i32 1238

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1239
  %out_grad_index = tfrt.constant.i32 1240
  %expected_index = tfrt.constant.i32 1241

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1242
  %out_grad_index = tfrt.constant.i32 1243
  %expected_index = tfrt.constant.i32 1244

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1245
  %out_grad_index = tfrt.constant.i32 1246
  %expected_index = tfrt.constant.i32 1247

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1248
  %out_grad_index = tfrt.constant.i32 1249
  %expected_index = tfrt.constant.i32 1250

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1251
  %out_grad_index = tfrt.constant.i32 1252
  %expected_index = tfrt.constant.i32 1253

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1254
  %out_grad_index = tfrt.constant.i32 1255
  %expected_index = tfrt.constant.i32 1256

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1257
  %out_grad_index = tfrt.constant.i32 1258
  %expected_index = tfrt.constant.i32 1259

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1260
  %out_grad_index = tfrt.constant.i32 1261
  %expected_index = tfrt.constant.i32 1262

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1263
  %out_grad_index = tfrt.constant.i32 1264
  %expected_index = tfrt.constant.i32 1265

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1266
  %out_grad_index = tfrt.constant.i32 1267
  %expected_index = tfrt.constant.i32 1268

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1269
  %out_grad_index = tfrt.constant.i32 1270
  %expected_index = tfrt.constant.i32 1271

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1272
  %out_grad_index = tfrt.constant.i32 1273
  %expected_index = tfrt.constant.i32 1274

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1275
  %out_grad_index = tfrt.constant.i32 1276
  %expected_index = tfrt.constant.i32 1277

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1278
  %out_grad_index = tfrt.constant.i32 1279
  %expected_index = tfrt.constant.i32 1280

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1281
  %out_grad_index = tfrt.constant.i32 1282
  %expected_index = tfrt.constant.i32 1283

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1284
  %out_grad_index = tfrt.constant.i32 1285
  %expected_index = tfrt.constant.i32 1286

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1287
  %out_grad_index = tfrt.constant.i32 1288
  %expected_index = tfrt.constant.i32 1289

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1290
  %out_grad_index = tfrt.constant.i32 1291
  %expected_index = tfrt.constant.i32 1292

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1293
  %out_grad_index = tfrt.constant.i32 1294
  %expected_index = tfrt.constant.i32 1295

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1296
  %out_grad_index = tfrt.constant.i32 1297
  %expected_index = tfrt.constant.i32 1298

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1299
  %out_grad_index = tfrt.constant.i32 1300
  %expected_index = tfrt.constant.i32 1301

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1302
  %out_grad_index = tfrt.constant.i32 1303
  %expected_index = tfrt.constant.i32 1304

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1305
  %out_grad_index = tfrt.constant.i32 1306
  %expected_index = tfrt.constant.i32 1307

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1308
  %out_grad_index = tfrt.constant.i32 1309
  %expected_index = tfrt.constant.i32 1310

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1311
  %out_grad_index = tfrt.constant.i32 1312
  %expected_index = tfrt.constant.i32 1313

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1314
  %out_grad_index = tfrt.constant.i32 1315
  %expected_index = tfrt.constant.i32 1316

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1317
  %out_grad_index = tfrt.constant.i32 1318
  %expected_index = tfrt.constant.i32 1319

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1320
  %out_grad_index = tfrt.constant.i32 1321
  %expected_index = tfrt.constant.i32 1322

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1323
  %out_grad_index = tfrt.constant.i32 1324
  %expected_index = tfrt.constant.i32 1325

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1326
  %out_grad_index = tfrt.constant.i32 1327
  %expected_index = tfrt.constant.i32 1328

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1329
  %out_grad_index = tfrt.constant.i32 1330
  %expected_index = tfrt.constant.i32 1331

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1332
  %out_grad_index = tfrt.constant.i32 1333
  %expected_index = tfrt.constant.i32 1334

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1335
  %out_grad_index = tfrt.constant.i32 1336
  %expected_index = tfrt.constant.i32 1337

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1338
  %out_grad_index = tfrt.constant.i32 1339
  %expected_index = tfrt.constant.i32 1340

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1341
  %out_grad_index = tfrt.constant.i32 1342
  %expected_index = tfrt.constant.i32 1343

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1344
  %out_grad_index = tfrt.constant.i32 1345
  %expected_index = tfrt.constant.i32 1346

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1347
  %out_grad_index = tfrt.constant.i32 1348
  %expected_index = tfrt.constant.i32 1349

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1350
  %out_grad_index = tfrt.constant.i32 1351
  %expected_index = tfrt.constant.i32 1352

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1353
  %out_grad_index = tfrt.constant.i32 1354
  %expected_index = tfrt.constant.i32 1355

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1356
  %out_grad_index = tfrt.constant.i32 1357
  %expected_index = tfrt.constant.i32 1358

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1359
  %out_grad_index = tfrt.constant.i32 1360
  %expected_index = tfrt.constant.i32 1361

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1362
  %out_grad_index = tfrt.constant.i32 1363
  %expected_index = tfrt.constant.i32 1364

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_2x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1365
  %out_grad_index = tfrt.constant.i32 1366
  %expected_index = tfrt.constant.i32 1367

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1368
  %out_grad_index = tfrt.constant.i32 1369
  %expected_index = tfrt.constant.i32 1370

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1371
  %out_grad_index = tfrt.constant.i32 1372
  %expected_index = tfrt.constant.i32 1373

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1374
  %out_grad_index = tfrt.constant.i32 1375
  %expected_index = tfrt.constant.i32 1376

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1377
  %out_grad_index = tfrt.constant.i32 1378
  %expected_index = tfrt.constant.i32 1379

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1380
  %out_grad_index = tfrt.constant.i32 1381
  %expected_index = tfrt.constant.i32 1382

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1383
  %out_grad_index = tfrt.constant.i32 1384
  %expected_index = tfrt.constant.i32 1385

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1386
  %out_grad_index = tfrt.constant.i32 1387
  %expected_index = tfrt.constant.i32 1388

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1389
  %out_grad_index = tfrt.constant.i32 1390
  %expected_index = tfrt.constant.i32 1391

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1392
  %out_grad_index = tfrt.constant.i32 1393
  %expected_index = tfrt.constant.i32 1394

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1395
  %out_grad_index = tfrt.constant.i32 1396
  %expected_index = tfrt.constant.i32 1397

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1398
  %out_grad_index = tfrt.constant.i32 1399
  %expected_index = tfrt.constant.i32 1400

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1401
  %out_grad_index = tfrt.constant.i32 1402
  %expected_index = tfrt.constant.i32 1403

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1404
  %out_grad_index = tfrt.constant.i32 1405
  %expected_index = tfrt.constant.i32 1406

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1407
  %out_grad_index = tfrt.constant.i32 1408
  %expected_index = tfrt.constant.i32 1409

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1410
  %out_grad_index = tfrt.constant.i32 1411
  %expected_index = tfrt.constant.i32 1412

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1413
  %out_grad_index = tfrt.constant.i32 1414
  %expected_index = tfrt.constant.i32 1415

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1416
  %out_grad_index = tfrt.constant.i32 1417
  %expected_index = tfrt.constant.i32 1418

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1419
  %out_grad_index = tfrt.constant.i32 1420
  %expected_index = tfrt.constant.i32 1421

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1422
  %out_grad_index = tfrt.constant.i32 1423
  %expected_index = tfrt.constant.i32 1424

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1425
  %out_grad_index = tfrt.constant.i32 1426
  %expected_index = tfrt.constant.i32 1427

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1428
  %out_grad_index = tfrt.constant.i32 1429
  %expected_index = tfrt.constant.i32 1430

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1431
  %out_grad_index = tfrt.constant.i32 1432
  %expected_index = tfrt.constant.i32 1433

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1434
  %out_grad_index = tfrt.constant.i32 1435
  %expected_index = tfrt.constant.i32 1436

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x9x7x10_f_3x2_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1437
  %out_grad_index = tfrt.constant.i32 1438
  %expected_index = tfrt.constant.i32 1439

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1440
  %out_grad_index = tfrt.constant.i32 1441
  %expected_index = tfrt.constant.i32 1442

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1443
  %out_grad_index = tfrt.constant.i32 1444
  %expected_index = tfrt.constant.i32 1445

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1446
  %out_grad_index = tfrt.constant.i32 1447
  %expected_index = tfrt.constant.i32 1448

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1449
  %out_grad_index = tfrt.constant.i32 1450
  %expected_index = tfrt.constant.i32 1451

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1452
  %out_grad_index = tfrt.constant.i32 1453
  %expected_index = tfrt.constant.i32 1454

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1455
  %out_grad_index = tfrt.constant.i32 1456
  %expected_index = tfrt.constant.i32 1457

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1458
  %out_grad_index = tfrt.constant.i32 1459
  %expected_index = tfrt.constant.i32 1460

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1461
  %out_grad_index = tfrt.constant.i32 1462
  %expected_index = tfrt.constant.i32 1463

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1464
  %out_grad_index = tfrt.constant.i32 1465
  %expected_index = tfrt.constant.i32 1466

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1467
  %out_grad_index = tfrt.constant.i32 1468
  %expected_index = tfrt.constant.i32 1469

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1470
  %out_grad_index = tfrt.constant.i32 1471
  %expected_index = tfrt.constant.i32 1472

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1473
  %out_grad_index = tfrt.constant.i32 1474
  %expected_index = tfrt.constant.i32 1475

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1476
  %out_grad_index = tfrt.constant.i32 1477
  %expected_index = tfrt.constant.i32 1478

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1479
  %out_grad_index = tfrt.constant.i32 1480
  %expected_index = tfrt.constant.i32 1481

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1482
  %out_grad_index = tfrt.constant.i32 1483
  %expected_index = tfrt.constant.i32 1484

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1485
  %out_grad_index = tfrt.constant.i32 1486
  %expected_index = tfrt.constant.i32 1487

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1488
  %out_grad_index = tfrt.constant.i32 1489
  %expected_index = tfrt.constant.i32 1490

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1491
  %out_grad_index = tfrt.constant.i32 1492
  %expected_index = tfrt.constant.i32 1493

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1494
  %out_grad_index = tfrt.constant.i32 1495
  %expected_index = tfrt.constant.i32 1496

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1497
  %out_grad_index = tfrt.constant.i32 1498
  %expected_index = tfrt.constant.i32 1499

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1500
  %out_grad_index = tfrt.constant.i32 1501
  %expected_index = tfrt.constant.i32 1502

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1503
  %out_grad_index = tfrt.constant.i32 1504
  %expected_index = tfrt.constant.i32 1505

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1506
  %out_grad_index = tfrt.constant.i32 1507
  %expected_index = tfrt.constant.i32 1508

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_1x1_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1509
  %out_grad_index = tfrt.constant.i32 1510
  %expected_index = tfrt.constant.i32 1511

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 1 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1512
  %out_grad_index = tfrt.constant.i32 1513
  %expected_index = tfrt.constant.i32 1514

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1515
  %out_grad_index = tfrt.constant.i32 1516
  %expected_index = tfrt.constant.i32 1517

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1518
  %out_grad_index = tfrt.constant.i32 1519
  %expected_index = tfrt.constant.i32 1520

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1521
  %out_grad_index = tfrt.constant.i32 1522
  %expected_index = tfrt.constant.i32 1523

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1524
  %out_grad_index = tfrt.constant.i32 1525
  %expected_index = tfrt.constant.i32 1526

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1527
  %out_grad_index = tfrt.constant.i32 1528
  %expected_index = tfrt.constant.i32 1529

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1530
  %out_grad_index = tfrt.constant.i32 1531
  %expected_index = tfrt.constant.i32 1532

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1533
  %out_grad_index = tfrt.constant.i32 1534
  %expected_index = tfrt.constant.i32 1535

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1536
  %out_grad_index = tfrt.constant.i32 1537
  %expected_index = tfrt.constant.i32 1538

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1539
  %out_grad_index = tfrt.constant.i32 1540
  %expected_index = tfrt.constant.i32 1541

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1542
  %out_grad_index = tfrt.constant.i32 1543
  %expected_index = tfrt.constant.i32 1544

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1545
  %out_grad_index = tfrt.constant.i32 1546
  %expected_index = tfrt.constant.i32 1547

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1548
  %out_grad_index = tfrt.constant.i32 1549
  %expected_index = tfrt.constant.i32 1550

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1551
  %out_grad_index = tfrt.constant.i32 1552
  %expected_index = tfrt.constant.i32 1553

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1554
  %out_grad_index = tfrt.constant.i32 1555
  %expected_index = tfrt.constant.i32 1556

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1557
  %out_grad_index = tfrt.constant.i32 1558
  %expected_index = tfrt.constant.i32 1559

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1560
  %out_grad_index = tfrt.constant.i32 1561
  %expected_index = tfrt.constant.i32 1562

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1563
  %out_grad_index = tfrt.constant.i32 1564
  %expected_index = tfrt.constant.i32 1565

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1566
  %out_grad_index = tfrt.constant.i32 1567
  %expected_index = tfrt.constant.i32 1568

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1569
  %out_grad_index = tfrt.constant.i32 1570
  %expected_index = tfrt.constant.i32 1571

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1572
  %out_grad_index = tfrt.constant.i32 1573
  %expected_index = tfrt.constant.i32 1574

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1575
  %out_grad_index = tfrt.constant.i32 1576
  %expected_index = tfrt.constant.i32 1577

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1578
  %out_grad_index = tfrt.constant.i32 1579
  %expected_index = tfrt.constant.i32 1580

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1581
  %out_grad_index = tfrt.constant.i32 1582
  %expected_index = tfrt.constant.i32 1583

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1584
  %out_grad_index = tfrt.constant.i32 1585
  %expected_index = tfrt.constant.i32 1586

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1587
  %out_grad_index = tfrt.constant.i32 1588
  %expected_index = tfrt.constant.i32 1589

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1590
  %out_grad_index = tfrt.constant.i32 1591
  %expected_index = tfrt.constant.i32 1592

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1593
  %out_grad_index = tfrt.constant.i32 1594
  %expected_index = tfrt.constant.i32 1595

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1596
  %out_grad_index = tfrt.constant.i32 1597
  %expected_index = tfrt.constant.i32 1598

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1599
  %out_grad_index = tfrt.constant.i32 1600
  %expected_index = tfrt.constant.i32 1601

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1602
  %out_grad_index = tfrt.constant.i32 1603
  %expected_index = tfrt.constant.i32 1604

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1605
  %out_grad_index = tfrt.constant.i32 1606
  %expected_index = tfrt.constant.i32 1607

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1608
  %out_grad_index = tfrt.constant.i32 1609
  %expected_index = tfrt.constant.i32 1610

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1611
  %out_grad_index = tfrt.constant.i32 1612
  %expected_index = tfrt.constant.i32 1613

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1614
  %out_grad_index = tfrt.constant.i32 1615
  %expected_index = tfrt.constant.i32 1616

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1617
  %out_grad_index = tfrt.constant.i32 1618
  %expected_index = tfrt.constant.i32 1619

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1620
  %out_grad_index = tfrt.constant.i32 1621
  %expected_index = tfrt.constant.i32 1622

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1623
  %out_grad_index = tfrt.constant.i32 1624
  %expected_index = tfrt.constant.i32 1625

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1626
  %out_grad_index = tfrt.constant.i32 1627
  %expected_index = tfrt.constant.i32 1628

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1629
  %out_grad_index = tfrt.constant.i32 1630
  %expected_index = tfrt.constant.i32 1631

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1632
  %out_grad_index = tfrt.constant.i32 1633
  %expected_index = tfrt.constant.i32 1634

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1635
  %out_grad_index = tfrt.constant.i32 1636
  %expected_index = tfrt.constant.i32 1637

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1638
  %out_grad_index = tfrt.constant.i32 1639
  %expected_index = tfrt.constant.i32 1640

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1641
  %out_grad_index = tfrt.constant.i32 1642
  %expected_index = tfrt.constant.i32 1643

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1644
  %out_grad_index = tfrt.constant.i32 1645
  %expected_index = tfrt.constant.i32 1646

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1647
  %out_grad_index = tfrt.constant.i32 1648
  %expected_index = tfrt.constant.i32 1649

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1650
  %out_grad_index = tfrt.constant.i32 1651
  %expected_index = tfrt.constant.i32 1652

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_2x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1653
  %out_grad_index = tfrt.constant.i32 1654
  %expected_index = tfrt.constant.i32 1655

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [2 : i64, 3 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c4_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1656
  %out_grad_index = tfrt.constant.i32 1657
  %expected_index = tfrt.constant.i32 1658

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c4_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1659
  %out_grad_index = tfrt.constant.i32 1660
  %expected_index = tfrt.constant.i32 1661

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c4_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1662
  %out_grad_index = tfrt.constant.i32 1663
  %expected_index = tfrt.constant.i32 1664

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c4_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1665
  %out_grad_index = tfrt.constant.i32 1666
  %expected_index = tfrt.constant.i32 1667

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c4_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1668
  %out_grad_index = tfrt.constant.i32 1669
  %expected_index = tfrt.constant.i32 1670

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c4_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1671
  %out_grad_index = tfrt.constant.i32 1672
  %expected_index = tfrt.constant.i32 1673

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c4_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1674
  %out_grad_index = tfrt.constant.i32 1675
  %expected_index = tfrt.constant.i32 1676

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c4_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1677
  %out_grad_index = tfrt.constant.i32 1678
  %expected_index = tfrt.constant.i32 1679

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c8_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1680
  %out_grad_index = tfrt.constant.i32 1681
  %expected_index = tfrt.constant.i32 1682

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c8_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1683
  %out_grad_index = tfrt.constant.i32 1684
  %expected_index = tfrt.constant.i32 1685

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c8_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1686
  %out_grad_index = tfrt.constant.i32 1687
  %expected_index = tfrt.constant.i32 1688

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c8_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1689
  %out_grad_index = tfrt.constant.i32 1690
  %expected_index = tfrt.constant.i32 1691

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c8_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1692
  %out_grad_index = tfrt.constant.i32 1693
  %expected_index = tfrt.constant.i32 1694

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c8_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1695
  %out_grad_index = tfrt.constant.i32 1696
  %expected_index = tfrt.constant.i32 1697

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c8_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1698
  %out_grad_index = tfrt.constant.i32 1699
  %expected_index = tfrt.constant.i32 1700

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c8_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1701
  %out_grad_index = tfrt.constant.i32 1702
  %expected_index = tfrt.constant.i32 1703

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c10_padding_valid_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1704
  %out_grad_index = tfrt.constant.i32 1705
  %expected_index = tfrt.constant.i32 1706

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c10_padding_valid_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1707
  %out_grad_index = tfrt.constant.i32 1708
  %expected_index = tfrt.constant.i32 1709

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c10_padding_valid_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1710
  %out_grad_index = tfrt.constant.i32 1711
  %expected_index = tfrt.constant.i32 1712

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c10_padding_valid_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1713
  %out_grad_index = tfrt.constant.i32 1714
  %expected_index = tfrt.constant.i32 1715

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c10_padding_same_s_1x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1716
  %out_grad_index = tfrt.constant.i32 1717
  %expected_index = tfrt.constant.i32 1718

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c10_padding_same_s_1x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1719
  %out_grad_index = tfrt.constant.i32 1720
  %expected_index = tfrt.constant.i32 1721

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c10_padding_same_s_2x1'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1722
  %out_grad_index = tfrt.constant.i32 1723
  %expected_index = tfrt.constant.i32 1724

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c10_padding_same_s_2x2'
func.func @test_conv2d_grad_filter_in_1x7x9x10_f_3x2_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_grad_filter_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1725
  %out_grad_index = tfrt.constant.i32 1726
  %expected_index = tfrt.constant.i32 1727

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %out_grad = "btf.read_dense_tensor.f32.4"(%path, %out_grad_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter_grad = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [3 : i64, 2 : i64, 10 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.grad.filter.f32"(%out_grad, %input, %filter_grad, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %filter_grad, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}
