/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// ContentguardsRbacAPIService ContentguardsRbacAPI service
type ContentguardsRbacAPIService service

type ContentguardsRbacAPIContentguardsCoreRbacAddRoleRequest struct {
	ctx context.Context
	ApiService *ContentguardsRbacAPIService
	rBACContentGuardHref string
	nestedRole *NestedRole
}

func (r ContentguardsRbacAPIContentguardsCoreRbacAddRoleRequest) NestedRole(nestedRole NestedRole) ContentguardsRbacAPIContentguardsCoreRbacAddRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r ContentguardsRbacAPIContentguardsCoreRbacAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.ContentguardsCoreRbacAddRoleExecute(r)
}

/*
ContentguardsCoreRbacAddRole Method for ContentguardsCoreRbacAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rBACContentGuardHref
 @return ContentguardsRbacAPIContentguardsCoreRbacAddRoleRequest
*/
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacAddRole(ctx context.Context, rBACContentGuardHref string) ContentguardsRbacAPIContentguardsCoreRbacAddRoleRequest {
	return ContentguardsRbacAPIContentguardsCoreRbacAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		rBACContentGuardHref: rBACContentGuardHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacAddRoleExecute(r ContentguardsRbacAPIContentguardsCoreRbacAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsRbacAPIService.ContentguardsCoreRbacAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{r_b_a_c_content_guard_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"r_b_a_c_content_guard_href"+"}", parameterValueToString(r.rBACContentGuardHref, "rBACContentGuardHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentguardsRbacAPIContentguardsCoreRbacCreateRequest struct {
	ctx context.Context
	ApiService *ContentguardsRbacAPIService
	rBACContentGuard *RBACContentGuard
}

func (r ContentguardsRbacAPIContentguardsCoreRbacCreateRequest) RBACContentGuard(rBACContentGuard RBACContentGuard) ContentguardsRbacAPIContentguardsCoreRbacCreateRequest {
	r.rBACContentGuard = &rBACContentGuard
	return r
}

func (r ContentguardsRbacAPIContentguardsCoreRbacCreateRequest) Execute() (*RBACContentGuardResponse, *http.Response, error) {
	return r.ApiService.ContentguardsCoreRbacCreateExecute(r)
}

/*
ContentguardsCoreRbacCreate Create a rbac content guard

Viewset for creating contentguards that use RBAC to protect content.
Has add and remove actions for managing permission for users and groups to download content
protected by this guard.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentguardsRbacAPIContentguardsCoreRbacCreateRequest
*/
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacCreate(ctx context.Context) ContentguardsRbacAPIContentguardsCoreRbacCreateRequest {
	return ContentguardsRbacAPIContentguardsCoreRbacCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return RBACContentGuardResponse
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacCreateExecute(r ContentguardsRbacAPIContentguardsCoreRbacCreateRequest) (*RBACContentGuardResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RBACContentGuardResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsRbacAPIService.ContentguardsCoreRbacCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/contentguards/core/rbac/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.rBACContentGuard == nil {
		return localVarReturnValue, nil, reportError("rBACContentGuard is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.rBACContentGuard
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentguardsRbacAPIContentguardsCoreRbacDeleteRequest struct {
	ctx context.Context
	ApiService *ContentguardsRbacAPIService
	rBACContentGuardHref string
}

func (r ContentguardsRbacAPIContentguardsCoreRbacDeleteRequest) Execute() (*http.Response, error) {
	return r.ApiService.ContentguardsCoreRbacDeleteExecute(r)
}

/*
ContentguardsCoreRbacDelete Delete a rbac content guard

Viewset for creating contentguards that use RBAC to protect content.
Has add and remove actions for managing permission for users and groups to download content
protected by this guard.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rBACContentGuardHref
 @return ContentguardsRbacAPIContentguardsCoreRbacDeleteRequest
*/
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacDelete(ctx context.Context, rBACContentGuardHref string) ContentguardsRbacAPIContentguardsCoreRbacDeleteRequest {
	return ContentguardsRbacAPIContentguardsCoreRbacDeleteRequest{
		ApiService: a,
		ctx: ctx,
		rBACContentGuardHref: rBACContentGuardHref,
	}
}

// Execute executes the request
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacDeleteExecute(r ContentguardsRbacAPIContentguardsCoreRbacDeleteRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsRbacAPIService.ContentguardsCoreRbacDelete")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{r_b_a_c_content_guard_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"r_b_a_c_content_guard_href"+"}", parameterValueToString(r.rBACContentGuardHref, "rBACContentGuardHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ContentguardsRbacAPIContentguardsCoreRbacListRequest struct {
	ctx context.Context
	ApiService *ContentguardsRbacAPIService
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	fields *[]string
	excludeFields *[]string
}

// Number of results to return per page.
func (r ContentguardsRbacAPIContentguardsCoreRbacListRequest) Limit(limit int32) ContentguardsRbacAPIContentguardsCoreRbacListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r ContentguardsRbacAPIContentguardsCoreRbacListRequest) Name(name string) ContentguardsRbacAPIContentguardsCoreRbacListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r ContentguardsRbacAPIContentguardsCoreRbacListRequest) NameContains(nameContains string) ContentguardsRbacAPIContentguardsCoreRbacListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r ContentguardsRbacAPIContentguardsCoreRbacListRequest) NameIcontains(nameIcontains string) ContentguardsRbacAPIContentguardsCoreRbacListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r ContentguardsRbacAPIContentguardsCoreRbacListRequest) NameIn(nameIn []string) ContentguardsRbacAPIContentguardsCoreRbacListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r ContentguardsRbacAPIContentguardsCoreRbacListRequest) NameStartswith(nameStartswith string) ContentguardsRbacAPIContentguardsCoreRbacListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r ContentguardsRbacAPIContentguardsCoreRbacListRequest) Offset(offset int32) ContentguardsRbacAPIContentguardsCoreRbacListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;description&#x60; - Description * &#x60;-description&#x60; - Description (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r ContentguardsRbacAPIContentguardsCoreRbacListRequest) Ordering(ordering []string) ContentguardsRbacAPIContentguardsCoreRbacListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r ContentguardsRbacAPIContentguardsCoreRbacListRequest) PulpHrefIn(pulpHrefIn []string) ContentguardsRbacAPIContentguardsCoreRbacListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r ContentguardsRbacAPIContentguardsCoreRbacListRequest) PulpIdIn(pulpIdIn []string) ContentguardsRbacAPIContentguardsCoreRbacListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// A list of fields to include in the response.
func (r ContentguardsRbacAPIContentguardsCoreRbacListRequest) Fields(fields []string) ContentguardsRbacAPIContentguardsCoreRbacListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentguardsRbacAPIContentguardsCoreRbacListRequest) ExcludeFields(excludeFields []string) ContentguardsRbacAPIContentguardsCoreRbacListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentguardsRbacAPIContentguardsCoreRbacListRequest) Execute() (*PaginatedRBACContentGuardResponseList, *http.Response, error) {
	return r.ApiService.ContentguardsCoreRbacListExecute(r)
}

/*
ContentguardsCoreRbacList List rbac content guards

Viewset for creating contentguards that use RBAC to protect content.
Has add and remove actions for managing permission for users and groups to download content
protected by this guard.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentguardsRbacAPIContentguardsCoreRbacListRequest
*/
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacList(ctx context.Context) ContentguardsRbacAPIContentguardsCoreRbacListRequest {
	return ContentguardsRbacAPIContentguardsCoreRbacListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedRBACContentGuardResponseList
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacListExecute(r ContentguardsRbacAPIContentguardsCoreRbacListRequest) (*PaginatedRBACContentGuardResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedRBACContentGuardResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsRbacAPIService.ContentguardsCoreRbacList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/contentguards/core/rbac/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentguardsRbacAPIContentguardsCoreRbacListRolesRequest struct {
	ctx context.Context
	ApiService *ContentguardsRbacAPIService
	rBACContentGuardHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentguardsRbacAPIContentguardsCoreRbacListRolesRequest) Fields(fields []string) ContentguardsRbacAPIContentguardsCoreRbacListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentguardsRbacAPIContentguardsCoreRbacListRolesRequest) ExcludeFields(excludeFields []string) ContentguardsRbacAPIContentguardsCoreRbacListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentguardsRbacAPIContentguardsCoreRbacListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.ContentguardsCoreRbacListRolesExecute(r)
}

/*
ContentguardsCoreRbacListRoles Method for ContentguardsCoreRbacListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rBACContentGuardHref
 @return ContentguardsRbacAPIContentguardsCoreRbacListRolesRequest
*/
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacListRoles(ctx context.Context, rBACContentGuardHref string) ContentguardsRbacAPIContentguardsCoreRbacListRolesRequest {
	return ContentguardsRbacAPIContentguardsCoreRbacListRolesRequest{
		ApiService: a,
		ctx: ctx,
		rBACContentGuardHref: rBACContentGuardHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacListRolesExecute(r ContentguardsRbacAPIContentguardsCoreRbacListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsRbacAPIService.ContentguardsCoreRbacListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{r_b_a_c_content_guard_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"r_b_a_c_content_guard_href"+"}", parameterValueToString(r.rBACContentGuardHref, "rBACContentGuardHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentguardsRbacAPIContentguardsCoreRbacMyPermissionsRequest struct {
	ctx context.Context
	ApiService *ContentguardsRbacAPIService
	rBACContentGuardHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentguardsRbacAPIContentguardsCoreRbacMyPermissionsRequest) Fields(fields []string) ContentguardsRbacAPIContentguardsCoreRbacMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentguardsRbacAPIContentguardsCoreRbacMyPermissionsRequest) ExcludeFields(excludeFields []string) ContentguardsRbacAPIContentguardsCoreRbacMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentguardsRbacAPIContentguardsCoreRbacMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.ContentguardsCoreRbacMyPermissionsExecute(r)
}

/*
ContentguardsCoreRbacMyPermissions Method for ContentguardsCoreRbacMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rBACContentGuardHref
 @return ContentguardsRbacAPIContentguardsCoreRbacMyPermissionsRequest
*/
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacMyPermissions(ctx context.Context, rBACContentGuardHref string) ContentguardsRbacAPIContentguardsCoreRbacMyPermissionsRequest {
	return ContentguardsRbacAPIContentguardsCoreRbacMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		rBACContentGuardHref: rBACContentGuardHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacMyPermissionsExecute(r ContentguardsRbacAPIContentguardsCoreRbacMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsRbacAPIService.ContentguardsCoreRbacMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{r_b_a_c_content_guard_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"r_b_a_c_content_guard_href"+"}", parameterValueToString(r.rBACContentGuardHref, "rBACContentGuardHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentguardsRbacAPIContentguardsCoreRbacPartialUpdateRequest struct {
	ctx context.Context
	ApiService *ContentguardsRbacAPIService
	rBACContentGuardHref string
	patchedRBACContentGuard *PatchedRBACContentGuard
}

func (r ContentguardsRbacAPIContentguardsCoreRbacPartialUpdateRequest) PatchedRBACContentGuard(patchedRBACContentGuard PatchedRBACContentGuard) ContentguardsRbacAPIContentguardsCoreRbacPartialUpdateRequest {
	r.patchedRBACContentGuard = &patchedRBACContentGuard
	return r
}

func (r ContentguardsRbacAPIContentguardsCoreRbacPartialUpdateRequest) Execute() (*RBACContentGuardResponse, *http.Response, error) {
	return r.ApiService.ContentguardsCoreRbacPartialUpdateExecute(r)
}

/*
ContentguardsCoreRbacPartialUpdate Update a rbac content guard

Viewset for creating contentguards that use RBAC to protect content.
Has add and remove actions for managing permission for users and groups to download content
protected by this guard.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rBACContentGuardHref
 @return ContentguardsRbacAPIContentguardsCoreRbacPartialUpdateRequest
*/
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacPartialUpdate(ctx context.Context, rBACContentGuardHref string) ContentguardsRbacAPIContentguardsCoreRbacPartialUpdateRequest {
	return ContentguardsRbacAPIContentguardsCoreRbacPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		rBACContentGuardHref: rBACContentGuardHref,
	}
}

// Execute executes the request
//  @return RBACContentGuardResponse
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacPartialUpdateExecute(r ContentguardsRbacAPIContentguardsCoreRbacPartialUpdateRequest) (*RBACContentGuardResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RBACContentGuardResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsRbacAPIService.ContentguardsCoreRbacPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{r_b_a_c_content_guard_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"r_b_a_c_content_guard_href"+"}", parameterValueToString(r.rBACContentGuardHref, "rBACContentGuardHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedRBACContentGuard == nil {
		return localVarReturnValue, nil, reportError("patchedRBACContentGuard is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedRBACContentGuard
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentguardsRbacAPIContentguardsCoreRbacReadRequest struct {
	ctx context.Context
	ApiService *ContentguardsRbacAPIService
	rBACContentGuardHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentguardsRbacAPIContentguardsCoreRbacReadRequest) Fields(fields []string) ContentguardsRbacAPIContentguardsCoreRbacReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentguardsRbacAPIContentguardsCoreRbacReadRequest) ExcludeFields(excludeFields []string) ContentguardsRbacAPIContentguardsCoreRbacReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentguardsRbacAPIContentguardsCoreRbacReadRequest) Execute() (*RBACContentGuardResponse, *http.Response, error) {
	return r.ApiService.ContentguardsCoreRbacReadExecute(r)
}

/*
ContentguardsCoreRbacRead Inspect a rbac content guard

Viewset for creating contentguards that use RBAC to protect content.
Has add and remove actions for managing permission for users and groups to download content
protected by this guard.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rBACContentGuardHref
 @return ContentguardsRbacAPIContentguardsCoreRbacReadRequest
*/
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacRead(ctx context.Context, rBACContentGuardHref string) ContentguardsRbacAPIContentguardsCoreRbacReadRequest {
	return ContentguardsRbacAPIContentguardsCoreRbacReadRequest{
		ApiService: a,
		ctx: ctx,
		rBACContentGuardHref: rBACContentGuardHref,
	}
}

// Execute executes the request
//  @return RBACContentGuardResponse
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacReadExecute(r ContentguardsRbacAPIContentguardsCoreRbacReadRequest) (*RBACContentGuardResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RBACContentGuardResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsRbacAPIService.ContentguardsCoreRbacRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{r_b_a_c_content_guard_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"r_b_a_c_content_guard_href"+"}", parameterValueToString(r.rBACContentGuardHref, "rBACContentGuardHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentguardsRbacAPIContentguardsCoreRbacRemoveRoleRequest struct {
	ctx context.Context
	ApiService *ContentguardsRbacAPIService
	rBACContentGuardHref string
	nestedRole *NestedRole
}

func (r ContentguardsRbacAPIContentguardsCoreRbacRemoveRoleRequest) NestedRole(nestedRole NestedRole) ContentguardsRbacAPIContentguardsCoreRbacRemoveRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r ContentguardsRbacAPIContentguardsCoreRbacRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.ContentguardsCoreRbacRemoveRoleExecute(r)
}

/*
ContentguardsCoreRbacRemoveRole Method for ContentguardsCoreRbacRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rBACContentGuardHref
 @return ContentguardsRbacAPIContentguardsCoreRbacRemoveRoleRequest
*/
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacRemoveRole(ctx context.Context, rBACContentGuardHref string) ContentguardsRbacAPIContentguardsCoreRbacRemoveRoleRequest {
	return ContentguardsRbacAPIContentguardsCoreRbacRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		rBACContentGuardHref: rBACContentGuardHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacRemoveRoleExecute(r ContentguardsRbacAPIContentguardsCoreRbacRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsRbacAPIService.ContentguardsCoreRbacRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{r_b_a_c_content_guard_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"r_b_a_c_content_guard_href"+"}", parameterValueToString(r.rBACContentGuardHref, "rBACContentGuardHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentguardsRbacAPIContentguardsCoreRbacUpdateRequest struct {
	ctx context.Context
	ApiService *ContentguardsRbacAPIService
	rBACContentGuardHref string
	rBACContentGuard *RBACContentGuard
}

func (r ContentguardsRbacAPIContentguardsCoreRbacUpdateRequest) RBACContentGuard(rBACContentGuard RBACContentGuard) ContentguardsRbacAPIContentguardsCoreRbacUpdateRequest {
	r.rBACContentGuard = &rBACContentGuard
	return r
}

func (r ContentguardsRbacAPIContentguardsCoreRbacUpdateRequest) Execute() (*RBACContentGuardResponse, *http.Response, error) {
	return r.ApiService.ContentguardsCoreRbacUpdateExecute(r)
}

/*
ContentguardsCoreRbacUpdate Update a rbac content guard

Viewset for creating contentguards that use RBAC to protect content.
Has add and remove actions for managing permission for users and groups to download content
protected by this guard.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rBACContentGuardHref
 @return ContentguardsRbacAPIContentguardsCoreRbacUpdateRequest
*/
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacUpdate(ctx context.Context, rBACContentGuardHref string) ContentguardsRbacAPIContentguardsCoreRbacUpdateRequest {
	return ContentguardsRbacAPIContentguardsCoreRbacUpdateRequest{
		ApiService: a,
		ctx: ctx,
		rBACContentGuardHref: rBACContentGuardHref,
	}
}

// Execute executes the request
//  @return RBACContentGuardResponse
func (a *ContentguardsRbacAPIService) ContentguardsCoreRbacUpdateExecute(r ContentguardsRbacAPIContentguardsCoreRbacUpdateRequest) (*RBACContentGuardResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RBACContentGuardResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentguardsRbacAPIService.ContentguardsCoreRbacUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{r_b_a_c_content_guard_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"r_b_a_c_content_guard_href"+"}", parameterValueToString(r.rBACContentGuardHref, "rBACContentGuardHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.rBACContentGuard == nil {
		return localVarReturnValue, nil, reportError("rBACContentGuard is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.rBACContentGuard
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
