/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.io;

import com.mysql.cj.api.conf.PropertySet;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.api.io.SocketConnection;
import com.mysql.cj.api.log.Log;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.io.AbstractSocketConnection;
import com.mysql.cj.core.io.FullReadInputStream;
import com.mysql.cj.core.io.ReadAheadInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MysqlaSocketConnection
extends AbstractSocketConnection
implements SocketConnection {
    @Override
    public void connect(String hostName, int portNumber, Properties props, PropertySet propSet, ExceptionInterceptor excInterceptor, Log log, int loginTimeout) {
        try {
            this.port = portNumber;
            this.host = hostName;
            this.propertySet = propSet;
            this.exceptionInterceptor = excInterceptor;
            this.socketFactory = this.createSocketFactory(propSet.getStringReadableProperty("socketFactory").getStringValue());
            this.mysqlSocket = this.socketFactory.connect(this.host, this.port, props, loginTimeout);
            int socketTimeout = propSet.getIntegerReadableProperty("socketTimeout").getValue();
            if (socketTimeout != 0) {
                try {
                    this.mysqlSocket.setSoTimeout(socketTimeout);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mysqlSocket = this.socketFactory.beforeHandshake();
            InputStream rawInputStream = propSet.getBooleanReadableProperty("useReadAheadInput").getValue() != false ? new ReadAheadInputStream(this.mysqlSocket.getInputStream(), 16384, propSet.getBooleanReadableProperty("traceProtocol").getValue(), log) : (propSet.getBooleanReadableProperty("useUnbufferedInput").getValue() != false ? this.mysqlSocket.getInputStream() : new BufferedInputStream(this.mysqlSocket.getInputStream(), 16384));
            this.mysqlInput = new FullReadInputStream(rawInputStream);
            this.mysqlOutput = new BufferedOutputStream(this.mysqlSocket.getOutputStream(), 16384);
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(propSet, null, 0L, 0L, ioEx, this.getExceptionInterceptor());
        }
    }
}

