/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.Socket;
import netscape.ldap.DynamicInvoker;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSSLSocketFactoryExt;

public class LDAPSSLSocketFactory
implements LDAPSSLSocketFactoryExt,
Serializable {
    static final long serialVersionUID = -3331456736649381427L;
    private boolean clientAuth = false;
    private String packageName = "netscape.net.SSLSocket";
    private transient Object cipherSuites = null;

    public LDAPSSLSocketFactory() {
    }

    public LDAPSSLSocketFactory(boolean clientAuth) {
        this.clientAuth = clientAuth;
    }

    public LDAPSSLSocketFactory(String className) {
        this.packageName = className;
    }

    public LDAPSSLSocketFactory(String className, boolean clientAuth) {
        this.packageName = className;
        this.clientAuth = clientAuth;
    }

    public LDAPSSLSocketFactory(String className, Object cipherSuites) {
        this.packageName = className;
        this.cipherSuites = cipherSuites;
    }

    public LDAPSSLSocketFactory(String className, Object cipherSuites, boolean clientAuth) {
        this.packageName = className;
        this.cipherSuites = cipherSuites;
        this.clientAuth = clientAuth;
    }

    public void enableClientAuth() {
        this.clientAuth = true;
    }

    public void enableClientAuth(String certdb, String keydb, String keypwd, String certnickname, String keynickname) throws LDAPException {
        throw new LDAPException("Client auth not supported now");
    }

    @Override
    public boolean isClientAuth() {
        return this.clientAuth;
    }

    public String getSSLSocketImpl() {
        return this.packageName;
    }

    @Override
    public Object getCipherSuites() {
        return this.cipherSuites;
    }

    @Override
    public Socket makeSocket(String host, int port) throws LDAPException {
        Executable m;
        if (this.clientAuth) {
            try {
                String[] types = new String[]{"java.lang.String"};
                m = DynamicInvoker.getMethod("netscape.security.PrivilegeManager", "enablePrivilege", types);
                if (m != null) {
                    Object[] args = new Object[]{"ClientAuth"};
                    ((Method)m).invoke(null, args);
                }
            }
            catch (Exception e) {
                String msg = "LDAPSSLSocketFactory.makeSocket: invoking enablePrivilege: " + e.toString();
                throw new LDAPException(msg, 89);
            }
        }
        try {
            Class<?> c = Class.forName(this.packageName);
            if (this.cipherSuites == null) {
                m = c.getConstructor(String.class, Integer.TYPE);
                return (Socket)((Constructor)m).newInstance(host, port);
            }
            m = c.getConstructor(String.class, Integer.TYPE, this.cipherSuites.getClass());
            return (Socket)((Constructor)m).newInstance(host, port, this.cipherSuites);
        }
        catch (NoSuchMethodException e) {
            throw new LDAPException("No appropriate constructor in " + this.packageName, 89);
        }
        catch (ClassNotFoundException e) {
            throw new LDAPException("Class " + this.packageName + " not found", 89);
        }
        catch (Exception e) {
            throw new LDAPException("Failed to create SSL socket", 91);
        }
    }
}

