var __assign =
  (this && this.__assign) ||
  function () {
    __assign =
      Object.assign ||
      function (t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
          s = arguments[i];
          for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
      };
    return __assign.apply(this, arguments);
  };
import { TransportItemType } from '../../transports';
export function initializeMeasurements(transports, metas, tracesApi) {
  var pushMeasurement = function (payload) {
    try {
      var item = {
        type: TransportItemType.MEASUREMENT,
        payload: __assign(__assign({}, payload), { trace: tracesApi.getTraceContext() }),
        meta: metas.value,
      };
      transports.execute(item);
    } catch (err) {
      // TODO: Add proper logging when debug is enabled
    }
  };
  return {
    pushMeasurement: pushMeasurement,
  };
}
//# sourceMappingURL=initialize.js.map
