"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeTransports = void 0;
var utils_1 = require("../utils");
var types_1 = require("./types");
function initializeTransports(config) {
    var transports = __spreadArray([], config.transports, true);
    var paused = config.paused;
    var beforeSendHooks = [];
    if (config.beforeSend) {
        beforeSendHooks.push(config.beforeSend);
    }
    if (config.ignoreErrors) {
        beforeSendHooks.push(createBeforeSendHookFromIgnorePatterns(config.ignoreErrors));
    }
    var add = function () {
        var transports = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            transports[_i] = arguments[_i];
        }
        transports.push.apply(transports, transports);
    };
    var execute = function (item) {
        if (!paused) {
            var _item = item;
            for (var _i = 0, beforeSendHooks_1 = beforeSendHooks; _i < beforeSendHooks_1.length; _i++) {
                var hook = beforeSendHooks_1[_i];
                var modified = hook(_item);
                if (modified === null) {
                    return;
                }
                _item = modified;
            }
            for (var _a = 0, transports_1 = transports; _a < transports_1.length; _a++) {
                var transport = transports_1[_a];
                transport.send(_item);
            }
        }
    };
    var pause = function () {
        paused = true;
    };
    var unpause = function () {
        paused = false;
    };
    return {
        add: add,
        execute: execute,
        transports: transports,
        pause: pause,
        unpause: unpause,
    };
}
exports.initializeTransports = initializeTransports;
function createBeforeSendHookFromIgnorePatterns(patterns) {
    return function (item) {
        if (item.type === types_1.TransportItemType.EXCEPTION && item.payload) {
            var event_1 = item.payload;
            var msg_1 = "".concat(event_1.type, ": ").concat(event_1.value);
            if (patterns.find(function (pattern) {
                return (0, utils_1.isString)(pattern) ? msg_1.includes(pattern) : !!msg_1.match(pattern);
            })) {
                return null;
            }
        }
        return item;
    };
}
//# sourceMappingURL=initialize.js.map