/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.ocsp;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ocsp.IDefStore;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.CRLIssuingPointRecord;
import com.netscape.ocsp.OCSPAuthority;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.X509CRLEntry;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ocsp.OCSPEngine;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

public class CheckCertServlet
extends CMSServlet {
    private static final long serialVersionUID = 7782198059640825050L;
    public static final String ATTR_STATUS = "status";
    public static final String ATTR_ISSUERDN = "issuerDN";
    public static final String ATTR_SUBJECTDN = "subjectDN";
    public static final String ATTR_SERIALNO = "serialno";
    public static final String STATUS_GOOD = "good";
    public static final String STATUS_REVOKED = "revoked";
    public static final String STATUS_UNKNOWN = "unknown";
    private static final String TPL_FILE = "checkCert.template";
    private String mFormPath = null;
    private OCSPAuthority mOCSPAuthority;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/ocsp/checkCert.template";
        this.mTemplates.remove(CMSRequest.SUCCESS);
        OCSPEngine engine = OCSPEngine.getInstance();
        this.mOCSPAuthority = engine.getOCSP();
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "validate");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        IDefStore defStore = this.mOCSPAuthority.getDefaultStore();
        String b64 = cmsReq.getHttpReq().getParameter("cert");
        if (b64.indexOf("-----BEGIN CERTIFICATE-----") == -1) {
            throw new ECMSGWException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_GW_MISSING_CERT_HEADER", (String[])new String[0]));
        }
        if (b64.indexOf("-----END CERTIFICATE-----") == -1) {
            throw new ECMSGWException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_GW_MISSING_CERT_FOOTER", (String[])new String[0]));
        }
        X509CertImpl cert = null;
        try {
            cert = Cert.mapCert((String)b64);
        }
        catch (Exception e) {
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DECODING_CERT_ERROR", (String[])new String[0]));
        }
        if (cert == null) {
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DECODING_CERT_ERROR", (String[])new String[0]));
        }
        CRLIssuingPointRecord pt = defStore.readCRLIssuingPoint(cert.getIssuerDN().getName());
        header.addStringValue(ATTR_ISSUERDN, cert.getIssuerDN().getName());
        header.addStringValue(ATTR_SUBJECTDN, cert.getSubjectDN().getName());
        header.addStringValue(ATTR_SERIALNO, "0x" + cert.getSerialNumber().toString(16));
        try {
            X509CRLImpl crl = null;
            crl = new X509CRLImpl(pt.getCRL());
            X509CRLEntry crlentry = crl.getRevokedCertificate(cert.getSerialNumber());
            if (crlentry == null) {
                if (defStore.isNotFoundGood()) {
                    header.addStringValue(ATTR_STATUS, STATUS_GOOD);
                } else {
                    header.addStringValue(ATTR_STATUS, STATUS_UNKNOWN);
                }
            } else {
                header.addStringValue(ATTR_STATUS, STATUS_REVOKED);
            }
        }
        catch (Exception e) {
            header.addStringValue(ATTR_STATUS, STATUS_UNKNOWN);
        }
        logger.info("Checked Certificate Status " + cert.getIssuerDN().getName() + " " + cert.getSerialNumber().toString());
        try {
            ServletOutputStream out = resp.getOutputStream();
            String xmlOutput = req.getParameter("xml");
            if (xmlOutput != null && xmlOutput.equals("true")) {
                this.outputXML(resp, argSet);
            } else {
                resp.setContentType("text/html");
                form.renderOutput((OutputStream)out, argSet);
                cmsReq.setStatus(CMSRequest.SUCCESS);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
    }
}

