/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.util;

import com.netscape.cmscore.base.ConfigStore;
import org.dogtagpki.util.logging.PKILogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Debug {
    public static Logger logger = LoggerFactory.getLogger(Debug.class);
    public static final String ID = "debug";
    public static final String PROP_LEVEL = "level";
    public static final int OBNOXIOUS = 1;
    public static final int VERBOSE = 5;
    public static final int INFORM = 10;
    public static final int WARN = 15;

    private static char getNybble(byte b) {
        return b < 10 ? (char)(48 + b) : (char)(97 + b - 10);
    }

    public static String dump(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            sb.append(Debug.getNybble((byte)((b[i] & 0xF0) >> 4)));
            sb.append(Debug.getNybble((byte)(b[i] & 0xF)));
            if (i % 16 == 15 && i != b.length) {
                sb.append('\n');
                continue;
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    public static void setLevel(int level) {
        PKILogger.LogLevel logLevel = level <= 1 ? PKILogger.LogLevel.TRACE : (level <= 5 ? PKILogger.LogLevel.DEBUG : (level <= 10 ? PKILogger.LogLevel.INFO : (level <= 15 ? PKILogger.LogLevel.WARN : PKILogger.LogLevel.ERROR)));
        PKILogger.setLevel((PKILogger.LogLevel)logLevel);
    }

    public void init(ConfigStore config) throws Exception {
        int level = config.getInteger(PROP_LEVEL, 10);
        Debug.setLevel(level);
        logger.debug("============================================");
        logger.debug("=====  DEBUG SUBSYSTEM INITIALIZED   =======");
        logger.debug("============================================");
    }
}

