/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.nss;

import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.cmstools.nss.NSSCLI;
import com.netscape.cmstools.nss.NSSCertExportCLI;
import com.netscape.cmstools.nss.NSSCertFindCLI;
import com.netscape.cmstools.nss.NSSCertImportCLI;
import com.netscape.cmstools.nss.NSSCertIssueCLI;
import com.netscape.cmstools.nss.NSSCertRequestCLI;
import com.netscape.cmstools.nss.NSSCertShowCLI;
import org.dogtagpki.cli.CLI;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.PK11Cert;

public class NSSCertCLI
extends CLI {
    public NSSCertCLI(NSSCLI nssCLI) {
        super("cert", "NSS certificate management commands", (CLI)nssCLI);
        this.addModule((CLI)new NSSCertFindCLI(this));
        this.addModule((CLI)new NSSCertExportCLI(this));
        this.addModule((CLI)new NSSCertImportCLI(this));
        this.addModule((CLI)new NSSCertIssueCLI(this));
        this.addModule((CLI)new NSSCertRequestCLI(this));
        this.addModule((CLI)new NSSCertShowCLI(this));
    }

    public static void printCertInfo(X509Certificate cert) throws Exception {
        System.out.println("  Nickname: " + cert.getNickname());
        CertId serialNumber = new CertId(cert.getSerialNumber());
        System.out.println("  Serial Number: " + serialNumber.toHexString());
        System.out.println("  Subject DN: " + cert.getSubjectDN());
        System.out.println("  Issuer DN: " + cert.getIssuerDN());
        PK11Cert pk11Cert = (PK11Cert)cert;
        System.out.println("  Not Valid Before: " + pk11Cert.getNotBefore());
        System.out.println("  Not Valid After: " + pk11Cert.getNotAfter());
        System.out.println("  Trust Flags: " + pk11Cert.getTrustFlags());
    }
}

