/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.client;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.client.ClientCLI;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.RandomStringUtils;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.nss.NSSDatabase;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCertShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ClientCertShowCLI.class);
    public ClientCLI clientCLI;

    public ClientCertShowCLI(ClientCLI clientCLI) {
        super("cert-show", "Show certificate in NSS database", (CLI)clientCLI);
        this.clientCLI = clientCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <nickname> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "cert", true, "PEM file to store the certificate.");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "private-key", true, "PEM file to store the private key.");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "client-cert", true, "PEM file to store the certificate and the private key.");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "pkcs12", true, "PKCS #12 file to store the certificate chain and the private key.");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "pkcs12-password", true, "PKCS #12 file password.");
        option.setArgName("password");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        File pkcs12File;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length > 1) {
            throw new Exception("Too many arguments specified.");
        }
        if (cmdArgs.length == 0) {
            throw new Exception("Missing certificate nickname.");
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        String nickname = cmdArgs[0];
        String certPath = cmd.getOptionValue("cert");
        String privateKeyPath = cmd.getOptionValue("private-key");
        String clientCertPath = cmd.getOptionValue("client-cert");
        String pkcs12Path = cmd.getOptionValue("pkcs12");
        String pkcs12Password = cmd.getOptionValue("pkcs12-password");
        if (pkcs12Path != null) {
            pkcs12File = new File(pkcs12Path);
            if (pkcs12Password == null) {
                throw new Exception("Missing PKCS #12 password");
            }
        } else if (clientCertPath != null || privateKeyPath != null) {
            pkcs12File = File.createTempFile("pki-client-cert-show-", ".p12");
            pkcs12File.deleteOnExit();
            pkcs12Password = RandomStringUtils.randomAlphanumeric((int)16);
        } else {
            mainCLI.init();
            CryptoManager manager = CryptoManager.getInstance();
            X509Certificate cert = manager.findCertByNickname(nickname);
            if (certPath != null) {
                try (PrintWriter out = new PrintWriter(new FileWriter(certPath));){
                    out.println("-----BEGIN CERTIFICATE-----");
                    out.print(Utils.base64encode((byte[])cert.getEncoded(), (boolean)true));
                    out.println("-----END CERTIFICATE-----");
                }
            } else {
                ClientCLI.printCertInfo(cert);
            }
            return;
        }
        File pkcs12PasswordFile = File.createTempFile("pki-client-cert-show-", ".pwd");
        pkcs12PasswordFile.deleteOnExit();
        try (PrintWriter out = new PrintWriter(new FileWriter(pkcs12PasswordFile));){
            out.print(pkcs12Password);
        }
        NSSDatabase nssdb = mainCLI.getNSSDatabase();
        logger.info("Exporting certificate chain and private key to " + pkcs12File);
        this.exportPKCS12(nssdb.getPath().toString(), mainCLI.config.getNSSPassword(), pkcs12File.getAbsolutePath(), pkcs12PasswordFile.getAbsolutePath(), nickname);
        if (certPath != null) {
            logger.info("Exporting certificate to " + certPath);
            this.exportCertificate(pkcs12File.getAbsolutePath(), pkcs12PasswordFile.getAbsolutePath(), certPath);
        }
        if (privateKeyPath != null) {
            logger.info("Exporting private key to " + privateKeyPath);
            this.exportPrivateKey(pkcs12File.getAbsolutePath(), pkcs12PasswordFile.getAbsolutePath(), privateKeyPath);
        }
        if (clientCertPath != null) {
            logger.info("Exporting client certificate and private key to " + clientCertPath);
            this.exportClientCertificateAndPrivateKey(pkcs12File.getAbsolutePath(), pkcs12PasswordFile.getAbsolutePath(), clientCertPath);
        }
    }

    public void exportPKCS12(String dbPath, String dbPassword, String pkcs12Path, String pkcs12PasswordPath, String nickname) throws Exception {
        String[] command = new String[]{"/usr/bin/pk12util", "-d", dbPath, "-K", dbPassword, "-o", pkcs12Path, "-w", pkcs12PasswordPath, "-n", nickname};
        try {
            this.runExternal(command);
        }
        catch (Exception e) {
            throw new Exception("Unable to export PKCS #12 file", e);
        }
    }

    public void exportCertificate(String pkcs12Path, String pkcs12PasswordPath, String certPath) throws Exception {
        String[] command = new String[]{"/usr/bin/openssl", "pkcs12", "-clcerts", "-nokeys", "-in", pkcs12Path, "-passin", "file:" + pkcs12PasswordPath, "-out", certPath};
        try {
            this.runExternal(command);
        }
        catch (Exception e) {
            throw new Exception("Unable to export certificate", e);
        }
    }

    public void exportPrivateKey(String pkcs12Path, String pkcs12PasswordPath, String privateKeyPath) throws Exception {
        String[] command = new String[]{"/usr/bin/openssl", "pkcs12", "-nocerts", "-nodes", "-in", pkcs12Path, "-passin", "file:" + pkcs12PasswordPath, "-out", privateKeyPath};
        try {
            this.runExternal(command);
        }
        catch (Exception e) {
            throw new Exception("Unable to export private key", e);
        }
    }

    public void exportClientCertificateAndPrivateKey(String pkcs12Path, String pkcs12PasswordPath, String clientCertPath) throws Exception {
        String[] command = new String[]{"/usr/bin/openssl", "pkcs12", "-clcerts", "-nodes", "-in", pkcs12Path, "-passin", "file:" + pkcs12PasswordPath, "-out", clientCertPath};
        try {
            this.runExternal(command);
        }
        catch (Exception e) {
            throw new Exception("Unable to export client certificate and private key", e);
        }
    }
}

