/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools;

import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.InitializationValues;
import org.mozilla.jss.NoSuchTokenException;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.ENUMERATED;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.UTF8String;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.pkix.cmc.PKIData;
import org.mozilla.jss.pkix.cmc.RevokeRequest;
import org.mozilla.jss.pkix.cmc.TaggedAttribute;
import org.mozilla.jss.pkix.cms.ContentInfo;
import org.mozilla.jss.pkix.cms.EncapsulatedContentInfo;
import org.mozilla.jss.pkix.cms.IssuerAndSerialNumber;
import org.mozilla.jss.pkix.cms.SignedData;
import org.mozilla.jss.pkix.cms.SignerIdentifier;
import org.mozilla.jss.pkix.cms.SignerInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;

public class CMCRevoke {
    public static final int ARGC = 8;
    static String dValue = null;
    static String nValue = null;
    static String iValue = null;
    static String sValue = null;
    static String mValue = null;
    static String hValue = null;
    static String pValue = null;
    static String cValue = null;
    static String tValue = null;
    public static final String CMS_BASE_CA_SIGNINGCERT_NOT_FOUND = "CA signing certificate not found";
    public static final String PR_REQUEST_CMC = "CMC";

    static String cleanArgs(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 2);
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 2);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] s) {
        String mPath = ".";
        String mPrefix = "";
        boolean bWrongParam = false;
        if (s.length != 8 && s.length != 7) {
            bWrongParam = true;
            System.out.println("Wrong number of parameters:" + s.length);
            System.out.println("Usage:  CMCRevoke -d<dir to NSS database> -n<nickname> -i<issuerName> -s<serialNumber> -m<reason to revoke> -t<shared secret> -p<password to db> -h<tokenname> -c<comment> ");
            System.out.println("\nNOTE: You can alternatively use CMCRequest instead for better usability.");
            for (int i = 0; i < s.length; ++i) {
                System.out.println(i + ":" + s[i]);
            }
        } else {
            int i;
            int length = s.length;
            for (i = 0; i < length; ++i) {
                if (s[i].startsWith("-d")) {
                    dValue = CMCRevoke.cleanArgs(s[i].substring(2));
                    continue;
                }
                if (s[i].startsWith("-n")) {
                    nValue = CMCRevoke.cleanArgs(s[i].substring(2));
                    continue;
                }
                if (s[i].startsWith("-i")) {
                    iValue = CMCRevoke.cleanArgs(s[i].substring(2));
                    continue;
                }
                if (s[i].startsWith("-s")) {
                    sValue = CMCRevoke.cleanArgs(s[i].substring(2));
                    continue;
                }
                if (s[i].startsWith("-m")) {
                    mValue = CMCRevoke.cleanArgs(s[i].substring(2));
                    continue;
                }
                if (s[i].startsWith("-p")) {
                    pValue = CMCRevoke.cleanArgs(s[i].substring(2));
                    continue;
                }
                if (s[i].startsWith("-t")) {
                    tValue = CMCRevoke.cleanArgs(s[i].substring(2));
                    continue;
                }
                if (s[i].startsWith("-h")) {
                    hValue = CMCRevoke.cleanArgs(s[i].substring(2));
                    continue;
                }
                if (!s[i].startsWith("-c")) continue;
                cValue = CMCRevoke.cleanArgs(s[i].substring(2));
            }
            if (hValue == null) {
                hValue = "";
            }
            if (dValue == null || nValue == null || iValue == null || sValue == null || mValue == null || pValue == null) {
                bWrongParam = true;
            } else if (dValue.length() == 0 || nValue.length() == 0 || iValue.length() == 0 || sValue.length() == 0 || mValue.length() == 0 || pValue.length() == 0) {
                bWrongParam = true;
            }
            if (bWrongParam) {
                System.out.println("Usage:  CMCRevoke -d<dir to NSS database> -n<nickname> -i<issuerName> -s<serialNumber> -m<reason to revoke> -p<password to db> -h<tokenname> -c<comment> ");
                for (i = 0; i < s.length; ++i) {
                    System.out.println(i + ":" + s[i]);
                }
                System.exit(0);
            }
            try {
                mPath = dValue;
                System.out.println("cert/key prefix = " + mPrefix);
                System.out.println("path = " + mPath);
                InitializationValues vals = new InitializationValues(mPath, mPrefix, mPrefix, "secmod.db");
                CryptoManager.initialize((InitializationValues)vals);
                CryptoManager cm = CryptoManager.getInstance();
                CryptoToken token = CryptoUtil.getKeyStorageToken((String)hValue);
                if (CryptoUtil.isInternalToken((String)hValue)) {
                    hValue = "internal";
                }
                Password pass = new Password(pValue.toCharArray());
                try {
                    token.login((PasswordCallback)pass);
                }
                finally {
                    pass.clear();
                }
                X509Certificate signerCert = CMCRevoke.getCertificate(cm, hValue, nValue);
                ContentInfo fullEnrollmentRequest = CMCRevoke.createRevokeReq(hValue, signerCert, cm);
                CMCRevoke.printCMCRevokeRequest(fullEnrollmentRequest);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            return;
        }
    }

    static void printCMCRevokeRequest(ContentInfo fullEnrollmentReq) {
        String method = "printCMCRevokeRequest: ";
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bs);
        if (fullEnrollmentReq == null) {
            System.out.println(method + "param fullEnrollmentRequest is null");
            System.exit(1);
        }
        try {
            fullEnrollmentReq.encode((OutputStream)os);
        }
        catch (IOException e) {
            System.out.println("CMCSigning:  I/O error encountered during write():\n" + e);
            System.exit(1);
        }
        ps.print(Utils.base64encode((byte[])os.toByteArray(), (boolean)false));
        String asciiBASE64Blob = bs.toString();
        System.out.println("-----BEGIN CERTIFICATE REQUEST-----");
        System.out.println(asciiBASE64Blob + "\n-----END CERTIFICATE REQUEST-----");
        FileOutputStream outputBlob = null;
        try {
            outputBlob = new FileOutputStream("CMCRevoke.out");
            fullEnrollmentReq.encode((OutputStream)outputBlob);
        }
        catch (IOException e) {
            System.out.println("CMCSigning:  unable to open file CMCRevoke.out for writing:\n" + e);
            return;
        }
        System.out.println("\nCMC revocation binary blob written to CMCRevoke.out\n");
        try {
            outputBlob.close();
        }
        catch (IOException e) {
            System.out.println("CMCSigning:  Unexpected error encountered while attempting to close() \n" + e);
        }
    }

    public static X509Certificate getCertificate(CryptoManager manager, String tokenname, String nickname) throws NoSuchTokenException, Exception, TokenException {
        CryptoToken token = CryptoUtil.getKeyStorageToken((String)tokenname);
        StringBuffer certname = new StringBuffer();
        if (!token.equals((Object)manager.getInternalKeyStorageToken())) {
            certname.append(tokenname);
            certname.append(":");
        }
        certname.append(nickname);
        System.out.println("CMCRevoke: searching for certificate nickname:" + certname.toString());
        try {
            return manager.findCertByNickname(certname.toString());
        }
        catch (ObjectNotFoundException e) {
            throw new Exception("Signing Certificate not found");
        }
    }

    static ContentInfo createRevokeReq(String tokenname, X509Certificate signerCert, CryptoManager manager) {
        PrivateKey privKey = null;
        SignerIdentifier si = null;
        ContentInfo fullEnrollmentReq = null;
        try {
            byte[] dig;
            BigInteger serialno = signerCert.getSerialNumber();
            byte[] certB = signerCert.getEncoded();
            X509CertImpl impl = new X509CertImpl(certB);
            X500Name issuerName = impl.getIssuerName();
            byte[] issuerByte = issuerName.getEncoded();
            ByteArrayInputStream istream = new ByteArrayInputStream(issuerByte);
            Name issuer = (Name)Name.getTemplate().decode((InputStream)istream);
            IssuerAndSerialNumber ias = new IssuerAndSerialNumber(issuer, new INTEGER(serialno.toString()));
            si = new SignerIdentifier(SignerIdentifier.ISSUER_AND_SERIALNUMBER, ias, null);
            privKey = manager.findPrivKeyByCert(signerCert);
            if (privKey == null) {
                System.out.println("CMCRevoke::createRevokeReq() - privKey is null!");
                return null;
            }
            int bpid = 1;
            SEQUENCE controlSeq = new SEQUENCE();
            Date date = new Date();
            String salt = "lala123" + date.toString();
            try {
                MessageDigest SHA2Digest = MessageDigest.getInstance("SHA256");
                dig = SHA2Digest.digest(salt.getBytes());
            }
            catch (NoSuchAlgorithmException ex) {
                dig = salt.getBytes();
            }
            String sn = Utils.base64encode((byte[])dig, (boolean)true);
            TaggedAttribute senderNonce = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_senderNonce, (ASN1Value)new OCTET_STRING(sn.getBytes()));
            controlSeq.addElement((ASN1Value)senderNonce);
            Name subjectName = new Name();
            subjectName.addCommonName(iValue);
            RevokeRequest lRevokeRequest = new RevokeRequest(new ANY(new X500Name(iValue).getEncoded()), new INTEGER(sValue), new ENUMERATED(Integer.valueOf(mValue).longValue()), null, tValue != null ? new OCTET_STRING(tValue.getBytes()) : null, cValue != null ? new UTF8String(cValue.toCharArray()) : null);
            TaggedAttribute revokeRequestTag = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_revokeRequest, (ASN1Value)lRevokeRequest);
            controlSeq.addElement((ASN1Value)revokeRequestTag);
            PKIData pkidata = new PKIData(controlSeq, new SEQUENCE(), new SEQUENCE(), new SEQUENCE());
            EncapsulatedContentInfo ci = new EncapsulatedContentInfo(OBJECT_IDENTIFIER.id_cct_PKIData, (ASN1Value)pkidata);
            DigestAlgorithm digestAlg = null;
            SignatureAlgorithm signAlg = null;
            PrivateKey.Type signingKeyType = privKey.getType();
            if (signingKeyType.equals(PrivateKey.Type.RSA)) {
                signAlg = SignatureAlgorithm.RSASignatureWithSHA256Digest;
            } else if (signingKeyType.equals(PrivateKey.Type.EC)) {
                signAlg = SignatureAlgorithm.ECSignatureWithSHA256Digest;
            } else {
                System.out.println("Algorithm not supported:" + signingKeyType);
                return null;
            }
            MessageDigest SHADigest = null;
            byte[] digest = null;
            try {
                SHADigest = MessageDigest.getInstance("SHA256");
                digestAlg = DigestAlgorithm.SHA256;
                ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                pkidata.encode((OutputStream)ostream);
                digest = SHADigest.digest(ostream.toByteArray());
            }
            catch (NoSuchAlgorithmException ostream) {
                // empty catch block
            }
            SignerInfo signInfo = new SignerInfo(si, null, null, OBJECT_IDENTIFIER.id_cct_PKIData, digest, signAlg, privKey);
            SET signInfos = new SET();
            signInfos.addElement((ASN1Value)signInfo);
            SET digestAlgs = new SET();
            if (digestAlg != null) {
                AlgorithmIdentifier ai = new AlgorithmIdentifier(digestAlg.toOID(), null);
                digestAlgs.addElement((ASN1Value)ai);
            }
            X509Certificate[] agentChain = manager.buildCertificateChain(signerCert);
            SET certs = new SET();
            for (int i = 0; i < agentChain.length; ++i) {
                ANY certificate = new ANY(agentChain[i].getEncoded());
                certs.addElement((ASN1Value)certificate);
            }
            SignedData req = new SignedData(digestAlgs, ci, certs, null, signInfos);
            fullEnrollmentReq = new ContentInfo(req);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return fullEnrollmentReq;
    }
}

