/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.profile;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.netscape.certsrv.profile.PolicyConstraintValue;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.util.JSONSerializer;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class PolicyConstraint
implements JSONSerializer {
    private String name;
    private String text;
    private String classId;
    private List<PolicyConstraintValue> constraints = new ArrayList<PolicyConstraintValue>();

    public void addConstraint(PolicyConstraintValue constraint) {
        this.constraints.add(constraint);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getClassId() {
        return this.classId;
    }

    public void setClassId(String classId) {
        this.classId = classId;
    }

    public List<PolicyConstraintValue> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<PolicyConstraintValue> constraints) {
        this.constraints = constraints;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classId == null ? 0 : this.classId.hashCode());
        result = 31 * result + (this.constraints == null ? 0 : this.constraints.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PolicyConstraint other = (PolicyConstraint)obj;
        if (this.classId == null ? other.classId != null : !this.classId.equals(other.classId)) {
            return false;
        }
        if (this.constraints == null ? other.constraints != null : !this.constraints.equals(other.constraints)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public Element toDOM(Document document) {
        Element pcvElement = document.createElement("policyConstraint");
        pcvElement.setAttribute("id", this.name);
        if (this.text != null) {
            Element descriptionElement = document.createElement("description");
            descriptionElement.appendChild(document.createTextNode(this.text));
            pcvElement.appendChild(descriptionElement);
        }
        if (this.classId != null) {
            Element classIdElement = document.createElement("classId");
            classIdElement.appendChild(document.createTextNode(this.classId));
            pcvElement.appendChild(classIdElement);
        }
        if (this.constraints != null) {
            for (PolicyConstraintValue pcv : this.constraints) {
                Descriptor descriptor;
                Element constraintElement = document.createElement("constraint");
                if (pcv.getName() != null) {
                    constraintElement.setAttribute("id", pcv.getName());
                }
                if (pcv.getValue() != null) {
                    Element valueElement = document.createElement("value");
                    valueElement.appendChild(document.createTextNode(pcv.getValue()));
                    constraintElement.appendChild(valueElement);
                }
                if ((descriptor = pcv.getDescriptor()) != null) {
                    Element descriptorElement = document.createElement("descriptor");
                    descriptor.toDOM(document, descriptorElement);
                    constraintElement.appendChild(descriptorElement);
                }
                pcvElement.appendChild(constraintElement);
            }
        }
        return pcvElement;
    }

    public static PolicyConstraint fromDOM(Element pcElement) throws DOMException, Exception {
        NodeList classIdList;
        PolicyConstraint pc = new PolicyConstraint();
        String id = pcElement.getAttribute("id");
        pc.setName(id);
        NodeList descriptionList = pcElement.getElementsByTagName("description");
        if (descriptionList.getLength() > 0) {
            String text = descriptionList.item(0).getTextContent();
            pc.setText(text);
        }
        if ((classIdList = pcElement.getElementsByTagName("classId")).getLength() > 0) {
            String classId = classIdList.item(0).getTextContent();
            pc.setClassId(classId);
        }
        NodeList constraintList = pcElement.getElementsByTagName("constraint");
        int constraintCount = constraintList.getLength();
        for (int i = 0; i < constraintCount; ++i) {
            NodeList descriptorList;
            Element constraintElement = (Element)constraintList.item(i);
            PolicyConstraintValue pcv = new PolicyConstraintValue();
            String pcvId = constraintElement.getAttribute("id");
            pcv.setName(pcvId);
            NodeList valueList = constraintElement.getElementsByTagName("value");
            if (valueList.getLength() > 0) {
                String value = valueList.item(0).getTextContent();
                pcv.setValue(value);
            }
            if ((descriptorList = constraintElement.getElementsByTagName("descriptor")).getLength() > 0) {
                Element descriptorElement = (Element)descriptorList.item(0);
                Descriptor descriptor = Descriptor.fromDOM(descriptorElement);
                pcv.setDescriptor(descriptor);
            }
            pc.addConstraint(pcv);
        }
        return pc;
    }

    public String toXML() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element accountElement = this.toDOM(document);
        document.appendChild(accountElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource domSource = new DOMSource(document);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        transformer.transform(domSource, streamResult);
        return sw.toString();
    }

    public static PolicyConstraint fromXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element accountElement = document.getDocumentElement();
        return PolicyConstraint.fromDOM(accountElement);
    }
}

