/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldap;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.request.Request;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapRenewalListener
extends RequestListener {
    public static Logger logger = LoggerFactory.getLogger(LdapRenewalListener.class);
    private CAPublisherProcessor processor;

    public LdapRenewalListener(CAPublisherProcessor processor) {
        this.processor = processor;
    }

    public void init(Subsystem sys, ConfigStore config) throws EBaseException {
    }

    public void set(String name, String val) {
    }

    public void accept(Request r) {
        logger.info("LdapRenewalListener: Handling renewal request " + r.getRequestId());
        X509CertImpl[] certs = r.getExtDataInCertArray("issuedCerts");
        if (certs == null || certs.length == 0) {
            logger.warn("LdapRenewalListener: No certs to publish for renewal request " + r.getRequestId());
            return;
        }
        this.acceptX509(r, (Certificate[])certs);
    }

    public void acceptX509(Request r, Certificate[] certs) {
        Integer[] results = new Integer[certs.length];
        Integer status = Request.RES_SUCCESS;
        for (int i = 0; i < certs.length; ++i) {
            X509CertImpl cert = (X509CertImpl)certs[i];
            if (cert == null) continue;
            try {
                this.processor.publishCert((X509Certificate)cert, r);
                results[i] = Request.RES_SUCCESS;
                logger.info("LdapRenewalListener: Published cert 0x" + cert.getSerialNumber().toString(16));
                continue;
            }
            catch (ELdapException e) {
                logger.warn(CMS.getLogMessage((String)"CMSCORE_LDAP_CERT_NOT_PUBLISH", (Object[])new Object[]{cert.getSerialNumber().toString(16), e.toString()}), (Throwable)e);
                results[i] = Request.RES_ERROR;
                status = Request.RES_ERROR;
            }
        }
        r.setExtData("ldapPublishStatus", results);
        r.setExtData("ldapPublishOverAllStatus", status);
    }
}

