/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.property.IConfigTemplate;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.constraint.PolicyConstraint;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.servlet.admin.AdminServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.registry.PluginInfo;
import com.netscape.cmscore.registry.PluginRegistry;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.ca.CAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caregistry", urlPatterns={"/registry"}, initParams={@WebInitParam(name="ID", value="caregistry"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca")})
public class RegistryAdminServlet
extends AdminServlet {
    public static Logger logger = LoggerFactory.getLogger(RegistryAdminServlet.class);
    private static final long serialVersionUID = 2104924641665675578L;
    public static final String PROP_AUTHORITY = "authority";
    private static final String INFO = "RegistryAdminServlet";
    public static final String PROP_PREDICATE = "predicate";
    private PluginRegistry registry;
    public static String INVALID_POLICY_SCOPE = "Invalid policy administration scope";
    public static String INVALID_POLICY_IMPL_OP = "Invalid operation for policy implementation management";
    public static String NYI = "Not Yet Implemented";
    public static String INVALID_POLICY_IMPL_CONFIG = "Invalid policy implementation configuration";
    public static String INVALID_POLICY_INSTANCE_CONFIG = "Invalid policy instance configuration";
    public static String MISSING_POLICY_IMPL_ID = "Missing policy impl id in request";
    public static String MISSING_POLICY_IMPL_CLASS = "Missing policy impl class in request";
    public static String INVALID_POLICY_IMPL_ID = "Invalid policy impl id in request";
    public static String MISSING_POLICY_INST_ID = "Missing policy impl id in request";
    public static String INVALID_POLICY_INST_ID = "Invalid policy impl id in request";
    public static String COMMA = ",";
    public static String MISSING_POLICY_ORDERING = "Missing policy ordering";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        CAEngine engine = CAEngine.getInstance();
        this.registry = engine.getPluginRegistry();
    }

    public String getServletInfo() {
        return INFO;
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
        super.authenticate(req);
        AUTHZ_RES_NAME = "certServer.registry.configuration";
        String scope = req.getParameter("OP_SCOPE");
        String op = req.getParameter("OP_TYPE");
        if (scope.equals("supportedConstraintPolicies")) {
            if (op.equals("OP_READ") && !this.readAuthorize(req, resp)) {
                return;
            }
            this.getSupportedConstraintPolicies(req, resp);
        } else {
            this.processImplMgmt(req, resp);
        }
    }

    private boolean readAuthorize(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.mOp = "read";
        this.mToken = super.authorize(req);
        if (this.mToken == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
            return false;
        }
        return true;
    }

    private boolean modifyAuthorize(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.mOp = "modify";
        this.mToken = super.authorize(req);
        if (this.mToken == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
            return false;
        }
        return true;
    }

    public void processImplMgmt(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String op = req.getParameter("OP_TYPE");
        if (op.equals("OP_SEARCH")) {
            if (!this.readAuthorize(req, resp)) {
                return;
            }
            this.listImpls(req, resp);
        } else if (op.equals("OP_READ")) {
            if (!this.readAuthorize(req, resp)) {
                return;
            }
            this.getProfileImplConfig(req, resp);
        } else if (op.equals("OP_DELETE")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.deleteImpl(req, resp);
        } else if (op.equals("OP_ADD")) {
            if (!this.modifyAuthorize(req, resp)) {
                return;
            }
            this.addImpl(req, resp);
        } else {
            this.sendResponse(ERROR, INVALID_POLICY_IMPL_OP, null, resp);
        }
    }

    public void addImpl(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("RS_ID");
        String scope = req.getParameter("OP_SCOPE");
        String classPath = req.getParameter("class");
        String desc = req.getParameter("desc");
        if (id == null) {
            this.sendResponse(ERROR, MISSING_POLICY_IMPL_ID, null, resp);
            return;
        }
        NameValuePairs nvp = new NameValuePairs();
        PluginInfo info = new PluginInfo(id, desc, classPath);
        try {
            this.registry.addPluginInfo(scope, id, info);
        }
        catch (Exception e) {
            logger.warn("RegistryAdminServlet: " + e.getMessage(), (Throwable)e);
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void deleteImpl(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("RS_ID");
        String scope = req.getParameter("OP_SCOPE");
        if (id == null) {
            this.sendResponse(ERROR, MISSING_POLICY_IMPL_ID, null, resp);
            return;
        }
        PluginInfo info = this.registry.getPluginInfo(scope, id);
        if (info == null) {
            this.sendResponse(ERROR, MISSING_POLICY_IMPL_ID, null, resp);
            return;
        }
        NameValuePairs nvp = new NameValuePairs();
        try {
            this.registry.removePluginInfo(scope, id);
        }
        catch (Exception e) {
            logger.warn("RegistryAdminServlet: " + e.getMessage(), (Throwable)e);
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void listImpls(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String scope = req.getParameter("OP_SCOPE");
        Enumeration impls = this.registry.getIds(scope);
        NameValuePairs nvp = new NameValuePairs();
        while (impls.hasMoreElements()) {
            String id = (String)impls.nextElement();
            PluginInfo info = this.registry.getPluginInfo(scope, id);
            nvp.put((Object)id, (Object)(info.getClassName() + "," + info.getDescription(this.getLocale(req)) + "," + info.getName(this.getLocale(req))));
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void getSupportedConstraintPolicies(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, MISSING_POLICY_IMPL_ID, null, resp);
            return;
        }
        NameValuePairs nvp = new NameValuePairs();
        try {
            PluginInfo info = this.registry.getPluginInfo("defaultPolicy", id);
            String className = info.getClassName();
            PolicyDefault policyDefaultClass = (PolicyDefault)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (policyDefaultClass != null) {
                Enumeration impls = this.registry.getIds("constraintPolicy");
                while (impls.hasMoreElements()) {
                    String constraintID = (String)impls.nextElement();
                    PluginInfo constraintInfo = this.registry.getPluginInfo("constraintPolicy", constraintID);
                    PolicyConstraint policyConstraintClass = (PolicyConstraint)Class.forName(constraintInfo.getClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    logger.debug("RegistryAdminServlet: getSUpportedConstraint " + constraintInfo.getClassName());
                    if (!policyConstraintClass.isApplicable(policyDefaultClass)) continue;
                    logger.debug("RegistryAdminServlet: getSUpportedConstraint isApplicable " + constraintInfo.getClassName());
                    nvp.put((Object)constraintID, (Object)(constraintInfo.getClassName() + "," + constraintInfo.getDescription(this.getLocale(req)) + "," + constraintInfo.getName(this.getLocale(req))));
                }
            }
        }
        catch (Exception ex) {
            logger.warn("RegistryAdminServlet: getSupportConstraintPolicies: " + ex.getMessage(), (Throwable)ex);
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    public void getProfileImplConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Enumeration names;
        String id = req.getParameter("RS_ID");
        String scope = req.getParameter("OP_SCOPE");
        if (id == null) {
            this.sendResponse(ERROR, MISSING_POLICY_IMPL_ID, null, resp);
            return;
        }
        PluginInfo info = this.registry.getPluginInfo(scope, id);
        if (info == null) {
            this.sendResponse(ERROR, MISSING_POLICY_IMPL_ID, null, resp);
            return;
        }
        NameValuePairs nvp = new NameValuePairs();
        String className = info.getClassName();
        IConfigTemplate template = null;
        try {
            template = (IConfigTemplate)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (template != null && (names = template.getConfigNames()) != null) {
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                logger.debug("RegistryAdminServlet: getProfileImpl descriptor " + name);
                IDescriptor desc = template.getConfigDescriptor(this.getLocale(req), name);
                if (desc != null) {
                    try {
                        String value = this.getNonNull(desc.getSyntax()) + ";" + this.getNonNull(desc.getConstraint()) + ";" + desc.getDescription(this.getLocale(req)) + ";" + this.getNonNull(desc.getDefaultValue());
                        logger.debug("RegistryAdminServlet: getProfileImpl " + value);
                        nvp.put((Object)name, (Object)value);
                    }
                    catch (Exception e) {
                        logger.warn("RegistryAdminServlet: getProfileImpl skipped descriptor for " + name + ": " + e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                logger.warn("RegistryAdminServlet: getProfileImpl cannot find descriptor for " + name);
            }
        }
        this.sendResponse(SUCCESS, null, nvp, resp);
    }

    protected String getNonNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

