/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.mappers;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.ELdapServerDownException;
import com.netscape.certsrv.publish.Mapper;
import com.netscape.cms.publish.mappers.AVAPattern;
import com.netscape.cms.publish.mappers.MapDNPattern;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapEnhancedMap
extends Mapper
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(LdapEnhancedMap.class);
    private boolean mInited = false;
    protected MapDNPattern mPattern = null;
    protected String[] mReqAttrs = null;
    protected String[] mCertAttrs = null;
    protected String[] mLdapValues = null;
    protected static final String PROP_DNPATTERN = "dnPattern";
    protected static final String PROP_CREATE = "createEntry";
    protected static final String PROP_OBJCLASS = "objectClass";
    protected static final String PROP_ATTRNUM = "attrNum";
    protected static final String PROP_ATTR_NAME = "attrName";
    protected static final String PROP_ATTR_PATTERN = "attrPattern";
    private static final int DEFAULT_NUM_ATTRS = 1;
    private static Vector<String> defaultParams = new Vector();
    protected String mDnPattern = null;
    protected boolean mCreateEntry = true;
    private int mNumAttrs = 1;
    protected String[] mLdapNames = null;
    protected String[] mLdapPatterns = null;
    public static final String DEFAULT_DNPATTERN = "UID=$req.HTTP_PARAMS.UID, OU=people, O=$subj.o, C=$subj.c";
    private static final int MAX_ATTRS = 10;
    protected static final int DEFAULT_ATTRNUM = 1;
    protected ConfigStore mConfig;
    protected AVAPattern[] mPatterns = null;

    protected void init(String dnPattern) throws EBaseException {
        if (this.mInited) {
            return;
        }
        this.mDnPattern = dnPattern;
        if (this.mDnPattern == null || this.mDnPattern.length() == 0) {
            this.mDnPattern = DEFAULT_DNPATTERN;
        }
        try {
            this.mPattern = new MapDNPattern(this.mDnPattern);
        }
        catch (ELdapException e) {
            logger.error(CMS.getLogMessage((String)"PUBLISH_DN_PATTERN_INIT", (Object[])new Object[]{dnPattern, e.toString()}), (Throwable)e);
            throw new EBaseException("Unable to init with pattern " + dnPattern + ": " + e.getMessage(), (Throwable)e);
        }
        this.mInited = true;
    }

    private String formDN(Request req, Object obj) throws EBaseException {
        CertificateExtensions certExt = null;
        X500Name subjectDN = null;
        try {
            X509Certificate cert = (X509Certificate)obj;
            subjectDN = (X500Name)cert.getSubjectDN();
            logger.debug("LdapEnhancedMap: cert subject dn:" + subjectDN);
            X509CertInfo info = (X509CertInfo)((X509CertImpl)cert).get("x509.info");
            certExt = (CertificateExtensions)info.get("extensions");
        }
        catch (CertificateParsingException e) {
            logger.warn(CMS.getLogMessage((String)"PUBLISH_CANT_GET_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"PUBLISH_CANT_GET_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (CertificateException e) {
            logger.warn(CMS.getLogMessage((String)"PUBLISH_CANT_GET_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (ClassCastException e) {
            try {
                X509CRLImpl crl = (X509CRLImpl)obj;
                subjectDN = (X500Name)crl.getIssuerDN();
                logger.warn("LdapEnhancedMap: crl issuer dn: " + subjectDN + ": " + e.getMessage(), (Throwable)e);
            }
            catch (ClassCastException ex) {
                logger.warn(CMS.getLogMessage((String)"PUBLISH_PUBLISH_OBJ_NOT_SUPPORTED", (Object[])new Object[]{req == null ? "" : req.getRequestId().toString()}), (Throwable)ex);
                return null;
            }
        }
        try {
            this.mLdapValues = new String[this.mNumAttrs];
            for (int i = 0; i < this.mNumAttrs; ++i) {
                if (this.mPatterns[i] == null) continue;
                this.mLdapValues[i] = this.mPatterns[i].formAVA(req, subjectDN, certExt);
            }
            String dn = this.mPattern.formDN(req, subjectDN, certExt);
            return dn;
        }
        catch (ELdapException e) {
            logger.error(CMS.getLogMessage((String)"PUBLISH_CANT_FORM_DN", (Object[])new Object[]{req == null ? "" : req.getRequestId().toString(), e.toString()}), (Throwable)e);
            throw new EBaseException("failed to form dn for request: " + (req == null ? "" : req.getRequestId().toString()) + " " + e, (Throwable)e);
        }
    }

    private void createEntry(LDAPConnection conn, String dn) throws LDAPException {
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        String[] caOc = new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"};
        DN dnobj = new DN(dn);
        String[] attrval = dnobj.explodeDN(true);
        attrs.add(new LDAPAttribute("cn", attrval[0]));
        attrs.add(new LDAPAttribute("sn", attrval[0]));
        attrs.add(new LDAPAttribute("objectclass", caOc));
        for (int i = 0; i < this.mNumAttrs; ++i) {
            if (this.mLdapNames[i] == null || this.mLdapNames[i].trim().equals("") || this.mLdapValues[i] == null || this.mLdapValues[i].trim().equals("")) continue;
            attrs.add(new LDAPAttribute(this.mLdapNames[i], this.mLdapValues[i]));
        }
        LDAPEntry entry = new LDAPEntry(dn, attrs);
        conn.add(entry);
    }

    public void init(ConfigStore config) throws EBaseException {
        this.mConfig = config;
        this.mDnPattern = this.mConfig.getString(PROP_DNPATTERN, DEFAULT_DNPATTERN);
        this.mCreateEntry = this.mConfig.getBoolean(PROP_CREATE, true);
        this.mNumAttrs = this.mConfig.getInteger(PROP_ATTRNUM, 0);
        this.mLdapNames = new String[this.mNumAttrs];
        this.mLdapPatterns = new String[this.mNumAttrs];
        this.mPatterns = new AVAPattern[this.mNumAttrs];
        for (int i = 0; i < this.mNumAttrs; ++i) {
            this.mLdapNames[i] = this.mConfig.getString(PROP_ATTR_NAME + Integer.toString(i), "");
            this.mLdapPatterns[i] = this.mConfig.getString(PROP_ATTR_PATTERN + Integer.toString(i), "");
            if (this.mLdapPatterns[i] == null || this.mLdapPatterns[i].trim().equals("")) continue;
            this.mPatterns[i] = new AVAPattern(this.mLdapPatterns[i]);
        }
        this.init(this.mDnPattern);
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public String getImplName() {
        return "LdapEnhancedMap";
    }

    public String getDescription() {
        return "LdapEnhancedMap";
    }

    public Vector<String> getDefaultParams() {
        return defaultParams;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> v = new Vector<String>();
        try {
            if (this.mDnPattern == null) {
                v.addElement("dnPattern=");
            } else {
                v.addElement("dnPattern=" + this.mConfig.getString(PROP_DNPATTERN));
            }
            v.addElement("createEntry=" + this.mConfig.getBoolean(PROP_CREATE, true));
            v.addElement("attrNum=" + this.mConfig.getInteger(PROP_ATTRNUM, 1));
            for (int i = 0; i < this.mNumAttrs; ++i) {
                if (this.mLdapNames[i] != null) {
                    v.addElement(PROP_ATTR_NAME + i + "=" + this.mLdapNames[i]);
                } else {
                    v.addElement(PROP_ATTR_NAME + i + "=");
                }
                if (this.mLdapPatterns[i] != null) {
                    v.addElement(PROP_ATTR_PATTERN + i + "=" + this.mLdapPatterns[i]);
                    continue;
                }
                v.addElement(PROP_ATTR_PATTERN + i + "=");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public String map(LDAPConnection conn, Object obj) throws ELdapException {
        return this.map(conn, null, obj);
    }

    public String map(LDAPConnection conn, Request req, Object obj) throws ELdapException {
        if (conn == null) {
            return null;
        }
        String dn = null;
        try {
            dn = this.formDN(req, obj);
            if (dn == null) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_DN_NOT_FORMED", (Object[])new Object[0]));
                String s1 = "";
                if (req != null) {
                    s1 = req.getRequestId().toString();
                }
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_DN_MATCH", (String[])new String[]{s1}));
            }
            int scope = 0;
            String filter = "(objectclass=*)";
            String[] attrs = new String[]{"1.1"};
            logger.info("LdapEnhancedMap: searching for dn: " + dn + " filter:" + filter + " scope: base");
            LDAPSearchResults results = conn.search(dn, scope, filter, attrs, false);
            LDAPEntry entry = results.next();
            if (results.hasMoreElements()) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_MORE_THAN_ONE_ENTRY", (Object[])new Object[]{dn + (req == null ? "" : req.getRequestId().toString())}));
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_MORE_THAN_ONE_ENTRY", (String[])new String[]{req == null ? "" : req.getRequestId().toString()}));
            }
            if (entry == null) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_ENTRY_NOT_FOUND", (Object[])new Object[]{dn + (req == null ? "" : req.getRequestId().toString())}));
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_MATCH_FOUND", (String[])new String[]{"null entry"}));
            }
            return entry.getDN();
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_NO_LDAP_SERVER", (Object[])new Object[0]), (Throwable)e);
                throw new ELdapServerDownException(CMS.getUserMessage((String)"CMS_LDAP_SERVER_UNAVAILABLE", (String[])new String[]{conn.getHost(), "" + conn.getPort()}));
            }
            if (e.getLDAPResultCode() == 32 && this.mCreateEntry) {
                try {
                    this.createEntry(conn, dn);
                    logger.info("Entry " + dn + " Created");
                    return dn;
                }
                catch (LDAPException e1) {
                    logger.error(CMS.getLogMessage((String)"PUBLISH_DN_MAP_EXCEPTION", (Object[])new Object[]{dn, e.toString()}), (Throwable)e);
                    logger.error("LdapEnhancedMap: Entry is not created. This may because there are entries in the directory hierachy not exit.");
                    throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_CREATE_ENTRY", (String[])new String[]{dn}), (Throwable)e1);
                }
            }
            logger.error(CMS.getLogMessage((String)"PUBLISH_DN_MAP_EXCEPTION", (Object[])new Object[]{dn, e.toString()}));
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_MATCH_FOUND", (String[])new String[]{e.toString()}));
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage((String)"PUBLISH_EXCEPTION_CAUGHT", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_MATCH_FOUND", (String[])new String[]{e.toString()}));
        }
    }

    public String[] getExtendedPluginInfo() {
        Vector<Object> v = new Vector<Object>();
        v.addElement("dnPattern;string;Describes how to form the Ldap Subject name in the directory.  Example 1:  'uid=CertMgr, o=Fedora'.  Example 2:  'uid=$req.HTTP_PARAMS.uid, E=$ext.SubjectAlternativeName.RFC822Name, ou=$subj.ou'. $req means: take the attribute from the request. $subj means: take the attribute from the certificate subject name. $ext means: take the attribute from the certificate extension");
        v.addElement("createEntry;boolean;If checked, An entry will be created automatically");
        v.addElement("attrNum;string;How many attributes to add.");
        v.addElement("HELP_TOKEN;configuration-ldappublish-mapper-enhancedmapper");
        v.addElement("HELP_TEXT;Describes how to form the LDAP DN of the entry to publish to");
        for (int i = 0; i < 10; ++i) {
            v.addElement(PROP_ATTR_NAME + Integer.toString(i) + ";string;The name of LDAP attribute to be added. e.g. mail");
            v.addElement(PROP_ATTR_PATTERN + Integer.toString(i) + ";string;How to create the LDAP attribute value. e.g. $req.HTTP_PARAMS.csrRequestorEmail, $subj.E or $ext.SubjectAlternativeName.RFC822Name");
        }
        String[] params = Utils.getStringArrayFromVector(v);
        return params;
    }

    static {
        defaultParams.addElement("dnPattern=");
        defaultParams.addElement("createEntry=true");
        defaultParams.addElement("attrNum=1");
        for (int i = 0; i < 1; ++i) {
            defaultParams.addElement(PROP_ATTR_NAME + i + "=");
            defaultParams.addElement(PROP_ATTR_PATTERN + i + "=");
        }
    }
}

