/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.PrivateKeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateKeyUsagePeriodExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(PrivateKeyUsagePeriodExtDefault.class);
    public static final String CONFIG_CRITICAL = "puCritical";
    public static final String CONFIG_START_TIME = "puStartTime";
    public static final String CONFIG_DURATION = "puDurationInDays";
    public static final String VAL_CRITICAL = "puCritical";
    public static final String VAL_NOT_BEFORE = "puNotBefore";
    public static final String VAL_NOT_AFTER = "puNotAfter";
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private long mDefault = 86400000L;

    public PrivateKeyUsagePeriodExtDefault() {
        this.addValueName("puCritical");
        this.addValueName(VAL_NOT_BEFORE);
        this.addValueName(VAL_NOT_AFTER);
        this.addConfigName("puCritical");
        this.addConfigName(CONFIG_START_TIME);
        this.addConfigName(CONFIG_DURATION);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("puCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(CONFIG_START_TIME)) {
            return new Descriptor("string", null, "0", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_VALIDITY_START_TIME", (String[])new String[0]));
        }
        if (name.equals(CONFIG_DURATION)) {
            return new Descriptor("string", null, "365", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_VALIDITY_RANGE", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        if (name.equals(CONFIG_START_TIME)) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_START_TIME}));
            }
        }
        if (name.equals(CONFIG_DURATION)) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_DURATION}));
            }
        }
        super.setConfig(name, value);
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("puCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(VAL_NOT_BEFORE)) {
            return new Descriptor("string", null, "0", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_BEFORE", (String[])new String[0]));
        }
        if (name.equals(VAL_NOT_AFTER)) {
            return new Descriptor("string", null, "30", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_AFTER", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        try {
            PrivateKeyUsageExtension ext = null;
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            ObjectIdentifier oid = PKIXExtensions.PrivateKeyUsage_Id;
            ext = (PrivateKeyUsageExtension)this.getExtension(oid.toString(), info);
            if (ext == null) {
                this.populate(null, info);
            }
            if (name.equals("puCritical")) {
                ext = (PrivateKeyUsageExtension)this.getExtension(oid.toString(), info);
                boolean val = Boolean.valueOf(value);
                if (ext == null) {
                    return;
                }
                ext.setCritical(val);
            } else if (name.equals(VAL_NOT_BEFORE)) {
                SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
                ParsePosition pos = new ParsePosition(0);
                Date date = formatter.parse(value, pos);
                ext = (PrivateKeyUsageExtension)this.getExtension(oid.toString(), info);
                if (ext == null) {
                    return;
                }
                ext.set("not_before", (Object)date);
            } else if (name.equals(VAL_NOT_AFTER)) {
                SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
                ParsePosition pos = new ParsePosition(0);
                Date date = formatter.parse(value, pos);
                ext = (PrivateKeyUsageExtension)this.getExtension(oid.toString(), info);
                if (ext == null) {
                    return;
                }
                ext.set("not_after", (Object)date);
            } else {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            this.replaceExtension(ext.getExtensionId().toString(), (Extension)ext, info);
        }
        catch (EProfileException e) {
            logger.warn("PrivateKeyUsageExtension: setValue " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("PrivateKeyUsageExtension: setValue " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        PrivateKeyUsageExtension ext = null;
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        ObjectIdentifier oid = PKIXExtensions.PrivateKeyUsage_Id;
        ext = (PrivateKeyUsageExtension)this.getExtension(oid.toString(), info);
        if (ext == null) {
            try {
                this.populate(null, info);
            }
            catch (EProfileException e) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals("puCritical")) {
            ext = (PrivateKeyUsageExtension)this.getExtension(oid.toString(), info);
            if (ext == null) {
                return null;
            }
            return ext.isCritical() ? "true" : "false";
        }
        if (name.equals(VAL_NOT_BEFORE)) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            ext = (PrivateKeyUsageExtension)this.getExtension(oid.toString(), info);
            if (ext == null) {
                return "";
            }
            return formatter.format(ext.getNotBefore());
        }
        if (name.equals(VAL_NOT_AFTER)) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            ext = (PrivateKeyUsageExtension)this.getExtension(oid.toString(), info);
            if (ext == null) {
                return "";
            }
            return formatter.format(ext.getNotAfter());
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig("puCritical"), this.getConfig(CONFIG_START_TIME), this.getConfig(CONFIG_DURATION)};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_PRIVATE_KEY_EXT", (String[])params);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        PrivateKeyUsageExtension ext = this.createExtension();
        this.addExtension(ext.getExtensionId().toString(), (Extension)ext, info);
    }

    public PrivateKeyUsageExtension createExtension() {
        PrivateKeyUsageExtension ext = null;
        try {
            boolean critical = this.getConfigBoolean("puCritical");
            String startTimeStr = this.getConfig(CONFIG_START_TIME);
            if (startTimeStr == null || startTimeStr.equals("")) {
                startTimeStr = "60";
            }
            long startTime = Long.parseLong(startTimeStr);
            Date notBefore = new Date(new Date().getTime() + 1000L * startTime);
            long notAfterVal = 0L;
            notAfterVal = notBefore.getTime() + this.mDefault * Long.parseLong(this.getConfig(CONFIG_DURATION));
            Date notAfter = new Date(notAfterVal);
            ext = new PrivateKeyUsageExtension(notBefore, notAfter);
            ext.setCritical(critical);
        }
        catch (Exception e) {
            logger.warn("PrivateKeyUsagePeriodExt: createExtension " + e.getMessage(), (Throwable)e);
        }
        return ext;
    }
}

