/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.jobs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.notification.ENotificationException;
import com.netscape.certsrv.notification.EmailResolver;
import com.netscape.cms.jobs.CertRecProcessor;
import com.netscape.cms.jobs.ItemCounter;
import com.netscape.cms.jobs.Job;
import com.netscape.cms.notification.MailNotification;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.jobs.JobConfig;
import com.netscape.cmscore.jobs.JobsScheduler;
import com.netscape.cmscore.notification.EmailFormProcessor;
import com.netscape.cmscore.notification.EmailResolverKeys;
import com.netscape.cmscore.notification.ReqCertSANameEmailResolver;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

public class RenewalNotificationJob
extends Job
implements IExtendedPluginInfo {
    public static final String PROP_CRON = "cron";
    public static final String PROP_PROFILE_ID = "profileId";
    public static final String PROP_NOTIFYTRIGGEROFFSET = "notifyTriggerOffset";
    public static final String PROP_NOTIFYENDOFFSET = "notifyEndOffset";
    public static final String PROP_SENDEREMAIL = "senderEmail";
    public static final String PROP_EMAILSUBJECT = "emailSubject";
    public static final String PROP_EMAILTEMPLATE = "emailTemplate";
    public static final String PROP_MAXNOTIFYCOUNT = "maxNotifyCount";
    public static final String PROP_SUMMARY_SENDEREMAIL = "summary.senderEmail";
    public static final String PROP_SUMMARY_RECIPIENTEMAIL = "summary.recipientEmail";
    public static final String PROP_SUMMARY_SUBJECT = "summary.emailSubject";
    public static final String PROP_SUMMARY_TEMPLATE = "summary.emailTemplate";
    public static final String PROP_SUMMARY_ITEMTEMPLATE = "summary.itemTemplate";
    protected static String[] mConfigParams = new String[]{"enabled", "cron", "profileId", "notifyTriggerOffset", "notifyEndOffset", "senderEmail", "emailSubject", "emailTemplate", "summary.enabled", "summary.recipientEmail", "summary.senderEmail", "summary.emailSubject", "summary.itemTemplate", "summary.emailTemplate"};
    protected CertificateRepository mCertDB;
    protected boolean mSummary = false;
    protected String mEmailSender = null;
    protected String mEmailSubject = null;
    protected String mEmailTemplateName = null;
    protected String mSummaryItemTemplateName = null;
    protected String mSummaryTemplateName = null;
    protected boolean mSummaryHTML = false;
    protected boolean mHTML = false;
    protected String mHttpHost = null;
    protected String mHttpPort = null;
    private int mPreDays = 0;
    private long mPreMS = 0L;
    private int mPostDays = 0;
    private long mPostMS = 0L;
    private String[] mProfileId = null;

    public String[] getExtendedPluginInfo() {
        String[] s = new String[]{"HELP_TEXT; A job that checks for expiring or expired certsnotifyTriggerOffset before and notifyEndOffset after the expiration date", "profileId;string;Specify the ID of the profile which approved the certificates that are about to expire. For multiple profiles, each entry is separated by white space. For example, if the administrator just wants to give automated notification when the SSL server certificates are about to expire, then he should enter \"caServerCert caAgentServerCert\" in the profileId textfield. Blank field means all profiles.", "notifyTriggerOffset;number,required;How long (in days) before certificate expiration will the first notification be sent", "notifyEndOffset;number,required;How long (in days) after certificate expiration will notifications continue to be resent if certificate is not renewed", "cron;string,required;Format: minute hour dayOfMonth Mmonth dayOfWeek. Use '*' for 'every'. For dayOfWeek, 0 is Sunday", "senderEmail;string,required;Specify the address to be used as the email's 'sender'. Bounces go to this address.", "emailSubject;string,required;Email subject", "emailTemplate;string,required;Fully qualified pathname of template file of email to be sent", "enabled;boolean;Enable this plugin", "summary.enabled;boolean;Enabled sending of summaries", "summary.senderEmail;string,required;Sender email address of summary", "summary.recipientEmail;string,required;Who should receive summaries", "summary.emailSubject;string,required;Subject of summary email", "summary.emailTemplate;string,required;Fully qualified pathname of template file of email to be sent", "summary.itemTemplate;string,required;Fully qualified pathname of file with template to be used for each summary item", "HELP_TOKEN;configuration-jobrules-renewalnotification"};
        return s;
    }

    public void init(JobsScheduler scheduler, String id, String implName, JobConfig config) throws EBaseException {
        super.init(scheduler, id, implName, config);
        CAEngine caEngine = (CAEngine)this.engine;
        this.mCertDB = caEngine.getCertificateRepository();
    }

    public void run() {
        block22: {
            CAEngine caEngine = (CAEngine)this.engine;
            CAEngineConfig cs = caEngine.getConfig();
            try {
                this.mHttpHost = cs.getHostname();
                this.mHttpPort = caEngine.getEESSLPort();
                this.mPreDays = this.mConfig.getInteger(PROP_NOTIFYTRIGGEROFFSET, 30);
                this.mPostDays = this.mConfig.getInteger(PROP_NOTIFYENDOFFSET, 15);
                this.mEmailSender = this.mConfig.getString(PROP_SENDEREMAIL);
                this.mEmailSubject = this.mConfig.getString(PROP_EMAILSUBJECT);
                this.mEmailTemplateName = this.mConfig.getString(PROP_EMAILTEMPLATE);
                ConfigStore sc = this.mConfig.getSubStore("summary", ConfigStore.class);
                if (sc.getBoolean("enabled", false)) {
                    this.mSummary = true;
                    this.mSummaryItemTemplateName = this.mConfig.getString(PROP_SUMMARY_ITEMTEMPLATE);
                    this.mSummarySenderEmail = this.mConfig.getString(PROP_SUMMARY_SENDEREMAIL);
                    this.mSummaryReceiverEmail = this.mConfig.getString(PROP_SUMMARY_RECIPIENTEMAIL);
                    this.mSummaryMailSubject = this.mConfig.getString(PROP_SUMMARY_SUBJECT);
                    this.mSummaryTemplateName = this.mConfig.getString(PROP_SUMMARY_TEMPLATE);
                } else {
                    this.mSummary = false;
                }
                long msperday = 86400000L;
                long mspredays = this.mPreDays;
                long mspostdays = this.mPostDays;
                this.mPreMS = mspredays * msperday;
                this.mPostMS = mspostdays * msperday;
                Date now = new Date();
                DateFormat dateFormat = DateFormat.getDateTimeInstance();
                String nowString = dateFormat.format(now);
                Date expiryDate = null;
                Date stopDate = null;
                long expiryMS = now.getTime() + this.mPreMS;
                long stopMS = now.getTime() - this.mPostMS;
                expiryDate = new Date(expiryMS);
                stopDate = new Date(stopMS);
                StringBuffer f = new StringBuffer();
                String profileId = "";
                try {
                    profileId = this.mConfig.getString(PROP_PROFILE_ID, "");
                }
                catch (EBaseException eBaseException) {
                    // empty catch block
                }
                if (profileId != null && profileId.length() > 0) {
                    StringTokenizer tokenizer = new StringTokenizer(profileId);
                    int num = tokenizer.countTokens();
                    this.mProfileId = new String[num];
                    for (int i = 0; i < num; ++i) {
                        this.mProfileId[i] = tokenizer.nextToken();
                    }
                }
                f.append("(&");
                if (this.mProfileId != null) {
                    if (this.mProfileId.length == 1) {
                        f.append("(certMetaInfo=profileId:" + this.mProfileId[0] + ")");
                    } else {
                        f.append("(|");
                        for (int i = 0; i < this.mProfileId.length; ++i) {
                            f.append("(certMetaInfo=profileId:" + this.mProfileId[i] + ")");
                        }
                        f.append(")");
                    }
                }
                f.append("(x509cert.notAfter<=" + expiryDate.getTime() + ")");
                f.append("(x509cert.notAfter>=" + stopDate.getTime() + ")");
                f.append("(!(certAutoRenew=DONE))");
                f.append("(!(certAutoRenew=DISABLED))");
                f.append("(!(certStatus=REVOKED))");
                f.append("(!(certStatus=REVOKED_EXPIRED))");
                f.append(")");
                String filter = f.toString();
                String emailTemplate = this.getTemplateContent(this.mEmailTemplateName);
                this.mHTML = this.mMailHTML;
                try {
                    String summaryItemTemplate = null;
                    if (this.mSummary) {
                        summaryItemTemplate = this.getTemplateContent(this.mSummaryItemTemplateName);
                    }
                    ItemCounter ic = new ItemCounter();
                    CertRecProcessor cp = new CertRecProcessor(this.engine, this, emailTemplate, summaryItemTemplate, ic);
                    Enumeration<Object> en = this.mCertDB.findCertRecs(filter);
                    while (en.hasMoreElements()) {
                        Object element = en.nextElement();
                        try {
                            cp.process(element);
                        }
                        catch (Exception e) {
                            logger.warn("RenewalNotificationJob: " + CMS.getLogMessage((String)"JOBS_FAILED_PROCESS", (Object[])new Object[]{e.toString()}), (Throwable)e);
                        }
                    }
                    if (!this.mSummary) break block22;
                    try {
                        String summaryTemplate = this.getTemplateContent(this.mSummaryTemplateName);
                        this.mSummaryHTML = this.mMailHTML;
                        this.buildContentParams("InstanceID", this.mId);
                        this.buildContentParams("SummaryItemList", ic.mItemListContent);
                        this.buildContentParams("SummaryTotalNum", String.valueOf(ic.mNumFail + ic.mNumSuccessful));
                        this.buildContentParams("SummaryTotalSuccess", String.valueOf(ic.mNumSuccessful));
                        this.buildContentParams("SummaryTotalFailure", String.valueOf(ic.mNumFail));
                        this.buildContentParams("ExecutionTime", nowString);
                        EmailFormProcessor summaryEmfp = new EmailFormProcessor();
                        String summaryContent = summaryEmfp.getEmailContent(summaryTemplate, this.mContentParams);
                        if (summaryContent == null) {
                            logger.warn("RenewalNotificationJob: " + CMS.getLogMessage((String)"JOBS_SUMMARY_CONTENT_NULL", (Object[])new Object[0]));
                            this.mailSummary(" no summaryContent");
                        } else {
                            this.mMailHTML = this.mSummaryHTML;
                            this.mailSummary(summaryContent);
                        }
                    }
                    catch (Exception e) {
                        logger.warn("RenewalNotificationJob: " + CMS.getLogMessage((String)"JOBS_EXCEPTION_IN_RUN", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    }
                }
                catch (EBaseException e) {
                    logger.warn("RenewalNotificationJob: " + CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
            }
            catch (EBaseException ex) {
                logger.warn("RenewalNotificationJob: " + CMS.getLogMessage((String)"Configuration error:", (Object[])new Object[]{ex.toString()}), (Throwable)ex);
            }
        }
    }

    protected void mailUser(String subject, String msg, String sender, Request req, CertRecord cr) throws IOException, ENotificationException, EBaseException {
        CAEngine caEngine = (CAEngine)this.engine;
        MailNotification mn = caEngine.getMailNotification();
        String rcp = null;
        Exception sendFailedException = null;
        EmailResolverKeys keys = new EmailResolverKeys();
        try {
            X509CertImpl c;
            if (req != null) {
                keys.set("request", (Object)req);
            }
            if (cr != null && (c = cr.getCertificate()) != null) {
                keys.set("cert", (Object)cr.getCertificate());
            }
            ReqCertSANameEmailResolver er = new ReqCertSANameEmailResolver();
            rcp = ((EmailResolver)er).getEmail(keys);
        }
        catch (Exception e) {
            sendFailedException = e;
            throw (ENotificationException)sendFailedException;
        }
        mn.setTo(rcp);
        if (sender != null) {
            mn.setFrom(sender);
        } else {
            mn.setFrom("nobody");
        }
        if (subject != null) {
            mn.setSubject(subject);
        } else {
            mn.setFrom("Important message from Certificate Authority");
        }
        if (this.mHTML) {
            mn.setContentType("text/html");
        }
        mn.setContent(msg);
        mn.sendNotification();
    }

    public String[] getConfigParams() {
        return mConfigParams;
    }
}

